/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.knox;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;

public class KnoxRangerPlugin
extends RangerBasePlugin {
    boolean initialized;

    public KnoxRangerPlugin() {
        super("knox", "knox");
    }

    public synchronized void init() {
        if (!this.initialized) {
            super.init();
            super.setResultProcessor((RangerAccessResultProcessor)new RangerDefaultAuditHandler((Configuration)this.getConfig()));
            this.initialized = true;
        }
    }

    public static class KnoxConstants {

        static class AccessType {
            static final String Allow = "allow";

            AccessType() {
            }
        }

        static class ResourceName {
            static final String Topology = "topology";
            static final String Service = "service";

            ResourceName() {
            }
        }

        static class PluginConfiguration {
            static final String ServiceType = "knox";
            static final String AuditApplicationType = "knox";

            PluginConfiguration() {
            }
        }
    }

    public static class RequestBuilder {
        String service;
        String topology;
        String user;
        Set<String> groups;
        String clientIp;
        String remoteIp;
        List<String> forwardedAddresses;

        RequestBuilder service(String service) {
            this.service = service;
            return this;
        }

        RequestBuilder topology(String topology) {
            this.topology = topology;
            return this;
        }

        RequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        RequestBuilder groups(Set<String> groups) {
            this.groups = groups;
            return this;
        }

        RequestBuilder clientIp(String clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        RequestBuilder remoteIp(String remoteIp) {
            this.remoteIp = remoteIp;
            return this;
        }

        RequestBuilder forwardedAddresses(List<String> forwardedAddresses) {
            this.forwardedAddresses = forwardedAddresses;
            return this;
        }

        void verifyBuildable() {
            if (this.topology == null) {
                throw new IllegalStateException("_topology can't be null!");
            }
            if (this.service == null) {
                throw new IllegalStateException("_service can't be null!");
            }
            if (this.user == null) {
                throw new IllegalStateException("_user can't be null!");
            }
        }

        RangerAccessRequest build() {
            RangerAccessResourceImpl resource = new RangerAccessResourceImpl();
            resource.setValue("service", (Object)this.service);
            resource.setValue("topology", (Object)this.topology);
            RangerAccessRequestImpl request = new RangerAccessRequestImpl();
            request.setAction("allow");
            request.setAccessType("allow");
            request.setClientIPAddress(this.clientIp);
            request.setUser(this.user);
            request.setUserGroups(this.groups);
            request.setResource((RangerAccessResource)resource);
            request.setRemoteIPAddress(this.remoteIp);
            request.setForwardedAddresses(this.forwardedAddresses);
            return request;
        }
    }
}

