/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.AbstractRangerAdminClient;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerPluginCapability;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.RangerSslHelper;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;
import org.apache.ranger.plugin.util.URLEncoderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAdminJersey2RESTClient
extends AbstractRangerAdminClient {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAdminJersey2RESTClient.class);
    private static final int MAX_PLUGIN_ID_LEN = 255;
    private final String pluginCapabilities = Long.toHexString(new RangerPluginCapability().getPluginCapabilities());
    volatile Client client;
    boolean isSSL;
    SSLContext sslContext;
    HostnameVerifier hv;
    String sslConfigFileName;
    String serviceName;
    String serviceNameUrlParam;
    String clusterName;
    boolean supportsPolicyDeltas;
    boolean supportsTagDeltas;
    String pluginId;
    int restClientConnTimeOutMs;
    int restClientReadTimeOutMs;
    int restClientMaxRetryAttempts;
    int restClientRetryIntervalMs;
    private int lastKnownActiveUrlIndex;
    private List<String> configURLs;
    private boolean isRangerCookieEnabled;
    private String rangerAdminCookieName;
    private Cookie policyDownloadSessionId;
    private boolean isValidPolicyDownloadSessionCookie;
    private Cookie tagDownloadSessionId;
    private boolean isValidTagDownloadSessionCookie;
    private Cookie roleDownloadSessionId;
    private boolean isValidRoleDownloadSessionCookie;

    public void init(String serviceName, String appId, String configPropertyPrefix, Configuration config) {
        LOG.debug("==> RangerAdminJersey2RESTClient.init({})", (Object)configPropertyPrefix);
        super.init(serviceName, appId, configPropertyPrefix, config);
        this.serviceName = serviceName;
        this.pluginId = this.getPluginId(serviceName, appId);
        String tmpUrl = config.get(configPropertyPrefix + ".policy.rest.url");
        this.sslConfigFileName = config.get(configPropertyPrefix + ".policy.rest.ssl.config.file");
        this.restClientConnTimeOutMs = config.getInt(configPropertyPrefix + ".policy.rest.client.connection.timeoutMs", 120000);
        this.restClientReadTimeOutMs = config.getInt(configPropertyPrefix + ".policy.rest.client.read.timeoutMs", 30000);
        this.restClientMaxRetryAttempts = config.getInt(configPropertyPrefix + ".policy.rest.client.max.retry.attempts", 3);
        this.restClientRetryIntervalMs = config.getInt(configPropertyPrefix + ".policy.rest.client.retry.interval.ms", 1000);
        this.clusterName = config.get(configPropertyPrefix + ".access.cluster.name", "");
        if (StringUtil.isEmpty((String)this.clusterName)) {
            this.clusterName = config.get(configPropertyPrefix + ".ambari.cluster.name", "");
        }
        this.supportsPolicyDeltas = config.getBoolean(configPropertyPrefix + ".supports.policy.deltas", false);
        this.supportsTagDeltas = config.getBoolean(configPropertyPrefix + ".supports.tag.deltas", false);
        this.isRangerCookieEnabled = config.getBoolean(configPropertyPrefix + ".policy.rest.client.cookie.enabled", true);
        this.rangerAdminCookieName = config.get(configPropertyPrefix + ".policy.rest.client.session.cookie.name", "RANGERADMINSESSIONID");
        this.configURLs = StringUtil.getURLs((String)tmpUrl);
        this.lastKnownActiveUrlIndex = new Random().nextInt(this.configURLs.size());
        String url = this.configURLs.get(this.lastKnownActiveUrlIndex);
        this.isSSL = this.isSsl(url);
        LOG.info("Init params: Base URL[{}], SSL Config filename[{}], ServiceName=[{}], SupportsPolicyDeltas=[{}], SupportsTagDeltas=[{}], ConfigURLs=[{}]", new Object[]{url, this.sslConfigFileName, this.serviceName, this.supportsPolicyDeltas, this.supportsTagDeltas, this.configURLs});
        this.client = this.getClient();
        this.client.property("jersey.config.client.connectTimeout", (Object)this.restClientConnTimeOutMs);
        this.client.property("jersey.config.client.readTimeout", (Object)this.restClientReadTimeOutMs);
        LOG.debug("<== RangerAdminJersey2RESTClient.init({}): {}", (Object)configPropertyPrefix, (Object)this.client);
        try {
            this.serviceNameUrlParam = URLEncoderUtil.encodeURIParam((String)serviceName);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Unsupported encoding, serviceName={}", (Object)serviceName);
            this.serviceNameUrlParam = serviceName;
        }
    }

    public ServicePolicies getServicePoliciesIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        LOG.debug("==> RangerAdminJersey2RESTClient.getServicePoliciesIfUpdated({}, {})", (Object)lastKnownVersion, (Object)lastActivationTimeInMillis);
        ServicePolicies servicePolicies = this.isRangerCookieEnabled && this.policyDownloadSessionId != null && this.isValidPolicyDownloadSessionCookie ? this.getServicePoliciesIfUpdatedWithCookie(lastKnownVersion, lastActivationTimeInMillis) : this.getServicePoliciesIfUpdatedWithCred(lastKnownVersion, lastActivationTimeInMillis);
        LOG.debug("<== RangerAdminJersey2RESTClient.getServicePoliciesIfUpdated({}, {}): {}", new Object[]{lastKnownVersion, lastActivationTimeInMillis, servicePolicies});
        return servicePolicies;
    }

    public RangerRoles getRolesIfUpdated(long lastKnowRoleVersion, long lastActivationTimeInMillis) throws Exception {
        LOG.debug("==> RangerAdminJersey2RESTClient.getRolesIfUpdated({}, {})", (Object)lastKnowRoleVersion, (Object)lastActivationTimeInMillis);
        RangerRoles rangerRoles = this.isRangerCookieEnabled && this.roleDownloadSessionId != null && this.isValidRoleDownloadSessionCookie ? this.getRangerRolesIfUpdatedWithCookie(lastKnowRoleVersion, lastActivationTimeInMillis) : this.getRangerRolesIfUpdatedWithCred(lastKnowRoleVersion, lastActivationTimeInMillis);
        LOG.debug("<== RangerAdminJersey2RESTClient.getRolesIfUpdated({}, {}): {}", new Object[]{lastKnowRoleVersion, lastActivationTimeInMillis, rangerRoles});
        return rangerRoles;
    }

    public void grantAccess(GrantRevokeRequest request) throws Exception {
        LOG.debug("==> RangerAdminRESTClient.grantAccess({})", (Object)request);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pluginId", this.pluginId);
        String relativeURL = "/service/plugins/services/grant/" + this.serviceName;
        Response response = this.get(queryParams, relativeURL);
        int httpResponseCode = response == null ? -1 : response.getStatus();
        switch (httpResponseCode) {
            case -1: {
                LOG.warn("Unexpected: Null response from policy server while granting access! Returning null!");
                throw new Exception("unknown error!");
            }
            case 200: {
                LOG.debug("grantAccess() suceeded: HTTP status={}", (Object)httpResponseCode);
                break;
            }
            case 401: {
                throw new AccessControlException();
            }
            default: {
                String body = (String)response.readEntity(String.class);
                LOG.warn("Unexpected: Received status[{}] with body[{}] form url[{}]", new Object[]{httpResponseCode, body, relativeURL});
                throw new Exception("HTTP status: " + httpResponseCode);
            }
        }
        LOG.debug("<== RangerAdminRESTClient.grantAccess({})", (Object)request);
    }

    public void revokeAccess(GrantRevokeRequest request) throws Exception {
        LOG.debug("==> RangerAdminRESTClient.grantAccess({})", (Object)request);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pluginId", this.pluginId);
        String relativeURL = "/service/plugins/services/revoke/" + this.serviceName;
        Response response = this.get(queryParams, relativeURL);
        int httpResponseCode = response == null ? -1 : response.getStatus();
        switch (httpResponseCode) {
            case -1: {
                LOG.warn("Unexpected: Null response from policy server while granting access! Returning null!");
                throw new Exception("unknown error!");
            }
            case 200: {
                LOG.debug("grantAccess() suceeded: HTTP status={}", (Object)httpResponseCode);
                break;
            }
            case 401: {
                throw new AccessControlException();
            }
            default: {
                String body = (String)response.readEntity(String.class);
                LOG.warn("Unexpected: Received status[{}] with body[{}] form url[{}]", new Object[]{httpResponseCode, body, relativeURL});
                throw new Exception("HTTP status: " + httpResponseCode);
            }
        }
        LOG.debug("<== RangerAdminRESTClient.grantAccess({})", (Object)request);
    }

    public ServiceTags getServiceTagsIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        LOG.debug("==> RangerAdminJersey2RESTClient.getServiceTagsIfUpdated({}, {})", (Object)lastKnownVersion, (Object)lastActivationTimeInMillis);
        ServiceTags serviceTags = this.isRangerCookieEnabled && this.tagDownloadSessionId != null && this.isValidTagDownloadSessionCookie ? this.getServiceTagsIfUpdatedWithCookie(lastKnownVersion, lastActivationTimeInMillis) : this.getServiceTagsIfUpdatedWithCred(lastKnownVersion, lastActivationTimeInMillis);
        LOG.debug("<== RangerAdminJersey2RESTClient.getServiceTagsIfUpdated({}, {}): {}", new Object[]{lastKnownVersion, lastActivationTimeInMillis, serviceTags});
        return serviceTags;
    }

    public List<String> getTagTypes(String pattern) throws Exception {
        throw new Exception("RangerAdminjersey2RESTClient.getTagTypes() -- *** NOT IMPLEMENTED *** ");
    }

    public RangerUserStore getUserStoreIfUpdated(long lastKnownUserStoreVersion, long lastActivationTimeInMillis) throws Exception {
        RangerUserStore ret;
        String resp;
        Response response;
        LOG.debug("==> RangerAdminjersey2RESTClient.getUserStoreIfUpdated(lastKnownUserStoreVersion={}, lastActivationTimeInMillis={})", (Object)lastKnownUserStoreVersion, (Object)lastActivationTimeInMillis);
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownUserStoreVersion", Long.toString(lastKnownUserStoreVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("clusterName", this.clusterName);
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            LOG.debug("Checking UserStore updated as user: {}", (Object)user);
            response = (Response)MiscUtil.executePrivilegedAction(() -> {
                try {
                    String relativeURL = "/service/xusers/secure/download/" + this.serviceNameUrlParam;
                    return this.get(queryParams, relativeURL);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response", (Throwable)e);
                    return null;
                }
            });
        } else {
            LOG.debug("Checking UserStore updated as user: {}", (Object)user);
            String relativeURL = "/service/xusers/download/" + this.serviceNameUrlParam;
            response = this.get(queryParams, relativeURL);
        }
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error("Error getting UserStore; Received NULL response!!. secureMode={}, user={}, serviceName={}", new Object[]{isSecureMode, user, this.serviceName});
            } else {
                resp = response.hasEntity() ? (String)response.readEntity(String.class) : null;
                LOG.debug("No change in UserStore. secureMode={}, user={}, response={}, serviceName={}, lastKnownUserStoreVersion={}, lastActivationTimeInMillis={}", new Object[]{isSecureMode, user, resp, this.serviceName, lastKnownUserStoreVersion, lastActivationTimeInMillis});
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            String body = (String)response.readEntity(String.class);
            ret = (RangerUserStore)this.getGson().fromJson(body, RangerUserStore.class);
        } else if (response.getStatus() == 404) {
            ret = null;
            LOG.error("Error getting UserStore; service not found. secureMode={}, user={}, response={}, serviceName={}, lastKnownUserStoreVersion={}, lastActivationTimeInMillis={}", new Object[]{isSecureMode, user, response.getStatus(), this.serviceName, lastKnownUserStoreVersion, lastActivationTimeInMillis});
            String exceptionMsg = response.hasEntity() ? (String)response.readEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this.serviceName, (String)exceptionMsg);
            LOG.warn("Received 404 error code with body:[{}], Ignoring", (Object)exceptionMsg);
        } else {
            resp = response.hasEntity() ? (String)response.readEntity(String.class) : null;
            LOG.warn("Error getting UserStore. secureMode={}, user={}, response={}, serviceName={}, lastKnownUserStoreVersion={}, lastActivationTimeInMillis={}", new Object[]{isSecureMode, user, resp, this.serviceName, lastKnownUserStoreVersion, lastActivationTimeInMillis});
            ret = null;
        }
        LOG.debug("<== RangerAdminjersey2RESTClient.getUserStoreIfUpdated(lastKnownUserStoreVersion={}, lastActivationTimeInMillis={}): ret={}", new Object[]{lastKnownUserStoreVersion, lastActivationTimeInMillis, ret});
        return ret;
    }

    protected boolean shouldRetry(String currentUrl, int index, int retryAttemptCount, ProcessingException ex) {
        boolean ret;
        LOG.warn("Failed to communicate with Ranger Admin. URL: {}. Error: {}", (Object)currentUrl, (Object)ex.getMessage());
        boolean isLastUrl = index == this.configURLs.size() - 1;
        boolean bl = ret = isLastUrl && retryAttemptCount < this.restClientMaxRetryAttempts;
        if (ret) {
            LOG.warn("Waiting for {}ms before retry attempt #{}", (Object)this.restClientRetryIntervalMs, (Object)(retryAttemptCount + 1));
            try {
                Thread.sleep(this.restClientRetryIntervalMs);
            }
            catch (InterruptedException excp) {
                LOG.error("Failed while waiting to retry", (Throwable)excp);
            }
        } else if (isLastUrl) {
            LOG.error("Failed to communicate with all Ranger Admin's URL's : [ {} ]", this.configURLs);
            throw new ProcessingException("Failed to communicate with all Ranger Admin's URL : [ " + this.configURLs + " ]", (Throwable)ex);
        }
        return ret;
    }

    Gson getGson() {
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Date.class, (Object)new GsonUnixDateDeserializer()).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Client getClient() {
        Client result = this.client;
        if (result == null) {
            RangerAdminJersey2RESTClient rangerAdminJersey2RESTClient = this;
            synchronized (rangerAdminJersey2RESTClient) {
                result = this.client;
                if (result == null) {
                    this.client = result = this.buildClient();
                }
            }
        }
        return result;
    }

    Client buildClient() {
        if (this.isSSL) {
            if (this.sslContext == null) {
                RangerSslHelper sslHelper = new RangerSslHelper(this.sslConfigFileName);
                this.sslContext = sslHelper.createContext();
            }
            if (this.hv == null) {
                this.hv = (urlHostName, session) -> session.getPeerHost().equals(urlHostName);
            }
            this.client = ClientBuilder.newBuilder().sslContext(this.sslContext).hostnameVerifier(this.hv).build();
        }
        if (this.client == null) {
            this.client = ClientBuilder.newClient();
        }
        return this.client;
    }

    private Response get(Map<String, String> queyParams, String relativeURL) {
        Response response = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int currentIndex = 0;
        int retryAttempt = 0;
        for (int index = 0; index < this.configURLs.size(); ++index) {
            try {
                currentIndex = (startIndex + index) % this.configURLs.size();
                WebTarget target = this.client.target(this.configURLs.get(currentIndex) + relativeURL);
                response = RangerAdminJersey2RESTClient.setQueryParams(target, queyParams).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
                if (response == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ProcessingException e) {
                if (!this.shouldRetry(this.configURLs.get(currentIndex), index, retryAttempt, e)) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return response;
    }

    private Response get(Map<String, String> queyParams, String relativeURL, Cookie sessionId) {
        Response response = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int currentIndex = 0;
        int retryAttempt = 0;
        for (int index = 0; index < this.configURLs.size(); ++index) {
            try {
                currentIndex = (startIndex + index) % this.configURLs.size();
                WebTarget target = this.client.target(this.configURLs.get(currentIndex) + relativeURL);
                target = RangerAdminJersey2RESTClient.setQueryParams(target, queyParams);
                Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).cookie(sessionId);
                response = invocationBuilder.get();
                if (response == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ProcessingException e) {
                if (!this.shouldRetry(this.configURLs.get(currentIndex), index, retryAttempt, e)) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return response;
    }

    private static WebTarget setQueryParams(WebTarget target, Map<String, String> params) {
        WebTarget ret = target;
        if (target != null && params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                ret = ret.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        return ret;
    }

    private void setLastKnownActiveUrlIndex(int lastKnownActiveUrlIndex) {
        this.lastKnownActiveUrlIndex = lastKnownActiveUrlIndex;
    }

    private boolean isSsl(String url) {
        return !StringUtils.isEmpty((String)url) && url.toLowerCase().startsWith("https");
    }

    private String getPluginId(String serviceName, String appId) {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("ERROR: Unable to find hostname for the agent ", (Throwable)e);
            hostName = "unknownHost";
        }
        String ret = hostName + "-" + serviceName;
        if (!StringUtils.isEmpty((String)appId)) {
            ret = appId + "@" + ret;
        }
        if (ret.length() > 255) {
            ret = ret.substring(0, 255);
        }
        return ret;
    }

    private ServicePolicies getServicePoliciesIfUpdatedWithCred(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServicePolicies ret;
        LOG.debug("==> RangerAdminJersey2RESTClient.getServicePoliciesWithCred({}, {})", (Object)lastKnownVersion, (Object)lastActivationTimeInMillis);
        Response response = this.getRangerAdminPolicyDownloadResponse(lastKnownVersion, lastActivationTimeInMillis);
        int httpResponseCode = response == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                LOG.debug("Response from 200 server: {}", (Object)body);
                Gson gson = this.getGson();
                ret = (ServicePolicies)gson.fromJson(body, ServicePolicies.class);
                this.setCookieReceivedFromCredSession(response);
                LOG.debug("Deserialized response to: {}", (Object)ret);
                break;
            }
            case 304: {
                ret = null;
                this.setCookieReceivedFromCredSession(response);
                LOG.debug("Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                ret = null;
                this.policyDownloadSessionId = null;
                LOG.warn("Unexpected: Null response from policy server while trying to get policies! Returning null!");
                break;
            }
            case 404: {
                ret = null;
                this.policyDownloadSessionId = null;
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this.serviceName, (String)body);
                }
                LOG.warn("Received 404 error code with body:[{}], Ignoring", (Object)body);
                break;
            }
            default: {
                ret = null;
                this.policyDownloadSessionId = null;
                body = (String)response.readEntity(String.class);
                LOG.warn("Unexpected: Received status[{}] with body[{}] form url[{}]", new Object[]{httpResponseCode, body, this.getRelativeURL(this.isSecureMode())});
            }
        }
        LOG.debug("<== RangerAdminJersey2RESTClient.getServicePoliciesWithCred({}, {}): {}", new Object[]{lastKnownVersion, lastActivationTimeInMillis, ret});
        return ret;
    }

    private ServicePolicies getServicePoliciesIfUpdatedWithCookie(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServicePolicies ret;
        LOG.debug("==> RangerAdminJersey2RESTClient.getServicePoliciesWithCookie({}, {})", (Object)lastKnownVersion, (Object)lastActivationTimeInMillis);
        Response response = this.getRangerAdminPolicyDownloadResponse(lastKnownVersion, lastActivationTimeInMillis);
        int httpResponseCode = response == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                LOG.debug("Response from 200 server: {}", (Object)body);
                Gson gson = this.getGson();
                ret = (ServicePolicies)gson.fromJson(body, ServicePolicies.class);
                this.checkAndResetSessionCookie(response);
                LOG.debug("Deserialized response to: {}", (Object)ret);
                break;
            }
            case 304: {
                ret = null;
                this.checkAndResetSessionCookie(response);
                LOG.debug("Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                ret = null;
                this.policyDownloadSessionId = null;
                this.isValidPolicyDownloadSessionCookie = false;
                LOG.warn("Unexpected: Null response from policy server while trying to get policies! Returning null!");
                break;
            }
            case 404: {
                ret = null;
                this.policyDownloadSessionId = null;
                this.isValidPolicyDownloadSessionCookie = false;
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this.serviceName, (String)body);
                }
                LOG.warn("Received 404 error code with body:[{}], Ignoring", (Object)body);
                break;
            }
            default: {
                ret = null;
                this.policyDownloadSessionId = null;
                this.isValidPolicyDownloadSessionCookie = false;
                body = (String)response.readEntity(String.class);
                LOG.warn("Unexpected: Received status[{}] with body[{}] form url[{}]", new Object[]{httpResponseCode, body, this.getRelativeURL(this.isSecureMode())});
            }
        }
        LOG.debug("<== RangerAdminJersey2RESTClient.getServicePoliciesWithCookie({}, {}): {}", new Object[]{lastKnownVersion, lastActivationTimeInMillis, ret});
        return ret;
    }

    private Response getRangerAdminPolicyDownloadResponse(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        Response ret;
        LOG.debug("==> RangerAdminJersey2RESTClient.getRangerAdminPolicyDownloadResponse({}, {})", (Object)lastKnownVersion, (Object)lastActivationTimeInMillis);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownVersion", Long.toString(lastKnownVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("clusterName", this.clusterName);
        queryParams.put("supportsPolicyDeltas", Boolean.toString(this.supportsPolicyDeltas));
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (this.isSecureMode()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Service policy if updated as user : {}", (Object)MiscUtil.getUGILoginUser());
            }
            ret = (Response)MiscUtil.executePrivilegedAction(() -> this.get(queryParams, this.getRelativeURL(true), this.policyDownloadSessionId));
        } else {
            LOG.debug("Checking Service policy if updated with old api call");
            ret = this.get(queryParams, this.getRelativeURL(false), this.policyDownloadSessionId);
        }
        LOG.debug("<== RangerAdminJersey2RESTClient.getRangerAdminPolicyDownloadResponse({}, {}): {}", new Object[]{lastKnownVersion, lastActivationTimeInMillis, ret});
        return ret;
    }

    private String getRelativeURL(boolean isSecureMode) {
        String ret = isSecureMode ? "/service/plugins/secure/policies/download/" + this.serviceName : "/service/plugins/policies/download/" + this.serviceName;
        return ret;
    }

    private void checkAndResetSessionCookie(Response response) {
        Map cookieMap = response.getCookies();
        Set cookieNames = cookieMap.keySet();
        for (String cookieName : cookieNames) {
            if (!cookieName.equalsIgnoreCase(this.rangerAdminCookieName)) continue;
            this.policyDownloadSessionId = (Cookie)cookieMap.get(cookieName);
            this.isValidPolicyDownloadSessionCookie = this.policyDownloadSessionId != null;
            break;
        }
    }

    private void setCookieReceivedFromCredSession(Response response) {
        if (this.isRangerCookieEnabled) {
            Cookie sessionCookie = null;
            Map cookieMap = response.getCookies();
            Set cookieNames = cookieMap.keySet();
            for (String cookieName : cookieNames) {
                if (!cookieName.equalsIgnoreCase(this.rangerAdminCookieName)) continue;
                sessionCookie = (Cookie)cookieMap.get(cookieName);
                break;
            }
            this.policyDownloadSessionId = sessionCookie;
            this.isValidPolicyDownloadSessionCookie = this.policyDownloadSessionId != null;
        }
    }

    private ServiceTags getServiceTagsIfUpdatedWithCred(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServiceTags ret;
        LOG.debug("==> RangerAdminJersey2RESTClient.getServiceTagsIfUpdatedWithCred({}, {})", (Object)lastKnownVersion, (Object)lastActivationTimeInMillis);
        Response response = this.getTagsDownloadResponse(lastKnownVersion, lastActivationTimeInMillis);
        int httpResponseCode = response == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                LOG.debug("Response from 200 server: {}", (Object)body);
                Gson gson = this.getGson();
                ret = (ServiceTags)gson.fromJson(body, ServiceTags.class);
                this.setCookieReceivedFromTagDownloadSession(response);
                LOG.debug("Deserialized response to: {}", (Object)ret);
                break;
            }
            case 304: {
                ret = null;
                this.setCookieReceivedFromTagDownloadSession(response);
                LOG.debug("Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                ret = null;
                this.tagDownloadSessionId = null;
                LOG.warn("Unexpected: Null response from tag server while trying to get tags! Returning null!");
                break;
            }
            case 404: {
                ret = null;
                this.tagDownloadSessionId = null;
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this.serviceName, (String)body);
                }
                LOG.warn("Received 404 error code with body:[{}], Ignoring", (Object)body);
                break;
            }
            default: {
                ret = null;
                this.tagDownloadSessionId = null;
                body = (String)response.readEntity(String.class);
                LOG.warn("Unexpected: Received status[{}] with body[{}] form url[{}]", new Object[]{httpResponseCode, body, this.getRelativeURLForTagDownload(this.isSecureMode())});
            }
        }
        LOG.debug("<== RangerAdminJersey2RESTClient.getServiceTagsIfUpdatedWithCred({}, {}): {}", new Object[]{lastKnownVersion, lastActivationTimeInMillis, ret});
        return ret;
    }

    private ServiceTags getServiceTagsIfUpdatedWithCookie(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServiceTags ret;
        LOG.debug("==> RangerAdminJersey2RESTClient.getServiceTagsIfUpdatedWithCookie({}, {})", (Object)lastKnownVersion, (Object)lastActivationTimeInMillis);
        Response response = this.getTagsDownloadResponse(lastKnownVersion, lastActivationTimeInMillis);
        int httpResponseCode = response == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                LOG.debug("Response from 200 server: {}", (Object)body);
                Gson gson = this.getGson();
                ret = (ServiceTags)gson.fromJson(body, ServiceTags.class);
                this.checkAndResetTagDownloadSessionCookie(response);
                LOG.debug("Deserialized response to: {}", (Object)ret);
                break;
            }
            case 304: {
                ret = null;
                this.checkAndResetTagDownloadSessionCookie(response);
                LOG.debug("Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                ret = null;
                this.tagDownloadSessionId = null;
                this.isValidTagDownloadSessionCookie = false;
                LOG.warn("Unexpected: Null response from tag server while trying to get tags! Returning null!");
                break;
            }
            case 404: {
                ret = null;
                this.tagDownloadSessionId = null;
                this.isValidTagDownloadSessionCookie = false;
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this.serviceName, (String)body);
                }
                LOG.warn("Received 404 error code with body:[{}], Ignoring", (Object)body);
                break;
            }
            default: {
                ret = null;
                this.tagDownloadSessionId = null;
                this.isValidTagDownloadSessionCookie = false;
                body = (String)response.readEntity(String.class);
                LOG.warn("Unexpected: Received status[{}] with body[{}] form url[{}]", new Object[]{httpResponseCode, body, ret});
            }
        }
        LOG.debug("<== RangerAdminJersey2RESTClient.getServiceTagsIfUpdatedWithCookie({}, {}): {}", new Object[]{lastKnownVersion, lastActivationTimeInMillis, ret});
        return ret;
    }

    private Response getTagsDownloadResponse(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        Response ret;
        LOG.debug("==> RangerAdminJersey2RESTClient.getTagsDownloadResponse({}, {})", (Object)lastKnownVersion, (Object)lastActivationTimeInMillis);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownVersion", Long.toString(lastKnownVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("supportsTagDeltas", Boolean.toString(this.supportsTagDeltas));
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (this.isSecureMode()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Service tags if updated as user : {}", (Object)MiscUtil.getUGILoginUser());
            }
            ret = (Response)MiscUtil.executePrivilegedAction(() -> this.get(queryParams, this.getRelativeURLForTagDownload(true), this.tagDownloadSessionId));
        } else {
            LOG.debug("Checking Service tags if updated with old api call");
            ret = this.get(queryParams, this.getRelativeURLForTagDownload(false), this.tagDownloadSessionId);
        }
        LOG.debug("<== RangerAdminJersey2RESTClient.getTagsDownloadResponse({}, {}): {}", new Object[]{lastKnownVersion, lastActivationTimeInMillis, ret});
        return ret;
    }

    private String getRelativeURLForTagDownload(boolean isSecureMode) {
        String ret = isSecureMode ? "/service/tags/secure/download/" + this.serviceName : "/service/tags/download/" + this.serviceName;
        return ret;
    }

    private void checkAndResetTagDownloadSessionCookie(Response response) {
        Map cookieMap = response.getCookies();
        Set cookieNames = cookieMap.keySet();
        for (String cookieName : cookieNames) {
            if (!cookieName.equalsIgnoreCase(this.rangerAdminCookieName)) continue;
            this.tagDownloadSessionId = (Cookie)cookieMap.get(cookieName);
            this.isValidTagDownloadSessionCookie = this.tagDownloadSessionId != null;
            break;
        }
    }

    private void setCookieReceivedFromTagDownloadSession(Response response) {
        if (this.isRangerCookieEnabled) {
            Cookie sessionCookie = null;
            Map cookieMap = response.getCookies();
            Set cookieNames = cookieMap.keySet();
            for (String cookieName : cookieNames) {
                if (!cookieName.equalsIgnoreCase(this.rangerAdminCookieName)) continue;
                sessionCookie = (Cookie)cookieMap.get(cookieName);
            }
            this.tagDownloadSessionId = sessionCookie;
            this.isValidTagDownloadSessionCookie = this.tagDownloadSessionId != null;
        }
    }

    private RangerRoles getRangerRolesIfUpdatedWithCred(long lastKnownRoleVersion, long lastActivationTimeInMillis) throws Exception {
        RangerRoles ret;
        LOG.debug("==> RangerAdminJersey2RESTClient.getRangerRolesIfUpdatedWithCred({}, {})", (Object)lastKnownRoleVersion, (Object)lastActivationTimeInMillis);
        Response response = this.getRoleDownloadResponse(lastKnownRoleVersion, lastActivationTimeInMillis);
        int httpResponseCode = response == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                LOG.debug("Response from 200 server: {}", (Object)body);
                Gson gson = this.getGson();
                ret = (RangerRoles)gson.fromJson(body, RangerRoles.class);
                this.setCookieReceivedFromRoleDownloadSession(response);
                LOG.debug("Deserialized response to: {}", (Object)ret);
                break;
            }
            case 304: {
                ret = null;
                this.setCookieReceivedFromRoleDownloadSession(response);
                LOG.debug("Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                ret = null;
                this.roleDownloadSessionId = null;
                LOG.warn("Unexpected: Null response from policy server while trying to get policies! Returning null!");
                break;
            }
            case 404: {
                ret = null;
                this.roleDownloadSessionId = null;
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this.serviceName, (String)body);
                }
                LOG.warn("Received 404 error code with body:[{}], Ignoring", (Object)body);
                break;
            }
            default: {
                ret = null;
                this.roleDownloadSessionId = null;
                body = (String)response.readEntity(String.class);
                LOG.warn("Unexpected: Received status[{}] with body[{}] form url[{}]", new Object[]{httpResponseCode, body, this.getRelativeURLForRoleDownload(this.isSecureMode())});
            }
        }
        LOG.debug("<== RangerAdminJersey2RESTClient.getRangerRolesIfUpdatedWithCred({}, {}): {}", new Object[]{lastKnownRoleVersion, lastActivationTimeInMillis, ret});
        return ret;
    }

    private RangerRoles getRangerRolesIfUpdatedWithCookie(long lastKnownRoleVersion, long lastActivationTimeInMillis) throws Exception {
        RangerRoles ret;
        LOG.debug("==> RangerAdminJersey2RESTClient.getRangerRolesIfUpdatedWithCookie({}, {})", (Object)lastKnownRoleVersion, (Object)lastActivationTimeInMillis);
        Response response = this.getRoleDownloadResponse(lastKnownRoleVersion, lastActivationTimeInMillis);
        int httpResponseCode = response == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                LOG.debug("Response from 200 server: {}", (Object)body);
                Gson gson = this.getGson();
                ret = (RangerRoles)gson.fromJson(body, RangerRoles.class);
                this.checkAndResetRoleDownloadSessionCookie(response);
                LOG.debug("Deserialized response to: {}", (Object)ret);
                break;
            }
            case 304: {
                ret = null;
                this.checkAndResetRoleDownloadSessionCookie(response);
                LOG.debug("Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                ret = null;
                this.roleDownloadSessionId = null;
                this.isValidRoleDownloadSessionCookie = false;
                LOG.warn("Unexpected: Null response from policy server while trying to get policies! Returning null!");
                break;
            }
            case 404: {
                ret = null;
                this.roleDownloadSessionId = null;
                this.isValidRoleDownloadSessionCookie = false;
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this.serviceName, (String)body);
                }
                LOG.warn("Received 404 error code with body:[{}], Ignoring", (Object)body);
                break;
            }
            default: {
                ret = null;
                this.roleDownloadSessionId = null;
                this.isValidRoleDownloadSessionCookie = false;
                body = (String)response.readEntity(String.class);
                LOG.warn("Unexpected: Received status[{}] with body[{}] form url[{}]", new Object[]{httpResponseCode, body, this.getRelativeURLForRoleDownload(this.isSecureMode())});
            }
        }
        LOG.debug("<== RangerAdminJersey2RESTClient.getRangerRolesIfUpdatedWithCookie({}, {}): {}", new Object[]{lastKnownRoleVersion, lastActivationTimeInMillis, ret});
        return ret;
    }

    private Response getRoleDownloadResponse(long lastKnownRoleVersion, long lastActivationTimeInMillis) throws Exception {
        Response ret;
        LOG.debug("==> RangerAdminJersey2RESTClient.getRoleDownloadResponse({}, {})", (Object)lastKnownRoleVersion, (Object)lastActivationTimeInMillis);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownRoleVersion", Long.toString(lastKnownRoleVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("clusterName", this.clusterName);
        if (this.isSecureMode()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Roles if updated as user : {}", (Object)MiscUtil.getUGILoginUser());
            }
            ret = (Response)MiscUtil.executePrivilegedAction(() -> this.get(queryParams, this.getRelativeURLForRoleDownload(true), this.roleDownloadSessionId));
        } else {
            LOG.debug("Checking Roles if updated with old api call");
            ret = this.get(queryParams, this.getRelativeURLForRoleDownload(false), this.roleDownloadSessionId);
        }
        LOG.debug("<== RangerAdminJersey2RESTClient.getRoleDownloadResponse({}, {}): {}", new Object[]{lastKnownRoleVersion, lastActivationTimeInMillis, ret});
        return ret;
    }

    private String getRelativeURLForRoleDownload(boolean isSecureMode) {
        String ret = isSecureMode ? "/service/roles/secure/download/" + this.serviceName : "/service/roles/download/" + this.serviceName;
        return ret;
    }

    private void checkAndResetRoleDownloadSessionCookie(Response response) {
        Map cookieMap = response.getCookies();
        Set cookieNames = cookieMap.keySet();
        for (String cookieName : cookieNames) {
            if (!cookieName.equalsIgnoreCase(this.rangerAdminCookieName)) continue;
            this.roleDownloadSessionId = (Cookie)cookieMap.get(cookieName);
            this.isValidRoleDownloadSessionCookie = this.roleDownloadSessionId != null;
            break;
        }
    }

    private void setCookieReceivedFromRoleDownloadSession(Response response) {
        if (this.isRangerCookieEnabled) {
            Cookie sessionCookie = null;
            Map cookieMap = response.getCookies();
            Set cookieNames = cookieMap.keySet();
            for (String cookieName : cookieNames) {
                if (!cookieName.equalsIgnoreCase(this.rangerAdminCookieName)) continue;
                sessionCookie = (Cookie)cookieMap.get(cookieName);
                break;
            }
            this.roleDownloadSessionId = sessionCookie;
            this.isValidRoleDownloadSessionCookie = this.roleDownloadSessionId != null;
        }
    }

    private boolean isSecureMode() {
        return this.isKerberosEnabled(MiscUtil.getUGILoginUser());
    }

    public static class GsonUnixDateDeserializer
    implements JsonDeserializer<Date> {
        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new Date(json.getAsJsonPrimitive().getAsLong());
        }
    }
}

