/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.knox;

import java.util.List;
import java.util.Set;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;

public class KnoxRangerPlugin
extends RangerBasePlugin {
    boolean initialized = false;

    public KnoxRangerPlugin() {
        super("knox", "knox");
    }

    public synchronized void init() {
        if (!this.initialized) {
            super.init();
            super.setResultProcessor((RangerAccessResultProcessor)new RangerDefaultAuditHandler());
            this.initialized = true;
        }
    }

    public static class KnoxConstants {

        static class AccessType {
            static final String Allow = "allow";

            AccessType() {
            }
        }

        static class ResourceName {
            static final String Topology = "topology";
            static final String Service = "service";

            ResourceName() {
            }
        }

        static class PluginConfiguration {
            static final String ServiceType = "knox";
            static final String AuditApplicationType = "knox";

            PluginConfiguration() {
            }
        }
    }

    public static class RequestBuilder {
        String _service;
        String _topology;
        String _user;
        Set<String> _groups;
        String _clientIp;
        String _clusterName;
        String _remoteIp;
        List<String> _forwardedAddresses;

        RequestBuilder service(String service) {
            this._service = service;
            return this;
        }

        RequestBuilder topology(String topology) {
            this._topology = topology;
            return this;
        }

        RequestBuilder user(String user) {
            this._user = user;
            return this;
        }

        RequestBuilder groups(Set<String> groups) {
            this._groups = groups;
            return this;
        }

        RequestBuilder clientIp(String clientIp) {
            this._clientIp = clientIp;
            return this;
        }

        RequestBuilder clusterName(String clusterName) {
            this._clusterName = clusterName;
            return this;
        }

        RequestBuilder remoteIp(String remoteIp) {
            this._remoteIp = remoteIp;
            return this;
        }

        RequestBuilder forwardedAddresses(List<String> forwardedAddresses) {
            this._forwardedAddresses = forwardedAddresses;
            return this;
        }

        void verifyBuildable() {
            if (this._topology == null) {
                throw new IllegalStateException("_topology can't be null!");
            }
            if (this._service == null) {
                throw new IllegalStateException("_service can't be null!");
            }
            if (this._user == null) {
                throw new IllegalStateException("_user can't be null!");
            }
        }

        RangerAccessRequest build() {
            RangerAccessResourceImpl resource = new RangerAccessResourceImpl();
            resource.setValue("service", (Object)this._service);
            resource.setValue("topology", (Object)this._topology);
            RangerAccessRequestImpl request = new RangerAccessRequestImpl();
            request.setAction("allow");
            request.setAccessType("allow");
            request.setClientIPAddress(this._clientIp);
            request.setUser(this._user);
            request.setUserGroups(this._groups);
            request.setResource((RangerAccessResource)resource);
            request.setClusterName(this._clusterName);
            request.setRemoteIPAddress(this._remoteIp);
            request.setForwardedAddresses(this._forwardedAddresses);
            return request;
        }
    }
}

