/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerRESTUtils;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.RangerSslHelper;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;

public class RangerAdminJersey2RESTClient
implements RangerAdminClient {
    private static final Log LOG = LogFactory.getLog(RangerAdminJersey2RESTClient.class);
    RangerRESTUtils _utils = new RangerRESTUtils();
    boolean _isSSL = false;
    volatile Client _client = null;
    SSLContext _sslContext = null;
    HostnameVerifier _hv;
    String _baseUrl = null;
    String _sslConfigFileName = null;
    String _serviceName = null;
    String _clusterName = null;
    String _pluginId = null;
    int _restClientConnTimeOutMs;
    int _restClientReadTimeOutMs;

    public void init(String serviceName, String appId, String configPropertyPrefix) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminJersey2RESTClient.init(" + configPropertyPrefix + ")"));
        }
        this._serviceName = serviceName;
        this._pluginId = this._utils.getPluginId(serviceName, appId);
        this._baseUrl = this._utils.getPolicyRestUrl(configPropertyPrefix);
        this._sslConfigFileName = this._utils.getSsslConfigFileName(configPropertyPrefix);
        this._isSSL = this._utils.isSsl(this._baseUrl);
        this._restClientConnTimeOutMs = RangerConfiguration.getInstance().getInt(configPropertyPrefix + ".policy.rest.client.connection.timeoutMs", 120000);
        this._restClientReadTimeOutMs = RangerConfiguration.getInstance().getInt(configPropertyPrefix + ".policy.rest.client.read.timeoutMs", 30000);
        this._clusterName = RangerConfiguration.getInstance().get(configPropertyPrefix + ".ambari.cluster.name", "");
        LOG.info((Object)("Init params: " + String.format("Base URL[%s], SSL Congig filename[%s], ServiceName=[%s]", this._baseUrl, this._sslConfigFileName, this._serviceName)));
        this._client = this.getClient();
        this._client.property("jersey.config.client.connectTimeout", (Object)this._restClientConnTimeOutMs);
        this._client.property("jersey.config.client.readTimeout", (Object)this._restClientReadTimeOutMs);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminJersey2RESTClient.init(" + configPropertyPrefix + "): " + this._client.toString()));
        }
    }

    public ServicePolicies getServicePoliciesIfUpdated(final long lastKnownVersion, final long lastActivationTimeInMillis) throws Exception {
        UserGroupInformation user;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminJersey2RESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")"));
        }
        boolean isSecureMode = (user = MiscUtil.getUGILoginUser()) != null && UserGroupInformation.isSecurityEnabled();
        String url = null;
        ServicePolicies servicePolicies = null;
        Response response = null;
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking Service policy if updated as user : " + user));
            }
            final String secureUrl = url = this._utils.getSecureUrlForPolicyUpdate(this._baseUrl, this._serviceName);
            PrivilegedAction<Response> action = new PrivilegedAction<Response>(){

                @Override
                public Response run() {
                    return RangerAdminJersey2RESTClient.this._client.target(secureUrl).queryParam("lastKnownVersion", new Object[]{Long.toString(lastKnownVersion)}).queryParam("lastActivationTime", new Object[]{Long.toString(lastActivationTimeInMillis)}).queryParam("pluginId", new Object[]{RangerAdminJersey2RESTClient.this._pluginId}).queryParam("clusterName", new Object[]{RangerAdminJersey2RESTClient.this._clusterName}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
                }
            };
            response = (Response)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checking Service policy if updated with old api call");
            }
            url = this._utils.getUrlForPolicyUpdate(this._baseUrl, this._serviceName);
            response = this._client.target(url).queryParam("lastKnownVersion", new Object[]{Long.toString(lastKnownVersion)}).queryParam("lastActivationTime", new Object[]{Long.toString(lastActivationTimeInMillis)}).queryParam("pluginId", new Object[]{this._pluginId}).queryParam("clusterName", new Object[]{this._clusterName}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        }
        int httpResponseCode = response == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Response from 200 server: " + body));
                }
                Gson gson = this.getGson();
                servicePolicies = (ServicePolicies)gson.fromJson(body, ServicePolicies.class);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("Deserialized response to: " + servicePolicies));
                break;
            }
            case 304: {
                LOG.debug((Object)"Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                LOG.warn((Object)"Unexpected: Null response from policy server while trying to get policies! Returning null!");
                break;
            }
            case 404: {
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this._serviceName, (String)body);
                }
                LOG.warn((Object)("Received 404 error code with body:[" + body + "], Ignoring"));
                break;
            }
            default: {
                body = (String)response.readEntity(String.class);
                LOG.warn((Object)String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, url));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminJersey2RESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + servicePolicies));
        }
        return servicePolicies;
    }

    public void grantAccess(GrantRevokeRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.grantAccess(" + request + ")"));
        }
        String url = this._utils.getUrlForGrantAccess(this._baseUrl, this._serviceName);
        Response response = this._client.target(url).queryParam("pluginId", new Object[]{this._pluginId}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        int httpResponseCode = response == null ? -1 : response.getStatus();
        switch (httpResponseCode) {
            case -1: {
                LOG.warn((Object)"Unexpected: Null response from policy server while granting access! Returning null!");
                throw new Exception("unknown error!");
            }
            case 200: {
                LOG.debug((Object)("grantAccess() suceeded: HTTP status=" + httpResponseCode));
                break;
            }
            case 401: {
                throw new AccessControlException();
            }
            default: {
                String body = (String)response.readEntity(String.class);
                String message = String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, url);
                LOG.warn((Object)message);
                throw new Exception("HTTP status: " + httpResponseCode);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.grantAccess(" + request + ")"));
        }
    }

    public void revokeAccess(GrantRevokeRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.grantAccess(" + request + ")"));
        }
        String url = this._utils.getUrlForRevokeAccess(this._baseUrl, this._serviceName);
        Response response = this._client.target(url).queryParam("pluginId", new Object[]{this._pluginId}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        int httpResponseCode = response == null ? -1 : response.getStatus();
        switch (httpResponseCode) {
            case -1: {
                LOG.warn((Object)"Unexpected: Null response from policy server while granting access! Returning null!");
                throw new Exception("unknown error!");
            }
            case 200: {
                LOG.debug((Object)("grantAccess() suceeded: HTTP status=" + httpResponseCode));
                break;
            }
            case 401: {
                throw new AccessControlException();
            }
            default: {
                String body = (String)response.readEntity(String.class);
                String message = String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, url);
                LOG.warn((Object)message);
                throw new Exception("HTTP status: " + httpResponseCode);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.grantAccess(" + request + ")"));
        }
    }

    public ServiceTags getServiceTagsIfUpdated(final long lastKnownVersion, final long lastActivationTimeInMillis) throws Exception {
        UserGroupInformation user;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminJersey2RESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")"));
        }
        boolean isSecureMode = (user = MiscUtil.getUGILoginUser()) != null && UserGroupInformation.isSecurityEnabled();
        String url = null;
        ServiceTags serviceTags = null;
        Response response = null;
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking Service tags if updated as user : " + user));
            }
            final String secureUrl = url = this._utils.getSecureUrlForTagUpdate(this._baseUrl, this._serviceName);
            PrivilegedAction<Response> action = new PrivilegedAction<Response>(){

                @Override
                public Response run() {
                    return RangerAdminJersey2RESTClient.this._client.target(secureUrl).queryParam("lastKnownVersion", new Object[]{Long.toString(lastKnownVersion)}).queryParam("lastActivationTime", new Object[]{Long.toString(lastActivationTimeInMillis)}).queryParam("pluginId", new Object[]{RangerAdminJersey2RESTClient.this._pluginId}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
                }
            };
            response = (Response)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checking Service tags if updated with old api call");
            }
            url = this._utils.getUrlForTagUpdate(this._baseUrl, this._serviceName);
            response = this._client.target(url).queryParam("lastKnownVersion", new Object[]{Long.toString(lastKnownVersion)}).queryParam("lastActivationTime", new Object[]{Long.toString(lastActivationTimeInMillis)}).queryParam("pluginId", new Object[]{this._pluginId}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        }
        int httpResponseCode = response == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Response from 200 server: " + body));
                }
                Gson gson = this.getGson();
                serviceTags = (ServiceTags)gson.fromJson(body, ServiceTags.class);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("Deserialized response to: " + serviceTags));
                break;
            }
            case 304: {
                LOG.debug((Object)"Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                LOG.warn((Object)"Unexpected: Null response from tag server while trying to get tags! Returning null!");
                break;
            }
            case 404: {
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this._serviceName, (String)body);
                }
                LOG.warn((Object)("Received 404 error code with body:[" + body + "], Ignoring"));
                break;
            }
            default: {
                body = (String)response.readEntity(String.class);
                LOG.warn((Object)String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, url));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminJersey2RESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + serviceTags));
        }
        return serviceTags;
    }

    public List<String> getTagTypes(String pattern) throws Exception {
        throw new Exception("RangerAdminjersey2RESTClient.getTagTypes() -- *** NOT IMPLEMENTED *** ");
    }

    Gson getGson() {
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Date.class, (Object)new GsonUnixDateDeserializer()).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Client getClient() {
        Client result = this._client;
        if (result == null) {
            RangerAdminJersey2RESTClient rangerAdminJersey2RESTClient = this;
            synchronized (rangerAdminJersey2RESTClient) {
                result = this._client;
                if (result == null) {
                    this._client = result = this.buildClient();
                }
            }
        }
        return result;
    }

    Client buildClient() {
        if (this._isSSL) {
            if (this._sslContext == null) {
                RangerSslHelper sslHelper = new RangerSslHelper(this._sslConfigFileName);
                this._sslContext = sslHelper.createContext();
            }
            if (this._hv == null) {
                this._hv = new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        return session.getPeerHost().equals(urlHostName);
                    }
                };
            }
            this._client = ClientBuilder.newBuilder().sslContext(this._sslContext).hostnameVerifier(this._hv).build();
        }
        if (this._client == null) {
            this._client = ClientBuilder.newClient();
        }
        return this._client;
    }

    public static class GsonUnixDateDeserializer
    implements JsonDeserializer<Date> {
        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new Date(json.getAsJsonPrimitive().getAsLong());
        }
    }
}

