/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.kms.metrics.source;

import com.codahale.metrics.Meter;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.ranger.kms.metrics.KMSMetrics;
import org.apache.ranger.kms.metrics.collector.KMSMetricsCollector;
import org.apache.ranger.metrics.RangerMetricsInfo;
import org.apache.ranger.metrics.source.RangerMetricsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMSMetricSource
extends RangerMetricsSource {
    private static final Logger LOG = LoggerFactory.getLogger(KMSMetricSource.class);
    private final String context;
    private final String record;
    private final KMSMetricsCollector kmsMetricsCollector;

    public KMSMetricSource(String context, String record, KMSMetricsCollector kmsMetricsCollector) {
        this.context = context;
        this.record = record;
        this.kmsMetricsCollector = kmsMetricsCollector;
    }

    protected void refresh() {
    }

    protected void update(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(this.record).setContext(this.context);
        boolean isCollectionThreadSafe = this.kmsMetricsCollector.isCollectionThreadSafe();
        Map<KMSMetrics.KMSMetric, Long> collectorMetricsMap = null;
        if (!isCollectionThreadSafe) {
            collectorMetricsMap = this.kmsMetricsCollector.getMetricsMap();
        }
        block4: for (KMSMetrics.KMSMetric metric : KMSMetrics.KMSMetric.values()) {
            LOG.debug("KMSMetricSource: key={} , value={} , type={}", new Object[]{metric.getKey(), metric.getValue(), metric.getType()});
            Long metricVal = isCollectionThreadSafe ? metric.getValue() : (Objects.isNull(collectorMetricsMap.get((Object)metric)) ? 0L : collectorMetricsMap.get((Object)metric));
            switch (metric.getType()) {
                case COUNTER: {
                    builder.addCounter((MetricsInfo)new RangerMetricsInfo(metric.getKey(), ""), Objects.isNull(metricVal) ? 0L : metricVal);
                    continue block4;
                }
                case GAUGE: {
                    builder.addGauge((MetricsInfo)new RangerMetricsInfo(metric.getKey(), ""), Objects.isNull(metricVal) ? 0L : metricVal);
                    continue block4;
                }
                default: {
                    LOG.warn("Unsupported metric type found, it is being ignored. Current metric type {}", (Object)metric.getType());
                }
            }
        }
        this.collectAndUpdateUserAccessMetrics(builder);
    }

    private void collectAndUpdateUserAccessMetrics(MetricsRecordBuilder builder) {
        Long metricVal;
        Meter meter = KMSWebApp.getUnauthenticatedCallsMeter();
        if (null != meter) {
            metricVal = KMSWebApp.getUnauthenticatedCallsMeter().getCount();
            builder.addCounter((MetricsInfo)new RangerMetricsInfo(KMSMetrics.KMSMetric.UNAUTHENTICATED_CALLS_COUNT.getKey(), ""), Objects.isNull(metricVal) ? 0L : metricVal);
        }
        if (null != (meter = KMSWebApp.getUnauthorizedCallsMeter())) {
            metricVal = KMSWebApp.getUnauthorizedCallsMeter().getCount();
            builder.addCounter((MetricsInfo)new RangerMetricsInfo(KMSMetrics.KMSMetric.UNAUTHORIZED_CALLS_COUNT.getKey(), ""), Objects.isNull(metricVal) ? 0L : metricVal);
        }
    }
}

