/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.apache.ranger.kms.metrics.KMSMetricWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="metrics")
@InterfaceAudience.Private
public class MetricREST {
    private static final Logger LOG = LoggerFactory.getLogger(MetricREST.class);
    private final KMSMetricWrapper kmsMetricWrapper = KMSMetricWrapper.getInstance(KMSWebApp.isMetricCollectionThreadSafe());

    @GET
    @Path(value="/prometheus")
    @Produces(value={"text/plain"})
    public String getMetricsPrometheus() {
        LOG.debug("MetricsREST.getMetricsPrometheus() ===>>");
        String ret = "";
        try {
            ret = this.kmsMetricWrapper.getRangerMetricsInPrometheusFormat();
        }
        catch (Exception e) {
            LOG.error("MetricsREST.getMetricsPrometheus(): Exception occured while getting metric.", (Throwable)e);
        }
        LOG.debug("MetricsREST.getMetricsPrometheus() <<=== {}", (Object)ret);
        return ret;
    }

    @GET
    @Path(value="/json")
    @Produces(value={"application/json", "application/xml"})
    public Map<String, Map<String, Object>> getMetricsJson() {
        LOG.debug("MetricsREST.getMetricsJson() ===>>");
        Map<String, Map<String, Object>> ret = null;
        try {
            ret = this.kmsMetricWrapper.getRangerMetricsInJsonFormat();
        }
        catch (Exception e) {
            LOG.error("MetricsREST.getMetricsJson(): Exception occurred while getting metric.", (Throwable)e);
        }
        LOG.debug("MetricsREST.getMetricsJson() <<=== {}", ret);
        return ret;
    }
}

