/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.kms.server.KMS;
import org.apache.hadoop.crypto.key.kms.server.KMSACLsType;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.ranger.plugin.util.AutoClosableLock;

public class KeyAuthorizationKeyProvider
extends KeyProviderCryptoExtension {
    public static final String KEY_ACL = "key.acl.";
    private static final String KEY_ACL_NAME = "key.acl.name";
    private final KeyProviderCryptoExtension provider;
    private final KeyACLs acls;
    private final ReentrantReadWriteLock lock;

    public KeyAuthorizationKeyProvider(KeyProviderCryptoExtension keyProvider, KeyACLs acls) {
        super((KeyProvider)keyProvider, null);
        this.provider = keyProvider;
        this.acls = acls;
        this.lock = new ReentrantReadWriteLock(true);
    }

    public void warmUpEncryptedKeys(String ... names) throws IOException {
        try (AutoClosableLock.AutoClosableReadLock ignored = new AutoClosableLock.AutoClosableReadLock((ReadWriteLock)this.lock);){
            for (String name : names) {
                this.doAccessCheck(name, KeyOpType.GENERATE_EEK);
            }
            this.provider.warmUpEncryptedKeys(names);
        }
    }

    public KeyProviderCryptoExtension.EncryptedKeyVersion generateEncryptedKey(String encryptionKeyName) throws IOException, GeneralSecurityException {
        try (AutoClosableLock.AutoClosableReadLock ignored = new AutoClosableLock.AutoClosableReadLock((ReadWriteLock)this.lock);){
            this.doAccessCheck(encryptionKeyName, KeyOpType.GENERATE_EEK);
            KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion = this.provider.generateEncryptedKey(encryptionKeyName);
            return encryptedKeyVersion;
        }
    }

    public KeyProvider.KeyVersion decryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion) throws IOException, GeneralSecurityException {
        try (AutoClosableLock.AutoClosableReadLock ignored = new AutoClosableLock.AutoClosableReadLock((ReadWriteLock)this.lock);){
            this.verifyKeyVersionBelongsToKey(encryptedKeyVersion);
            this.doAccessCheck(encryptedKeyVersion.getEncryptionKeyName(), KeyOpType.DECRYPT_EEK);
            KeyProvider.KeyVersion keyVersion = this.provider.decryptEncryptedKey(encryptedKeyVersion);
            return keyVersion;
        }
    }

    public KeyProviderCryptoExtension.EncryptedKeyVersion reencryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion ekv) throws IOException, GeneralSecurityException {
        try (AutoClosableLock.AutoClosableReadLock ignored = new AutoClosableLock.AutoClosableReadLock((ReadWriteLock)this.lock);){
            this.verifyKeyVersionBelongsToKey(ekv);
            this.doAccessCheck(ekv.getEncryptionKeyName(), KeyOpType.GENERATE_EEK);
            KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion = this.provider.reencryptEncryptedKey(ekv);
            return encryptedKeyVersion;
        }
    }

    public void reencryptEncryptedKeys(List<KeyProviderCryptoExtension.EncryptedKeyVersion> ekvs) throws IOException, GeneralSecurityException {
        if (ekvs.isEmpty()) {
            return;
        }
        try (AutoClosableLock.AutoClosableReadLock ignored = new AutoClosableLock.AutoClosableReadLock((ReadWriteLock)this.lock);){
            for (KeyProviderCryptoExtension.EncryptedKeyVersion ekv : ekvs) {
                this.verifyKeyVersionBelongsToKey(ekv);
            }
            String keyName = ekvs.get(0).getEncryptionKeyName();
            this.doAccessCheck(keyName, KeyOpType.GENERATE_EEK);
            this.provider.reencryptEncryptedKeys(ekvs);
        }
    }

    protected KeyProvider getKeyProvider() {
        return this;
    }

    public boolean isTransient() {
        return this.provider.isTransient();
    }

    public KeyProvider.Metadata[] getKeysMetadata(String ... names) throws IOException {
        try (AutoClosableLock.AutoClosableReadLock ignored = new AutoClosableLock.AutoClosableReadLock((ReadWriteLock)this.lock);){
            for (String name : names) {
                this.doAccessCheck(name, KeyOpType.READ);
            }
            String[] stringArray = this.provider.getKeysMetadata(names);
            return stringArray;
        }
    }

    public KeyProvider.KeyVersion getCurrentKey(String name) throws IOException {
        try (AutoClosableLock.AutoClosableReadLock ignored = new AutoClosableLock.AutoClosableReadLock((ReadWriteLock)this.lock);){
            this.doAccessCheck(name, KeyOpType.READ);
            KeyProvider.KeyVersion keyVersion = this.provider.getCurrentKey(name);
            return keyVersion;
        }
    }

    public KeyProvider.KeyVersion createKey(String name, KeyProvider.Options options) throws NoSuchAlgorithmException, IOException {
        try (AutoClosableLock.AutoClosableWriteLock ignored = new AutoClosableLock.AutoClosableWriteLock((ReadWriteLock)this.lock);){
            this.authorizeCreateKey(name, options, this.getUser());
            KeyProvider.KeyVersion keyVersion = this.provider.createKey(name, options);
            return keyVersion;
        }
    }

    public KeyProvider.KeyVersion rollNewVersion(String name) throws NoSuchAlgorithmException, IOException {
        try (AutoClosableLock.AutoClosableWriteLock ignored = new AutoClosableLock.AutoClosableWriteLock((ReadWriteLock)this.lock);){
            this.doAccessCheck(name, KeyOpType.MANAGEMENT);
            KeyProvider.KeyVersion keyVersion = this.provider.rollNewVersion(name);
            return keyVersion;
        }
    }

    public KeyProvider.KeyVersion getKeyVersion(String versionName) throws IOException {
        KeyProvider.KeyVersion keyVersion = this.provider.getKeyVersion(versionName);
        if (keyVersion != null) {
            this.doAccessCheck(keyVersion.getName(), KeyOpType.READ);
        }
        return keyVersion;
    }

    public List<String> getKeys() throws IOException {
        return this.provider.getKeys();
    }

    public List<KeyProvider.KeyVersion> getKeyVersions(String name) throws IOException {
        try (AutoClosableLock.AutoClosableReadLock ignored = new AutoClosableLock.AutoClosableReadLock((ReadWriteLock)this.lock);){
            this.doAccessCheck(name, KeyOpType.READ);
            List list = this.provider.getKeyVersions(name);
            return list;
        }
    }

    public KeyProvider.Metadata getMetadata(String name) throws IOException {
        this.doAccessCheck(name, KeyOpType.READ);
        return this.provider.getMetadata(name);
    }

    public KeyProvider.KeyVersion createKey(String name, byte[] material, KeyProvider.Options options) throws IOException {
        try (AutoClosableLock.AutoClosableWriteLock ignored = new AutoClosableLock.AutoClosableWriteLock((ReadWriteLock)this.lock);){
            this.authorizeCreateKey(name, options, this.getUser());
            KeyProvider.KeyVersion keyVersion = this.provider.createKey(name, material, options);
            return keyVersion;
        }
    }

    public void deleteKey(String name) throws IOException {
        try (AutoClosableLock.AutoClosableWriteLock ignored = new AutoClosableLock.AutoClosableWriteLock((ReadWriteLock)this.lock);){
            this.doAccessCheck(name, KeyOpType.MANAGEMENT);
            this.provider.deleteKey(name);
        }
    }

    public KeyProvider.KeyVersion rollNewVersion(String name, byte[] material) throws IOException {
        try (AutoClosableLock.AutoClosableWriteLock ignored = new AutoClosableLock.AutoClosableWriteLock((ReadWriteLock)this.lock);){
            this.doAccessCheck(name, KeyOpType.MANAGEMENT);
            KeyProvider.KeyVersion keyVersion = this.provider.rollNewVersion(name, material);
            return keyVersion;
        }
    }

    public void flush() throws IOException {
        this.provider.flush();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ":" + this.provider.toString();
    }

    private void authorizeCreateKey(String keyName, KeyProvider.Options options, UserGroupInformation ugi) throws IOException {
        boolean success;
        Preconditions.checkNotNull((Object)ugi, (Object)"UserGroupInformation cannot be null");
        Map attributes = options.getAttributes();
        String aclName = (String)attributes.get(KEY_ACL_NAME);
        if (StringUtils.isEmpty((CharSequence)aclName)) {
            if (this.acls.isACLPresent(keyName, KeyOpType.MANAGEMENT)) {
                options.setAttributes((Map)ImmutableMap.builder().putAll(attributes).put((Object)KEY_ACL_NAME, (Object)keyName).build());
                success = this.acls.hasAccessToKey(keyName, ugi, KeyOpType.MANAGEMENT) || this.acls.hasAccessToKey(keyName, ugi, KeyOpType.ALL);
            } else {
                success = false;
            }
        } else {
            boolean bl = success = this.acls.isACLPresent(aclName, KeyOpType.MANAGEMENT) && (this.acls.hasAccessToKey(aclName, ugi, KeyOpType.MANAGEMENT) || this.acls.hasAccessToKey(aclName, ugi, KeyOpType.ALL));
        }
        if (!success) {
            throw new AuthorizationException(String.format("User [%s] is not authorized to create key !!", ugi.getShortUserName()));
        }
    }

    private void checkAccess(String aclName, UserGroupInformation ugi, KeyOpType opType) throws AuthorizationException {
        Preconditions.checkNotNull((Object)aclName, (Object)"Key ACL name cannot be null");
        Preconditions.checkNotNull((Object)ugi, (Object)"UserGroupInformation cannot be null");
        if (this.acls.isACLPresent(aclName, KeyOpType.MANAGEMENT) && (this.acls.hasAccessToKey(aclName, ugi, opType) || this.acls.hasAccessToKey(aclName, ugi, KeyOpType.ALL))) {
            return;
        }
        throw new AuthorizationException(String.format("User [%s] is not authorized to perform [%s] on key with ACL name [%s]!!", new Object[]{ugi.getShortUserName(), opType, aclName}));
    }

    private void verifyKeyVersionBelongsToKey(KeyProviderCryptoExtension.EncryptedKeyVersion ekv) throws IOException {
        String kn = ekv.getEncryptionKeyName();
        String kvn = ekv.getEncryptionKeyVersionName();
        KeyProvider.KeyVersion kv = this.provider.getKeyVersion(kvn);
        if (kv == null) {
            throw new IllegalArgumentException(String.format("'%s' not found", kvn));
        }
        if (!kv.getName().equals(kn)) {
            throw new IllegalArgumentException(String.format("KeyVersion '%s' does not belong to the key '%s'", kvn, kn));
        }
    }

    private void doAccessCheck(String keyName, KeyOpType opType) throws IOException {
        KeyProvider.Metadata metadata = this.provider.getMetadata(keyName);
        if (metadata != null) {
            String aclName = (String)metadata.getAttributes().get(KEY_ACL_NAME);
            this.checkAccess(aclName == null ? keyName : aclName, this.getUser(), opType);
        }
    }

    private UserGroupInformation getUser() throws IOException {
        return UserGroupInformation.getCurrentUser();
    }

    public static interface KeyACLs {
        public boolean hasAccessToKey(String var1, UserGroupInformation var2, KeyOpType var3);

        public boolean isACLPresent(String var1, KeyOpType var2);

        public void startReloader();

        public void stopReloader();

        public boolean hasAccess(KMSACLsType.Type var1, UserGroupInformation var2, String var3);

        public void assertAccess(KMSACLsType.Type var1, UserGroupInformation var2, KMS.KMSOp var3, String var4, String var5) throws AccessControlException;
    }

    public static enum KeyOpType {
        ALL,
        READ,
        MANAGEMENT,
        GENERATE_EEK,
        DECRYPT_EEK;

    }
}

