/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.CachingKeyProvider;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.crypto.key.kms.server.EagerKeyGeneratorKeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.kms.server.KMSACLs;
import org.apache.hadoop.crypto.key.kms.server.KMSAudit;
import org.apache.hadoop.crypto.key.kms.server.KMSConfiguration;
import org.apache.hadoop.crypto.key.kms.server.KeyAuthorizationKeyProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.VersionInfo;
import org.apache.ranger.kms.metrics.KMSMetricWrapper;
import org.apache.ranger.kms.metrics.collector.KMSMetricsCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

@InterfaceAudience.Private
public class KMSWebApp
implements ServletContextListener {
    private static Logger log;
    public static final String HADOOP_KMS_METRIC_COLLECTION_THREADSAFE = "hadoop.kms.metric.collection.threadsafe";
    private static final String METRICS_PREFIX = "hadoop.kms.";
    private static final String ADMIN_CALLS_METER = "hadoop.kms.admin.calls.meter";
    private static final String KEY_CALLS_METER = "hadoop.kms.key.calls.meter";
    private static final String INVALID_CALLS_METER = "hadoop.kms.invalid.calls.meter";
    private static final String UNAUTHORIZED_CALLS_METER = "hadoop.kms.unauthorized.calls.meter";
    private static final String UNAUTHENTICATED_CALLS_METER = "hadoop.kms.unauthenticated.calls.meter";
    private static final String GENERATE_EEK_METER = "hadoop.kms.generate_eek.calls.meter";
    private static final String DECRYPT_EEK_METER = "hadoop.kms.decrypt_eek.calls.meter";
    private static final String REENCRYPT_EEK_METER = "hadoop.kms.reencrypt_eek.calls.meter";
    private static final String REENCRYPT_EEK_BATCH_METER = "hadoop.kms.reencrypt_eek_batch.calls.meter";
    private static MetricRegistry metricRegistry;
    private static Configuration kmsConf;
    private static KeyAuthorizationKeyProvider.KeyACLs kmsAcls;
    private static Meter adminCallsMeter;
    private static Meter keyCallsMeter;
    private static Meter unauthorizedCallsMeter;
    private static Meter unauthenticatedCallsMeter;
    private static Meter decryptEEKCallsMeter;
    private static Meter reencryptEEKCallsMeter;
    private static Meter reencryptEEKBatchCallsMeter;
    private static Meter generateEEKCallsMeter;
    private static Meter invalidCallsMeter;
    private static KMSAudit kmsAudit;
    private static KeyProviderCryptoExtension keyProviderCryptoExtension;
    private static KMSMetricsCollector kmsMetricsCollector;
    private static boolean isMetricsCollectionThreadsafe;
    private JmxReporter jmxReporter;

    public static Configuration getConfiguration() {
        return new Configuration(kmsConf);
    }

    public static KeyAuthorizationKeyProvider.KeyACLs getACLs() {
        return kmsAcls;
    }

    public static Meter getAdminCallsMeter() {
        return adminCallsMeter;
    }

    public static Meter getKeyCallsMeter() {
        return keyCallsMeter;
    }

    public static Meter getInvalidCallsMeter() {
        return invalidCallsMeter;
    }

    public static Meter getGenerateEEKCallsMeter() {
        return generateEEKCallsMeter;
    }

    public static Meter getDecryptEEKCallsMeter() {
        return decryptEEKCallsMeter;
    }

    public static Meter getReencryptEEKCallsMeter() {
        return reencryptEEKCallsMeter;
    }

    public static Meter getReencryptEEKBatchCallsMeter() {
        return reencryptEEKBatchCallsMeter;
    }

    public static Meter getUnauthorizedCallsMeter() {
        return unauthorizedCallsMeter;
    }

    public static Meter getUnauthenticatedCallsMeter() {
        return unauthenticatedCallsMeter;
    }

    public static KeyProviderCryptoExtension getKeyProvider() {
        return keyProviderCryptoExtension;
    }

    public static KMSAudit getKMSAudit() {
        return kmsAudit;
    }

    public static boolean isMetricCollectionThreadSafe() {
        return isMetricsCollectionThreadsafe;
    }

    public static KMSMetricsCollector getKmsMetricsCollector() {
        return kmsMetricsCollector;
    }

    public void contextInitialized(ServletContextEvent sce) {
        try {
            String confDir = System.getProperty("kms.config.dir");
            if (confDir == null) {
                throw new RuntimeException("System property 'kms.config.dir' not defined");
            }
            kmsConf = KMSConfiguration.getKMSConf();
            this.initLogging();
            UserGroupInformation.setConfiguration((Configuration)kmsConf);
            log.info("-------------------------------------------------------------");
            log.info("  Java runtime version : {}", (Object)System.getProperty("java.runtime.version"));
            log.info("  KMS Hadoop Version: {}", (Object)VersionInfo.getVersion());
            log.info("-------------------------------------------------------------");
            kmsAcls = this.getKeyAcls(kmsConf.get("hadoop.kms.security.authorization.manager"));
            kmsAcls.startReloader();
            metricRegistry = new MetricRegistry();
            this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).build();
            this.jmxReporter.start();
            generateEEKCallsMeter = (Meter)metricRegistry.register(GENERATE_EEK_METER, (Metric)new Meter());
            decryptEEKCallsMeter = (Meter)metricRegistry.register(DECRYPT_EEK_METER, (Metric)new Meter());
            reencryptEEKCallsMeter = (Meter)metricRegistry.register(REENCRYPT_EEK_METER, (Metric)new Meter());
            reencryptEEKBatchCallsMeter = (Meter)metricRegistry.register(REENCRYPT_EEK_BATCH_METER, (Metric)new Meter());
            adminCallsMeter = (Meter)metricRegistry.register(ADMIN_CALLS_METER, (Metric)new Meter());
            keyCallsMeter = (Meter)metricRegistry.register(KEY_CALLS_METER, (Metric)new Meter());
            invalidCallsMeter = (Meter)metricRegistry.register(INVALID_CALLS_METER, (Metric)new Meter());
            unauthorizedCallsMeter = (Meter)metricRegistry.register(UNAUTHORIZED_CALLS_METER, (Metric)new Meter());
            unauthenticatedCallsMeter = (Meter)metricRegistry.register(UNAUTHENTICATED_CALLS_METER, (Metric)new Meter());
            kmsAudit = new KMSAudit(kmsConf);
            isMetricsCollectionThreadsafe = Boolean.valueOf(kmsConf.get(HADOOP_KMS_METRIC_COLLECTION_THREADSAFE, "false"));
            KMSMetricWrapper kmsMetricWrapper = KMSMetricWrapper.getInstance(KMSWebApp.isMetricCollectionThreadSafe());
            kmsMetricsCollector = kmsMetricWrapper.getKmsMetricsCollector();
            String providerString = kmsConf.get("hadoop.kms.key.provider.uri");
            if (providerString == null) {
                throw new IllegalStateException("No KeyProvider has been defined");
            }
            log.info("------------------ Ranger KMSWebApp---------------------");
            log.info("provider string = {}", (Object)providerString);
            log.info("URI = {} scheme = {}", (Object)new URI(providerString), (Object)new URI(providerString).getScheme());
            log.info("kmsconf size= {} kms classname={}", (Object)kmsConf.size(), (Object)kmsConf.getClass().getName());
            log.info("----------------Instantiating key provider ---------------");
            KeyProvider keyProvider = KMSWebApp.createKeyProvider(new URI(providerString), kmsConf);
            Preconditions.checkNotNull((Object)keyProvider, (Object)String.format("No KeyProvider has been initialized, please check whether %s '%s' is configured correctly in kms-site.xml.", "hadoop.kms.key.provider.uri", providerString));
            log.info("keyProvider = {}", (Object)keyProvider);
            if (kmsConf.getBoolean("hadoop.kms.cache.enable", true)) {
                long keyTimeOutMillis = kmsConf.getLong("hadoop.kms.cache.timeout.ms", 600000L);
                long currKeyTimeOutMillis = kmsConf.getLong("hadoop.kms.current.key.cache.timeout.ms", 30000L);
                keyProvider = new CachingKeyProvider(keyProvider, keyTimeOutMillis, currKeyTimeOutMillis);
            }
            log.info("Initialized KeyProvider {}", (Object)keyProvider);
            keyProviderCryptoExtension = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)keyProvider);
            keyProviderCryptoExtension = new EagerKeyGeneratorKeyProviderCryptoExtension(kmsConf, keyProviderCryptoExtension);
            if (kmsConf.getBoolean("hadoop.kms.key.authorization.enable", true)) {
                keyProviderCryptoExtension = new KeyAuthorizationKeyProvider(keyProviderCryptoExtension, kmsAcls);
            }
            log.info("Initialized KeyProviderCryptoExtension {}", (Object)keyProviderCryptoExtension);
            log.info("Default key bitlength is {}", (Object)kmsConf.getInt("hadoop.security.key.default.bitlength", 128));
            log.info("Ranger KMS Started");
            ShutdownHookManager.get().addShutdownHook(() -> KMSMetricWrapper.getInstance(KMSWebApp.isMetricCollectionThreadSafe()).writeJsonMetricsToFile(), 10);
        }
        catch (Throwable ex) {
            System.out.println();
            System.out.println("ERROR: Hadoop KMS could not be started");
            System.out.println();
            System.out.println("REASON: " + ex);
            System.out.println();
            System.out.println("Stacktrace:");
            System.out.println("---------------------------------------------------");
            ex.printStackTrace(System.out);
            System.out.println("---------------------------------------------------");
            System.out.println();
            System.exit(1);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            keyProviderCryptoExtension.close();
        }
        catch (IOException ioe) {
            log.error("Error closing KeyProviderCryptoExtension", (Throwable)ioe);
        }
        kmsAudit.shutdown();
        kmsAcls.stopReloader();
        this.jmxReporter.stop();
        this.jmxReporter.close();
        metricRegistry = null;
        log.info("KMS Stopped");
    }

    private void initLogging() {
        log = LoggerFactory.getLogger(KMSWebApp.class);
    }

    private static KeyProvider createKeyProvider(URI uri, Configuration conf) throws IOException {
        KeyProviderFactory factory;
        ServiceLoader<KeyProviderFactory> serviceLoader = ServiceLoader.load(KeyProviderFactory.class);
        KeyProvider kp = null;
        Iterator<KeyProviderFactory> iterator = serviceLoader.iterator();
        while (iterator.hasNext() && (kp = (factory = iterator.next()).createProvider(uri, conf)) == null) {
        }
        return kp;
    }

    private KeyAuthorizationKeyProvider.KeyACLs getKeyAcls(String clsStr) throws IOException {
        KeyAuthorizationKeyProvider.KeyACLs keyAcl = null;
        try {
            Class cls = null;
            if (clsStr == null || clsStr.trim().isEmpty()) {
                cls = KMSACLs.class;
            } else {
                Class<?> configClass = Class.forName(clsStr);
                if (!KeyAuthorizationKeyProvider.KeyACLs.class.isAssignableFrom(configClass)) {
                    throw new RuntimeException(clsStr + " should implement KeyACLs");
                }
                cls = configClass;
            }
            if (cls != null) {
                keyAcl = (KeyAuthorizationKeyProvider.KeyACLs)ReflectionUtils.newInstance(cls, (Configuration)kmsConf);
            }
        }
        catch (Exception e) {
            log.error("Unable to getAcls with an exception", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        return keyAcl;
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

