/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.util.KMSUtil;

@InterfaceAudience.Private
public class KMSServerJSONUtils {
    private KMSServerJSONUtils() {
    }

    public static List toJSON(List<KeyProvider.KeyVersion> keyVersions) {
        ArrayList<Map> json = new ArrayList<Map>();
        if (keyVersions != null) {
            for (KeyProvider.KeyVersion version : keyVersions) {
                json.add(KMSUtil.toJSON((KeyProvider.KeyVersion)version));
            }
        }
        return json;
    }

    public static Map toJSON(String keyName, KeyProvider.Metadata meta) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        if (meta != null) {
            json.put("name", keyName);
            json.put("cipher", meta.getCipher());
            json.put("length", meta.getBitLength());
            json.put("description", meta.getDescription());
            json.put("attributes", meta.getAttributes());
            json.put("created", meta.getCreated().getTime());
            json.put("versions", Long.valueOf(meta.getVersions()));
        }
        return json;
    }

    public static List toJSON(String[] keyNames, KeyProvider.Metadata[] metas) {
        ArrayList<Map> json = new ArrayList<Map>();
        for (int i = 0; i < keyNames.length; ++i) {
            json.add(KMSServerJSONUtils.toJSON(keyNames[i], metas[i]));
        }
        return json;
    }
}

