/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.kms.server.KMSConfiguration;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMSMetricUtil {
    private static final Logger logger = LoggerFactory.getLogger(KMSMetricUtil.class);
    private static final String HSM_ENABLED = "ranger.ks.hsm.enabled";
    private static String metricType;

    public static void main(String[] args) {
        logger.info("KMSMetricUtil : main()");
        if (args.length != 2) {
            System.out.println("type: Incorrect Arguments usage : For KMSMetric Usage: metric -type  hsmenabled | encryptedkey | encryptedkeybyalgorithm");
        } else if (!args[0].equalsIgnoreCase("-type") || !args[1].equalsIgnoreCase("hsmenabled") && !args[1].equalsIgnoreCase("encryptedkey") && !args[1].equalsIgnoreCase("encryptedkeybyalgorithm")) {
            System.out.println("type: Incorrect Arguments usage : For KMSMetric Usage: metric -type  hsmenabled | encryptedkey | encryptedkeybyalgorithm");
        } else {
            metricType = args[1];
            logger.debug("KMSMetric Type : {}", (Object)metricType);
        }
        KMSMetricUtil kmsmetricutil = new KMSMetricUtil();
        kmsmetricutil.getKMSMetricCalculation(metricType);
    }

    private void getKMSMetricCalculation(String caseValue) {
        logger.info("Metric Type : {}", (Object)caseValue);
        try {
            switch (caseValue.toLowerCase()) {
                case "hsmenabled": {
                    try {
                        if (KMSConfiguration.getACLsConf() != null) {
                            String jsonHSMEnabled;
                            String hsmEnabledValue = KMSConfiguration.getACLsConf().get(HSM_ENABLED);
                            HashMap<String, String> hsmEnabledMap = new HashMap<String, String>();
                            if (hsmEnabledValue != null) {
                                hsmEnabledMap.put("hsmEnabled", hsmEnabledValue);
                                Gson gson = new GsonBuilder().create();
                                jsonHSMEnabled = gson.toJson(hsmEnabledMap);
                            } else {
                                hsmEnabledMap.put("hsmEnabled", "");
                                Gson gson = new GsonBuilder().create();
                                jsonHSMEnabled = gson.toJson(hsmEnabledMap);
                            }
                            logger.info("HSM Enabled : {}", (Object)jsonHSMEnabled);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error calculating KMSMetric for HSM enabled : {}", (Object)e.getMessage());
                    }
                    break;
                }
                case "encryptedkey": {
                    try {
                        KMSWebApp kmsWebAppEncryptedKey = new KMSWebApp();
                        if (kmsWebAppEncryptedKey != null) {
                            String jsonEncKeycount;
                            kmsWebAppEncryptedKey.contextInitialized(null);
                            KeyProviderCryptoExtension keyProvider = kmsWebAppEncryptedKey.getKeyProvider();
                            if (keyProvider != null && keyProvider.getKeys() != null) {
                                Integer encryptedKeyCount = keyProvider.getKeys().size();
                                HashMap<String, Integer> encryptedKeyCountValueMap = new HashMap<String, Integer>();
                                encryptedKeyCountValueMap.put("encryptedKeyCount", encryptedKeyCount);
                                Gson gson = new GsonBuilder().create();
                                jsonEncKeycount = gson.toJson(encryptedKeyCountValueMap);
                            } else {
                                HashMap<String, String> encryptedKeyCountValueMap = new HashMap<String, String>();
                                encryptedKeyCountValueMap.put("encryptedKeyCount", "");
                                Gson gson = new GsonBuilder().create();
                                jsonEncKeycount = gson.toJson(encryptedKeyCountValueMap);
                            }
                            logger.info("Encrypted Key Count : {}", (Object)jsonEncKeycount);
                            kmsWebAppEncryptedKey.contextDestroyed(null);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error calculating KMSMetric for encrypted key count: {}", (Object)e.getMessage());
                    }
                    break;
                }
                case "encryptedkeybyalgorithm": {
                    try {
                        KMSWebApp kmsWebApp = new KMSWebApp();
                        if (kmsWebApp != null) {
                            kmsWebApp.contextInitialized(null);
                            KeyProviderCryptoExtension keyProvider = kmsWebApp.getKeyProvider();
                            HashMap<String, Integer> encryptedKeyByAlgorithmCountMap = new HashMap<String, Integer>();
                            int count = 0;
                            String jsonEncKeyByAlgo = null;
                            if (keyProvider != null && keyProvider.getKeys() != null && keyProvider.getKeys().size() > 0) {
                                ArrayList keyList = new ArrayList();
                                keyList.addAll(keyProvider.getKeys());
                                if (keyList != null) {
                                    for (String key : keyList) {
                                        String algorithmName = keyProvider.getMetadata(key).getCipher();
                                        if (encryptedKeyByAlgorithmCountMap.containsKey(algorithmName)) {
                                            count = (Integer)encryptedKeyByAlgorithmCountMap.get(algorithmName);
                                            encryptedKeyByAlgorithmCountMap.put(algorithmName, ++count);
                                            continue;
                                        }
                                        encryptedKeyByAlgorithmCountMap.put(algorithmName, 1);
                                    }
                                    Gson gson = new GsonBuilder().create();
                                    jsonEncKeyByAlgo = gson.toJson(encryptedKeyByAlgorithmCountMap);
                                }
                            } else {
                                encryptedKeyByAlgorithmCountMap.put("encryptedKeyByAlgorithm", count);
                                Gson gson = new GsonBuilder().create();
                                jsonEncKeyByAlgo = gson.toJson(encryptedKeyByAlgorithmCountMap);
                            }
                            logger.info("Key Encryption Algorithm : {}", (Object)jsonEncKeyByAlgo);
                            kmsWebApp.contextDestroyed(null);
                        }
                    }
                    catch (IOException e) {
                        logger.error("Error calculating KMSMetric for encrypted key by algorithm : {}", (Object)e.getMessage());
                    }
                    break;
                }
                default: {
                    System.out.println("type: Incorrect Arguments usage : For KMSMetric Usage: metric -type  hsmenabled | encryptedkey | encryptedkeybyalgorithm");
                }
            }
        }
        catch (Exception e) {
            logger.error("Error calculating KMSMetric : {}", (Object)e.getMessage());
        }
    }
}

