/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
@InterfaceStability.Evolving
interface KMSAuditLogger {
    public void cleanup() throws IOException;

    public void initialize(Configuration var1) throws IOException;

    public void logAuditEvent(OpStatus var1, AuditEvent var2);

    public static class AuditEvent {
        private final AtomicLong accessCount = new AtomicLong(-1L);
        private final Object op;
        private final String keyName;
        private final String user;
        private final String impersonator;
        private final String remoteHost;
        private final String extraMsg;
        private final long startTime;
        private long endTime = this.startTime = System.currentTimeMillis();

        AuditEvent(Object op, UserGroupInformation ugi, String keyName, String remoteHost, String msg) {
            this.keyName = keyName;
            if (ugi == null) {
                this.user = null;
                this.impersonator = null;
            } else {
                this.user = ugi.getUserName();
                this.impersonator = ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.PROXY ? ugi.getRealUser().getUserName() : null;
            }
            this.remoteHost = remoteHost;
            this.op = op;
            this.extraMsg = msg;
        }

        public AtomicLong getAccessCount() {
            return this.accessCount;
        }

        public Object getOp() {
            return this.op;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public String getUser() {
            return this.user;
        }

        public String getImpersonator() {
            return this.impersonator;
        }

        public String getRemoteHost() {
            return this.remoteHost;
        }

        public String getExtraMsg() {
            return this.extraMsg;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("op=").append(this.op).append(", keyName=").append(this.keyName).append(", user=").append(this.user).append(", impersonator=").append(this.impersonator).append(", remoteHost=").append(this.remoteHost).append(", extraMsg=").append(this.extraMsg);
            return sb.toString();
        }
    }

    public static enum OpStatus {
        OK,
        UNAUTHORIZED,
        UNAUTHENTICATED,
        ERROR;

    }
}

