/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.kms.ValueQueue;

@InterfaceAudience.Private
public class EagerKeyGeneratorKeyProviderCryptoExtension
extends KeyProviderCryptoExtension {
    private static final String KEY_CACHE_PREFIX = "hadoop.security.kms.encrypted.key.cache.";
    public static final int KMS_KEY_CACHE_SIZE_DEFAULT = 100;
    public static final float KMS_KEY_CACHE_LOW_WATERMARK_DEFAULT = 0.3f;
    public static final int KMS_KEY_CACHE_EXPIRY_DEFAULT = 43200000;
    public static final int KMS_KEY_CACHE_NUM_REFILL_THREADS_DEFAULT = 2;
    public static final String KMS_KEY_CACHE_SIZE = "hadoop.security.kms.encrypted.key.cache.size";
    public static final String KMS_KEY_CACHE_LOW_WATERMARK = "hadoop.security.kms.encrypted.key.cache.low.watermark";
    public static final String KMS_KEY_CACHE_EXPIRY_MS = "hadoop.security.kms.encrypted.key.cache.expiry";
    public static final String KMS_KEY_CACHE_NUM_REFILL_THREADS = "hadoop.security.kms.encrypted.key.cache.num.fill.threads";

    public EagerKeyGeneratorKeyProviderCryptoExtension(Configuration conf, KeyProviderCryptoExtension keyProviderCryptoExtension) {
        super((KeyProvider)keyProviderCryptoExtension, (KeyProviderCryptoExtension.CryptoExtension)new CryptoExtension(conf, keyProviderCryptoExtension));
    }

    public KeyProvider.KeyVersion rollNewVersion(String name) throws NoSuchAlgorithmException, IOException {
        KeyProvider.KeyVersion keyVersion = super.rollNewVersion(name);
        ((KeyProviderCryptoExtension.CryptoExtension)this.getExtension()).drain(name);
        return keyVersion;
    }

    public KeyProvider.KeyVersion rollNewVersion(String name, byte[] material) throws IOException {
        KeyProvider.KeyVersion keyVersion = super.rollNewVersion(name, material);
        ((KeyProviderCryptoExtension.CryptoExtension)this.getExtension()).drain(name);
        return keyVersion;
    }

    public void invalidateCache(String name) throws IOException {
        super.invalidateCache(name);
        ((KeyProviderCryptoExtension.CryptoExtension)this.getExtension()).drain(name);
    }

    private static class CryptoExtension
    implements KeyProviderCryptoExtension.CryptoExtension {
        private final ValueQueue<KeyProviderCryptoExtension.EncryptedKeyVersion> encKeyVersionQueue;
        private final KeyProviderCryptoExtension keyProviderCryptoExtension;

        public CryptoExtension(Configuration conf, KeyProviderCryptoExtension keyProviderCryptoExtension) {
            this.keyProviderCryptoExtension = keyProviderCryptoExtension;
            this.encKeyVersionQueue = new ValueQueue(conf.getInt(EagerKeyGeneratorKeyProviderCryptoExtension.KMS_KEY_CACHE_SIZE, 100), conf.getFloat(EagerKeyGeneratorKeyProviderCryptoExtension.KMS_KEY_CACHE_LOW_WATERMARK, 0.3f), (long)conf.getInt(EagerKeyGeneratorKeyProviderCryptoExtension.KMS_KEY_CACHE_EXPIRY_MS, 43200000), conf.getInt(EagerKeyGeneratorKeyProviderCryptoExtension.KMS_KEY_CACHE_NUM_REFILL_THREADS, 2), ValueQueue.SyncGenerationPolicy.LOW_WATERMARK, (ValueQueue.QueueRefiller)new EncryptedQueueRefiller());
        }

        public void warmUpEncryptedKeys(String ... keyNames) throws IOException {
            try {
                this.encKeyVersionQueue.initializeQueuesForKeys(keyNames);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }

        public void drain(String keyName) {
            this.encKeyVersionQueue.drain(keyName);
        }

        public KeyProviderCryptoExtension.EncryptedKeyVersion generateEncryptedKey(String encryptionKeyName) throws IOException, GeneralSecurityException {
            try {
                return (KeyProviderCryptoExtension.EncryptedKeyVersion)this.encKeyVersionQueue.getNext(encryptionKeyName);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }

        public KeyProvider.KeyVersion decryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion) throws IOException, GeneralSecurityException {
            return this.keyProviderCryptoExtension.decryptEncryptedKey(encryptedKeyVersion);
        }

        public KeyProviderCryptoExtension.EncryptedKeyVersion reencryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion arg0) throws IOException, GeneralSecurityException {
            return this.keyProviderCryptoExtension.reencryptEncryptedKey(arg0);
        }

        public void reencryptEncryptedKeys(List<KeyProviderCryptoExtension.EncryptedKeyVersion> arg0) throws IOException, GeneralSecurityException {
            this.keyProviderCryptoExtension.reencryptEncryptedKeys(arg0);
        }

        private class EncryptedQueueRefiller
        implements ValueQueue.QueueRefiller<KeyProviderCryptoExtension.EncryptedKeyVersion> {
            private EncryptedQueueRefiller() {
            }

            public void fillQueueForKey(String keyName, Queue<KeyProviderCryptoExtension.EncryptedKeyVersion> keyQueue, int numKeys) throws IOException {
                LinkedList<KeyProviderCryptoExtension.EncryptedKeyVersion> retEdeks = new LinkedList<KeyProviderCryptoExtension.EncryptedKeyVersion>();
                for (int i = 0; i < numKeys; ++i) {
                    try {
                        retEdeks.add(CryptoExtension.this.keyProviderCryptoExtension.generateEncryptedKey(keyName));
                        continue;
                    }
                    catch (GeneralSecurityException e) {
                        throw new IOException(e);
                    }
                }
                keyQueue.addAll(retEdeks);
            }
        }
    }
}

