/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Function;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public enum SupportedPBECryptoAlgo {
    PBEWithMD5AndTripleDES("PBEWithMD5AndTripleDES", "PBEWithMD5AndTripleDES", 0, keySpec -> new PBEParameterSpec(keySpec.getSalt(), keySpec.getIterationCount())),
    PBEWithMD5AndDES("PBEWithMD5AndDES", "PBEWithMD5AndDES", 0, keySpec -> new PBEParameterSpec(keySpec.getSalt(), keySpec.getIterationCount())),
    PBKDF2WithHmacSHA256("PBKDF2WithHmacSHA256", "AES/CBC/PKCS7Padding", 256, keySpec -> new IvParameterSpec(keySpec.getSalt()));

    private final String encrAlgoName;
    private final String cipherTransformation;
    private final int keyLength;
    private final Function<PBEKeySpec, AlgorithmParameterSpec> algoParamSpecFunc;

    private SupportedPBECryptoAlgo(String encrAlgoName, String cipherTransformation, int keyLength, Function<PBEKeySpec, AlgorithmParameterSpec> algoParamSpecFunc) {
        this.encrAlgoName = encrAlgoName;
        this.cipherTransformation = cipherTransformation;
        this.keyLength = keyLength;
        this.algoParamSpecFunc = algoParamSpecFunc;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public String getAlgoName() {
        return this.encrAlgoName;
    }

    public String getCipherTransformation() {
        return this.cipherTransformation;
    }

    public AlgorithmParameterSpec getAlgoParamSpec(PBEKeySpec keySpec) {
        return this.algoParamSpecFunc.apply(keySpec);
    }

    public static SupportedPBECryptoAlgo getFIPSCompliantAlgorithm() {
        return PBKDF2WithHmacSHA256;
    }

    public static boolean isFIPSCompliantAlgorithm(SupportedPBECryptoAlgo encrAlgo) {
        return PBKDF2WithHmacSHA256.equals((Object)encrAlgo);
    }
}

