/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.RangerKMSMKI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSafenetKeySecure
implements RangerKMSMKI {
    static final Logger logger = LoggerFactory.getLogger(RangerSafenetKeySecure.class);
    private static final String MK_ALGO = "AES";
    private static final int MK_KEY_SIZE_DEFAULT = 256;
    private static final String CFGFILEPATH = "ranger.kms.keysecure.sunpkcs11.cfg.filepath";
    private static final String MK_KEYSIZE = "ranger.kms.keysecure.masterkey.size";
    private static final String ALIAS_KEY = "ranger.kms.keysecure.masterkey.name";
    private static final String PROVIDER_KEY = "ranger.kms.keysecure.provider.type";
    private static final String KEYSECURE_LOGIN = "ranger.kms.keysecure.login";
    private final String alias;
    private final String providerType;
    private final String adp;
    private final int mkSize;
    private KeyStore myStore;
    private Provider provider;
    private final String pkcs11CfgFilePath;

    public RangerSafenetKeySecure(Configuration conf) throws Exception {
        this.mkSize = conf.getInt(MK_KEYSIZE, 256);
        this.alias = conf.get(ALIAS_KEY, "RANGERMK");
        this.providerType = conf.get(PROVIDER_KEY, "SunPKCS11");
        this.adp = conf.get(KEYSECURE_LOGIN);
        this.pkcs11CfgFilePath = conf.get(CFGFILEPATH);
        try {
            int javaVersion = this.getJavaVersion();
            if (javaVersion <= 8) {
                Class<?> providerClass = Class.forName("sun.security.pkcs11.SunPKCS11");
                Constructor<?> constructor = providerClass.getConstructor(String.class);
                this.provider = (Provider)constructor.newInstance(this.pkcs11CfgFilePath);
            } else if (javaVersion > 8) {
                Class<Provider> cls = Provider.class;
                Method configureMethod = cls.getDeclaredMethod("configure", String.class);
                this.provider = Security.getProvider(this.providerType);
                if (this.provider != null) {
                    this.provider = (Provider)configureMethod.invoke((Object)this.provider, this.pkcs11CfgFilePath);
                }
            }
            if (this.provider != null) {
                Security.addProvider(this.provider);
                this.myStore = KeyStore.getInstance("PKCS11", this.provider);
            } else {
                logger.error("Provider was not initialize for Ranger Safenet Key Secure.");
            }
            if (this.myStore != null) {
                this.myStore.load(null, this.adp.toCharArray());
            } else {
                logger.error("Safenet Keysecure not found. Please verify the Ranger KMS Safenet Keysecure configuration setup.");
            }
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException("Unexpected NoSuchMethodException while loading keystore : " + e.getMessage());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new NoSuchAlgorithmException("Unexpected NoSuchAlgorithmException while loading keystore : " + nsae.getMessage());
        }
        catch (CertificateException e) {
            throw new CertificateException("Unexpected CertificateException while loading keystore : " + e.getMessage());
        }
        catch (IOException e) {
            throw new IOException("Unexpected IOException while loading keystore : " + e.getMessage());
        }
    }

    @Override
    public boolean generateMasterKey(String password) {
        if (this.myStore != null) {
            KeyGenerator keyGen = null;
            SecretKey aesKey = null;
            try {
                boolean result = this.myStore.containsAlias(this.alias);
                if (!result) {
                    keyGen = KeyGenerator.getInstance(MK_ALGO, this.provider);
                    keyGen.init(this.mkSize);
                    aesKey = keyGen.generateKey();
                    this.myStore.setKeyEntry(this.alias, aesKey, password.toCharArray(), null);
                    return true;
                }
                return true;
            }
            catch (Exception e) {
                logger.error("generateMasterKey : Exception during Ranger Master Key Generation - {}", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public String getMasterKey(String password) throws Throwable {
        if (this.myStore != null) {
            try {
                SecretKey key;
                boolean result = this.myStore.containsAlias(this.alias);
                if (result && (key = (SecretKey)this.myStore.getKey(this.alias, password.toCharArray())) != null) {
                    return Base64.encode(key.getEncoded());
                }
            }
            catch (Exception e) {
                logger.error("getMasterKey : Exception searching for Ranger Master Key - {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    public boolean setMasterKey(String password, byte[] key, Configuration conf) {
        if (this.myStore != null) {
            try {
                SecretKeySpec aesKey = new SecretKeySpec(key, MK_ALGO);
                this.myStore.setKeyEntry(this.alias, aesKey, password.toCharArray(), null);
                return true;
            }
            catch (Exception e) {
                logger.error("setMasterKey : Exception while setting Master Key - {}", (Object)e.getMessage());
            }
        }
        return false;
    }

    private int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }
}

