/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.google.common.annotations.VisibleForTesting;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.crypto.key.RangerKMSMKI;
import org.apache.hadoop.crypto.key.SupportedPBECryptoAlgo;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.base.Splitter;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.ranger.entity.XXRangerMasterKey;
import org.apache.ranger.kms.dao.DaoManager;
import org.apache.ranger.kms.dao.RangerMasterKeyDao;
import org.apache.ranger.plugin.util.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerMasterKey
implements RangerKMSMKI {
    private static final Logger logger = LoggerFactory.getLogger(RangerMasterKey.class);
    public static final int PADDING_STRING_ELEM_COUNT = 7;
    public static final String DBKS_SITE_XML = "dbks-site.xml";
    private static final String DEFAULT_MK_CIPHER = "AES";
    private static final int DEFAULT_MK_KeySize = 256;
    private static final int DEFAULT_SALT_SIZE = 8;
    private static final String DEFAULT_SALT = "abcdefghijklmnopqrstuvwxyz01234567890";
    private static final int DEFAULT_ITERATION_COUNT = 1000;
    private static final Properties serverConfigProperties = new Properties();
    private static SupportedPBECryptoAlgo defaultCryptAlgo;
    private static SupportedPBECryptoAlgo encrCryptoAlgo;
    public static String mkCipher;
    public static Integer mkKeySize;
    public static Integer saltSize;
    public static String salt;
    public static String pbeAlgo;
    public static String mdAlgo;
    public static Integer iterationCount;
    public static String paddingString;
    private static String password;
    private static String defaultMdAlgo;
    private static boolean isFipsEnabled;
    private final RangerMasterKeyDao masterKeyDao;

    public RangerMasterKey() {
        this(null);
    }

    public RangerMasterKey(DaoManager daoManager) {
        this.masterKeyDao = daoManager != null ? daoManager.getRangerMasterKeyDao() : null;
        this.init();
    }

    public static void getPasswordParam(String paddedEncryptedPwd) {
        String[] encryptedPwd = null;
        if (paddedEncryptedPwd != null && paddedEncryptedPwd.contains(",")) {
            encryptedPwd = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)paddedEncryptedPwd)).toArray(new String[0]);
        }
        if (encryptedPwd != null && encryptedPwd.length >= 7) {
            int index = 0;
            mkCipher = encryptedPwd[index];
            mkKeySize = Integer.parseInt(encryptedPwd[++index]);
            saltSize = Integer.parseInt(encryptedPwd[++index]);
            pbeAlgo = encryptedPwd[++index];
            mdAlgo = encryptedPwd[++index];
            iterationCount = Integer.parseInt(encryptedPwd[++index]);
            salt = encryptedPwd[++index];
            password = encryptedPwd[++index];
        } else {
            mkCipher = DEFAULT_MK_CIPHER;
            mkKeySize = 256;
            saltSize = 8;
            pbeAlgo = isFipsEnabled ? SupportedPBECryptoAlgo.PBEWithMD5AndTripleDES.getAlgoName() : defaultCryptAlgo.getAlgoName();
            mdAlgo = defaultMdAlgo;
            salt = password = paddedEncryptedPwd;
            if (password != null) {
                iterationCount = password.toCharArray().length + 1;
            }
        }
    }

    protected static String getConfig(String key, String defaultValue) {
        String value = serverConfigProperties.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            value = System.getProperty(key);
        }
        if (value == null || value.trim().isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    protected static int getIntConfig(String key, int defaultValue) {
        int ret = defaultValue;
        String retStr = serverConfigProperties.getProperty(key);
        try {
            if (retStr != null) {
                ret = Integer.parseInt(retStr);
            }
        }
        catch (Exception err) {
            logger.warn("Key can not be parsed to int due to NumberFormatException");
        }
        return ret;
    }

    public SecretKey getMasterSecretKey(String password) throws Throwable {
        logger.debug("==> RangerMasterKey.getMasterSecretKey()");
        logger.info("Getting Master Key");
        List result = this.getEncryptedMK();
        String encryptedPassString = null;
        byte[] masterKeyByte = null;
        if (CollectionUtils.isNotEmpty((Collection)result) && result.size() == 2) {
            masterKeyByte = (byte[])result.get(0);
            encryptedPassString = (String)result.get(1);
        } else if (CollectionUtils.isNotEmpty((Collection)result)) {
            masterKeyByte = (byte[])result.get(0);
        }
        if (masterKeyByte != null && masterKeyByte.length > 0) {
            logger.debug("<== RangerMasterKey.getMasterSecretKey()");
            return this.decryptMasterKeySK(masterKeyByte, password, encryptedPassString);
        }
        throw new Exception("No Master Key Found");
    }

    public void init() {
        logger.debug("==> RangerMasterKey.init()");
        XMLUtils.loadConfig((String)DBKS_SITE_XML, (Map)serverConfigProperties);
        isFipsEnabled = RangerMasterKey.getConfig("ranger.keystore.file.type", KeyStore.getDefaultType()).equalsIgnoreCase("bcfks");
        defaultMdAlgo = isFipsEnabled ? "SHA-512" : "MD5";
        defaultCryptAlgo = isFipsEnabled ? SupportedPBECryptoAlgo.PBKDF2WithHmacSHA256 : defaultCryptAlgo;
        mkCipher = RangerMasterKey.getConfig("ranger.kms.service.masterkey.password.cipher", DEFAULT_MK_CIPHER);
        mkKeySize = RangerMasterKey.getIntConfig("ranger.kms.service.masterkey.password.size", 256);
        saltSize = RangerMasterKey.getIntConfig("ranger.kms.service.masterkey.password.salt.size", 8);
        salt = RangerMasterKey.getConfig("ranger.kms.service.masterkey.password.salt", DEFAULT_SALT);
        pbeAlgo = RangerMasterKey.getConfig("ranger.kms.service.masterkey.password.encryption.algorithm", defaultCryptAlgo.getAlgoName());
        encrCryptoAlgo = SupportedPBECryptoAlgo.valueOf(pbeAlgo);
        mdAlgo = RangerMasterKey.getConfig("ranger.kms.service.masterkey.password.md.algorithm", defaultMdAlgo);
        iterationCount = RangerMasterKey.getIntConfig("ranger.kms.service.masterkey.password.iteration.count", 1000);
        paddingString = Joiner.on((String)",").skipNulls().join((Object)mkCipher, (Object)mkKeySize, new Object[]{saltSize, pbeAlgo, mdAlgo, iterationCount, salt});
        logger.info("Selected DEFAULT_CRYPT_ALGO={}", (Object)defaultCryptAlgo);
        logger.info("Selected MD_ALGO={}", (Object)mdAlgo);
        logger.info("Selected ENCR_CRYPTO_ALGO={}", (Object)encrCryptoAlgo);
        logger.debug("<== RangerMasterKey.init()");
    }

    @Override
    public boolean generateMasterKey(String password) throws Throwable {
        logger.debug("==> RangerMasterKey.generateMasterKey()");
        logger.info("Generating Master Key...");
        if (!this.checkMKExistence(this.masterKeyDao)) {
            logger.info("Master Key doesn't exist in DB, Generating the Master Key");
            String encryptedMasterKey = this.encryptMasterKey(password);
            String savedKey = this.saveEncryptedMK(paddingString + "," + encryptedMasterKey);
            if (savedKey != null && !savedKey.trim().equals("")) {
                logger.debug("Master Key Created with id = {}", (Object)savedKey);
                logger.debug("<== RangerMasterKey.generateMasterKey()");
                return true;
            }
        } else {
            logger.debug("Ranger Master Key already exists in the DB, returning.");
        }
        logger.debug("<== RangerMasterKey.generateMasterKey()");
        return false;
    }

    @Override
    public String getMasterKey(String password) throws Throwable {
        logger.debug("==> RangerMasterKey.getMasterKey()");
        logger.info("Getting Master Key");
        List result = this.getEncryptedMK();
        String encryptedPassString = null;
        byte[] masterKeyByte = null;
        if (CollectionUtils.isNotEmpty((Collection)result) && result.size() == 2) {
            masterKeyByte = (byte[])result.get(0);
            encryptedPassString = (String)result.get(1);
        } else if (CollectionUtils.isNotEmpty((Collection)result)) {
            masterKeyByte = (byte[])result.get(0);
        }
        if (masterKeyByte != null && masterKeyByte.length > 0) {
            logger.debug("<== RangerMasterKey.getMasterKey()");
            return this.decryptMasterKey(masterKeyByte, password, encryptedPassString);
        }
        throw new Exception("No Master Key Found");
    }

    private String fetchEncrAlgo(String encryptedPassString) {
        String encrAlgo = SupportedPBECryptoAlgo.PBEWithMD5AndTripleDES.getAlgoName();
        String[] mkSplits = null;
        if (encryptedPassString != null && encryptedPassString.contains(",")) {
            mkSplits = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)encryptedPassString)).toArray(new String[0]);
        }
        if (mkSplits != null && mkSplits.length >= 7) {
            encrAlgo = mkSplits[3];
        }
        return encrAlgo;
    }

    @Override
    public boolean reencryptMKWithFipsAlgo(String mkPassword) {
        logger.debug("==> RangerMasterKey.reencryptMKWithFipsAlgorithm");
        boolean isMKReencrypted = false;
        List result = this.getEncryptedMK();
        String encryptedPassString = null;
        byte[] masterKeyByte = null;
        if (CollectionUtils.isNotEmpty((Collection)result) && result.size() == 2) {
            masterKeyByte = (byte[])result.get(0);
            encryptedPassString = (String)result.get(1);
        } else if (CollectionUtils.isNotEmpty((Collection)result)) {
            masterKeyByte = (byte[])result.get(0);
        }
        String currentPbeAlgo = this.fetchEncrAlgo(encryptedPassString);
        if (!SupportedPBECryptoAlgo.isFIPSCompliantAlgorithm(SupportedPBECryptoAlgo.valueOf(currentPbeAlgo)) && !encrCryptoAlgo.getAlgoName().equalsIgnoreCase(currentPbeAlgo)) {
            logger.info("MasterKey key material was encrypted using {} , going to re-encrypt using {}", (Object)currentPbeAlgo, (Object)encrCryptoAlgo);
            byte[] oldKeyMaterial = null;
            try {
                PBEKeySpec pbeKeyspec = this.getPBEParameterSpec(mkPassword, SupportedPBECryptoAlgo.valueOf(currentPbeAlgo));
                oldKeyMaterial = this.decryptKey(masterKeyByte, pbeKeyspec);
                this.init();
                PBEKeySpec newPbeKeySpec = this.getPBEParameterSpec(mkPassword, encrCryptoAlgo);
                byte[] masterKeyToDB = this.encryptKey(oldKeyMaterial, newPbeKeySpec);
                byte[] decryptedMaterialWithNewAlgo = this.decryptKey(masterKeyToDB, newPbeKeySpec);
                if (!Base64.encode(oldKeyMaterial).equals(Base64.encode(decryptedMaterialWithNewAlgo))) {
                    String errMsg = "After re-encryption, Latest decrypted MasterKey material is different than original.Aborting the re-encryption, DB is not updated with new encrypted material.";
                    logger.error(errMsg);
                    throw new RuntimeException(errMsg);
                }
                String encodeMKToDB = Base64.encode(masterKeyToDB);
                this.updateEncryptedMK(paddingString + "," + encodeMKToDB);
                isMKReencrypted = true;
                logger.info("MasterKey key material got re-encrypted and saved to the DB");
            }
            catch (Throwable e) {
                logger.error(" Error while re-encrypting the  MasterKey", e);
                throw new RuntimeException(e);
            }
        }
        logger.debug("<== RangerMasterKey.reencryptMKWithFipsAlgo");
        return isMKReencrypted;
    }

    public void generateMKFromHSMMK(String password, byte[] key) throws Throwable {
        logger.debug("==> RangerMasterKey.generateMKFromHSMMK()");
        if (!this.checkMKExistence(this.masterKeyDao)) {
            logger.info("Master Key doesn't exist in DB, Generating the Master Key");
            String encryptedMasterKey = this.encryptMasterKey(password, key);
            String savedKey = this.saveEncryptedMK(paddingString + "," + encryptedMasterKey);
            if (savedKey != null && !savedKey.trim().equals("")) {
                logger.debug("Master Key Created with id = {}", (Object)savedKey);
                logger.debug("<== RangerMasterKey.generateMKFromHSMMK()");
            }
        } else {
            logger.debug("Ranger Master Key already exists in the DB, returning.");
        }
        logger.debug("<== RangerMasterKey.generateMKFromHSMMK()");
    }

    public void generateMKFromKeySecureMK(String password, byte[] key) throws Throwable {
        logger.debug("==> RangerMasterKey.generateMKFromKeySecureMK()");
        if (!this.checkMKExistence(this.masterKeyDao)) {
            logger.info("Master Key doesn't exist in DB, Generating the Master Key");
            String encryptedMasterKey = this.encryptMasterKey(password, key);
            String savedKey = this.saveEncryptedMK(paddingString + "," + encryptedMasterKey);
            if (savedKey != null && !savedKey.trim().equals("")) {
                logger.debug("Master Key Created with id = " + savedKey);
            }
        } else {
            logger.debug("Ranger Master Key already exists in the DB, returning.");
        }
        logger.debug("<== RangerMasterKey.generateMKFromKeySecureMK()");
    }

    private String decryptMasterKey(byte[] masterKey, String password, String encryptedPassString) throws Throwable {
        logger.debug("==> RangerMasterKey.decryptMasterKey()");
        logger.debug("Decrypting Master Key...");
        if (encryptedPassString == null) {
            RangerMasterKey.getPasswordParam(password);
        }
        PBEKeySpec pbeKeyspec = this.getPBEParameterSpec(password, SupportedPBECryptoAlgo.valueOf(pbeAlgo));
        byte[] masterKeyFromDBDecrypted = this.decryptKey(masterKey, pbeKeyspec);
        SecretKey masterKeyFromDB = this.getMasterKeyFromBytes(masterKeyFromDBDecrypted);
        logger.debug("<== RangerMasterKey.decryptMasterKey()");
        return Base64.encode(masterKeyFromDB.getEncoded());
    }

    private SecretKey decryptMasterKeySK(byte[] masterKey, String password, String encryptedPassString) throws Throwable {
        logger.debug("==> RangerMasterKey.decryptMasterKeySK()");
        if (encryptedPassString == null) {
            RangerMasterKey.getPasswordParam(password);
        }
        PBEKeySpec pbeKeyspec = this.getPBEParameterSpec(password, SupportedPBECryptoAlgo.valueOf(pbeAlgo));
        byte[] masterKeyFromDBDecrypted = this.decryptKey(masterKey, pbeKeyspec);
        logger.debug("<== RangerMasterKey.decryptMasterKeySK()");
        return this.getMasterKeyFromBytes(masterKeyFromDBDecrypted);
    }

    private List getEncryptedMK() {
        logger.debug("==> RangerMasterKey.getEncryptedMK()");
        try {
            if (this.masterKeyDao != null) {
                ArrayList<Object> ret = new ArrayList<Object>();
                List lstRangerMasterKey = this.masterKeyDao.getAll();
                if (lstRangerMasterKey.size() < 1) {
                    throw new Exception("No Master Key exists");
                }
                if (lstRangerMasterKey.size() > 1) {
                    throw new Exception("More than one Master Key exists");
                }
                XXRangerMasterKey rangerMasterKey = (XXRangerMasterKey)this.masterKeyDao.getById(((XXRangerMasterKey)lstRangerMasterKey.get(0)).getId());
                String masterKeyStr = rangerMasterKey.getMasterKey();
                if (masterKeyStr.contains(",")) {
                    RangerMasterKey.getPasswordParam(masterKeyStr);
                    ret.add(Base64.decode(password));
                    ret.add(masterKeyStr);
                } else {
                    ret.add(Base64.decode(masterKeyStr));
                }
                logger.debug("<== RangerMasterKey.getEncryptedMK()");
                return ret;
            }
        }
        catch (Exception e) {
            logger.error("Unable to retrieve Master Key from the database!!!", (Throwable)e);
        }
        logger.debug("<== RangerMasterKey.getEncryptedMK()");
        return null;
    }

    private String saveEncryptedMK(String encryptedMasterKey) {
        logger.debug("==> RangerMasterKey.saveEncryptedMK()");
        XXRangerMasterKey xxRangerMasterKey = new XXRangerMasterKey();
        xxRangerMasterKey.setCipher(mkCipher);
        xxRangerMasterKey.setBitLength(mkKeySize);
        xxRangerMasterKey.setMasterKey(encryptedMasterKey);
        try {
            if (this.masterKeyDao != null) {
                XXRangerMasterKey rangerMasterKey = this.masterKeyDao.create(xxRangerMasterKey);
                logger.debug("<== RangerMasterKey.saveEncryptedMK()");
                return rangerMasterKey.getId().toString();
            }
        }
        catch (Exception e) {
            logger.error("Error while saving master key in Database!!! ", (Throwable)e);
        }
        logger.debug("<== RangerMasterKey.saveEncryptedMK()");
        return null;
    }

    private void updateEncryptedMK(String encryptedMasterKey) throws Exception {
        logger.debug("==> RangerMasterKey.updateEncryptedMK()");
        try {
            if (this.masterKeyDao != null) {
                XXRangerMasterKey rangerMasterKey = (XXRangerMasterKey)this.masterKeyDao.getAll().get(0);
                if (rangerMasterKey != null) {
                    rangerMasterKey.setMasterKey(encryptedMasterKey);
                    this.masterKeyDao.update(rangerMasterKey);
                }
                logger.debug("<== RangerMasterKey.updateEncryptedMK()");
            }
        }
        catch (Exception e) {
            String errorMsg = "Error while updating master key in Database!!! ";
            logger.error(errorMsg, (Throwable)e);
            throw new Exception("Error while updating master key in Database!!! ", e);
        }
        logger.debug("<== RangerMasterKey.updateEncryptedMK()");
    }

    private boolean checkMKExistence(RangerMasterKeyDao rangerMKDao) {
        boolean mkExists = false;
        if (rangerMKDao != null) {
            mkExists = rangerMKDao.getAllCount() >= 1L;
        }
        return mkExists;
    }

    private String encryptMasterKey(String password) throws Throwable {
        logger.debug("==> RangerMasterKey.encryptMasterKey()");
        Key secretKey = this.generateMasterKey();
        PBEKeySpec pbeKeySpec = this.getPBEParameterSpec(password, encrCryptoAlgo);
        byte[] masterKeyToDB = this.encryptKey(secretKey.getEncoded(), pbeKeySpec);
        logger.debug("<== RangerMasterKey.encryptMasterKey()");
        return Base64.encode(masterKeyToDB);
    }

    private String encryptMasterKey(String password, byte[] secretKey) throws Throwable {
        logger.debug("==> RangerMasterKey.encryptMasterKey()");
        PBEKeySpec pbeKeySpec = this.getPBEParameterSpec(password, encrCryptoAlgo);
        byte[] masterKeyToDB = this.encryptKey(secretKey, pbeKeySpec);
        logger.debug("<== RangerMasterKey.encryptMasterKey()");
        return Base64.encode(masterKeyToDB);
    }

    private Key generateMasterKey() throws NoSuchAlgorithmException {
        logger.debug("==> RangerMasterKey.generateMasterKey()");
        KeyGenerator kg = KeyGenerator.getInstance(mkCipher);
        kg.init(mkKeySize);
        return kg.generateKey();
    }

    private PBEKeySpec getPBEParameterSpec(String password, SupportedPBECryptoAlgo encrAlgo) throws Throwable {
        PBEKeySpec pbeKeySpec;
        logger.debug("==> RangerMasterKey.getPBEParameterSpec()");
        if (SupportedPBECryptoAlgo.isFIPSCompliantAlgorithm(encrAlgo)) {
            int saltSize;
            for (saltSize = RangerMasterKey.saltSize.intValue(); saltSize < 16; saltSize *= 2) {
            }
            pbeKeySpec = new PBEKeySpec(this.getFIPSCompliantPassword(password).toCharArray(), this.generateSalt(saltSize), iterationCount, encrAlgo.getKeyLength());
        } else {
            pbeKeySpec = new PBEKeySpec(password.toCharArray(), this.generateSalt(saltSize), iterationCount);
        }
        return pbeKeySpec;
    }

    private byte[] generateSalt(int saltSize) throws Throwable {
        MessageDigest md = MessageDigest.getInstance(mdAlgo);
        byte[] saltGen = md.digest(salt.getBytes());
        byte[] salt = new byte[saltSize];
        System.arraycopy(saltGen, 0, salt, 0, RangerMasterKey.saltSize);
        return salt;
    }

    private String getFIPSCompliantPassword(String password) {
        String newPwd = password;
        while (newPwd.length() < 14) {
            newPwd = newPwd.concat(password);
        }
        return newPwd;
    }

    private byte[] encryptKey(byte[] data, PBEKeySpec keyspec) throws Throwable {
        logger.debug("==> RangerMasterKey.encryptKey()");
        SecretKey key = this.getPasswordKey(keyspec, encrCryptoAlgo.getAlgoName());
        if (keyspec.getSalt() != null) {
            Cipher c = Cipher.getInstance(encrCryptoAlgo.getCipherTransformation());
            c.init(1, (Key)key, encrCryptoAlgo.getAlgoParamSpec(keyspec));
            logger.debug("<== RangerMasterKey.encryptKey()");
            return c.doFinal(data);
        }
        logger.debug("<== RangerMasterKey.encryptKey()");
        return null;
    }

    private SecretKey getPasswordKey(PBEKeySpec keyspec, String cryptoAlgo) throws Throwable {
        logger.debug("==> RangerMasterKey.getPasswordKey()");
        SecretKeyFactory factory = SecretKeyFactory.getInstance(cryptoAlgo);
        logger.debug("<== RangerMasterKey.getPasswordKey()");
        return factory.generateSecret(keyspec);
    }

    private byte[] decryptKey(byte[] encrypted, PBEKeySpec keySpec) throws Throwable {
        SecretKey key = this.getPasswordKey(keySpec, pbeAlgo);
        if (keySpec.getSalt() != null) {
            AlgorithmParameterSpec algoParamSpec = SupportedPBECryptoAlgo.valueOf(pbeAlgo).getAlgoParamSpec(keySpec);
            Cipher c = Cipher.getInstance(SupportedPBECryptoAlgo.valueOf(pbeAlgo).getCipherTransformation());
            c.init(2, (Key)key, algoParamSpec);
            return c.doFinal(encrypted);
        }
        return null;
    }

    private SecretKey getMasterKeyFromBytes(byte[] keyData) {
        return new SecretKeySpec(keyData, mkCipher);
    }

    @VisibleForTesting
    SupportedPBECryptoAlgo getDefaultCryptoAlgorithm() {
        return defaultCryptAlgo;
    }

    @VisibleForTesting
    SupportedPBECryptoAlgo getSelectedCryptoAlgorithm() {
        return encrCryptoAlgo;
    }

    @VisibleForTesting
    SupportedPBECryptoAlgo getMKEncryptionAlgoName() {
        List result = this.getEncryptedMK();
        String encryptedPassString = null;
        if (CollectionUtils.isNotEmpty((Collection)result) && result.size() == 2) {
            encryptedPassString = (String)result.get(1);
        }
        return SupportedPBECryptoAlgo.valueOf(this.fetchEncrAlgo(encryptedPassString));
    }

    @VisibleForTesting
    void resetDefaultMDAlgoAndEncrAlgo() {
        defaultMdAlgo = "MD5";
        defaultCryptAlgo = SupportedPBECryptoAlgo.PBEWithMD5AndTripleDES;
    }

    static {
        encrCryptoAlgo = defaultCryptAlgo = SupportedPBECryptoAlgo.PBEWithMD5AndTripleDES;
        mkKeySize = 0;
        saltSize = 0;
        iterationCount = 0;
    }
}

