/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.AzureKeyVaultClientAuthenticator;
import org.apache.hadoop.crypto.key.RangerAzureKeyVaultKeyGenerator;
import org.apache.hadoop.crypto.key.RangerKMSDB;
import org.apache.hadoop.crypto.key.RangerKeyStore;
import org.apache.hadoop.crypto.key.RangerKeyStoreProvider;
import org.apache.hadoop.crypto.key.RangerMasterKey;
import org.apache.ranger.entity.XXRangerKeyStore;
import org.apache.ranger.kms.dao.DaoManager;

public class DBToAzureKeyVault {
    private static final String AZURE_CLIENT_ID = "ranger.kms.azure.client.id";
    private static final String AZURE_CLIENT_SECRET = "ranger.kms.azure.client.secret";
    private static final String AZURE_MASTER_KEY_ALIAS = "ranger.kms.azure.masterkey.name";
    private static final String AZURE_KEYVAULT_CERTIFICATE_PATH = "ranger.kms.azure.keyvault.certificate.path";
    private static final String AZURE_KEYVAULT_URL = "ranger.kms.azurekeyvault.url";
    private static final String ENCRYPTION_KEY = "ranger.db.encrypt.key.password";
    private static final String AZURE_MASTER_KEY_TYPE = "ranger.kms.azure.masterkey.type";
    private static final String ZONE_KEY_ENCRYPTION_ALGO = "ranger.kms.azure.zonekey.encryption.algorithm";
    private RangerKeyStore dbStore;

    public static void showUsage() {
        System.err.println("USAGE: java " + DBToAzureKeyVault.class.getName() + " <azureMasterKeyName> <azureMasterKeyType> <zoneKeyEncryptionAlgo> <azureKeyVaultUrl> <azureClientId> <isSSLEnabled> <clientSecret / Certificate Path>");
    }

    public static void main(String[] args) {
        if (args.length < 7) {
            System.err.println("Invalid number of parameters found.");
            DBToAzureKeyVault.showUsage();
            System.exit(1);
        } else {
            boolean result;
            String isSSLEnabled;
            String azureClientId;
            String azureKeyVaultUrl;
            String zoneKeyEncryptionAlgo;
            String azureMasterKeyType;
            Configuration conf = RangerKeyStoreProvider.getDBKSConf();
            String azureKeyName = args[0];
            if (azureKeyName == null || azureKeyName.trim().isEmpty()) {
                System.err.println("Azure master key name not provided.");
                DBToAzureKeyVault.showUsage();
                System.exit(1);
            }
            if ((azureMasterKeyType = args[1]) == null || azureMasterKeyType.trim().isEmpty()) {
                System.err.println("Azure master key type not provided.");
                DBToAzureKeyVault.showUsage();
                System.exit(1);
            }
            if ((zoneKeyEncryptionAlgo = args[2]) == null || zoneKeyEncryptionAlgo.trim().isEmpty()) {
                System.err.println("Zone Key Encryption algorithm name not provided.");
                DBToAzureKeyVault.showUsage();
                System.exit(1);
            }
            if ((azureKeyVaultUrl = args[3]) == null || azureKeyVaultUrl.trim().isEmpty()) {
                System.err.println("Azure Key Vault url not provided.");
                DBToAzureKeyVault.showUsage();
                System.exit(1);
            }
            if ((azureClientId = args[4]) == null || azureClientId.trim().isEmpty()) {
                System.err.println("Azure Client Id is not provided.");
                DBToAzureKeyVault.showUsage();
                System.exit(1);
            }
            if ((isSSLEnabled = args[5]) == null || isSSLEnabled.trim().isEmpty()) {
                System.err.println("isSSLEnabled not provided.");
                DBToAzureKeyVault.showUsage();
                System.exit(1);
            }
            if (!isSSLEnabled.equalsIgnoreCase("true") && !isSSLEnabled.equalsIgnoreCase("false")) {
                System.err.println("Please provide the valid value for isSSLEnabled");
                DBToAzureKeyVault.showUsage();
                System.exit(1);
            }
            String passwordOrCertPath = args[6];
            String certificatePassword = null;
            if (passwordOrCertPath == null || passwordOrCertPath.trim().isEmpty()) {
                System.err.println("Please provide Azure client password of certificate password");
                DBToAzureKeyVault.showUsage();
                System.exit(1);
            }
            boolean sslEnabled = false;
            if (isSSLEnabled.equalsIgnoreCase("true")) {
                sslEnabled = true;
                if (!passwordOrCertPath.endsWith(".pem") && !passwordOrCertPath.endsWith(".pfx")) {
                    System.err.println("Please provide valid certificate file path E.G .pem /.pfx");
                    DBToAzureKeyVault.showUsage();
                    System.exit(1);
                } else if (args.length > 7 && !StringUtils.isEmpty((String)args[7])) {
                    certificatePassword = args[7];
                }
            }
            if (result = new DBToAzureKeyVault().doExportMKToAzureKeyVault(sslEnabled, azureKeyName, azureMasterKeyType, zoneKeyEncryptionAlgo, azureClientId, azureKeyVaultUrl, passwordOrCertPath, certificatePassword, conf)) {
                System.out.println("Master Key from Ranger KMS DB has been successfully imported into Azure Key Vault.");
            } else {
                System.out.println("Import of Master Key from DB has been unsuccessful.");
                System.exit(1);
            }
            System.exit(0);
        }
    }

    private boolean doExportMKToAzureKeyVault(boolean sslEnabled, String masterKeyName, String masterKeyType, String zoneKeyEncryptionAlgo, String azureClientId, String azureKeyVaultUrl, String passwordOrCertPath, String certificatePassword, Configuration conf) {
        try {
            RangerAzureKeyVaultKeyGenerator rangerKVKeyGenerator;
            boolean azureMKSuccess;
            AzureKeyVaultClientAuthenticator azureKVClientAuthenticator;
            String mKeyPass = conf.get(ENCRYPTION_KEY);
            if (mKeyPass == null || mKeyPass.trim().equals("") || mKeyPass.trim().equals("_") || mKeyPass.trim().equals("crypted")) {
                throw new IOException("Master Key Jceks does not exists");
            }
            conf.set(AZURE_MASTER_KEY_TYPE, masterKeyType);
            conf.set(ZONE_KEY_ENCRYPTION_ALGO, zoneKeyEncryptionAlgo);
            conf.set(AZURE_MASTER_KEY_ALIAS, masterKeyName);
            conf.set(AZURE_CLIENT_ID, azureClientId);
            conf.set(AZURE_KEYVAULT_URL, azureKeyVaultUrl);
            RangerKMSDB rangerkmsDb = new RangerKMSDB(conf);
            DaoManager daoManager = rangerkmsDb.getDaoManager();
            KeyVaultClient kvClient = null;
            if (sslEnabled) {
                conf.set(AZURE_KEYVAULT_CERTIFICATE_PATH, passwordOrCertPath);
                azureKVClientAuthenticator = new AzureKeyVaultClientAuthenticator(azureClientId);
                kvClient = !StringUtils.isEmpty((String)certificatePassword) ? azureKVClientAuthenticator.getAuthentication(passwordOrCertPath, certificatePassword) : azureKVClientAuthenticator.getAuthentication(passwordOrCertPath, "");
            } else {
                conf.set(AZURE_CLIENT_SECRET, passwordOrCertPath);
                azureKVClientAuthenticator = new AzureKeyVaultClientAuthenticator(azureClientId, passwordOrCertPath);
                kvClient = new KeyVaultClient((ServiceClientCredentials)azureKVClientAuthenticator);
            }
            if (kvClient == null) {
                System.err.println("Key Vault is null. Please check the azure related configs.");
                System.exit(1);
            }
            if (azureMKSuccess = (rangerKVKeyGenerator = new RangerAzureKeyVaultKeyGenerator(conf, kvClient)).generateMasterKey(mKeyPass)) {
                this.dbStore = new RangerKeyStore(daoManager, conf, kvClient);
                RangerMasterKey rangerMasterKey = new RangerMasterKey(daoManager);
                char[] mkey = rangerMasterKey.getMasterKey(mKeyPass).toCharArray();
                ArrayList<XXRangerKeyStore> rangerKeyStoreList = new ArrayList<XXRangerKeyStore>();
                this.dbStore.engineLoad(null, mkey);
                Enumeration<String> e = this.dbStore.engineAliases();
                while (e.hasMoreElements()) {
                    String alias = e.nextElement();
                    Key key = this.dbStore.engineGetKey(alias, mkey);
                    XXRangerKeyStore xxRangerKeyStore = this.dbStore.convertKeysBetweenRangerKMSAndAzureKeyVault(alias, key, rangerKVKeyGenerator);
                    rangerKeyStoreList.add(xxRangerKeyStore);
                }
                if (rangerKeyStoreList != null && !rangerKeyStoreList.isEmpty()) {
                    for (XXRangerKeyStore rangerKeyStore : rangerKeyStoreList) {
                        this.dbStore.dbOperationStore(rangerKeyStore);
                    }
                }
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to import Master key from Ranger DB to Azure Key Vault ", t);
        }
    }
}

