/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.kms.authorizer;

import org.apache.hadoop.crypto.key.kms.server.KMS;
import org.apache.hadoop.crypto.key.kms.server.KMSACLsType;
import org.apache.hadoop.crypto.key.kms.server.KeyAuthorizationKeyProvider;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.plugin.classloader.PluginClassLoaderActivator;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerKmsAuthorizer
implements Runnable,
KeyAuthorizationKeyProvider.KeyACLs {
    private static final Logger LOG = LoggerFactory.getLogger(RangerKmsAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "kms";
    private static final String RANGER_KMS_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.kms.authorizer.RangerKmsAuthorizer";
    private Runnable implRunnable;
    private KeyAuthorizationKeyProvider.KeyACLs implKeyACLs;
    private RangerPluginClassLoader pluginClassLoader;

    public RangerKmsAuthorizer() {
        LOG.debug("==> RangerKmsAuthorizer.RangerKmsAuthorizer()");
        this.init();
        LOG.debug("<== RangerKmsAuthorizer.RangerKmsAuthorizer()");
    }

    public boolean hasAccessToKey(String keyName, UserGroupInformation ugi, KeyAuthorizationKeyProvider.KeyOpType opType) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "hasAccessToKey");){
            boolean bl = this.implKeyACLs.hasAccessToKey(keyName, ugi, opType);
            return bl;
        }
    }

    public boolean isACLPresent(String aclName, KeyAuthorizationKeyProvider.KeyOpType opType) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "isACLPresent");){
            boolean bl = this.implKeyACLs.isACLPresent(aclName, opType);
            return bl;
        }
    }

    public void startReloader() {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "startReloader");){
            this.implKeyACLs.startReloader();
        }
    }

    public void stopReloader() {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "stopReloader");){
            this.implKeyACLs.stopReloader();
        }
    }

    public boolean hasAccess(KMSACLsType.Type aclType, UserGroupInformation ugi, String clientIp) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "hasAccess");){
            boolean bl = this.implKeyACLs.hasAccess(aclType, ugi, clientIp);
            return bl;
        }
    }

    public void assertAccess(KMSACLsType.Type aclType, UserGroupInformation ugi, KMS.KMSOp operation, String key, String clientIp) throws AccessControlException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "assertAccess");){
            this.implKeyACLs.assertAccess(aclType, ugi, operation, key, clientIp);
        }
    }

    @Override
    public void run() {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "run");){
            this.implRunnable.run();
        }
    }

    private void init() {
        LOG.debug("==> RangerKmsAuthorizer.init()");
        try {
            this.pluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_KMS_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.pluginClassLoader);
            try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "init");){
                Object impl = cls.newInstance();
                this.implRunnable = (Runnable)impl;
                this.implKeyACLs = (KeyAuthorizationKeyProvider.KeyACLs)impl;
            }
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerKMSPlugin", (Throwable)e);
        }
        LOG.debug("<== RangerKmsAuthorizer.init()");
    }
}

