/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.kafka.client;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.services.kafka.client.ServiceKafkaClient;

public class ServiceKafkaConnectionMgr {
    private static final String SEPARATOR = ",";
    private static final String KEY_SASL_MECHANISM = "sasl.mechanism";
    private static final String KEY_KAFKA_KEYTAB = "kafka.keytab";
    private static final String KEY_KAFKA_PRINCIPAL = "kafka.principal";

    private ServiceKafkaConnectionMgr() {
    }

    public static ServiceKafkaClient getKafkaClient(String serviceName, Map<String, String> configs) throws Exception {
        String error = ServiceKafkaConnectionMgr.getServiceConfigValidationErrors(configs);
        if (StringUtils.isNotBlank((String)error)) {
            error = "JAAS configuration missing or not correct in Ranger Kafka Service. " + error;
            throw new Exception(error);
        }
        return new ServiceKafkaClient(serviceName, configs);
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        ServiceKafkaClient serviceKafkaClient = ServiceKafkaConnectionMgr.getKafkaClient(serviceName, configs);
        return serviceKafkaClient.connectionTest();
    }

    private static String getServiceConfigValidationErrors(Map<String, String> configs) {
        StringBuilder ret = new StringBuilder();
        String bootstrapServers = configs.get("bootstrap.servers");
        String securityProtocol = configs.get("security.protocol");
        String saslMechanism = configs.get(KEY_SASL_MECHANISM);
        String kafkaKeytab = configs.get(KEY_KAFKA_KEYTAB);
        String kafkaPrincipal = configs.get(KEY_KAFKA_PRINCIPAL);
        if (StringUtils.isEmpty((String)bootstrapServers)) {
            ret.append("bootstrap.servers");
        }
        if (StringUtils.isEmpty((String)securityProtocol)) {
            if (StringUtils.isNotBlank((String)ret.toString())) {
                ret.append(SEPARATOR).append("security.protocol");
            } else {
                ret.append("security.protocol");
            }
        }
        if (StringUtils.isEmpty((String)saslMechanism)) {
            if (StringUtils.isNotBlank((String)ret.toString())) {
                ret.append(SEPARATOR).append(KEY_SASL_MECHANISM);
            } else {
                ret.append(KEY_SASL_MECHANISM);
            }
        }
        if (StringUtils.isEmpty((String)kafkaKeytab)) {
            if (StringUtils.isNotBlank((String)ret.toString())) {
                ret.append(SEPARATOR).append(KEY_KAFKA_KEYTAB);
            } else {
                ret.append(KEY_KAFKA_KEYTAB);
            }
        }
        if (StringUtils.isEmpty((String)kafkaPrincipal)) {
            if (StringUtils.isNotBlank((String)ret.toString())) {
                ret.append(SEPARATOR).append(KEY_KAFKA_PRINCIPAL);
            } else {
                ret.append(KEY_KAFKA_PRINCIPAL);
            }
        }
        return ret.toString();
    }
}

