/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.kafka.authorizer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.ranger.plugin.classloader.PluginClassLoaderActivator;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerKafkaAuthorizer
implements Authorizer {
    private static final Logger logger = LoggerFactory.getLogger(RangerKafkaAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "kafka";
    private static final String RANGER_KAFKA_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.kafka.authorizer.RangerKafkaAuthorizer";
    private Authorizer rangerKafkaAuthorizerImpl;
    private RangerPluginClassLoader pluginClassLoader;

    public RangerKafkaAuthorizer() {
        logger.debug("==> RangerKafkaAuthorizer.RangerKafkaAuthorizer()");
        this.init();
        logger.debug("<== RangerKafkaAuthorizer.RangerKafkaAuthorizer()");
    }

    public void configure(Map<String, ?> configs) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "configure");){
            this.rangerKafkaAuthorizerImpl.configure(configs);
        }
    }

    public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo authorizerServerInfo) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "start");){
            Map map = this.rangerKafkaAuthorizerImpl.start(authorizerServerInfo);
            return map;
        }
    }

    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "authorize");){
            List list = this.rangerKafkaAuthorizerImpl.authorize(requestContext, actions);
            return list;
        }
    }

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "createAcls");){
            List list = this.rangerKafkaAuthorizerImpl.createAcls(requestContext, aclBindings);
            return list;
        }
    }

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "deleteAcls");){
            List list = this.rangerKafkaAuthorizerImpl.deleteAcls(requestContext, aclBindingFilters);
            return list;
        }
    }

    public Iterable<AclBinding> acls(AclBindingFilter filter) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "acls");){
            Iterable iterable = this.rangerKafkaAuthorizerImpl.acls(filter);
            return iterable;
        }
    }

    public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext requestContext, AclOperation op, ResourceType resourceType) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "authorizeByResourceType");){
            AuthorizationResult authorizationResult = this.rangerKafkaAuthorizerImpl.authorizeByResourceType(requestContext, op, resourceType);
            return authorizationResult;
        }
    }

    public void close() throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "close");){
            this.rangerKafkaAuthorizerImpl.close();
        }
    }

    private void init() {
        logger.debug("==> RangerKafkaAuthorizer.init()");
        try {
            this.pluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_KAFKA_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.pluginClassLoader);
            try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "init");){
                this.rangerKafkaAuthorizerImpl = (Authorizer)cls.newInstance();
            }
        }
        catch (Exception e) {
            logger.error("Error Enabling RangerKafkaPlugin", (Throwable)e);
            throw new IllegalStateException("Error Enabling RangerKafkaPlugin", e);
        }
        logger.debug("<== RangerKafkaAuthorizer.init()");
    }
}

