/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hive.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.hive.client.HiveClient;
import org.apache.ranger.services.hive.client.HiveConnectionMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveResourceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(HiveResourceMgr.class);
    private static final String DATABASE = "database";
    private static final String TABLE = "table";
    private static final String COLUMN = "column";

    private HiveResourceMgr() {
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        Map<String, Object> ret;
        LOG.debug("==> HiveResourceMgr.connectionTest ServiceName: {}Configs{}", (Object)serviceName, configs);
        try {
            ret = HiveClient.connectionTest(serviceName, configs);
        }
        catch (HadoopException e) {
            LOG.error("<== HiveResourceMgr.connectionTest Error: {}", (Object)String.valueOf((Object)e));
            throw e;
        }
        LOG.debug("<== HiveResourceMgr.connectionTest Result : {}", ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getHiveResources(String serviceName, String serviceType, Map<String, String> configs, ResourceLookupContext context) throws Exception {
        List columnList;
        List tableList;
        List databaseList;
        List resultList;
        String userInput;
        block25: {
            userInput = context.getUserInput();
            String resource = context.getResourceName();
            Map resourceMap = context.getResources();
            resultList = null;
            databaseList = null;
            tableList = null;
            columnList = null;
            String databaseName = null;
            String tableName = null;
            String columnName = null;
            LOG.debug("<== HiveResourceMgr.getHiveResources()  UserInput: \"{}\" resource : {} resourceMap: {}", new Object[]{userInput, resource, resourceMap});
            if (userInput != null && resource != null) {
                if (resourceMap != null && !resourceMap.isEmpty()) {
                    databaseList = (List)resourceMap.get(DATABASE);
                    tableList = (List)resourceMap.get(TABLE);
                    columnList = (List)resourceMap.get(COLUMN);
                }
                switch (resource.trim().toLowerCase()) {
                    case "database": {
                        databaseName = userInput;
                        break;
                    }
                    case "table": {
                        tableName = userInput;
                        break;
                    }
                    case "column": {
                        columnName = userInput;
                        break;
                    }
                }
            }
            if (serviceName != null && userInput != null) {
                try {
                    Callable<List> callableObj;
                    LOG.debug("==> HiveResourceMgr.getHiveResources() UserInput: {} configs: {} databaseList: {} tableList: {} columnList: {}", new Object[]{userInput, configs, databaseList, tableList, columnList});
                    HiveClient hiveClient = new HiveConnectionMgr().getHiveConnection(serviceName, serviceType, configs);
                    if (hiveClient == null) break block25;
                    List finaldatabaseList = databaseList;
                    List finaltableList = tableList;
                    List finalcolumnList = columnList;
                    if (databaseName != null && !databaseName.isEmpty()) {
                        String finalDbName = databaseName = databaseName + "*";
                        callableObj = () -> hiveClient.getDatabaseList(finalDbName, finaldatabaseList);
                    } else if (tableName != null && !tableName.isEmpty()) {
                        String finalTableName = tableName = tableName + "*";
                        callableObj = () -> hiveClient.getTableList(finalTableName, finaldatabaseList, finaltableList);
                    } else if (columnName != null && !columnName.isEmpty()) {
                        String finalColName = columnName = columnName + "*";
                        String finalDbName = databaseName;
                        String finalTableName = tableName;
                        callableObj = () -> hiveClient.getColumnList(finalColName, finaldatabaseList, finaltableList, finalcolumnList);
                    } else {
                        callableObj = null;
                    }
                    if (callableObj != null) {
                        HiveClient hiveClient2 = hiveClient;
                        synchronized (hiveClient2) {
                            resultList = (List)TimedEventUtil.timedTask(callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                            break block25;
                        }
                    }
                    LOG.error("Could not initiate at timedTask");
                }
                catch (Exception e) {
                    LOG.error("Unable to get hive resources.", (Throwable)e);
                    throw e;
                }
            }
        }
        LOG.debug("<== HiveResourceMgr.getHiveResources() UserInput: {} configs: {} databaseList: {} tableList: {} columnList: {}Result :{}", new Object[]{userInput, configs, databaseList, tableList, columnList, resultList});
        return resultList;
    }
}

