/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hive.client;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.hive.client.HiveClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveConnectionMgr {
    private static final Logger LOG = LoggerFactory.getLogger(HiveConnectionMgr.class);
    protected ConcurrentMap<String, HiveClient> hiveConnectionCache = new ConcurrentHashMap<String, HiveClient>();
    protected ConcurrentMap<String, Boolean> repoConnectStatusMap = new ConcurrentHashMap<String, Boolean>();

    public HiveClient getHiveConnection(String serviceName, String serviceType, Map<String, String> configs) {
        HiveClient hiveClient = null;
        if (serviceType != null) {
            hiveClient = (HiveClient)this.hiveConnectionCache.get(serviceName);
            if (hiveClient == null) {
                if (configs != null) {
                    Callable<HiveClient> connectHive = () -> new HiveClient(serviceName, configs);
                    try {
                        hiveClient = (HiveClient)TimedEventUtil.timedTask(connectHive, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        LOG.error("Error connecting hive repository : {} using config : {}", new Object[]{serviceName, configs, e});
                    }
                    HiveClient oldClient = hiveClient != null ? this.hiveConnectionCache.putIfAbsent(serviceName, hiveClient) : (HiveClient)this.hiveConnectionCache.get(serviceName);
                    if (oldClient != null) {
                        if (hiveClient != null) {
                            hiveClient.close();
                        }
                        hiveClient = oldClient;
                    }
                    this.repoConnectStatusMap.put(serviceName, true);
                } else {
                    LOG.error("Connection Config not defined for asset :{}", (Object)serviceName, (Object)new Throwable());
                }
            } else {
                try {
                    hiveClient.getDatabaseList("*", null);
                }
                catch (Exception e) {
                    this.hiveConnectionCache.remove(serviceName);
                    hiveClient.close();
                    hiveClient = this.getHiveConnection(serviceName, serviceType, configs);
                }
            }
        } else {
            LOG.error("Asset not found with name {}", (Object)serviceName, (Object)new Throwable());
        }
        return hiveClient;
    }
}

