/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePolicyChangeListener;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePolicyProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveResourceACLs;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAuthorizer;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveResource;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.service.RangerAuthContextListener;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerHivePolicyProvider
implements HivePolicyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RangerHivePolicyProvider.class);
    private static final Logger PERF_HIVEACLPROVIDER_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"hiveACLProvider.request");
    private final RangerHiveAuthContextListener authContextListener = new RangerHiveAuthContextListener();
    private final Set<String> hivePrivileges;
    private final RangerBasePlugin rangerPlugin;
    private final RangerHiveAuthorizer authorizer;

    public RangerHivePolicyProvider(@NotNull RangerBasePlugin hivePlugin, @NotNull RangerHiveAuthorizer authorizer) {
        HashSet<String> privileges = new HashSet<String>();
        for (HiveResourceACLs.Privilege privilege : HiveResourceACLs.Privilege.values()) {
            privileges.add(privilege.name().toLowerCase());
        }
        this.hivePrivileges = new HashSet<String>(privileges);
        this.rangerPlugin = hivePlugin;
        this.authorizer = authorizer;
    }

    public HiveResourceACLs getResourceACLs(HivePrivilegeObject hiveObject) {
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_HIVEACLPROVIDER_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer((Logger)PERF_HIVEACLPROVIDER_REQUEST_LOG, (String)"RangerHivePolicyProvider.getResourceACLS()");
        }
        RangerHiveResource hiveResource = this.authorizer.createHiveResource(hiveObject);
        HiveResourceACLs ret = this.getResourceACLs(hiveResource);
        RangerPerfTracer.log((RangerPerfTracer)perf);
        return ret;
    }

    public void registerHivePolicyChangeListener(HivePolicyChangeListener listener) {
        LOG.debug("==> RangerHiveACLProviderFactory.registerACLProviderChangeListener()");
        this.authContextListener.providerChangeListeners.add(listener);
        this.rangerPlugin.registerAuthContextEventListener((RangerAuthContextListener)this.authContextListener);
        LOG.debug("<== RangerHiveACLProviderFactory.registerACLProviderChangeListener()");
    }

    public HiveResourceACLs getResourceACLs(RangerHiveResource hiveResource) {
        RangerAccessRequestImpl request = new RangerAccessRequestImpl((RangerAccessResource)hiveResource, "_any", null, null, null);
        RangerResourceACLs acls = this.rangerPlugin.getResourceACLs((RangerAccessRequest)request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("HiveResource:[{}], Computed ACLS:[{}]", (Object)hiveResource.getAsString(), (Object)acls);
        }
        Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> userPermissions = this.convertRangerACLsToHiveACLs(acls.getUserACLs());
        Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> groupPermissions = this.convertRangerACLsToHiveACLs(acls.getGroupACLs());
        return new RangerHiveResourceACLs(userPermissions, groupPermissions);
    }

    private Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> convertRangerACLsToHiveACLs(Map<String, Map<String, RangerResourceACLs.AccessResult>> rangerACLs) {
        HashMap<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> ret = new HashMap<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>>();
        if (MapUtils.isNotEmpty(rangerACLs)) {
            for (Map.Entry<String, Map<String, RangerResourceACLs.AccessResult>> entry : rangerACLs.entrySet()) {
                HashMap<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> permissions = new HashMap<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>();
                ret.put(entry.getKey(), permissions);
                for (Map.Entry<String, RangerResourceACLs.AccessResult> permission : entry.getValue().entrySet()) {
                    if (!this.hivePrivileges.contains(permission.getKey())) continue;
                    HiveResourceACLs.Privilege privilege = HiveResourceACLs.Privilege.valueOf((String)StringUtils.upperCase((String)permission.getKey()));
                    int rangerResultValue = permission.getValue().getResult();
                    HiveResourceACLs.AccessResult accessResult = rangerResultValue == RangerPolicyEvaluator.ACCESS_ALLOWED ? HiveResourceACLs.AccessResult.ALLOWED : (rangerResultValue == RangerPolicyEvaluator.ACCESS_DENIED ? HiveResourceACLs.AccessResult.NOT_ALLOWED : (rangerResultValue == RangerPolicyEvaluator.ACCESS_CONDITIONAL ? HiveResourceACLs.AccessResult.CONDITIONAL_ALLOWED : HiveResourceACLs.AccessResult.NOT_ALLOWED));
                    permissions.put(privilege, accessResult);
                }
            }
        }
        return ret;
    }

    static class RangerHiveAuthContextListener
    implements RangerAuthContextListener {
        Set<HivePolicyChangeListener> providerChangeListeners = new HashSet<HivePolicyChangeListener>();

        RangerHiveAuthContextListener() {
        }

        public void contextChanged() {
            for (HivePolicyChangeListener eventListener : this.providerChangeListeners) {
                eventListener.notifyPolicyChange(null);
            }
        }
    }
}

