/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePolicyProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveResourceACLs;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveRoleGrant;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAccessRequest;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAuditHandler;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAuthorizerBase;
import org.apache.ranger.authorization.hive.authorizer.RangerHivePolicyProvider;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveResource;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerRequestedResources;
import org.apache.ranger.plugin.util.RangerRoles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerHiveAuthorizer
extends RangerHiveAuthorizerBase {
    private static final Logger LOG = LoggerFactory.getLogger(RangerHiveAuthorizer.class);
    private static final Logger PERF_HIVEAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"hiveauth.request");
    private static final char COLUMN_SEP = ',';
    private static final String HIVE_CONF_VAR_QUERY_STRING = "hive.query.string";
    private static final String DEFAULT_RANGER_POLICY_GRANTOR = "ranger";
    private static final String ROLE_ALL = "ALL";
    private static final String ROLE_DEFAULT = "DEFAULT";
    private static final String ROLE_NONE = "NONE";
    private static final String ROLE_ADMIN = "admin";
    private static final String CMD_CREATE_ROLE = "create role %s";
    private static final String CMD_DROP_ROLE = "drop role %s";
    private static final String CMD_SHOW_ROLES = "show roles";
    private static final String CMD_SHOW_ROLE_GRANT = "show role grant %s";
    private static final String CMD_SHOW_PRINCIPALS = "show principals %s";
    private static final String CMD_GRANT_ROLE = "grant %s to %s ";
    private static final String CMD_REVOKE_ROLE = "revoke %s from %s";
    private static final String CMD_SET_ROLE = "set role %s";
    private static final Set<String> RESERVED_ROLE_NAMES;
    private static volatile RangerHivePlugin hivePlugin;
    private String currentUserName;
    private Set<String> currentRoles;
    private String adminRole;
    private boolean isCurrentRoleSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RangerHiveAuthorizer(HiveMetastoreClientFactory metastoreClientFactory, HiveConf hiveConf, HiveAuthenticationProvider hiveAuthenticator, HiveAuthzSessionContext sessionContext) {
        super(metastoreClientFactory, hiveConf, hiveAuthenticator, sessionContext);
        LOG.debug("RangerHiveAuthorizer.RangerHiveAuthorizer()");
        RangerHivePlugin plugin = hivePlugin;
        if (plugin != null) return;
        Class<RangerHiveAuthorizer> clazz = RangerHiveAuthorizer.class;
        synchronized (RangerHiveAuthorizer.class) {
            plugin = hivePlugin;
            if (plugin != null) return;
            String appType = "unknown";
            if (sessionContext != null) {
                switch (sessionContext.getClientType()) {
                    case HIVECLI: {
                        appType = "hiveCLI";
                        break;
                    }
                    case HIVESERVER2: {
                        appType = "hiveServer2";
                    }
                }
            }
            plugin = new RangerHivePlugin(appType);
            plugin.init();
            hivePlugin = plugin;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    static void setOwnerUser(RangerHiveResource resource, HivePrivilegeObject hiveObj, IMetaStoreClient metaStoreClient, Map<String, String> objOwners) {
        if (hiveObj != null) {
            String objName = null;
            String owner = hiveObj.getOwnerName();
            switch (hiveObj.getType()) {
                case DATABASE: {
                    try {
                        objName = hiveObj.getDbname();
                        if (StringUtils.isBlank((String)owner) && objOwners != null) {
                            owner = objOwners.get(objName);
                        }
                        if (StringUtils.isBlank((String)owner)) {
                            Database database;
                            Database database2 = database = metaStoreClient != null ? metaStoreClient.getDatabase(hiveObj.getDbname()) : null;
                            if (database == null) break;
                            owner = database.getOwnerName();
                            break;
                        }
                        LOG.debug("Owner for database {} is already known", (Object)objName);
                    }
                    catch (Exception excp) {
                        LOG.error("failed to get database object from Hive metastore. dbName={}", (Object)hiveObj.getDbname(), (Object)excp);
                    }
                    break;
                }
                case TABLE_OR_VIEW: 
                case COLUMN: {
                    try {
                        objName = hiveObj.getDbname() + "." + hiveObj.getObjectName();
                        if (StringUtils.isBlank((String)owner) && objOwners != null) {
                            owner = objOwners.get(objName);
                        }
                        if (StringUtils.isBlank((String)owner)) {
                            Table table;
                            Table table2 = table = metaStoreClient != null ? metaStoreClient.getTable(hiveObj.getDbname(), hiveObj.getObjectName()) : null;
                            if (table == null) break;
                            owner = table.getOwner();
                            break;
                        }
                        LOG.debug("Owner for table {} is already known", (Object)objName);
                        break;
                    }
                    catch (Exception excp) {
                        LOG.error("failed to get table object from Hive metastore. dbName={}, tblName={}", new Object[]{hiveObj.getDbname(), hiveObj.getObjectName(), excp});
                    }
                }
            }
            if (objOwners != null && objName != null) {
                objOwners.put(objName, owner);
            }
            if (StringUtils.isNotBlank((String)objName) && StringUtils.isNotBlank((String)owner)) {
                resource.setOwnerUser(owner);
            }
        }
        LOG.debug("setOwnerUser({}): ownerName={}", (Object)hiveObj, (Object)resource.getOwnerUser());
    }

    public void grantPrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        LOG.debug("grantPrivileges() => HivePrivilegeObject:{}grantorPrincipal: {}hivePrincipals{}hivePrivileges{}", new Object[]{this.toString(hivePrivObject, new StringBuilder()), grantorPrincipal, hivePrincipals, hivePrivileges});
        if (!RangerHivePlugin.updateXaPoliciesOnGrantRevoke) {
            throw new HiveAuthzPluginException("GRANT/REVOKE not supported in Ranger HiveAuthorizer. Please use Ranger Security Admin to setup access control.");
        }
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
        try {
            ArrayList<HivePrivilegeObject> outputs = new ArrayList<HivePrivilegeObject>(Collections.singletonList(hivePrivObject));
            RangerHiveResource resource = this.getHiveResource(HiveOperationType.GRANT_PRIVILEGE, hivePrivObject, null, outputs, null);
            GrantRevokeRequest request = this.createGrantRevokeData(resource, hivePrincipals, hivePrivileges, grantorPrincipal, grantOption);
            LOG.debug("grantPrivileges(): {}", (Object)request);
            hivePlugin.grantAccess(request, (RangerAccessResultProcessor)auditHandler);
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            auditHandler.flushAudit();
        }
    }

    public void revokePrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        if (!RangerHivePlugin.updateXaPoliciesOnGrantRevoke) {
            throw new HiveAuthzPluginException("GRANT/REVOKE not supported in Ranger HiveAuthorizer. Please use Ranger Security Admin to setup access control.");
        }
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
        try {
            ArrayList<HivePrivilegeObject> outputs = new ArrayList<HivePrivilegeObject>(Collections.singletonList(hivePrivObject));
            RangerHiveResource resource = this.getHiveResource(HiveOperationType.REVOKE_PRIVILEGE, hivePrivObject, null, outputs, null);
            GrantRevokeRequest request = this.createGrantRevokeData(resource, hivePrincipals, hivePrivileges, grantorPrincipal, grantOption);
            LOG.debug("revokePrivileges(): {}", (Object)request);
            hivePlugin.revokeAccess(request, (RangerAccessResultProcessor)auditHandler);
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            auditHandler.flushAudit();
        }
    }

    public void createRole(String roleName, HivePrincipal adminGrantor) throws HiveAuthzPluginException, HiveAccessControlException {
        LOG.debug(" ==> RangerHiveAuthorizer.createRole()");
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
        String currentUserName = this.getGrantorUsername(adminGrantor);
        List<String> roleNames = Collections.singletonList(roleName);
        List<String> userNames = Collections.singletonList(currentUserName);
        boolean result = false;
        if (RESERVED_ROLE_NAMES.contains(roleName.trim().toUpperCase())) {
            throw new HiveAuthzPluginException("Role name cannot be one of the reserved roles: " + RESERVED_ROLE_NAMES);
        }
        try {
            RangerRole role = new RangerRole();
            role.setName(roleName);
            role.setCreatedByUser(currentUserName);
            role.setCreatedBy(currentUserName);
            role.setUpdatedBy(currentUserName);
            RangerRole.RoleMember userMember = new RangerRole.RoleMember(currentUserName, true);
            ArrayList<RangerRole.RoleMember> userMemberList = new ArrayList<RangerRole.RoleMember>();
            userMemberList.add(userMember);
            role.setUsers(userMemberList);
            RangerRole ret = hivePlugin.createRole(role, (RangerAccessResultProcessor)auditHandler);
            LOG.debug("<== createRole(): {}", (Object)ret);
            result = true;
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, currentUserName, userNames, HiveOperationType.CREATEROLE, HiveAccessType.CREATE, roleNames, result);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
    }

    public void dropRole(String roleName) throws HiveAuthzPluginException, HiveAccessControlException {
        LOG.debug("RangerHiveAuthorizer.dropRole()");
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        boolean result = false;
        List<String> roleNames = Collections.singletonList(roleName);
        if (ugi == null) {
            throw new HiveAccessControlException("Permission denied: user information not available");
        }
        if (RESERVED_ROLE_NAMES.contains(roleName.trim().toUpperCase())) {
            throw new HiveAuthzPluginException("Role name cannot be one of the reserved roles: " + RESERVED_ROLE_NAMES);
        }
        String currentUserName = ugi.getShortUserName();
        List<String> userNames = Collections.singletonList(currentUserName);
        try {
            LOG.debug("<== dropRole(): {}", (Object)roleName);
            hivePlugin.dropRole(currentUserName, roleName, (RangerAccessResultProcessor)auditHandler);
            result = true;
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, currentUserName, userNames, HiveOperationType.DROPROLE, HiveAccessType.DROP, roleNames, result);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
    }

    public List<HiveRoleGrant> getPrincipalGrantInfoForRole(String roleName) throws HiveAuthzPluginException, HiveAccessControlException {
        LOG.debug("==> RangerHiveAuthorizer.getPrincipalGrantInfoForRole() for RoleName: {}", (Object)roleName);
        ArrayList<HiveRoleGrant> ret = new ArrayList<HiveRoleGrant>();
        List<String> roleNames = Collections.singletonList(roleName);
        List<String> userNames = null;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
        boolean result = false;
        if (hivePlugin == null) {
            throw new HiveAuthzPluginException("RangerHiveAuthorizer.getPrincipalGrantInfoForRole(): HivePlugin initialization failed...");
        }
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new HiveAccessControlException("RangerHiveAuthorizer.getPrincipalGrantInfoForRole(): User information not available...");
        }
        String currentUserName = ugi.getShortUserName();
        try {
            RangerRole rangerRole;
            if (!hivePlugin.isServiceAdmin(currentUserName)) {
                throw new HiveAccessControlException("Permission denied: User not authorized to perform this operation!");
            }
            userNames = Collections.singletonList(currentUserName);
            if (StringUtils.isNotEmpty((String)roleName) && (rangerRole = this.getRangerRoleForRoleName(roleName)) != null) {
                HiveRoleGrant hiveRoleGrant;
                for (RangerRole.RoleMember roleMember : rangerRole.getRoles()) {
                    hiveRoleGrant = this.getHiveRoleGrant(rangerRole, roleMember, HivePrincipal.HivePrincipalType.ROLE.name());
                    ret.add(hiveRoleGrant);
                }
                for (RangerRole.RoleMember group : rangerRole.getGroups()) {
                    hiveRoleGrant = this.getHiveRoleGrant(rangerRole, group, HivePrincipal.HivePrincipalType.GROUP.name());
                    ret.add(hiveRoleGrant);
                }
                for (RangerRole.RoleMember user : rangerRole.getUsers()) {
                    hiveRoleGrant = this.getHiveRoleGrant(rangerRole, user, HivePrincipal.HivePrincipalType.USER.name());
                    ret.add(hiveRoleGrant);
                }
                result = true;
            }
        }
        catch (Exception excp) {
            throw new HiveAuthzPluginException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, currentUserName, userNames, HiveOperationType.SHOW_ROLE_PRINCIPALS, HiveAccessType.SELECT, roleNames, result);
            hivePlugin.evalAuditPolicies(accessResult);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
        LOG.debug("<== RangerHiveAuthorizer.getPrincipalGrantInfoForRole() for Rolename: {} Roles: {}", (Object)roleName, ret);
        return ret;
    }

    public List<HiveRoleGrant> getRoleGrantInfoForPrincipal(HivePrincipal principal) throws HiveAuthzPluginException, HiveAccessControlException {
        LOG.debug("==> RangerHiveAuthorizer.getRoleGrantInfoForPrincipal() for Principal: {}", (Object)principal);
        ArrayList<HiveRoleGrant> ret = new ArrayList<HiveRoleGrant>();
        List<String> principalInfo = null;
        List<String> userNames = null;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
        boolean result = false;
        if (hivePlugin == null) {
            throw new HiveAuthzPluginException("RangerHiveAuthorizer.getRoleGrantInfoForPrincipal(): HivePlugin initialization failed...");
        }
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new HiveAccessControlException("RangerHiveAuthorizer.getRoleGrantInfoForPrincipal(): User information not available...");
        }
        String currentUserName = ugi.getShortUserName();
        try {
            String principalName = principal.getName();
            String type = principal.getType().name();
            userNames = Collections.singletonList(currentUserName);
            principalInfo = Collections.singletonList(principal.getType() + " " + principalName);
            if (!hivePlugin.isServiceAdmin(currentUserName) && !principalName.equals(currentUserName)) {
                throw new HiveAccessControlException("Permission denied: user information not available");
            }
            Set roles = hivePlugin.getRangerRoleForPrincipal(principalName, type);
            if (CollectionUtils.isNotEmpty((Collection)roles)) {
                for (RangerRole rangerRole : roles) {
                    switch (type) {
                        case "USER": {
                            RangerRole.RoleMember userRoleMember = new RangerRole.RoleMember(principalName, false);
                            ret.add(this.getHiveRoleGrant(rangerRole, userRoleMember, type));
                            break;
                        }
                        case "GROUP": {
                            RangerRole.RoleMember groupRoleMember = new RangerRole.RoleMember(principalName, false);
                            ret.add(this.getHiveRoleGrant(rangerRole, groupRoleMember, type));
                            break;
                        }
                        case "ROLE": {
                            RangerRole.RoleMember roleRoleMember = new RangerRole.RoleMember(principalName, false);
                            ret.add(this.getHiveRoleGrant(rangerRole, roleRoleMember, type));
                        }
                    }
                }
                result = true;
            }
        }
        catch (Exception excp) {
            throw new HiveAuthzPluginException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, currentUserName, userNames, HiveOperationType.SHOW_ROLE_GRANT, HiveAccessType.SELECT, principalInfo, result);
            hivePlugin.evalAuditPolicies(accessResult);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
        LOG.debug("<== getRoleGrantInfoForPrincipal(): Principal: {} Roles: {}", (Object)principal, ret);
        return ret;
    }

    public void grantRole(List<HivePrincipal> hivePrincipals, List<String> roles, boolean grantOption, HivePrincipal grantorPrinc) throws HiveAccessControlException {
        LOG.debug("RangerHiveAuthorizerBase.grantRole()");
        boolean result = false;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
        String username = this.getGrantorUsername(grantorPrinc);
        ArrayList<String> principals = new ArrayList<String>();
        try {
            HiveAuthzSessionContext sessionContext;
            GrantRevokeRoleRequest request = new GrantRevokeRoleRequest();
            HashSet<String> userList = new HashSet<String>();
            HashSet<String> roleList = new HashSet<String>();
            HashSet<String> groupList = new HashSet<String>();
            request.setGrantor(username);
            request.setGrantorGroups(this.getGrantorGroupNames(grantorPrinc));
            for (HivePrincipal principal : hivePrincipals) {
                switch (principal.getType()) {
                    case USER: {
                        String name = principal.getName();
                        userList.add(name);
                        principals.add("USER " + name);
                        break;
                    }
                    case GROUP: {
                        String name = principal.getName();
                        groupList.add(name);
                        principals.add("GROUP " + name);
                        break;
                    }
                    case ROLE: {
                        String name = principal.getName();
                        roleList.add(name);
                        principals.add("ROLE " + name);
                        break;
                    }
                }
            }
            request.setUsers(userList);
            request.setGroups(groupList);
            request.setRoles(roleList);
            request.setGrantOption(Boolean.valueOf(grantOption));
            request.setTargetRoles(new HashSet<String>(roles));
            SessionState ss = SessionState.get();
            if (ss != null) {
                request.setClientIPAddress(ss.getUserIpAddress());
                request.setSessionId(ss.getSessionId());
                HiveConf hiveConf = ss.getConf();
                if (hiveConf != null) {
                    request.setRequestData(hiveConf.get(HIVE_CONF_VAR_QUERY_STRING));
                }
            }
            if ((sessionContext = this.getHiveAuthzSessionContext()) != null) {
                request.setClientType(sessionContext.getClientType() == null ? null : sessionContext.getClientType().toString());
            }
            hivePlugin.grantRole(request, (RangerAccessResultProcessor)auditHandler);
            result = true;
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, username, principals, HiveOperationType.GRANT_ROLE, HiveAccessType.ALTER, roles, result);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
    }

    public void revokeRole(List<HivePrincipal> hivePrincipals, List<String> roles, boolean grantOption, HivePrincipal grantorPrinc) throws HiveAccessControlException {
        LOG.debug("RangerHiveAuthorizerBase.revokeRole()");
        boolean result = false;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
        String grantorUserName = this.getGrantorUsername(grantorPrinc);
        ArrayList<String> principals = new ArrayList<String>();
        try {
            HiveAuthzSessionContext sessionContext;
            GrantRevokeRoleRequest request = new GrantRevokeRoleRequest();
            HashSet<String> userList = new HashSet<String>();
            HashSet<String> roleList = new HashSet<String>();
            HashSet<String> groupList = new HashSet<String>();
            request.setGrantor(grantorUserName);
            request.setGrantorGroups(this.getGrantorGroupNames(grantorPrinc));
            for (HivePrincipal principal : hivePrincipals) {
                switch (principal.getType()) {
                    case USER: {
                        String principalName = principal.getName();
                        userList.add(principalName);
                        principals.add("USER " + principalName);
                        break;
                    }
                    case GROUP: {
                        String principalName = principal.getName();
                        groupList.add(principalName);
                        principals.add("GROUP " + principalName);
                        break;
                    }
                    case ROLE: {
                        String principalName = principal.getName();
                        roleList.add(principalName);
                        principals.add("ROLE " + principalName);
                        break;
                    }
                }
            }
            request.setUsers(userList);
            request.setGroups(groupList);
            request.setRoles(roleList);
            request.setGrantOption(Boolean.valueOf(grantOption));
            request.setTargetRoles(new HashSet<String>(roles));
            SessionState ss = SessionState.get();
            if (ss != null) {
                request.setClientIPAddress(ss.getUserIpAddress());
                request.setSessionId(ss.getSessionId());
                HiveConf hiveConf = ss.getConf();
                if (hiveConf != null) {
                    request.setRequestData(hiveConf.get(HIVE_CONF_VAR_QUERY_STRING));
                }
            }
            if ((sessionContext = this.getHiveAuthzSessionContext()) != null) {
                request.setClientType(sessionContext.getClientType() == null ? null : sessionContext.getClientType().toString());
            }
            LOG.debug("revokeRole(): {}", (Object)request);
            hivePlugin.revokeRole(request, (RangerAccessResultProcessor)auditHandler);
            result = true;
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, grantorUserName, principals, HiveOperationType.REVOKE_ROLE, HiveAccessType.ALTER, roles, result);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkPrivileges(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, HiveAuthzContext context) throws HiveAccessControlException {
        HashMap<String, String> objOwners;
        Set<String> roles;
        HashSet groups;
        String user;
        HiveAuthzSessionContext sessionContext;
        RangerPerfTracer perf;
        RangerHiveAuditHandler auditHandler;
        block54: {
            UserGroupInformation ugi = this.getCurrentUserGroupInfo();
            if (ugi == null) {
                throw new HiveAccessControlException("Permission denied: user information not available");
            }
            auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
            perf = null;
            sessionContext = this.getHiveAuthzSessionContext();
            user = ugi.getShortUserName();
            groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            roles = this.getCurrentRolesForUser(user, groups);
            objOwners = new HashMap<String, String>();
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.toString(hiveOpType, inputHObjs, outputHObjs, context, sessionContext));
            }
            if (hiveOpType != HiveOperationType.DFS) break block54;
            this.handleDfsCommand(hiveOpType, inputHObjs, user, auditHandler);
            auditHandler.flushAudit();
            RangerPerfTracer.log(perf);
            return;
        }
        try {
            RangerHiveAccessRequest request;
            String tableName;
            String dbName;
            HiveAccessType accessType;
            Path resolvedPath;
            FileSystem fs;
            FsAction permission;
            HiveObjectType hiveObjType;
            String pathStr;
            RangerHiveResource resource;
            if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_HIVEAUTH_REQUEST_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Logger)PERF_HIVEAUTH_REQUEST_LOG, (String)("RangerHiveAuthorizer.checkPrivileges(hiveOpType=" + hiveOpType + ")"));
            }
            ArrayList<RangerHiveAccessRequest> requests = new ArrayList<RangerHiveAccessRequest>();
            if (!CollectionUtils.isEmpty(inputHObjs)) {
                for (HivePrivilegeObject hivePrivilegeObject : inputHObjs) {
                    resource = this.getHiveResource(hiveOpType, hivePrivilegeObject, inputHObjs, outputHObjs, objOwners);
                    if (resource == null) continue;
                    pathStr = hivePrivilegeObject.getObjectName();
                    hiveObjType = resource.getObjectType();
                    if (hiveObjType == HiveObjectType.URI && this.isPathInFSScheme(pathStr)) {
                        permission = this.getURIAccessType(hiveOpType);
                        Path path = new Path(pathStr);
                        try {
                            fs = FileSystem.get((URI)path.toUri(), (Configuration)this.getHiveConf());
                        }
                        catch (IOException e) {
                            LOG.error("Error getting permissions for {}", (Object)path, (Object)e);
                            throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, permission.name(), path), (Throwable)e);
                        }
                        boolean shouldCheckAccess = true;
                        if (this.isMountedFs(fs) && (resolvedPath = this.resolvePath(path, fs)) != null) {
                            shouldCheckAccess = this.isPathInFSScheme(resolvedPath.toUri().toString());
                        }
                        if (shouldCheckAccess) {
                            if (this.isURIAccessAllowed(user, permission, path, fs)) continue;
                            throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, permission.name(), path));
                        }
                    }
                    if ((accessType = this.getAccessType(hivePrivilegeObject, hiveOpType, hiveObjType, true)) == HiveAccessType.NONE || this.existsByResourceAndAccessType(requests, resource, accessType)) continue;
                    RangerHiveAccessRequest rangerHiveAccessRequest = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, roles, hiveOpType, accessType, context, sessionContext);
                    requests.add(rangerHiveAccessRequest);
                }
            } else if (hiveOpType == HiveOperationType.SHOWDATABASES) {
                RangerHiveResource rangerHiveResource = new RangerHiveResource(HiveObjectType.DATABASE, null);
                RangerHiveAccessRequest rangerHiveAccessRequest = new RangerHiveAccessRequest(rangerHiveResource, user, (Set<String>)groups, roles, hiveOpType.name(), HiveAccessType.USE, context, sessionContext);
                requests.add(rangerHiveAccessRequest);
            } else if (hiveOpType == HiveOperationType.SHOW_GRANT) {
                String string = context.getCommandString();
                String string2 = "SHOW GRANT\\s*(\\w+)?\\s*(\\w+)?\\s*ON\\s*(\\w+)?\\s*(\\S+)";
                Pattern pattern = Pattern.compile(string2, 2);
                Matcher matcher = pattern.matcher(string);
                if (matcher.find()) {
                    RangerHiveAccessRequest request2;
                    RangerHiveResource resource2;
                    void var20_48;
                    String hiveObjectValue;
                    String hiveObjectType = matcher.group(3);
                    String string3 = hiveObjectValue = matcher.group(4);
                    String tableName2 = "";
                    if (hiveObjectValue.contains(".")) {
                        String[] parts = hiveObjectValue.split("\\.");
                        String string4 = parts[0];
                        tableName2 = parts[1];
                    }
                    if (hiveObjectType.toUpperCase().equals(HiveObjectType.DATABASE.name())) {
                        resource2 = new RangerHiveResource(HiveObjectType.DATABASE, (String)var20_48);
                        request2 = new RangerHiveAccessRequest(resource2, user, (Set<String>)groups, roles, hiveOpType.name(), HiveAccessType.USE, context, sessionContext);
                        requests.add(request2);
                    } else if (hiveObjectType.toUpperCase().equals(HiveObjectType.TABLE.name())) {
                        resource2 = new RangerHiveResource(HiveObjectType.TABLE, (String)var20_48, tableName2);
                        request2 = new RangerHiveAccessRequest(resource2, user, (Set<String>)groups, roles, hiveOpType.name(), HiveAccessType.USE, context, sessionContext);
                        requests.add(request2);
                    }
                }
            } else if (hiveOpType == HiveOperationType.REPLDUMP) {
                void var14_19;
                HiveObj hiveObj = new HiveObj(context);
                dbName = hiveObj.getDatabaseName();
                tableName = hiveObj.getTableName();
                LOG.debug("Database: {} Table: {}", (Object)dbName, (Object)tableName);
                if (!StringUtil.isEmpty((String)tableName)) {
                    RangerHiveResource rangerHiveResource = new RangerHiveResource(HiveObjectType.TABLE, dbName, tableName);
                } else {
                    RangerHiveResource rangerHiveResource = new RangerHiveResource(HiveObjectType.DATABASE, dbName, null);
                }
                request = new RangerHiveAccessRequest((RangerHiveResource)var14_19, user, (Set<String>)groups, roles, hiveOpType.name(), HiveAccessType.REPLADMIN, context, sessionContext);
                requests.add(request);
            } else if (hiveOpType.equals((Object)HiveOperationType.ALTERTABLE_OWNER)) {
                RangerHiveAccessRequest rangerHiveAccessRequest = this.buildRequestForAlterTableSetOwnerFromCommandString(user, groups, roles, hiveOpType.name(), context, sessionContext);
                if (rangerHiveAccessRequest == null) throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have privilege for [%s] command", user, hiveOpType.name()));
                requests.add(rangerHiveAccessRequest);
            } else {
                LOG.debug("RangerHiveAuthorizer.checkPrivileges: Unexpected operation type[{}] received with empty input objects list!", (Object)hiveOpType);
            }
            if (!CollectionUtils.isEmpty(outputHObjs)) {
                for (HivePrivilegeObject hivePrivilegeObject : outputHObjs) {
                    resource = this.getHiveResource(hiveOpType, hivePrivilegeObject, inputHObjs, outputHObjs, objOwners);
                    if (resource == null) continue;
                    pathStr = hivePrivilegeObject.getObjectName();
                    hiveObjType = resource.getObjectType();
                    if (hiveObjType == HiveObjectType.URI && this.isPathInFSScheme(pathStr)) {
                        permission = this.getURIAccessType(hiveOpType);
                        Path path = new Path(pathStr);
                        try {
                            fs = FileSystem.get((URI)path.toUri(), (Configuration)this.getHiveConf());
                        }
                        catch (IOException e) {
                            LOG.error("Error getting permissions for {}", (Object)path, (Object)e);
                            throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, permission.name(), path), (Throwable)e);
                        }
                        boolean shouldCheckAccess = true;
                        if (this.isMountedFs(fs) && (resolvedPath = this.resolvePath(path, fs)) != null) {
                            shouldCheckAccess = this.isPathInFSScheme(resolvedPath.toUri().toString());
                        }
                        if (shouldCheckAccess) {
                            if (this.isURIAccessAllowed(user, permission, path, fs)) continue;
                            throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, permission.name(), path));
                        }
                    }
                    if ((accessType = this.getAccessType(hivePrivilegeObject, hiveOpType, hiveObjType, false)) == HiveAccessType.NONE || this.existsByResourceAndAccessType(requests, resource, accessType)) continue;
                    RangerHiveAccessRequest rangerHiveAccessRequest = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, roles, hiveOpType, accessType, context, sessionContext);
                    requests.add(rangerHiveAccessRequest);
                }
            } else if (hiveOpType == HiveOperationType.REPLLOAD) {
                void var14_25;
                HiveObj hiveObj = new HiveObj(context);
                dbName = hiveObj.getDatabaseName();
                tableName = hiveObj.getTableName();
                LOG.debug("Database: {} Table: {}", (Object)dbName, (Object)tableName);
                if (!StringUtil.isEmpty((String)tableName)) {
                    RangerHiveResource rangerHiveResource = new RangerHiveResource(HiveObjectType.TABLE, dbName, tableName);
                } else {
                    RangerHiveResource rangerHiveResource = new RangerHiveResource(HiveObjectType.DATABASE, dbName, null);
                }
                request = new RangerHiveAccessRequest((RangerHiveResource)var14_25, user, (Set<String>)groups, roles, hiveOpType.name(), HiveAccessType.REPLADMIN, context, sessionContext);
                requests.add(request);
            }
            this.buildRequestContextWithAllAccessedResources(requests);
            for (RangerHiveAccessRequest rangerHiveAccessRequest : requests) {
                LOG.debug("request: {}", (Object)rangerHiveAccessRequest);
                resource = (RangerHiveResource)rangerHiveAccessRequest.getResource();
                RangerAccessResult result = null;
                if (resource.getObjectType() == HiveObjectType.COLUMN && StringUtils.contains((String)resource.getColumn(), (char)',')) {
                    ArrayList<RangerHiveAccessRequest> colRequests = new ArrayList<RangerHiveAccessRequest>();
                    String[] columns = StringUtils.split((String)resource.getColumn(), (char)',');
                    resource.setServiceDef(hivePlugin.getServiceDef());
                    for (String column : columns) {
                        if (column != null) {
                            column = column.trim();
                        }
                        if (StringUtils.isBlank((String)column)) continue;
                        RangerHiveResource colResource = new RangerHiveResource(HiveObjectType.COLUMN, resource.getDatabase(), resource.getTable(), column);
                        colResource.setOwnerUser(resource.getOwnerUser());
                        RangerHiveAccessRequest colRequest = rangerHiveAccessRequest.copy();
                        colRequest.setResource((RangerAccessResource)colResource);
                        colRequests.add(colRequest);
                    }
                    Collection collection = hivePlugin.isAccessAllowed(colRequests, (RangerAccessResultProcessor)auditHandler);
                    if (collection != null) {
                        RangerAccessResult colResult;
                        Iterator fs2 = collection.iterator();
                        while (fs2.hasNext() && ((result = (colResult = (RangerAccessResult)fs2.next())) == null || result.getIsAllowed())) {
                        }
                    }
                } else {
                    result = hivePlugin.isAccessAllowed((RangerAccessRequest)rangerHiveAccessRequest, (RangerAccessResultProcessor)auditHandler);
                }
                if ((result == null || result.getIsAllowed()) && this.isBlockAccessIfRowfilterColumnMaskSpecified(hiveOpType, rangerHiveAccessRequest)) {
                    HiveAccessType savedAccessType = rangerHiveAccessRequest.getHiveAccessType();
                    RangerHiveResource tblResource = new RangerHiveResource(HiveObjectType.TABLE, resource.getDatabase(), resource.getTable());
                    rangerHiveAccessRequest.setHiveAccessType(HiveAccessType.SELECT);
                    rangerHiveAccessRequest.setResource((RangerAccessResource)tblResource);
                    RangerAccessResult rangerAccessResult = this.getRowFilterResult(rangerHiveAccessRequest);
                    if (this.isRowFilterEnabled(rangerAccessResult)) {
                        if (result == null) {
                            result = new RangerAccessResult(0, rangerAccessResult.getServiceName(), rangerAccessResult.getServiceDef(), (RangerAccessRequest)rangerHiveAccessRequest);
                        }
                        result.setIsAllowed(false);
                        result.setPolicyId(rangerAccessResult.getPolicyId());
                        result.setPolicyVersion(rangerAccessResult.getPolicyVersion());
                        result.setReason("User does not have access to all rows of the table");
                    } else {
                        rangerHiveAccessRequest.setResourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS);
                        RangerAccessResult dataMaskResult = this.getDataMaskResult(rangerHiveAccessRequest);
                        if (this.isDataMaskEnabled(dataMaskResult)) {
                            if (result == null) {
                                result = new RangerAccessResult(0, dataMaskResult.getServiceName(), dataMaskResult.getServiceDef(), (RangerAccessRequest)rangerHiveAccessRequest);
                            }
                            result.setIsAllowed(false);
                            result.setPolicyId(dataMaskResult.getPolicyId());
                            result.setPolicyVersion(dataMaskResult.getPolicyVersion());
                            result.setReason("User does not have access to unmasked column values");
                        }
                    }
                    rangerHiveAccessRequest.setHiveAccessType(savedAccessType);
                    rangerHiveAccessRequest.setResource((RangerAccessResource)resource);
                    if (result != null && !result.getIsAllowed()) {
                        auditHandler.processResult(result);
                    }
                }
                if (result != null && result.getIsAllowed()) continue;
                String path = resource.getAsString();
                path = path == null ? "Unknown resource!!" : this.buildPathForException(path, hiveOpType);
                throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, rangerHiveAccessRequest.getHiveAccessType().name(), path));
            }
            auditHandler.flushAudit();
        }
        catch (Throwable throwable) {
            auditHandler.flushAudit();
            RangerPerfTracer.log(perf);
            throw throwable;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
    }

    public List<HivePrivilegeObject> filterListCmdObjects(List<HivePrivilegeObject> objs, HiveAuthzContext context) {
        LOG.debug("==> filterListCmdObjects({}, {})", objs, (Object)context);
        RangerPerfTracer perf = null;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
        if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_HIVEAUTH_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer((Logger)PERF_HIVEAUTH_REQUEST_LOG, (String)"RangerHiveAuthorizer.filterListCmdObjects()");
        }
        List<HivePrivilegeObject> ret = null;
        if (objs == null) {
            LOG.debug("filterListCmdObjects: meta objects list was null!");
        } else if (objs.isEmpty()) {
            LOG.debug("filterListCmdObjects: meta objects list was empty!");
            ret = objs;
        } else if (this.getCurrentUserGroupInfo() == null) {
            LOG.warn("filterListCmdObjects: user information not available");
            ret = objs;
        } else {
            LOG.debug("filterListCmdObjects: number of input objects[{}]", (Object)objs.size());
            UserGroupInformation ugi = this.getCurrentUserGroupInfo();
            HiveAuthzSessionContext sessionContext = this.getHiveAuthzSessionContext();
            String user = ugi.getShortUserName();
            HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            Set<String> roles = this.getCurrentRolesForUser(user, groups);
            HashMap<String, String> objOwners = new HashMap<String, String>();
            LOG.debug("filterListCmdObjects: user[{}], groups[{}], roles[{}] ", new Object[]{user, groups, roles});
            if (ret == null) {
                ret = new ArrayList<HivePrivilegeObject>(objs.size());
            }
            for (HivePrivilegeObject privilegeObject : objs) {
                RangerHiveResource resource;
                if (LOG.isDebugEnabled()) {
                    HivePrivilegeObject.HivePrivObjectActionType actionType = privilegeObject.getActionType();
                    HivePrivilegeObject.HivePrivilegeObjectType objectType = privilegeObject.getType();
                    String objectName = privilegeObject.getObjectName();
                    String dbName = privilegeObject.getDbname();
                    List columns = privilegeObject.getColumns();
                    List partitionKeys = privilegeObject.getPartKeys();
                    String commandString = context == null ? null : context.getCommandString();
                    String ipAddress = context == null ? null : context.getIpAddress();
                    LOG.debug("filterListCmdObjects: actionType[{}], objectType[{}], objectName[{}], dbName[{}], columns[{}], partitionKeys[{}]; context: commandString[{}], ipAddress[{}]", new Object[]{actionType, objectType, objectName, dbName, columns, partitionKeys, commandString, ipAddress});
                }
                if ((resource = this.createHiveResourceForFiltering(privilegeObject, objOwners)) == null) {
                    LOG.error("filterListCmdObjects: RangerHiveResource returned by createHiveResource is null");
                    continue;
                }
                RangerHiveAccessRequest request = new RangerHiveAccessRequest(resource, user, groups, roles, context, sessionContext);
                RangerAccessResult result = hivePlugin.isAccessAllowed((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
                if (result == null) {
                    LOG.error("filterListCmdObjects: Internal error: null RangerAccessResult object received back from isAccessAllowed()!");
                    continue;
                }
                if (!result.getIsAllowed()) {
                    if (!LOG.isDebugEnabled()) continue;
                    String path = resource.getAsString();
                    LOG.debug("filterListCmdObjects: Permission denied: user [{}] does not have [{}] privilege on [{}]. resource[{}], request[{}], result[{}]", new Object[]{user, request.getHiveAccessType().name(), path, resource, request, result});
                    continue;
                }
                LOG.debug("filterListCmdObjects: access allowed. resource[{}], request[{}], result[{}]", new Object[]{resource, request, result});
                ret.add(privilegeObject);
            }
        }
        auditHandler.flushAudit();
        RangerPerfTracer.log((RangerPerfTracer)perf);
        LOG.debug("<== filterListCmdObjects: count[{}], ret[{}]", (Object)(ret == null ? 0 : ret.size()), ret);
        return ret;
    }

    public List<String> getAllRoles() throws HiveAuthzPluginException, HiveAccessControlException {
        LOG.debug("==> RangerHiveAuthorizer.getAllRoles()");
        ArrayList<String> ret = new ArrayList<String>();
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
        List<String> userNames = null;
        boolean result = false;
        if (hivePlugin == null) {
            throw new HiveAuthzPluginException("RangerHiveAuthorizer.getAllRoles(): HivePlugin initialization failed...");
        }
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new HiveAccessControlException("RangerHiveAuthorizer.getAllRoles(): User information not available...");
        }
        String currentUserName = ugi.getShortUserName();
        try {
            Set roles;
            if (!hivePlugin.isServiceAdmin(currentUserName)) {
                throw new HiveAccessControlException("RangerHiveAuthorizer.getAllRoles(): User not authorized to run show roles...");
            }
            userNames = Collections.singletonList(currentUserName);
            RangerRoles rangerRoles = hivePlugin.getRangerRoles();
            if (rangerRoles != null && CollectionUtils.isNotEmpty((Collection)(roles = rangerRoles.getRangerRoles()))) {
                for (RangerRole rangerRole : roles) {
                    ret.add(rangerRole.getName());
                }
            }
            result = true;
        }
        catch (Exception excp) {
            throw new HiveAuthzPluginException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, currentUserName, userNames, HiveOperationType.SHOW_ROLES, HiveAccessType.SELECT, null, result);
            hivePlugin.evalAuditPolicies(accessResult);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
        LOG.debug("<== RangerHiveAuthorizer.getAllRoles() roles: {}", ret);
        return ret;
    }

    /*
     * Exception decompiling
     */
    public void setCurrentRole(String roleName) throws HiveAccessControlException, HiveAuthzPluginException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<String> getCurrentRoleNames() throws HiveAuthzPluginException {
        LOG.debug("RangerHiveAuthorizer.getCurrentRoleNames()");
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new HiveAuthzPluginException("User information not available");
        }
        boolean result = false;
        ArrayList<String> ret = new ArrayList<String>();
        String user = ugi.getShortUserName();
        List<String> userNames = Collections.singletonList(user);
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
        try {
            LOG.debug("<== getCurrentRoleNames() for user {}", (Object)user);
            for (String role : this.getCurrentRoles()) {
                ret.add(role);
            }
            result = true;
        }
        catch (Exception excp) {
            throw new HiveAuthzPluginException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, user, userNames, HiveOperationType.SHOW_ROLES, HiveAccessType.SELECT, ret, result);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
        return ret;
    }

    public List<HivePrivilegeObject> applyRowFilterAndColumnMasking(HiveAuthzContext queryContext, List<HivePrivilegeObject> hiveObjs) throws SemanticException {
        LOG.debug("==> applyRowFilterAndColumnMasking({}, objCount={})", (Object)queryContext, (Object)hiveObjs.size());
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_HIVEAUTH_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer((Logger)PERF_HIVEAUTH_REQUEST_LOG, (String)"RangerHiveAuthorizer.applyRowFilterAndColumnMasking()");
        }
        if (CollectionUtils.isNotEmpty(hiveObjs)) {
            IMetaStoreClient metaStoreClient = this.getMetaStoreClient();
            HashMap<String, String> objOwners = new HashMap<String, String>();
            for (HivePrivilegeObject hiveObj : hiveObjs) {
                HivePrivilegeObject.HivePrivilegeObjectType hiveObjType = hiveObj.getType();
                if (hiveObjType == null) {
                    hiveObjType = HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
                }
                LOG.debug("applyRowFilterAndColumnMasking(hiveObjType={})", (Object)hiveObjType);
                boolean needToTransform = false;
                if (hiveObjType == HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW) {
                    String database = hiveObj.getDbname();
                    String table = hiveObj.getObjectName();
                    String rowFilterExpr = this.getRowFilterExpression(queryContext, hiveObj, metaStoreClient, objOwners);
                    if (StringUtils.isNotBlank((String)rowFilterExpr)) {
                        LOG.debug("rowFilter(database={}, table={}): {}", new Object[]{database, table, rowFilterExpr});
                        hiveObj.setRowFilterExpression(rowFilterExpr);
                        needToTransform = true;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)hiveObj.getColumns())) {
                        ArrayList<String> columnTransformers = new ArrayList<String>();
                        for (String column : hiveObj.getColumns()) {
                            boolean isColumnTransformed = this.addCellValueTransformerAndCheckIfTransformed(queryContext, hiveObj, column, columnTransformers, metaStoreClient, objOwners);
                            LOG.debug("addCellValueTransformerAndCheckIfTransformed(database={}, table={}, column={}): {}", new Object[]{database, table, column, isColumnTransformed});
                            needToTransform = needToTransform || isColumnTransformed;
                        }
                        hiveObj.setCellValueTransformers(columnTransformers);
                    }
                }
                if (!needToTransform) continue;
                ret.add(hiveObj);
            }
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        LOG.debug("<== applyRowFilterAndColumnMasking({}, objCount={}): retCount={}", new Object[]{queryContext, hiveObjs.size(), ret.size()});
        return ret;
    }

    public boolean needTransform() {
        return true;
    }

    @Override
    public List<HivePrivilegeInfo> showPrivileges(HivePrincipal principal, HivePrivilegeObject privObj) throws HiveAuthzPluginException {
        List<HivePrivilegeInfo> ret;
        LOG.debug("==> RangerHiveAuthorizer.showPrivileges ==>  principal: {}HivePrivilegeObject : {}", (Object)principal, (Object)privObj.getObjectName());
        if (hivePlugin == null) {
            throw new HiveAuthzPluginException("RangerHiveAuthorizer.showPrivileges error: hivePlugin is null");
        }
        try {
            HiveObjectRef msObjRef = AuthorizationUtils.getThriftHiveObjectRef((HivePrivilegeObject)privObj);
            if (msObjRef.getDbName() == null) {
                throw new HiveAuthzPluginException("RangerHiveAuthorizer.showPrivileges() only supports SHOW PRIVILEGES for Hive resources and not user level");
            }
            ret = this.getHivePrivilegeInfos(principal, privObj);
        }
        catch (Exception e) {
            LOG.error("RangerHiveAuthorizer.showPrivileges() error", (Throwable)e);
            throw new HiveAuthzPluginException("RangerHiveAuthorizer.showPrivileges() error: " + e.getMessage(), (Throwable)e);
        }
        LOG.debug("<== RangerHiveAuthorizer.showPrivileges() Result: {}", ret);
        return ret;
    }

    @Override
    public HivePolicyProvider getHivePolicyProvider() throws HiveAuthzPluginException {
        if (hivePlugin == null) {
            throw new HiveAuthzPluginException();
        }
        return new RangerHivePolicyProvider(hivePlugin, this);
    }

    RangerHiveResource createHiveResource(HivePrivilegeObject privilegeObject) {
        return this.createHiveResource(privilegeObject, null);
    }

    RangerHiveResource createHiveResource(HivePrivilegeObject privilegeObject, Map<String, String> objOwners) {
        RangerHiveResource resource = null;
        HivePrivilegeObject.HivePrivilegeObjectType objectType = privilegeObject.getType();
        String objectName = privilegeObject.getObjectName();
        String dbName = privilegeObject.getDbname();
        switch (objectType) {
            case DATABASE: {
                resource = new RangerHiveResource(HiveObjectType.DATABASE, dbName);
                break;
            }
            case TABLE_OR_VIEW: {
                resource = new RangerHiveResource(HiveObjectType.TABLE, dbName, objectName);
                break;
            }
            case COLUMN: {
                int numOfColumns;
                List columns = privilegeObject.getColumns();
                int n = numOfColumns = columns == null ? 0 : columns.size();
                if (numOfColumns == 1) {
                    resource = new RangerHiveResource(HiveObjectType.COLUMN, dbName, objectName, (String)columns.get(0));
                    break;
                }
                LOG.warn("RangerHiveAuthorizer.getHiveResource: unexpected number of columns requested:{}, objectType:{}", (Object)numOfColumns, (Object)objectType);
                break;
            }
            default: {
                LOG.warn("RangerHiveAuthorizer.getHiveResource: unexpected objectType:{}", (Object)objectType);
            }
        }
        if (resource != null) {
            RangerHiveAuthorizer.setOwnerUser(resource, privilegeObject, this.getMetaStoreClient(), objOwners);
            resource.setServiceDef(hivePlugin == null ? null : hivePlugin.getServiceDef());
        }
        return resource;
    }

    private RangerAccessResult getDataMaskResult(RangerHiveAccessRequest request) {
        LOG.debug("==> getDataMaskResult(request={})", (Object)request);
        RangerAccessResult ret = hivePlugin.evalDataMaskPolicies((RangerAccessRequest)request, null);
        LOG.debug("<== getDataMaskResult(request={}): ret={}", (Object)request, (Object)ret);
        return ret;
    }

    private RangerAccessResult getRowFilterResult(RangerHiveAccessRequest request) {
        LOG.debug("==> getRowFilterResult(request={})", (Object)request);
        RangerAccessResult ret = hivePlugin.evalRowFilterPolicies((RangerAccessRequest)request, null);
        LOG.debug("<== getRowFilterResult(request={}): ret={}", (Object)request, (Object)ret);
        return ret;
    }

    private boolean isDataMaskEnabled(RangerAccessResult result) {
        return result != null && result.isMaskEnabled();
    }

    private boolean isRowFilterEnabled(RangerAccessResult result) {
        return result != null && result.isRowFilterEnabled() && StringUtils.isNotEmpty((String)result.getFilterExpr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRowFilterExpression(HiveAuthzContext context, HivePrivilegeObject tableOrView, IMetaStoreClient metaStoreClient, Map<String, String> objOwners) throws SemanticException {
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new SemanticException("user information not available");
        }
        String databaseName = tableOrView.getDbname();
        String tableOrViewName = tableOrView.getObjectName();
        LOG.debug("==> getRowFilterExpression({}, {})", (Object)databaseName, (Object)tableOrViewName);
        String ret = null;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
        try {
            HiveAuthzSessionContext sessionContext = this.getHiveAuthzSessionContext();
            String user = ugi.getShortUserName();
            HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            Set<String> roles = this.getCurrentRolesForUser(user, groups);
            HiveObjectType objectType = HiveObjectType.TABLE;
            RangerHiveResource resource = new RangerHiveResource(objectType, databaseName, tableOrViewName);
            RangerHiveAuthorizer.setOwnerUser(resource, tableOrView, metaStoreClient, objOwners);
            RangerHiveAccessRequest request = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, roles, objectType.name(), HiveAccessType.SELECT, context, sessionContext);
            RangerAccessResult result = hivePlugin.evalRowFilterPolicies((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
            if (this.isRowFilterEnabled(result)) {
                ret = result.getFilterExpr();
            }
        }
        finally {
            auditHandler.flushAudit();
        }
        LOG.debug("<== getRowFilterExpression({}, {}): {}", new Object[]{databaseName, tableOrViewName, ret});
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addCellValueTransformerAndCheckIfTransformed(HiveAuthzContext context, HivePrivilegeObject tableOrView, String columnName, List<String> columnTransformers, IMetaStoreClient metaStoreClient, Map<String, String> objOwners) throws SemanticException {
        boolean ret;
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new SemanticException("user information not available");
        }
        String databaseName = tableOrView.getDbname();
        String tableOrViewName = tableOrView.getObjectName();
        LOG.debug("==> addCellValueTransformerAndCheckIfTransformed({}, {}, {})", new Object[]{databaseName, tableOrViewName, columnName});
        String columnTransformer = columnName;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
        try {
            HiveAuthzSessionContext sessionContext = this.getHiveAuthzSessionContext();
            String user = ugi.getShortUserName();
            HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            Set<String> roles = this.getCurrentRolesForUser(user, groups);
            HiveObjectType objectType = HiveObjectType.COLUMN;
            RangerHiveResource resource = new RangerHiveResource(objectType, databaseName, tableOrViewName, columnName);
            RangerHiveAuthorizer.setOwnerUser(resource, tableOrView, metaStoreClient, objOwners);
            RangerHiveAccessRequest request = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, roles, objectType.name(), HiveAccessType.SELECT, context, sessionContext);
            RangerAccessResult result = hivePlugin.evalDataMaskPolicies((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
            ret = this.isDataMaskEnabled(result);
            if (ret) {
                String maskType = result.getMaskType();
                RangerServiceDef.RangerDataMaskTypeDef maskTypeDef = result.getMaskTypeDef();
                String transformer = null;
                if (maskTypeDef != null) {
                    transformer = maskTypeDef.getTransformer();
                }
                if (StringUtils.equalsIgnoreCase((String)maskType, (String)"MASK_NULL")) {
                    columnTransformer = "NULL";
                } else if (StringUtils.equalsIgnoreCase((String)maskType, (String)"CUSTOM")) {
                    String maskedValue = result.getMaskedValue();
                    columnTransformer = maskedValue == null ? "NULL" : maskedValue.replace("{col}", columnName);
                } else if (StringUtils.isNotEmpty((String)transformer)) {
                    columnTransformer = transformer.replace("{col}", columnName);
                }
                if (columnTransformer.contains("{colType}")) {
                    String colType = RangerHiveAuthorizer.getColumnType(tableOrView, columnName, metaStoreClient);
                    if (StringUtils.isBlank((String)colType)) {
                        LOG.warn("addCellValueTransformerAndCheckIfTransformed({}, {}, {}): failed to find column datatype", new Object[]{databaseName, tableOrViewName, columnName});
                        colType = "string";
                    }
                    columnTransformer = columnTransformer.replace("{colType}", colType);
                }
            }
        }
        finally {
            auditHandler.flushAudit();
        }
        columnTransformers.add(columnTransformer);
        LOG.debug("<== addCellValueTransformerAndCheckIfTransformed({}, {}, {}): {}", new Object[]{databaseName, tableOrViewName, columnName, ret});
        return ret;
    }

    private RangerHiveResource createHiveResourceForFiltering(HivePrivilegeObject privilegeObject, Map<String, String> objOwners) {
        RangerHiveResource resource = null;
        HivePrivilegeObject.HivePrivilegeObjectType objectType = privilegeObject.getType();
        switch (objectType) {
            case DATABASE: 
            case TABLE_OR_VIEW: {
                resource = this.createHiveResource(privilegeObject, objOwners);
                break;
            }
            default: {
                LOG.warn("RangerHiveAuthorizer.createHiveResourceForFiltering: unexpected objectType:{}", (Object)objectType);
            }
        }
        return resource;
    }

    private RangerHiveResource getHiveResource(HiveOperationType hiveOpType, HivePrivilegeObject hiveObj, List<HivePrivilegeObject> inputs, List<HivePrivilegeObject> outputs, Map<String, String> objOwners) {
        RangerHiveResource ret = null;
        HiveObjectType objectType = this.getObjectType(hiveObj, hiveOpType);
        switch (objectType) {
            case DATABASE: {
                ret = new RangerHiveResource(objectType, hiveObj.getDbname());
                if (this.isCreateOperation(hiveOpType)) break;
                RangerHiveAuthorizer.setOwnerUser(ret, hiveObj, this.getMetaStoreClient(), objOwners);
                break;
            }
            case TABLE: 
            case VIEW: 
            case FUNCTION: {
                HivePrivilegeObject dbObject;
                ret = new RangerHiveResource(objectType, hiveObj.getDbname(), hiveObj.getObjectName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Size of inputs = [{}, Size of outputs = [{}]", (Object)(CollectionUtils.isNotEmpty(inputs) ? inputs.size() : 0), (Object)(CollectionUtils.isNotEmpty(outputs) ? outputs.size() : 0));
                }
                RangerHiveAuthorizer.setOwnerUser(ret, hiveObj, this.getMetaStoreClient(), objOwners);
                if (!this.isCreateOperation(hiveOpType) || (dbObject = this.getDatabaseObject(hiveObj.getDbname(), inputs, outputs)) == null) break;
                RangerHiveAuthorizer.setOwnerUser(ret, dbObject, this.getMetaStoreClient(), objOwners);
                break;
            }
            case PARTITION: 
            case INDEX: {
                ret = new RangerHiveResource(objectType, hiveObj.getDbname(), hiveObj.getObjectName());
                break;
            }
            case COLUMN: {
                ret = new RangerHiveResource(objectType, hiveObj.getDbname(), hiveObj.getObjectName(), StringUtils.join((Collection)hiveObj.getColumns(), (char)','));
                RangerHiveAuthorizer.setOwnerUser(ret, hiveObj, this.getMetaStoreClient(), objOwners);
                break;
            }
            case URI: 
            case SERVICE_NAME: {
                ret = new RangerHiveResource(objectType, hiveObj.getObjectName());
                break;
            }
            case GLOBAL: {
                ret = new RangerHiveResource(objectType, hiveObj.getObjectName());
                break;
            }
        }
        if (ret != null) {
            ret.setServiceDef(hivePlugin == null ? null : hivePlugin.getServiceDef());
        }
        return ret;
    }

    private boolean isCreateOperation(HiveOperationType hiveOpType) {
        boolean ret = false;
        switch (hiveOpType) {
            case CREATETABLE: 
            case CREATEVIEW: 
            case CREATETABLE_AS_SELECT: 
            case CREATE_MATERIALIZED_VIEW: 
            case CREATEFUNCTION: {
                ret = true;
            }
        }
        return ret;
    }

    private HivePrivilegeObject getDatabaseObject(String dbName, List<HivePrivilegeObject> inputs, List<HivePrivilegeObject> outputs) {
        HivePrivilegeObject ret = null;
        if (CollectionUtils.isNotEmpty(outputs)) {
            for (HivePrivilegeObject hiveOutPrivObj : outputs) {
                if (hiveOutPrivObj.getType() != HivePrivilegeObject.HivePrivilegeObjectType.DATABASE || !dbName.equalsIgnoreCase(hiveOutPrivObj.getDbname())) continue;
                ret = hiveOutPrivObj;
            }
        }
        if (ret == null && CollectionUtils.isNotEmpty(inputs)) {
            for (HivePrivilegeObject hiveInPrivObj : inputs) {
                if (hiveInPrivObj.getType() != HivePrivilegeObject.HivePrivilegeObjectType.DATABASE || !dbName.equalsIgnoreCase(hiveInPrivObj.getDbname())) continue;
                ret = hiveInPrivObj;
            }
        }
        return ret;
    }

    private HiveObjectType getObjectType(HivePrivilegeObject hiveObj, HiveOperationType hiveOpType) {
        HiveObjectType objType = HiveObjectType.NONE;
        String hiveOpTypeName = hiveOpType.name().toLowerCase();
        if (hiveObj.getType() == null) {
            return HiveObjectType.DATABASE;
        }
        switch (hiveObj.getType()) {
            case DATABASE: {
                objType = HiveObjectType.DATABASE;
                break;
            }
            case PARTITION: {
                objType = HiveObjectType.PARTITION;
                break;
            }
            case TABLE_OR_VIEW: {
                if (hiveOpTypeName.contains("index")) {
                    objType = HiveObjectType.INDEX;
                    break;
                }
                if (!StringUtil.isEmpty((Collection)hiveObj.getColumns())) {
                    objType = HiveObjectType.COLUMN;
                    break;
                }
                if (hiveOpTypeName.contains("view")) {
                    objType = HiveObjectType.VIEW;
                    break;
                }
                objType = HiveObjectType.TABLE;
                break;
            }
            case FUNCTION: {
                objType = HiveObjectType.FUNCTION;
                if (!this.isTempUDFOperation(hiveOpTypeName, hiveObj)) break;
                objType = HiveObjectType.GLOBAL;
                break;
            }
            case DFS_URI: 
            case LOCAL_URI: {
                objType = HiveObjectType.URI;
                break;
            }
            case COMMAND_PARAMS: 
            case GLOBAL: {
                if (!"add".equals(hiveOpTypeName) && !"compile".equals(hiveOpTypeName)) break;
                objType = HiveObjectType.GLOBAL;
                break;
            }
            case SERVICE_NAME: {
                objType = HiveObjectType.SERVICE_NAME;
                break;
            }
        }
        return objType;
    }

    private HiveAccessType getAccessType(HivePrivilegeObject hiveObj, HiveOperationType hiveOpType, HiveObjectType hiveObjectType, boolean isInput) {
        HiveAccessType accessType;
        block43: {
            accessType = HiveAccessType.NONE;
            HivePrivilegeObject.HivePrivObjectActionType objectActionType = hiveObj.getActionType();
            if (hiveObjectType == HiveObjectType.URI && isInput) {
                accessType = HiveAccessType.READ;
                return accessType;
            }
            if (hiveObjectType == HiveObjectType.URI && !isInput) {
                accessType = HiveAccessType.WRITE;
                return accessType;
            }
            block0 : switch (objectActionType) {
                case INSERT: 
                case INSERT_OVERWRITE: 
                case UPDATE: 
                case DELETE: {
                    accessType = HiveAccessType.UPDATE;
                    break;
                }
                case OTHER: {
                    switch (hiveOpType) {
                        case CREATEDATABASE: {
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.DATABASE) {
                                accessType = HiveAccessType.CREATE;
                                break block0;
                            }
                            break block43;
                        }
                        case CREATEDATACONNECTOR: {
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.DATACONNECTOR) {
                                accessType = HiveAccessType.CREATE;
                                break block0;
                            }
                            break block43;
                        }
                        case CREATEFUNCTION: {
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.FUNCTION) {
                                accessType = HiveAccessType.CREATE;
                            }
                            if (hiveObjectType == HiveObjectType.GLOBAL) {
                                accessType = HiveAccessType.TEMPUDFADMIN;
                                break block0;
                            }
                            break block43;
                        }
                        case CREATETABLE: 
                        case CREATEVIEW: 
                        case CREATETABLE_AS_SELECT: 
                        case CREATE_MATERIALIZED_VIEW: {
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW) {
                                accessType = isInput ? HiveAccessType.SELECT : HiveAccessType.CREATE;
                                break block0;
                            }
                            break block43;
                        }
                        case ALTERVIEW_AS: {
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW) {
                                accessType = isInput ? HiveAccessType.SELECT : HiveAccessType.ALTER;
                                break block0;
                            }
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.DATABASE) {
                                accessType = HiveAccessType.SELECT;
                                break block0;
                            }
                            break block43;
                        }
                        case ALTERDATABASE: 
                        case ALTERDATABASE_LOCATION: 
                        case ALTERDATABASE_OWNER: 
                        case ALTERPARTITION_BUCKETNUM: 
                        case ALTERPARTITION_FILEFORMAT: 
                        case ALTERPARTITION_LOCATION: 
                        case ALTERPARTITION_MERGEFILES: 
                        case ALTERPARTITION_PROTECTMODE: 
                        case ALTERPARTITION_SERDEPROPERTIES: 
                        case ALTERPARTITION_SERIALIZER: 
                        case ALTERTABLE_ADDCOLS: 
                        case ALTERTABLE_ADDPARTS: 
                        case ALTERTABLE_ARCHIVE: 
                        case ALTERTABLE_BUCKETNUM: 
                        case ALTERTABLE_CLUSTER_SORT: 
                        case ALTERTABLE_COMPACT: 
                        case ALTERTABLE_DROPPARTS: 
                        case ALTERTABLE_DROPCONSTRAINT: 
                        case ALTERTABLE_ADDCONSTRAINT: 
                        case ALTERTABLE_FILEFORMAT: 
                        case ALTERTABLE_LOCATION: 
                        case ALTERTABLE_MERGEFILES: 
                        case ALTERTABLE_PARTCOLTYPE: 
                        case ALTERTABLE_PROPERTIES: 
                        case ALTERTABLE_SETPARTSPEC: 
                        case ALTERTABLE_EXECUTE: 
                        case ALTERTABLE_CONVERT: 
                        case ALTERDATACONNECTOR: 
                        case ALTERDATACONNECTOR_OWNER: 
                        case ALTERDATACONNECTOR_URL: 
                        case ALTERTABLE_PROTECTMODE: 
                        case ALTERTABLE_RENAME: 
                        case ALTERTABLE_RENAMECOL: 
                        case ALTERTABLE_RENAMEPART: 
                        case ALTERTABLE_REPLACECOLS: 
                        case ALTERTABLE_SERDEPROPERTIES: 
                        case ALTERTABLE_SERIALIZER: 
                        case ALTERTABLE_SKEWED: 
                        case ALTERTABLE_TOUCH: 
                        case ALTERTABLE_UNARCHIVE: 
                        case ALTERTABLE_UPDATEPARTSTATS: 
                        case ALTERTABLE_UPDATETABLESTATS: 
                        case ALTERTABLE_UPDATECOLUMNS: 
                        case ALTERTABLE_CREATEBRANCH: 
                        case ALTERTABLE_DROPBRANCH: 
                        case ALTERTABLE_CREATETAG: 
                        case ALTERTABLE_DROPTAG: 
                        case ALTERTBLPART_SKEWED_LOCATION: 
                        case ALTERVIEW_PROPERTIES: 
                        case ALTERVIEW_RENAME: 
                        case ALTER_MATERIALIZED_VIEW_REWRITE: 
                        case ALTER_MATERIALIZED_VIEW_REBUILD: 
                        case MSCK: {
                            accessType = HiveAccessType.ALTER;
                            break block0;
                        }
                        case DROPFUNCTION: 
                        case DROPTABLE: 
                        case DROPVIEW: 
                        case DROP_MATERIALIZED_VIEW: 
                        case DROPDATABASE: 
                        case DROPDATACONNECTOR: {
                            accessType = HiveAccessType.DROP;
                            break block0;
                        }
                        case IMPORT: {
                            accessType = isInput ? HiveAccessType.SELECT : HiveAccessType.CREATE;
                            break block0;
                        }
                        case EXPORT: 
                        case LOAD: {
                            accessType = isInput ? HiveAccessType.SELECT : HiveAccessType.UPDATE;
                            break block0;
                        }
                        case LOCKDB: 
                        case LOCKTABLE: 
                        case UNLOCKDB: 
                        case UNLOCKTABLE: {
                            accessType = HiveAccessType.LOCK;
                            break block0;
                        }
                        case QUERY: 
                        case SHOW_TABLESTATUS: 
                        case SHOW_CREATETABLE: 
                        case SHOWPARTITIONS: 
                        case SHOW_TBLPROPERTIES: 
                        case ANALYZE_TABLE: {
                            accessType = HiveAccessType.SELECT;
                            break block0;
                        }
                        case SHOWCOLUMNS: 
                        case DESCTABLE: {
                            switch (StringUtil.toLower((String)RangerHivePlugin.describeShowTableAuth)) {
                                case "show-allowed": 
                                case "none": 
                                case "": {
                                    accessType = HiveAccessType.SELECT;
                                    break block0;
                                }
                                case "show-all": {
                                    accessType = HiveAccessType.USE;
                                }
                            }
                            break block0;
                        }
                        case SHOWDATABASES: 
                        case SHOWDATACONNECTORS: 
                        case SHOW_GRANT: 
                        case SWITCHDATABASE: 
                        case DESCDATABASE: 
                        case DESCDATACONNECTOR: 
                        case SHOWTABLES: 
                        case SHOWVIEWS: {
                            accessType = HiveAccessType.USE;
                            break block0;
                        }
                        case TRUNCATETABLE: {
                            accessType = HiveAccessType.UPDATE;
                            break block0;
                        }
                        case GRANT_PRIVILEGE: 
                        case REVOKE_PRIVILEGE: {
                            accessType = HiveAccessType.NONE;
                            break block0;
                        }
                        case REPLDUMP: 
                        case REPLLOAD: 
                        case REPLSTATUS: {
                            accessType = HiveAccessType.REPLADMIN;
                            break block0;
                        }
                        case KILL_QUERY: 
                        case CREATE_RESOURCEPLAN: 
                        case SHOW_RESOURCEPLAN: 
                        case ALTER_RESOURCEPLAN: 
                        case DROP_RESOURCEPLAN: 
                        case CREATE_TRIGGER: 
                        case ALTER_TRIGGER: 
                        case DROP_TRIGGER: 
                        case CREATE_POOL: 
                        case ALTER_POOL: 
                        case DROP_POOL: 
                        case CREATE_MAPPING: 
                        case ALTER_MAPPING: 
                        case DROP_MAPPING: 
                        case LLAP_CACHE_PURGE: 
                        case LLAP_CLUSTER_INFO: {
                            accessType = HiveAccessType.SERVICEADMIN;
                            break block0;
                        }
                        case ADD: 
                        case COMPILE: {
                            accessType = HiveAccessType.TEMPUDFADMIN;
                            break block0;
                        }
                    }
                }
            }
        }
        return accessType;
    }

    private FsAction getURIAccessType(HiveOperationType hiveOpType) {
        FsAction ret = FsAction.NONE;
        switch (hiveOpType) {
            case IMPORT: 
            case LOAD: {
                ret = FsAction.READ;
                break;
            }
            case EXPORT: {
                ret = FsAction.WRITE;
                break;
            }
            case CREATETABLE: 
            case CREATETABLE_AS_SELECT: 
            case CREATEFUNCTION: 
            case CREATEDATABASE: 
            case CREATEDATACONNECTOR: 
            case ALTERDATABASE: 
            case ALTERDATABASE_LOCATION: 
            case ALTERDATABASE_OWNER: 
            case ALTERPARTITION_BUCKETNUM: 
            case ALTERPARTITION_FILEFORMAT: 
            case ALTERPARTITION_LOCATION: 
            case ALTERPARTITION_MERGEFILES: 
            case ALTERPARTITION_PROTECTMODE: 
            case ALTERPARTITION_SERDEPROPERTIES: 
            case ALTERPARTITION_SERIALIZER: 
            case ALTERTABLE_ADDCOLS: 
            case ALTERTABLE_ADDPARTS: 
            case ALTERTABLE_ARCHIVE: 
            case ALTERTABLE_BUCKETNUM: 
            case ALTERTABLE_CLUSTER_SORT: 
            case ALTERTABLE_COMPACT: 
            case ALTERTABLE_DROPPARTS: 
            case ALTERTABLE_DROPCONSTRAINT: 
            case ALTERTABLE_ADDCONSTRAINT: 
            case ALTERTABLE_FILEFORMAT: 
            case ALTERTABLE_LOCATION: 
            case ALTERTABLE_MERGEFILES: 
            case ALTERTABLE_PARTCOLTYPE: 
            case ALTERTABLE_PROPERTIES: 
            case ALTERTABLE_SETPARTSPEC: 
            case ALTERTABLE_EXECUTE: 
            case ALTERTABLE_CONVERT: 
            case ALTERDATACONNECTOR: 
            case ALTERDATACONNECTOR_OWNER: 
            case ALTERDATACONNECTOR_URL: 
            case ALTERTABLE_PROTECTMODE: 
            case ALTERTABLE_RENAME: 
            case ALTERTABLE_RENAMECOL: 
            case ALTERTABLE_RENAMEPART: 
            case ALTERTABLE_REPLACECOLS: 
            case ALTERTABLE_SERDEPROPERTIES: 
            case ALTERTABLE_SERIALIZER: 
            case ALTERTABLE_SKEWED: 
            case ALTERTABLE_TOUCH: 
            case ALTERTABLE_UNARCHIVE: 
            case ALTERTABLE_UPDATEPARTSTATS: 
            case ALTERTABLE_UPDATETABLESTATS: 
            case ALTERTABLE_UPDATECOLUMNS: 
            case ALTERTABLE_CREATEBRANCH: 
            case ALTERTABLE_DROPBRANCH: 
            case ALTERTABLE_CREATETAG: 
            case ALTERTABLE_DROPTAG: 
            case ALTERTBLPART_SKEWED_LOCATION: 
            case DROPFUNCTION: 
            case QUERY: 
            case ADD: 
            case DELETE: 
            case RELOADFUNCTION: 
            case ALTERTABLE_EXCHANGEPARTITION: 
            case ALTERTABLE_OWNER: {
                ret = FsAction.ALL;
                break;
            }
        }
        return ret;
    }

    private String buildPathForException(String path, HiveOperationType hiveOpType) {
        String ret = path;
        switch (hiveOpType) {
            case DESCTABLE: {
                ret = path + "/*";
                break;
            }
            case QUERY: {
                try {
                    int endIndex = StringUtils.ordinalIndexOf((String)path, (String)"/", (int)2);
                    ret = path.substring(0, endIndex) + "/*";
                    break;
                }
                catch (Exception e) {
                    LOG.debug("RangerHiveAuthorizer.buildPathForException(): Error while creating exception message ", (Throwable)e);
                }
            }
        }
        return ret;
    }

    private boolean isURIAccessAllowed(String userName, FsAction action, Path filePath, FileSystem fs) {
        return this.isURIAccessAllowed(userName, action, filePath, fs, RangerHivePlugin.uriPermissionCoarseCheck);
    }

    private boolean isURIAccessAllowed(String userName, FsAction action, Path filePath, FileSystem fs, boolean coarseCheck) {
        boolean ret;
        boolean recurse;
        boolean bl = recurse = !coarseCheck;
        if (action == FsAction.NONE) {
            ret = true;
        } else {
            try {
                FileStatus[] filestat = fs.globStatus(filePath);
                if (filestat != null && filestat.length > 0) {
                    boolean isDenied = false;
                    for (FileStatus file : filestat) {
                        if (FileUtils.isOwnerOfFileHierarchy((FileSystem)fs, (FileStatus)file, (String)userName) || FileUtils.isActionPermittedForFileHierarchy((FileSystem)fs, (FileStatus)file, (String)userName, (FsAction)action, (boolean)recurse)) continue;
                        isDenied = true;
                        break;
                    }
                    ret = !isDenied;
                } else {
                    FileStatus file = FileUtils.getPathOrParentThatExists((FileSystem)fs, (Path)filePath);
                    FileUtils.checkFileAccessWithImpersonation((FileSystem)fs, (FileStatus)file, (FsAction)action, (String)userName);
                    ret = true;
                }
            }
            catch (Exception excp) {
                ret = false;
                LOG.error("Error getting permissions for {}", (Object)filePath, (Object)excp);
            }
        }
        return ret;
    }

    private boolean isPathInFSScheme(String uri) {
        boolean ret = false;
        String[] fsScheme = hivePlugin.getFSScheme();
        if (fsScheme != null) {
            for (String scheme : fsScheme) {
                if (uri.isEmpty() || !uri.startsWith(scheme)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private Path resolvePath(Path path, FileSystem fs) {
        try {
            return fs.resolvePath(path);
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean isMountedFs(FileSystem fs) {
        return fs.getChildFileSystems() != null;
    }

    private void handleDfsCommand(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, String user, RangerHiveAuditHandler auditHandler) throws HiveAccessControlException {
        String dfsCommandParams = null;
        if (inputHObjs != null) {
            for (HivePrivilegeObject hiveObj : inputHObjs) {
                if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.COMMAND_PARAMS && !StringUtil.isEmpty((String)(dfsCommandParams = StringUtil.toString((List)hiveObj.getCommandParams())))) break;
            }
        }
        int serviceType = -1;
        String serviceName = null;
        if (hivePlugin != null) {
            serviceType = hivePlugin.getServiceDefId();
            serviceName = hivePlugin.getServiceName();
        }
        auditHandler.logAuditEventForDfs(user, dfsCommandParams, false, serviceType, serviceName);
        throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have privilege for [%s] command", user, hiveOpType.name()));
    }

    private boolean existsByResourceAndAccessType(Collection<RangerHiveAccessRequest> requests, RangerHiveResource resource, HiveAccessType accessType) {
        boolean ret = false;
        if (requests != null && resource != null) {
            for (RangerHiveAccessRequest request : requests) {
                if (request.getHiveAccessType() != accessType || !request.getResource().equals((Object)resource)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private String getGrantorUsername(HivePrincipal grantorPrincipal) {
        String grantor;
        String string = grantor = grantorPrincipal != null ? grantorPrincipal.getName() : null;
        if (StringUtil.isEmpty((String)grantor)) {
            UserGroupInformation ugi = this.getCurrentUserGroupInfo();
            grantor = ugi != null ? ugi.getShortUserName() : null;
        }
        return grantor;
    }

    private Set<String> getGrantorGroupNames(HivePrincipal grantorPrincipal) {
        String[] groups;
        HashSet<String> ret = null;
        String grantor = grantorPrincipal != null ? grantorPrincipal.getName() : null;
        UserGroupInformation ugi = StringUtil.isEmpty((String)grantor) ? this.getCurrentUserGroupInfo() : UserGroupInformation.createRemoteUser((String)grantor);
        String[] stringArray = groups = ugi != null ? ugi.getGroupNames() : null;
        if (groups != null && groups.length > 0) {
            ret = new HashSet<String>(Arrays.asList(groups));
        }
        return ret;
    }

    private GrantRevokeRequest createGrantRevokeData(RangerHiveResource resource, List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAccessControlException {
        HiveAuthzSessionContext sessionContext;
        if (resource == null || resource.getObjectType() != HiveObjectType.DATABASE && resource.getObjectType() != HiveObjectType.TABLE && resource.getObjectType() != HiveObjectType.VIEW && resource.getObjectType() != HiveObjectType.COLUMN) {
            throw new HiveAccessControlException("grant/revoke: unexpected object type '" + (resource == null ? null : resource.getObjectType().name()));
        }
        GrantRevokeRequest ret = new GrantRevokeRequest();
        ret.setGrantor(this.getGrantorUsername(grantorPrincipal));
        ret.setGrantorGroups(this.getGrantorGroupNames(grantorPrincipal));
        ret.setDelegateAdmin(grantOption ? Boolean.TRUE : Boolean.FALSE);
        ret.setEnableAudit(Boolean.TRUE);
        ret.setReplaceExistingPermissions(Boolean.FALSE);
        String database = StringUtils.isEmpty((String)resource.getDatabase()) ? "*" : resource.getDatabase();
        String table = StringUtils.isEmpty((String)resource.getTable()) ? "*" : resource.getTable();
        String column = StringUtils.isEmpty((String)resource.getColumn()) ? "*" : resource.getColumn();
        HashMap<String, String> mapResource = new HashMap<String, String>();
        mapResource.put("database", database);
        mapResource.put("table", table);
        mapResource.put("column", column);
        ret.setOwnerUser(resource.getOwnerUser());
        ret.setResource(mapResource);
        SessionState ss = SessionState.get();
        if (ss != null) {
            ret.setClientIPAddress(ss.getUserIpAddress());
            ret.setSessionId(ss.getSessionId());
            HiveConf hiveConf = ss.getConf();
            if (hiveConf != null) {
                ret.setRequestData(hiveConf.get(HIVE_CONF_VAR_QUERY_STRING));
            }
        }
        if ((sessionContext = this.getHiveAuthzSessionContext()) != null) {
            ret.setClientType(sessionContext.getClientType() == null ? null : sessionContext.getClientType().toString());
        }
        for (HivePrincipal principal : hivePrincipals) {
            switch (principal.getType()) {
                case USER: {
                    ret.getUsers().add(principal.getName());
                    break;
                }
                case GROUP: {
                    ret.getGroups().add(principal.getName());
                    break;
                }
                case ROLE: {
                    ret.getRoles().add(principal.getName());
                    break;
                }
            }
        }
        for (HivePrivilege privilege : hivePrivileges) {
            String privName = privilege.getName();
            if (StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.ALL.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.ALTER.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.CREATE.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.DROP.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.INDEX.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.LOCK.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.SELECT.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.UPDATE.name())) {
                ret.getAccessTypes().add(privName.toLowerCase());
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)privName, (String)"Insert") || StringUtils.equalsIgnoreCase((String)privName, (String)"Delete")) {
                ret.getAccessTypes().add(HiveAccessType.UPDATE.name().toLowerCase());
                continue;
            }
            LOG.warn("grant/revoke: unexpected privilege type '{}'. Ignored", (Object)privName);
        }
        return ret;
    }

    private HivePrivilegeObject.HivePrivilegeObjectType getPluginPrivilegeObjType(org.apache.hadoop.hive.metastore.api.HiveObjectType objectType) {
        switch (objectType) {
            case DATABASE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.DATABASE;
            }
            case TABLE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
            }
        }
        throw new AssertionError((Object)("Unexpected object type " + objectType));
    }

    private RangerRequestedResources buildRequestContextWithAllAccessedResources(List<RangerHiveAccessRequest> requests) {
        RangerRequestedResources requestedResources = new RangerRequestedResources();
        for (RangerHiveAccessRequest request : requests) {
            RangerAccessRequestUtil.setRequestedResourcesInContext((Map)request.getContext(), (RangerRequestedResources)requestedResources);
            RangerHiveResource resource = (RangerHiveResource)request.getResource();
            if (resource.getObjectType() == HiveObjectType.COLUMN && StringUtils.contains((String)resource.getColumn(), (char)',')) {
                String[] columns = StringUtils.split((String)resource.getColumn(), (char)',');
                resource.setServiceDef(hivePlugin.getServiceDef());
                for (String column : columns) {
                    if (column != null) {
                        column = column.trim();
                    }
                    if (StringUtils.isBlank((String)column)) continue;
                    RangerHiveResource colResource = new RangerHiveResource(HiveObjectType.COLUMN, resource.getDatabase(), resource.getTable(), column);
                    colResource.setOwnerUser(resource.getOwnerUser());
                    colResource.setServiceDef(hivePlugin.getServiceDef());
                    requestedResources.addRequestedResource((RangerAccessResource)colResource);
                }
                continue;
            }
            resource.setServiceDef(hivePlugin.getServiceDef());
            requestedResources.addRequestedResource((RangerAccessResource)resource);
        }
        LOG.debug("RangerHiveAuthorizer.buildRequestContextWithAllAccessedResources() - {}", (Object)requestedResources);
        return requestedResources;
    }

    private boolean isBlockAccessIfRowfilterColumnMaskSpecified(HiveOperationType hiveOpType, RangerHiveAccessRequest request) {
        boolean ret = false;
        RangerHiveResource resource = (RangerHiveResource)request.getResource();
        HiveObjectType objType = resource.getObjectType();
        if (objType == HiveObjectType.TABLE || objType == HiveObjectType.VIEW || objType == HiveObjectType.COLUMN) {
            boolean bl = ret = hiveOpType == HiveOperationType.EXPORT;
            if (!ret && request.getHiveAccessType() == HiveAccessType.UPDATE && RangerHivePlugin.blockUpdateIfRowfilterColumnMaskSpecified) {
                ret = true;
            }
        }
        LOG.debug("isBlockAccessIfRowfilterColumnMaskSpecified({}, {}): {}", new Object[]{hiveOpType, request, ret});
        return ret;
    }

    private boolean isTempUDFOperation(String hiveOpTypeName, HivePrivilegeObject hiveObj) {
        return (hiveOpTypeName.contains("createfunction") || hiveOpTypeName.contains("dropfunction")) && StringUtils.isEmpty((String)hiveObj.getDbname());
    }

    private List<HivePrivilegeInfo> getHivePrivilegeInfos(HivePrincipal principal, HivePrivilegeObject privObj) throws HiveAuthzPluginException {
        ArrayList<HivePrivilegeInfo> ret = new ArrayList<HivePrivilegeInfo>();
        try {
            HiveObjectRef msObjRef = AuthorizationUtils.getThriftHiveObjectRef((HivePrivilegeObject)privObj);
            if (msObjRef != null) {
                HivePrivilegeObject hivePrivilegeObject = null;
                if (msObjRef.getDbName() != null) {
                    HivePrivilegeObject.HivePrivilegeObjectType objectType = this.getPluginPrivilegeObjType(msObjRef.getObjectType());
                    String dbName = msObjRef.getDbName();
                    String objectName = msObjRef.getObjectName();
                    String columnName = msObjRef.getColumnName() == null ? "" : msObjRef.getColumnName();
                    ArrayList<String> partValues = msObjRef.getPartValues() == null ? new ArrayList() : msObjRef.getPartValues();
                    hivePrivilegeObject = new HivePrivilegeObject(objectType, dbName, objectName);
                    RangerResourceACLs rangerResourceACLs = this.getRangerResourceACLs(hivePrivilegeObject);
                    if (rangerResourceACLs != null) {
                        Map userRangerACLs = rangerResourceACLs.getUserACLs();
                        Map groupRangerACLs = rangerResourceACLs.getGroupACLs();
                        Map roleRangerACLs = rangerResourceACLs.getRoleACLs();
                        Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> userPermissions = this.convertRangerACLsToHiveACLs(userRangerACLs);
                        Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> groupPermissions = this.convertRangerACLsToHiveACLs(groupRangerACLs);
                        Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> rolePermissions = this.convertRangerACLsToHiveACLs(roleRangerACLs);
                        if (principal != null) {
                            String role;
                            Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> roleACLs;
                            if (principal.getType() == HivePrincipal.HivePrincipalType.USER) {
                                String user = principal.getName();
                                Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> userACLs = userPermissions.get(user);
                                if (userACLs != null) {
                                    Map userAccessResult = (Map)userRangerACLs.get(user);
                                    for (HiveResourceACLs.Privilege userACL : userACLs.keySet()) {
                                        RangerPolicy policy = this.getRangerPolicy(userAccessResult, userACL.name());
                                        if (policy == null) continue;
                                        String aclname = this.getPermission(userACL, userAccessResult, policy);
                                        HivePrivilegeInfo privilegeInfo = this.createHivePrivilegeInfo(principal, objectType, dbName, objectName, columnName, partValues, aclname, policy);
                                        ret.add(privilegeInfo);
                                    }
                                }
                                Set<String> groups = this.getPrincipalGroup(user);
                                for (String group : groups) {
                                    Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> groupACLs = groupPermissions.get(group);
                                    if (groupACLs == null) continue;
                                    Map groupAccessResult = (Map)groupRangerACLs.get(group);
                                    for (HiveResourceACLs.Privilege groupACL : groupACLs.keySet()) {
                                        RangerPolicy policy = this.getRangerPolicy(groupAccessResult, groupACL.name());
                                        if (policy == null) continue;
                                        String aclname = this.getPermission(groupACL, groupAccessResult, policy);
                                        HivePrivilegeInfo privilegeInfo = this.createHivePrivilegeInfo(principal, objectType, dbName, objectName, columnName, partValues, aclname, policy);
                                        ret.add(privilegeInfo);
                                    }
                                }
                            } else if (principal.getType() == HivePrincipal.HivePrincipalType.ROLE && (roleACLs = rolePermissions.get(role = principal.getName())) != null) {
                                Map roleAccessResult = (Map)roleRangerACLs.get(role);
                                for (HiveResourceACLs.Privilege roleACL : roleACLs.keySet()) {
                                    RangerPolicy policy = this.getRangerPolicy(roleAccessResult, roleACL.name());
                                    if (policy == null) continue;
                                    String aclname = this.getPermission(roleACL, roleAccessResult, policy);
                                    HivePrivilegeInfo privilegeInfo = this.createHivePrivilegeInfo(principal, objectType, dbName, objectName, columnName, partValues, aclname, policy);
                                    ret.add(privilegeInfo);
                                }
                            }
                        } else {
                            HivePrivilegeInfo privilegeInfo;
                            String aclname;
                            RangerPolicy policy;
                            HivePrincipal hivePrincipal;
                            for (String user : userRangerACLs.keySet()) {
                                hivePrincipal = new HivePrincipal(user, HivePrincipal.HivePrincipalType.USER);
                                Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> userACLs = userPermissions.get(user);
                                if (userACLs == null) continue;
                                Map userAccessResult = (Map)userRangerACLs.get(user);
                                for (HiveResourceACLs.Privilege userACL : userACLs.keySet()) {
                                    policy = this.getRangerPolicy(userAccessResult, userACL.name());
                                    if (policy == null) continue;
                                    aclname = this.getPermission(userACL, userAccessResult, policy);
                                    privilegeInfo = this.createHivePrivilegeInfo(hivePrincipal, objectType, dbName, objectName, columnName, partValues, aclname, policy);
                                    ret.add(privilegeInfo);
                                }
                            }
                            for (String group : groupRangerACLs.keySet()) {
                                hivePrincipal = new HivePrincipal(group, HivePrincipal.HivePrincipalType.GROUP);
                                Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> groupACLs = groupPermissions.get(group);
                                if (groupACLs == null) continue;
                                Map groupAccessResult = (Map)groupRangerACLs.get(group);
                                for (HiveResourceACLs.Privilege groupACL : groupACLs.keySet()) {
                                    policy = this.getRangerPolicy(groupAccessResult, groupACL.name());
                                    if (policy == null) continue;
                                    aclname = this.getPermission(groupACL, groupAccessResult, policy);
                                    privilegeInfo = this.createHivePrivilegeInfo(hivePrincipal, objectType, dbName, objectName, columnName, partValues, aclname, policy);
                                    ret.add(privilegeInfo);
                                }
                            }
                            for (String role : roleRangerACLs.keySet()) {
                                hivePrincipal = new HivePrincipal(role, HivePrincipal.HivePrincipalType.ROLE);
                                Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> roleACLs = rolePermissions.get(role);
                                if (roleACLs == null) continue;
                                Map roleAccessResult = (Map)roleRangerACLs.get(role);
                                for (HiveResourceACLs.Privilege roleACL : roleACLs.keySet()) {
                                    policy = this.getRangerPolicy(roleAccessResult, roleACL.name());
                                    if (policy == null) continue;
                                    aclname = this.getPermission(roleACL, roleAccessResult, policy);
                                    privilegeInfo = this.createHivePrivilegeInfo(hivePrincipal, objectType, dbName, objectName, columnName, partValues, aclname, policy);
                                    ret.add(privilegeInfo);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HiveAuthzPluginException("hive showPrivileges: " + e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    private RangerPolicy getRangerPolicy(Map<String, RangerResourceACLs.AccessResult> accessResults, String rangerACL) {
        RangerResourceACLs.AccessResult accessResult;
        RangerPolicy ret = null;
        if (MapUtils.isNotEmpty(accessResults) && (accessResult = accessResults.get(rangerACL.toLowerCase())) != null) {
            ret = accessResult.getPolicy();
        }
        return ret;
    }

    private HivePrivilegeInfo createHivePrivilegeInfo(HivePrincipal hivePrincipal, HivePrivilegeObject.HivePrivilegeObjectType objectType, String dbName, String objectName, String columnName, List<String> partValues, String aclName, RangerPolicy policy) {
        int creationDate = 0;
        boolean delegateAdmin = false;
        for (RangerPolicy.RangerPolicyItem policyItem : policy.getPolicyItems()) {
            List policyItemAccesses = policyItem.getAccesses();
            List users = policyItem.getUsers();
            List groups = policyItem.getGroups();
            ArrayList<String> accessTypes = new ArrayList<String>();
            for (RangerPolicy.RangerPolicyItemAccess policyItemAccess : policyItemAccesses) {
                accessTypes.add(policyItemAccess.getType());
            }
            if (!accessTypes.contains(aclName.toLowerCase()) || !users.contains(hivePrincipal.getName()) && !groups.contains(hivePrincipal.getName())) continue;
            creationDate = policy.getCreateTime() == null ? creationDate : (int)(policy.getCreateTime().getTime() / 1000L);
            delegateAdmin = policyItem.getDelegateAdmin() == null ? delegateAdmin : policyItem.getDelegateAdmin();
        }
        HivePrincipal grantorPrincipal = new HivePrincipal(DEFAULT_RANGER_POLICY_GRANTOR, HivePrincipal.HivePrincipalType.USER);
        HivePrivilegeObject privilegeObject = new HivePrivilegeObject(objectType, dbName, objectName, partValues, columnName);
        HivePrivilege privilege = new HivePrivilege(aclName, null);
        HivePrivilegeInfo ret = new HivePrivilegeInfo(hivePrincipal, privilege, privilegeObject, grantorPrincipal, delegateAdmin, creationDate);
        return ret;
    }

    private Set<String> getPrincipalGroup(String user) {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
        return Sets.newHashSet((Object[])ugi.getGroupNames());
    }

    private RangerResourceACLs getRangerResourceACLs(HivePrivilegeObject hiveObject) {
        LOG.debug("==> RangerHivePolicyProvider.getRangerResourceACLs:[{}]", (Object)hiveObject);
        RangerHiveResource hiveResource = this.createHiveResource(hiveObject);
        RangerAccessRequestImpl request = new RangerAccessRequestImpl((RangerAccessResource)hiveResource, "_any", null, null, null);
        RangerResourceACLs ret = hivePlugin.getResourceACLs((RangerAccessRequest)request);
        LOG.debug("<== RangerHivePolicyProvider.getRangerResourceACLs:[{}], Computed ACLS:[{}]", (Object)hiveObject, (Object)ret);
        return ret;
    }

    private Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> convertRangerACLsToHiveACLs(Map<String, Map<String, RangerResourceACLs.AccessResult>> rangerACLs) {
        HashMap<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> ret = new HashMap<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>>();
        if (MapUtils.isNotEmpty(rangerACLs)) {
            HashSet<String> hivePrivileges = new HashSet<String>();
            for (HiveResourceACLs.Privilege privilege : HiveResourceACLs.Privilege.values()) {
                hivePrivileges.add(privilege.name().toLowerCase());
            }
            for (Map.Entry entry : rangerACLs.entrySet()) {
                HashMap<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> permissions = new HashMap<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>();
                ret.put((String)entry.getKey(), permissions);
                for (Map.Entry permission : ((Map)entry.getValue()).entrySet()) {
                    if (!hivePrivileges.contains(permission.getKey())) continue;
                    HiveResourceACLs.Privilege privilege = HiveResourceACLs.Privilege.valueOf((String)StringUtils.upperCase((String)((String)permission.getKey())));
                    int rangerResultValue = ((RangerResourceACLs.AccessResult)permission.getValue()).getResult();
                    HiveResourceACLs.AccessResult accessResult = rangerResultValue == RangerPolicyEvaluator.ACCESS_ALLOWED ? HiveResourceACLs.AccessResult.ALLOWED : (rangerResultValue == RangerPolicyEvaluator.ACCESS_DENIED ? HiveResourceACLs.AccessResult.NOT_ALLOWED : (rangerResultValue == RangerPolicyEvaluator.ACCESS_CONDITIONAL ? HiveResourceACLs.AccessResult.CONDITIONAL_ALLOWED : HiveResourceACLs.AccessResult.NOT_ALLOWED));
                    permissions.put(privilege, accessResult);
                }
            }
        }
        return ret;
    }

    private String getPermission(HiveResourceACLs.Privilege acl, Map<String, RangerResourceACLs.AccessResult> accessResultMap, RangerPolicy policy) {
        String aclname = acl.name();
        int aclResult = this.checkACLIsAllowed(acl, accessResultMap);
        if (aclResult > RangerPolicyEvaluator.ACCESS_DENIED && policy != null) {
            if (aclResult == RangerPolicyEvaluator.ACCESS_UNDETERMINED) {
                aclname = aclname + " (ACCESS_UNDETERMINED)";
            } else if (aclResult == RangerPolicyEvaluator.ACCESS_CONDITIONAL) {
                aclname = aclname + " (ACCESS_CONDITIONAL)";
            }
        }
        return aclname;
    }

    private int checkACLIsAllowed(HiveResourceACLs.Privilege acl, Map<String, RangerResourceACLs.AccessResult> accessResultMap) {
        int result = -1;
        String aclName = acl.name().toLowerCase();
        RangerResourceACLs.AccessResult accessResult = accessResultMap.get(aclName);
        if (accessResult != null) {
            result = accessResult.getResult();
        }
        return result;
    }

    private String toString(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, HiveAuthzContext context, HiveAuthzSessionContext sessionContext) {
        StringBuilder sb = new StringBuilder();
        sb.append("'checkPrivileges':{");
        sb.append("'hiveOpType':").append(hiveOpType);
        sb.append(", 'inputHObjs':[");
        this.toString(inputHObjs, sb);
        sb.append("]");
        sb.append(", 'outputHObjs':[");
        this.toString(outputHObjs, sb);
        sb.append("]");
        sb.append(", 'context':{");
        sb.append("'clientType':").append(sessionContext == null ? null : sessionContext.getClientType());
        sb.append(", 'commandString':").append(context == null ? "null" : context.getCommandString());
        sb.append(", 'ipAddress':").append(context == null ? "null" : context.getIpAddress());
        sb.append(", 'forwardedAddresses':").append(context == null ? "null" : StringUtils.join((Collection)context.getForwardedAddresses(), (String)", "));
        sb.append(", 'sessionString':").append(sessionContext == null ? "null" : sessionContext.getSessionString());
        sb.append("}");
        sb.append(", 'user':").append(this.getCurrentUserGroupInfo().getUserName());
        sb.append(", 'groups':[").append(StringUtil.toString((String[])this.getCurrentUserGroupInfo().getGroupNames())).append("]");
        sb.append("}");
        return sb.toString();
    }

    private StringBuilder toString(List<HivePrivilegeObject> privObjs, StringBuilder sb) {
        if (privObjs != null && !privObjs.isEmpty()) {
            this.toString(privObjs.get(0), sb);
            for (int i = 1; i < privObjs.size(); ++i) {
                sb.append(",");
                this.toString(privObjs.get(i), sb);
            }
        }
        return sb;
    }

    private StringBuilder toString(HivePrivilegeObject privObj, StringBuilder sb) {
        sb.append("'HivePrivilegeObject':{");
        sb.append("'type':").append(privObj.getType().toString());
        sb.append(", 'dbName':").append(privObj.getDbname());
        sb.append(", 'objectType':").append(privObj.getType());
        sb.append(", 'objectName':").append(privObj.getObjectName());
        sb.append(", 'columns':[").append(StringUtil.toString((List)privObj.getColumns())).append("]");
        sb.append(", 'partKeys':[").append(StringUtil.toString((List)privObj.getPartKeys())).append("]");
        sb.append(", 'commandParams':[").append(StringUtil.toString((List)privObj.getCommandParams())).append("]");
        sb.append(", 'actionType':").append(privObj.getActionType().toString());
        sb.append("}");
        return sb;
    }

    private RangerAccessResult createAuditEvent(RangerHivePlugin hivePlugin, String userOrGrantor, List<String> roleUsers, HiveOperationType hiveOperationType, HiveAccessType accessType, List<String> roleNames, boolean result) {
        RangerHiveAccessRequest rangerHiveAccessRequest = this.createRangerHiveAccessRequest(userOrGrantor, roleUsers, hiveOperationType, accessType, roleNames);
        return this.createRangerHiveAccessResult(hivePlugin, userOrGrantor, rangerHiveAccessRequest, result);
    }

    private RangerHiveAccessRequest createRangerHiveAccessRequest(String userOrGrantor, List<String> roleUsers, HiveOperationType hiveOperationType, HiveAccessType accessType, List<String> roleNames) {
        HiveAuthzContext.Builder builder = new HiveAuthzContext.Builder();
        String roleNameStr = this.createRoleString(roleNames);
        String userNameStr = this.createUserString(roleUsers);
        String commandString = this.getCommandString(hiveOperationType, userNameStr, roleNameStr);
        String cmdStr = commandString != null ? commandString : "";
        builder.setCommandString(cmdStr);
        HiveAuthzContext hiveAuthzContext = builder.build();
        RangerHiveResource rangerHiveResource = new RangerHiveResource(HiveObjectType.GLOBAL, "*");
        RangerHiveAccessRequest ret = new RangerHiveAccessRequest(rangerHiveResource, userOrGrantor, null, null, hiveOperationType, accessType, hiveAuthzContext, null);
        ret.setClusterName(hivePlugin.getClusterName());
        ret.setAction(hiveOperationType.name());
        ret.setClientIPAddress(RangerHiveAuthorizer.getRemoteIp());
        ret.setRemoteIPAddress(RangerHiveAuthorizer.getRemoteIp());
        return ret;
    }

    private RangerAccessResult createRangerHiveAccessResult(RangerHivePlugin hivePlugin, String userOrGrantor, RangerHiveAccessRequest rangerHiveAccessRequest, boolean result) {
        String serviceName = hivePlugin.getServiceName();
        RangerServiceDef serviceDef = hivePlugin.getServiceDef();
        String reason = String.format("%s is not an Admin", userOrGrantor);
        if (result) {
            reason = String.format("%s is Admin", userOrGrantor);
        }
        RangerAccessResult ret = new RangerAccessResult(0, serviceName, serviceDef, (RangerAccessRequest)rangerHiveAccessRequest);
        ret.setIsAccessDetermined(true);
        ret.setIsAudited(true);
        ret.setIsAllowed(result);
        ret.setAuditPolicyId(-1L);
        ret.setPolicyId(-1L);
        ret.setPolicyPriority(0);
        ret.setZoneName(null);
        ret.setPolicyVersion(null);
        ret.setReason(reason);
        ret.setAdditionalInfo(MapUtils.EMPTY_MAP);
        return ret;
    }

    private String getCommandString(HiveOperationType hiveOperationType, String user, String roleName) {
        String ret = "";
        switch (hiveOperationType) {
            case CREATEROLE: {
                ret = String.format(CMD_CREATE_ROLE, roleName);
                break;
            }
            case DROPROLE: {
                ret = String.format(CMD_DROP_ROLE, roleName);
                break;
            }
            case SHOW_ROLES: {
                ret = CMD_SHOW_ROLES;
                break;
            }
            case SHOW_ROLE_GRANT: {
                ret = String.format(CMD_SHOW_ROLE_GRANT, roleName);
                break;
            }
            case SHOW_ROLE_PRINCIPALS: {
                ret = String.format(CMD_SHOW_PRINCIPALS, roleName);
                break;
            }
            case GRANT_ROLE: {
                ret = String.format(CMD_GRANT_ROLE, roleName, user);
                break;
            }
            case REVOKE_ROLE: {
                ret = String.format(CMD_REVOKE_ROLE, roleName, user);
                break;
            }
            case SET: {
                ret = String.format(CMD_SET_ROLE, roleName);
            }
        }
        return ret;
    }

    private String createRoleString(List<String> roleNames) {
        String ret = CollectionUtils.isEmpty(roleNames) ? "" : (roleNames.size() > 1 ? StringUtils.join(roleNames, (String)",") : roleNames.get(0));
        return ret;
    }

    private String createUserString(List<String> userNames) {
        String ret = CollectionUtils.isEmpty(userNames) ? "" : (userNames.size() > 1 ? StringUtils.join(userNames, (String)",") : userNames.get(0));
        return ret;
    }

    private static String getRemoteIp() {
        SessionState ss = SessionState.get();
        String ret = ss != null ? ss.getUserIpAddress() : null;
        LOG.debug("RangerHiveAuthorizer.getRemoteIp()={}", (Object)ret);
        return ret;
    }

    private Set<String> getCurrentRoles() {
        this.getCurrentRoleForCurrentUser();
        return this.currentRoles;
    }

    private void initUserRoles() {
        LOG.debug(" ==> RangerHiveAuthorizer.initUserRoles()");
        String newUserName = this.getHiveAuthenticator().getUserName();
        if (Objects.equals(this.currentUserName, newUserName)) {
            return;
        }
        this.currentUserName = newUserName;
        try {
            this.currentRoles = this.getCurrentRoleNamesFromRanger();
        }
        catch (HiveAuthzPluginException e) {
            LOG.error("Error while fetching roles from ranger for user : {}", (Object)this.currentUserName, (Object)e);
        }
        LOG.info("Current user : {}, Current Roles : {}", (Object)this.currentUserName, this.currentRoles);
    }

    private void getCurrentRoleForCurrentUser() {
        if (this.isCurrentRoleSet) {
            return;
        }
        this.currentUserName = this.getHiveAuthenticator().getUserName();
        try {
            this.currentRoles = this.getCurrentRoleNamesFromRanger();
        }
        catch (HiveAuthzPluginException e) {
            LOG.error("Error while fetching roles from ranger for user : {}", (Object)this.currentUserName, (Object)e);
        }
        LOG.info("Current user : {}, Current Roles : {}", (Object)this.currentUserName, this.currentRoles);
    }

    private Set<String> getCurrentRolesForUser(String user, Set<String> groups) {
        LOG.debug("==> RangerHiveAuthorizer.getCurrentRolesForUser()");
        Set<String> ret = hivePlugin.getRolesFromUserAndGroups(user, groups);
        ret = this.isCurrentRoleSet ? this.currentRoles : ret;
        LOG.debug("<== RangerHiveAuthorizer.getCurrentRolesForUser() User: {}, User Roles: {}", (Object)this.currentUserName, ret);
        return ret;
    }

    private Set<String> getCurrentRoleNamesFromRanger() throws HiveAuthzPluginException {
        LOG.debug("==> RangerHiveAuthorizer.getCurrentRoleNamesFromRanger()");
        boolean result = false;
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new HiveAuthzPluginException("User information not available");
        }
        HashSet<String> ret = new HashSet<String>();
        String user = ugi.getShortUserName();
        HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler((Configuration)hivePlugin.getConfig());
        try {
            LOG.debug("==> RangerHiveAuthorizer.getCurrentRoleNamesFromRanger() for user {}, userGroups: {}", (Object)user, (Object)groups);
            HashSet<String> userRoles = new HashSet<String>(this.getRolesforUserAndGroups(user, groups));
            for (String role : userRoles) {
                if (!ROLE_ADMIN.equalsIgnoreCase(role)) {
                    ret.add(role);
                    continue;
                }
                this.adminRole = role;
            }
            result = true;
        }
        catch (Exception excp) {
            throw new HiveAuthzPluginException((Throwable)excp);
        }
        finally {
            ArrayList<String> roleNames = new ArrayList<String>(ret);
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, this.currentUserName, roleNames, HiveOperationType.SHOW_ROLES, HiveAccessType.SELECT, null, result);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
        LOG.debug("<== RangerHiveAuthorizer.getCurrentRoleNamesFromRanger() for user: {}, userGroups: {}, roleNames: {}", new Object[]{user, groups, ret});
        return ret;
    }

    private Set<String> getRolesforUserAndGroups(String user, Set<String> groups) {
        LOG.debug("==> RangerHiveAuthorizer.getRolesforUserAndGroups()");
        Set<String> ret = null;
        if (hivePlugin != null) {
            ret = hivePlugin.getRolesFromUserAndGroups(user, groups);
        }
        LOG.debug("<== RangerHiveAuthorizer.getRolesforUserAndGroups(), user: {}, groups: {}, roles: {}", new Object[]{user, groups, ret});
        return ret != null ? ret : Collections.emptySet();
    }

    private HiveRoleGrant getHiveRoleGrant(RangerRole role, RangerRole.RoleMember roleMember, String type) {
        HiveRoleGrant ret = new HiveRoleGrant();
        ret.setRoleName(role.getName());
        ret.setGrantOption(roleMember.getIsAdmin());
        ret.setGrantor(role.getCreatedByUser());
        ret.setGrantorType(HivePrincipal.HivePrincipalType.USER.name());
        ret.setPrincipalName(roleMember.getName());
        ret.setPrincipalType(type);
        if (role.getUpdateTime() != null) {
            ret.setGrantTime((int)(role.getUpdateTime().getTime() / 1000L));
        }
        return ret;
    }

    private RangerRole getRangerRoleForRoleName(String roleName) {
        RangerRole ret = null;
        RangerRoles rangerRoles = hivePlugin.getRangerRoles();
        if (rangerRoles != null) {
            Set roles = rangerRoles.getRangerRoles();
            for (RangerRole role : roles) {
                if (!roleName.equals(role.getName())) continue;
                ret = role;
                break;
            }
        }
        return ret;
    }

    private RangerHiveAccessRequest buildRequestForAlterTableSetOwnerFromCommandString(String user, Set<String> userGroups, Set<String> userRoles, String hiveOpTypeName, HiveAuthzContext context, HiveAuthzSessionContext sessionContext) {
        RangerHiveAccessRequest request = null;
        HiveObj hiveObj = new HiveObj();
        hiveObj.fetchHiveObjForAlterTable(context);
        String dbName = hiveObj.getDatabaseName();
        String tableName = hiveObj.getTableName();
        LOG.debug("Database: {} Table: {}", (Object)dbName, (Object)tableName);
        if (dbName != null && tableName != null) {
            RangerHiveResource resource = new RangerHiveResource(HiveObjectType.TABLE, dbName, tableName);
            request = new RangerHiveAccessRequest(resource, user, userGroups, userRoles, hiveOpTypeName, HiveAccessType.ALTER, context, sessionContext);
        }
        return request;
    }

    private static String getColumnType(HivePrivilegeObject hiveObj, String colName, IMetaStoreClient metaStoreClient) {
        String ret = null;
        if (hiveObj != null && metaStoreClient != null) {
            try {
                block1 : switch (hiveObj.getType()) {
                    case TABLE_OR_VIEW: 
                    case COLUMN: {
                        List cols;
                        Table table = metaStoreClient.getTable(hiveObj.getDbname(), hiveObj.getObjectName());
                        List list = cols = table != null && table.getSd() != null ? table.getSd().getCols() : null;
                        if (!CollectionUtils.isNotEmpty(cols)) break;
                        for (FieldSchema col : cols) {
                            if (!StringUtils.equalsIgnoreCase((String)col.getName(), (String)colName)) continue;
                            ret = col.getType();
                            break block1;
                        }
                        break;
                    }
                }
            }
            catch (Exception excp) {
                LOG.error("failed to get column type from Hive metastore. dbName={}, tblName={}, colName={}", new Object[]{hiveObj.getDbname(), hiveObj.getObjectName(), colName, excp});
            }
        }
        LOG.debug("getColumnType({}, {}): columnType={}", new Object[]{hiveObj, colName, ret});
        return ret;
    }

    private IMetaStoreClient getMetaStoreClient() {
        IMetaStoreClient ret = null;
        try {
            ret = this.getMetastoreClientFactory().getHiveMetastoreClient();
        }
        catch (HiveAuthzPluginException excp) {
            LOG.warn("failed to get meta-store client", (Throwable)excp);
        }
        return ret;
    }

    static {
        HashSet<String> roleNames = new HashSet<String>();
        roleNames.add(ROLE_ALL);
        roleNames.add(ROLE_DEFAULT);
        roleNames.add(ROLE_NONE);
        RESERVED_ROLE_NAMES = Collections.unmodifiableSet(roleNames);
    }

    private static class RangerHivePlugin
    extends RangerBasePlugin {
        private static final String RANGER_PLUGIN_HIVE_ULRAUTH_FILESYSTEM_SCHEMES = "ranger.plugin.hive.urlauth.filesystem.schemes";
        private static final String RANGER_PLUGIN_HIVE_ULRAUTH_FILESYSTEM_SCHEMES_DEFAULT = "hdfs:,file:";
        private static final String FILESYSTEM_SCHEMES_SEPARATOR_CHAR = ",";
        public static boolean uriPermissionCoarseCheck = false;
        public static boolean updateXaPoliciesOnGrantRevoke = true;
        public static boolean blockUpdateIfRowfilterColumnMaskSpecified = true;
        public static String describeShowTableAuth = "NONE";
        private String[] fsScheme;

        public RangerHivePlugin(String appType) {
            super("hive", appType);
        }

        public void init() {
            super.init();
            uriPermissionCoarseCheck = this.getConfig().getBoolean("xasecure.hive.uri.permission.coarse.check", false);
            updateXaPoliciesOnGrantRevoke = this.getConfig().getBoolean("xasecure.hive.update.xapolicies.on.grant.revoke", true);
            blockUpdateIfRowfilterColumnMaskSpecified = this.getConfig().getBoolean("xasecure.hive.block.update.if.rowfilter.columnmask.specified", true);
            describeShowTableAuth = this.getConfig().get("xasecure.hive.describetable.showcolumns.authorization.option", RangerHiveAuthorizer.ROLE_NONE);
            String fsSchemesString = this.getConfig().get(RANGER_PLUGIN_HIVE_ULRAUTH_FILESYSTEM_SCHEMES, RANGER_PLUGIN_HIVE_ULRAUTH_FILESYSTEM_SCHEMES_DEFAULT);
            this.fsScheme = StringUtils.split((String)fsSchemesString, (String)FILESYSTEM_SCHEMES_SEPARATOR_CHAR);
            if (this.fsScheme != null) {
                for (int i = 0; i < this.fsScheme.length; ++i) {
                    this.fsScheme[i] = this.fsScheme[i].trim();
                }
            }
        }

        public String[] getFSScheme() {
            return this.fsScheme;
        }
    }

    private static class HiveObj {
        String databaseName;
        String tableName;

        HiveObj() {
        }

        HiveObj(HiveAuthzContext context) {
            this.fetchHiveObj(context);
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void fetchHiveObjForAlterTable(HiveAuthzContext context) {
            Object[] cmd;
            String cmdString;
            if (context != null && (cmdString = context.getCommandString()) != null && !ArrayUtils.isEmpty((Object[])(cmd = cmdString.trim().split("\\s+"))) && cmd.length > 2) {
                this.tableName = cmd[2];
                if (this.tableName.contains(".")) {
                    String[] result = this.splitDBName(this.tableName);
                    this.databaseName = result[0];
                    this.tableName = result[1];
                } else {
                    SessionState sessionState = SessionState.get();
                    if (sessionState != null) {
                        this.databaseName = sessionState.getCurrentDatabase();
                    }
                }
            }
        }

        private void fetchHiveObj(HiveAuthzContext context) {
            Object[] cmd;
            String cmdString;
            if (context != null && (cmdString = context.getCommandString()) != null && !ArrayUtils.isEmpty((Object[])(cmd = cmdString.trim().split("\\s+"))) && cmd.length > 2) {
                Object dbName = cmd[2];
                if (((String)dbName).contains(".")) {
                    String[] result = this.splitDBName((String)dbName);
                    this.databaseName = result[0];
                    this.tableName = result[1];
                } else {
                    this.databaseName = dbName;
                    this.tableName = null;
                }
            }
        }

        private String[] splitDBName(String dbName) {
            return dbName.split("\\.");
        }
    }

    public static enum HiveAccessType {
        NONE,
        CREATE,
        ALTER,
        DROP,
        INDEX,
        LOCK,
        SELECT,
        UPDATE,
        USE,
        READ,
        WRITE,
        ALL,
        REPLADMIN,
        SERVICEADMIN,
        TEMPUDFADMIN;

    }

    public static enum HiveObjectType {
        NONE,
        DATABASE,
        TABLE,
        VIEW,
        PARTITION,
        INDEX,
        COLUMN,
        FUNCTION,
        URI,
        SERVICE_NAME,
        GLOBAL;

    }
}

