/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.authorization.hive.authorizer.HiveAccessType;
import org.apache.ranger.authorization.hive.authorizer.HiveObjectType;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAccessRequest;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAuditHandler;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAuthorizerBase;
import org.apache.ranger.authorization.hive.authorizer.RangerHivePlugin;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveResource;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerRequestedResources;

public class RangerHiveAuthorizer
extends RangerHiveAuthorizerBase {
    private static final Log LOG = LogFactory.getLog(RangerHiveAuthorizer.class);
    private static final Log PERF_HIVEAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"hiveauth.request");
    private static final char COLUMN_SEP = ',';
    private static final String HIVE_CONF_VAR_QUERY_STRING = "hive.query.string";
    private static volatile RangerHivePlugin hivePlugin = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RangerHiveAuthorizer(HiveMetastoreClientFactory metastoreClientFactory, HiveConf hiveConf, HiveAuthenticationProvider hiveAuthenticator, HiveAuthzSessionContext sessionContext) {
        super(metastoreClientFactory, hiveConf, hiveAuthenticator, sessionContext);
        LOG.debug((Object)"RangerHiveAuthorizer.RangerHiveAuthorizer()");
        RangerHivePlugin plugin = hivePlugin;
        if (plugin != null) return;
        Class<RangerHiveAuthorizer> clazz = RangerHiveAuthorizer.class;
        synchronized (RangerHiveAuthorizer.class) {
            plugin = hivePlugin;
            if (plugin != null) return;
            String appType = "unknown";
            if (sessionContext != null) {
                switch (sessionContext.getClientType()) {
                    case HIVECLI: {
                        appType = "hiveCLI";
                        break;
                    }
                    case HIVESERVER2: {
                        appType = "hiveServer2";
                    }
                }
            }
            plugin = new RangerHivePlugin(appType);
            plugin.init();
            hivePlugin = plugin;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public void grantPrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        if (!RangerHivePlugin.UpdateXaPoliciesOnGrantRevoke) {
            throw new HiveAuthzPluginException("GRANT/REVOKE not supported in Ranger HiveAuthorizer. Please use Ranger Security Admin to setup access control.");
        }
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            RangerHiveResource resource = this.getHiveResource(HiveOperationType.GRANT_PRIVILEGE, hivePrivObject);
            GrantRevokeRequest request = this.createGrantRevokeData(resource, hivePrincipals, hivePrivileges, grantorPrincipal, grantOption);
            request.setClusterName(hivePlugin.getClusterName());
            LOG.info((Object)("grantPrivileges(): " + request));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("grantPrivileges(): " + request));
            }
            hivePlugin.grantAccess(request, (RangerAccessResultProcessor)auditHandler);
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            auditHandler.flushAudit();
        }
    }

    public void revokePrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        if (!RangerHivePlugin.UpdateXaPoliciesOnGrantRevoke) {
            throw new HiveAuthzPluginException("GRANT/REVOKE not supported in Ranger HiveAuthorizer. Please use Ranger Security Admin to setup access control.");
        }
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            RangerHiveResource resource = this.getHiveResource(HiveOperationType.REVOKE_PRIVILEGE, hivePrivObject);
            GrantRevokeRequest request = this.createGrantRevokeData(resource, hivePrincipals, hivePrivileges, grantorPrincipal, grantOption);
            request.setClusterName(hivePlugin.getClusterName());
            LOG.info((Object)("revokePrivileges(): " + request));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("revokePrivileges(): " + request));
            }
            hivePlugin.revokeAccess(request, (RangerAccessResultProcessor)auditHandler);
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            auditHandler.flushAudit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPrivileges(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, HiveAuthzContext context) throws HiveAuthzPluginException, HiveAccessControlException {
        String clusterName;
        HashSet groups;
        String user;
        HiveAuthzSessionContext sessionContext;
        RangerPerfTracer perf;
        RangerHiveAuditHandler auditHandler;
        block31: {
            UserGroupInformation ugi = this.getCurrentUserGroupInfo();
            if (ugi == null) {
                throw new HiveAccessControlException("Permission denied: user information not available");
            }
            auditHandler = new RangerHiveAuditHandler();
            perf = null;
            sessionContext = this.getHiveAuthzSessionContext();
            user = ugi.getShortUserName();
            groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            clusterName = hivePlugin.getClusterName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)this.toString(hiveOpType, inputHObjs, outputHObjs, context, sessionContext));
            }
            if (hiveOpType != HiveOperationType.DFS) break block31;
            this.handleDfsCommand(hiveOpType, inputHObjs, user, auditHandler);
            auditHandler.flushAudit();
            RangerPerfTracer.log(perf);
            return;
        }
        try {
            HiveAccessType accessType;
            FsAction permission;
            HiveObjectType hiveObjType;
            String path;
            RangerHiveResource resource;
            if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_HIVEAUTH_REQUEST_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Log)PERF_HIVEAUTH_REQUEST_LOG, (String)("RangerHiveAuthorizer.checkPrivileges(hiveOpType=" + hiveOpType + ")"));
            }
            ArrayList<RangerHiveAccessRequest> requests = new ArrayList<RangerHiveAccessRequest>();
            if (!CollectionUtils.isEmpty(inputHObjs)) {
                for (HivePrivilegeObject hiveObj : inputHObjs) {
                    resource = this.getHiveResource(hiveOpType, hiveObj);
                    if (resource == null) continue;
                    path = hiveObj.getObjectName();
                    hiveObjType = resource.getObjectType();
                    if (hiveObjType == HiveObjectType.URI && this.isPathInFSScheme(path)) {
                        permission = this.getURIAccessType(hiveOpType);
                        if (this.isURIAccessAllowed(user, permission, path, this.getHiveConf())) continue;
                        throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, permission.name(), path));
                    }
                    accessType = this.getAccessType(hiveObj, hiveOpType, hiveObjType, true);
                    if (accessType == HiveAccessType.NONE || this.existsByResourceAndAccessType(requests, resource, accessType)) continue;
                    RangerHiveAccessRequest rangerHiveAccessRequest = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, hiveOpType, accessType, context, sessionContext, clusterName);
                    requests.add(rangerHiveAccessRequest);
                }
            } else if (hiveOpType == HiveOperationType.SHOWDATABASES) {
                RangerHiveResource resource2 = new RangerHiveResource(HiveObjectType.DATABASE, null);
                RangerHiveAccessRequest request2 = new RangerHiveAccessRequest(resource2, user, (Set<String>)groups, hiveOpType.name(), HiveAccessType.USE, context, sessionContext, clusterName);
                requests.add(request2);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RangerHiveAuthorizer.checkPrivileges: Unexpected operation type[" + hiveOpType + "] received with empty input objects list!"));
            }
            if (!CollectionUtils.isEmpty(outputHObjs)) {
                for (HivePrivilegeObject hiveObj : outputHObjs) {
                    resource = this.getHiveResource(hiveOpType, hiveObj);
                    if (resource == null) continue;
                    path = hiveObj.getObjectName();
                    hiveObjType = resource.getObjectType();
                    if (hiveObjType == HiveObjectType.URI && this.isPathInFSScheme(path)) {
                        permission = this.getURIAccessType(hiveOpType);
                        if (this.isURIAccessAllowed(user, permission, path, this.getHiveConf())) continue;
                        throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, permission.name(), path));
                    }
                    accessType = this.getAccessType(hiveObj, hiveOpType, hiveObjType, false);
                    if (accessType == HiveAccessType.NONE || this.existsByResourceAndAccessType(requests, resource, accessType)) continue;
                    RangerHiveAccessRequest rangerHiveAccessRequest = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, hiveOpType, accessType, context, sessionContext, clusterName);
                    requests.add(rangerHiveAccessRequest);
                }
            }
            this.buildRequestContextWithAllAccessedResources(requests);
            for (RangerHiveAccessRequest request : requests) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("request: " + (Object)((Object)request)));
                }
                resource = (RangerHiveResource)request.getResource();
                RangerAccessResult result = null;
                if (resource.getObjectType() == HiveObjectType.COLUMN && StringUtils.contains((String)resource.getColumn(), (char)',')) {
                    ArrayList<RangerHiveAccessRequest> colRequests = new ArrayList<RangerHiveAccessRequest>();
                    String[] columns = StringUtils.split((String)resource.getColumn(), (char)',');
                    resource.setServiceDef(hivePlugin.getServiceDef());
                    for (String column : columns) {
                        if (column != null) {
                            column = column.trim();
                        }
                        if (StringUtils.isBlank((String)column)) continue;
                        RangerHiveResource colResource = new RangerHiveResource(HiveObjectType.COLUMN, resource.getDatabase(), resource.getTable(), column);
                        RangerHiveAccessRequest colRequest = request.copy();
                        colRequest.setResource((RangerAccessResource)colResource);
                        colRequests.add(colRequest);
                    }
                    Collection collection = hivePlugin.isAccessAllowed(colRequests, (RangerAccessResultProcessor)auditHandler);
                    if (collection != null) {
                        RangerAccessResult colResult;
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext() && ((result = (colResult = (RangerAccessResult)iterator.next())) == null || result.getIsAllowed())) {
                        }
                    }
                } else {
                    result = hivePlugin.isAccessAllowed((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
                }
                if ((result == null || result.getIsAllowed()) && this.isBlockAccessIfRowfilterColumnMaskSpecified(hiveOpType, request)) {
                    HiveAccessType savedAccessType = request.getHiveAccessType();
                    RangerHiveResource tblResource = new RangerHiveResource(HiveObjectType.TABLE, resource.getDatabase(), resource.getTable());
                    request.setHiveAccessType(HiveAccessType.SELECT);
                    request.setResource((RangerAccessResource)tblResource);
                    RangerAccessResult rangerAccessResult = this.getRowFilterResult(request);
                    if (this.isRowFilterEnabled(rangerAccessResult)) {
                        if (result == null) {
                            result = new RangerAccessResult(0, rangerAccessResult.getServiceName(), rangerAccessResult.getServiceDef(), (RangerAccessRequest)request);
                        }
                        result.setIsAllowed(false);
                        result.setPolicyId(rangerAccessResult.getPolicyId());
                        result.setReason("User does not have acces to all rows of the table");
                    } else {
                        request.setResourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS);
                        RangerAccessResult dataMaskResult = this.getDataMaskResult(request);
                        if (this.isDataMaskEnabled(dataMaskResult)) {
                            if (result == null) {
                                result = new RangerAccessResult(0, dataMaskResult.getServiceName(), dataMaskResult.getServiceDef(), (RangerAccessRequest)request);
                            }
                            result.setIsAllowed(false);
                            result.setPolicyId(dataMaskResult.getPolicyId());
                            result.setReason("User does not have access to unmasked column values");
                        }
                    }
                    request.setHiveAccessType(savedAccessType);
                    request.setResource((RangerAccessResource)resource);
                    if (result != null && !result.getIsAllowed()) {
                        auditHandler.processResult(result);
                    }
                }
                if (result != null && result.getIsAllowed()) continue;
                String path2 = resource.getAsString();
                path2 = path2 == null ? "Unknown resource!!" : this.buildPathForException(path2, hiveOpType);
                throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, request.getHiveAccessType().name(), path2));
            }
            auditHandler.flushAudit();
        }
        catch (Throwable throwable) {
            auditHandler.flushAudit();
            RangerPerfTracer.log(perf);
            throw throwable;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
    }

    public List<HivePrivilegeObject> filterListCmdObjects(List<HivePrivilegeObject> objs, HiveAuthzContext context) throws HiveAuthzPluginException, HiveAccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> filterListCmdObjects(%s, %s)", objs, context));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_HIVEAUTH_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer((Log)PERF_HIVEAUTH_REQUEST_LOG, (String)"RangerHiveAuthorizer.filterListCmdObjects()");
        }
        List<HivePrivilegeObject> ret = null;
        if (objs == null) {
            LOG.debug((Object)"filterListCmdObjects: meta objects list was null!");
        } else if (objs.isEmpty()) {
            LOG.debug((Object)"filterListCmdObjects: meta objects list was empty!");
            ret = objs;
        } else if (this.getCurrentUserGroupInfo() == null) {
            LOG.warn((Object)"filterListCmdObjects: user information not available");
            ret = objs;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("filterListCmdObjects: number of input objects[" + objs.size() + "]"));
            }
            UserGroupInformation ugi = this.getCurrentUserGroupInfo();
            HiveAuthzSessionContext sessionContext = this.getHiveAuthzSessionContext();
            String user = ugi.getShortUserName();
            HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("filterListCmdObjects: user[%s], groups%s", user, groups));
            }
            if (ret == null) {
                ret = new ArrayList<HivePrivilegeObject>(objs.size());
            }
            for (HivePrivilegeObject privilegeObject : objs) {
                RangerHiveResource resource;
                if (LOG.isDebugEnabled()) {
                    HivePrivilegeObject.HivePrivObjectActionType actionType = privilegeObject.getActionType();
                    HivePrivilegeObject.HivePrivilegeObjectType objectType = privilegeObject.getType();
                    String objectName = privilegeObject.getObjectName();
                    String dbName = privilegeObject.getDbname();
                    List columns = privilegeObject.getColumns();
                    List partitionKeys = privilegeObject.getPartKeys();
                    String commandString = context == null ? null : context.getCommandString();
                    String ipAddress = context == null ? null : context.getIpAddress();
                    String format = "filterListCmdObjects: actionType[%s], objectType[%s], objectName[%s], dbName[%s], columns[%s], partitionKeys[%s]; context: commandString[%s], ipAddress[%s]";
                    LOG.debug((Object)String.format("filterListCmdObjects: actionType[%s], objectType[%s], objectName[%s], dbName[%s], columns[%s], partitionKeys[%s]; context: commandString[%s], ipAddress[%s]", actionType, objectType, objectName, dbName, columns, partitionKeys, commandString, ipAddress));
                }
                if ((resource = this.createHiveResource(privilegeObject)) == null) {
                    LOG.error((Object)"filterListCmdObjects: RangerHiveResource returned by createHiveResource is null");
                    continue;
                }
                RangerHiveAccessRequest request = new RangerHiveAccessRequest(resource, user, groups, context, sessionContext, hivePlugin.getClusterName());
                RangerAccessResult result = hivePlugin.isAccessAllowed((RangerAccessRequest)request);
                if (result == null) {
                    LOG.error((Object)"filterListCmdObjects: Internal error: null RangerAccessResult object received back from isAccessAllowed()!");
                    continue;
                }
                if (!result.getIsAllowed()) {
                    if (LOG.isDebugEnabled()) continue;
                    String path = resource.getAsString();
                    LOG.debug((Object)String.format("filterListCmdObjects: Permission denied: user [%s] does not have [%s] privilege on [%s]. resource[%s], request[%s], result[%s]", new Object[]{user, request.getHiveAccessType().name(), path, resource, request, result}));
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("filterListCmdObjects: access allowed. resource[%s], request[%s], result[%s]", new Object[]{resource, request, result}));
                }
                ret.add(privilegeObject);
            }
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            int count = ret == null ? 0 : ret.size();
            LOG.debug((Object)String.format("<== filterListCmdObjects: count[%d], ret[%s]", count, ret));
        }
        return ret;
    }

    public List<HivePrivilegeObject> applyRowFilterAndColumnMasking(HiveAuthzContext queryContext, List<HivePrivilegeObject> hiveObjs) throws SemanticException {
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> applyRowFilterAndColumnMasking(" + queryContext + ", objCount=" + hiveObjs.size() + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_HIVEAUTH_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer((Log)PERF_HIVEAUTH_REQUEST_LOG, (String)"RangerHiveAuthorizer.applyRowFilterAndColumnMasking()");
        }
        if (CollectionUtils.isNotEmpty(hiveObjs)) {
            for (HivePrivilegeObject hiveObj : hiveObjs) {
                HivePrivilegeObject.HivePrivilegeObjectType hiveObjType = hiveObj.getType();
                if (hiveObjType == null) {
                    hiveObjType = HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("applyRowFilterAndColumnMasking(hiveObjType=" + hiveObjType + ")"));
                }
                boolean needToTransform = false;
                if (hiveObjType == HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW) {
                    String table;
                    String database = hiveObj.getDbname();
                    String rowFilterExpr = this.getRowFilterExpression(queryContext, database, table = hiveObj.getObjectName());
                    if (StringUtils.isNotBlank((String)rowFilterExpr)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("rowFilter(database=" + database + ", table=" + table + "): " + rowFilterExpr));
                        }
                        hiveObj.setRowFilterExpression(rowFilterExpr);
                        needToTransform = true;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)hiveObj.getColumns())) {
                        ArrayList<String> columnTransformers = new ArrayList<String>();
                        for (String column : hiveObj.getColumns()) {
                            boolean isColumnTransformed = this.addCellValueTransformerAndCheckIfTransformed(queryContext, database, table, column, columnTransformers);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("addCellValueTransformerAndCheckIfTransformed(database=" + database + ", table=" + table + ", column=" + column + "): " + isColumnTransformed));
                            }
                            needToTransform = needToTransform || isColumnTransformed;
                        }
                        hiveObj.setCellValueTransformers(columnTransformers);
                    }
                }
                if (!needToTransform) continue;
                ret.add(hiveObj);
            }
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== applyRowFilterAndColumnMasking(" + queryContext + ", objCount=" + hiveObjs.size() + "): retCount=" + ret.size()));
        }
        return ret;
    }

    public boolean needTransform() {
        return true;
    }

    private RangerAccessResult getDataMaskResult(RangerHiveAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> getDataMaskResult(request=" + (Object)((Object)request) + ")"));
        }
        RangerAccessResult ret = hivePlugin.evalDataMaskPolicies((RangerAccessRequest)request, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== getDataMaskResult(request=" + (Object)((Object)request) + "): ret=" + ret));
        }
        return ret;
    }

    private RangerAccessResult getRowFilterResult(RangerHiveAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> getRowFilterResult(request=" + (Object)((Object)request) + ")"));
        }
        RangerAccessResult ret = hivePlugin.evalRowFilterPolicies((RangerAccessRequest)request, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== getRowFilterResult(request=" + (Object)((Object)request) + "): ret=" + ret));
        }
        return ret;
    }

    private boolean isDataMaskEnabled(RangerAccessResult result) {
        return result != null && result.isMaskEnabled();
    }

    private boolean isRowFilterEnabled(RangerAccessResult result) {
        return result != null && result.isRowFilterEnabled() && StringUtils.isNotEmpty((String)result.getFilterExpr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRowFilterExpression(HiveAuthzContext context, String databaseName, String tableOrViewName) throws SemanticException {
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new SemanticException("user information not available");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> getRowFilterExpression(" + databaseName + ", " + tableOrViewName + ")"));
        }
        String ret = null;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            HiveAuthzSessionContext sessionContext = this.getHiveAuthzSessionContext();
            String user = ugi.getShortUserName();
            HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            HiveObjectType objectType = HiveObjectType.TABLE;
            String clusterName = hivePlugin.getClusterName();
            RangerHiveResource resource = new RangerHiveResource(objectType, databaseName, tableOrViewName);
            RangerHiveAccessRequest request = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, objectType.name(), HiveAccessType.SELECT, context, sessionContext, clusterName);
            RangerAccessResult result = hivePlugin.evalRowFilterPolicies((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
            if (this.isRowFilterEnabled(result)) {
                ret = result.getFilterExpr();
            }
        }
        finally {
            auditHandler.flushAudit();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== getRowFilterExpression(" + databaseName + ", " + tableOrViewName + "): " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addCellValueTransformerAndCheckIfTransformed(HiveAuthzContext context, String databaseName, String tableOrViewName, String columnName, List<String> columnTransformers) throws SemanticException {
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        String clusterName = hivePlugin.getClusterName();
        if (ugi == null) {
            throw new SemanticException("user information not available");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> addCellValueTransformerAndCheckIfTransformed(" + databaseName + ", " + tableOrViewName + ", " + columnName + ")"));
        }
        boolean ret = false;
        String columnTransformer = columnName;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            HiveAuthzSessionContext sessionContext = this.getHiveAuthzSessionContext();
            String user = ugi.getShortUserName();
            HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            HiveObjectType objectType = HiveObjectType.COLUMN;
            RangerHiveResource resource = new RangerHiveResource(objectType, databaseName, tableOrViewName, columnName);
            RangerHiveAccessRequest request = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, objectType.name(), HiveAccessType.SELECT, context, sessionContext, clusterName);
            RangerAccessResult result = hivePlugin.evalDataMaskPolicies((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
            ret = this.isDataMaskEnabled(result);
            if (ret) {
                String maskType = result.getMaskType();
                RangerServiceDef.RangerDataMaskTypeDef maskTypeDef = result.getMaskTypeDef();
                String transformer = null;
                if (maskTypeDef != null) {
                    transformer = maskTypeDef.getTransformer();
                }
                if (StringUtils.equalsIgnoreCase((String)maskType, (String)"MASK_NULL")) {
                    columnTransformer = "NULL";
                } else if (StringUtils.equalsIgnoreCase((String)maskType, (String)"CUSTOM")) {
                    String maskedValue = result.getMaskedValue();
                    columnTransformer = maskedValue == null ? "NULL" : maskedValue.replace("{col}", columnName);
                } else if (StringUtils.isNotEmpty((String)transformer)) {
                    columnTransformer = transformer.replace("{col}", columnName);
                }
            }
        }
        finally {
            auditHandler.flushAudit();
        }
        columnTransformers.add(columnTransformer);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== addCellValueTransformerAndCheckIfTransformed(" + databaseName + ", " + tableOrViewName + ", " + columnName + "): " + ret));
        }
        return ret;
    }

    RangerHiveResource createHiveResource(HivePrivilegeObject privilegeObject) {
        RangerHiveResource resource = null;
        HivePrivilegeObject.HivePrivilegeObjectType objectType = privilegeObject.getType();
        String objectName = privilegeObject.getObjectName();
        String dbName = privilegeObject.getDbname();
        switch (objectType) {
            case DATABASE: {
                resource = new RangerHiveResource(HiveObjectType.DATABASE, objectName);
                break;
            }
            case TABLE_OR_VIEW: {
                resource = new RangerHiveResource(HiveObjectType.TABLE, dbName, objectName);
                break;
            }
            default: {
                LOG.warn((Object)("RangerHiveAuthorizer.getHiveResource: unexpected objectType:" + objectType));
            }
        }
        if (resource != null) {
            resource.setServiceDef(hivePlugin == null ? null : hivePlugin.getServiceDef());
        }
        return resource;
    }

    private RangerHiveResource getHiveResource(HiveOperationType hiveOpType, HivePrivilegeObject hiveObj) {
        RangerHiveResource ret = null;
        HiveObjectType objectType = this.getObjectType(hiveObj, hiveOpType);
        switch (objectType) {
            case DATABASE: {
                ret = new RangerHiveResource(objectType, hiveObj.getDbname());
                break;
            }
            case TABLE: 
            case VIEW: 
            case PARTITION: 
            case INDEX: 
            case FUNCTION: {
                ret = new RangerHiveResource(objectType, hiveObj.getDbname(), hiveObj.getObjectName());
                break;
            }
            case COLUMN: {
                ret = new RangerHiveResource(objectType, hiveObj.getDbname(), hiveObj.getObjectName(), StringUtils.join((Collection)hiveObj.getColumns(), (char)','));
                break;
            }
            case URI: {
                ret = new RangerHiveResource(objectType, hiveObj.getObjectName());
                break;
            }
        }
        if (ret != null) {
            ret.setServiceDef(hivePlugin == null ? null : hivePlugin.getServiceDef());
        }
        return ret;
    }

    private HiveObjectType getObjectType(HivePrivilegeObject hiveObj, HiveOperationType hiveOpType) {
        HiveObjectType objType = HiveObjectType.NONE;
        if (hiveObj.getType() == null) {
            return HiveObjectType.DATABASE;
        }
        switch (hiveObj.getType()) {
            case DATABASE: {
                objType = HiveObjectType.DATABASE;
                break;
            }
            case PARTITION: {
                objType = HiveObjectType.PARTITION;
                break;
            }
            case TABLE_OR_VIEW: {
                String hiveOpTypeName = hiveOpType.name().toLowerCase();
                if (hiveOpTypeName.contains("index")) {
                    objType = HiveObjectType.INDEX;
                    break;
                }
                if (!StringUtil.isEmpty((Collection)hiveObj.getColumns())) {
                    objType = HiveObjectType.COLUMN;
                    break;
                }
                if (hiveOpTypeName.contains("view")) {
                    objType = HiveObjectType.VIEW;
                    break;
                }
                objType = HiveObjectType.TABLE;
                break;
            }
            case FUNCTION: {
                objType = HiveObjectType.FUNCTION;
                break;
            }
            case DFS_URI: 
            case LOCAL_URI: {
                objType = HiveObjectType.URI;
                break;
            }
            case COMMAND_PARAMS: 
            case GLOBAL: {
                break;
            }
        }
        return objType;
    }

    private HiveAccessType getAccessType(HivePrivilegeObject hiveObj, HiveOperationType hiveOpType, HiveObjectType hiveObjectType, boolean isInput) {
        HiveAccessType accessType;
        block35: {
            accessType = HiveAccessType.NONE;
            HivePrivilegeObject.HivePrivObjectActionType objectActionType = hiveObj.getActionType();
            if (hiveObjectType == HiveObjectType.URI && isInput) {
                accessType = HiveAccessType.READ;
                return accessType;
            }
            if (hiveObjectType == HiveObjectType.URI && !isInput) {
                accessType = HiveAccessType.WRITE;
                return accessType;
            }
            block0 : switch (objectActionType) {
                case INSERT: 
                case INSERT_OVERWRITE: 
                case UPDATE: 
                case DELETE: {
                    accessType = HiveAccessType.UPDATE;
                    break;
                }
                case OTHER: {
                    switch (hiveOpType) {
                        case CREATEDATABASE: {
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.DATABASE) {
                                accessType = HiveAccessType.CREATE;
                                break block0;
                            }
                            break block35;
                        }
                        case CREATEFUNCTION: {
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.FUNCTION) {
                                accessType = HiveAccessType.CREATE;
                                break block0;
                            }
                            break block35;
                        }
                        case CREATETABLE: 
                        case CREATEVIEW: 
                        case CREATETABLE_AS_SELECT: {
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW) {
                                accessType = isInput ? HiveAccessType.SELECT : HiveAccessType.CREATE;
                                break block0;
                            }
                            break block35;
                        }
                        case ALTERDATABASE: 
                        case ALTERDATABASE_OWNER: 
                        case ALTERINDEX_PROPS: 
                        case ALTERINDEX_REBUILD: 
                        case ALTERPARTITION_BUCKETNUM: 
                        case ALTERPARTITION_FILEFORMAT: 
                        case ALTERPARTITION_LOCATION: 
                        case ALTERPARTITION_MERGEFILES: 
                        case ALTERPARTITION_PROTECTMODE: 
                        case ALTERPARTITION_SERDEPROPERTIES: 
                        case ALTERPARTITION_SERIALIZER: 
                        case ALTERTABLE_ADDCOLS: 
                        case ALTERTABLE_ADDPARTS: 
                        case ALTERTABLE_ARCHIVE: 
                        case ALTERTABLE_BUCKETNUM: 
                        case ALTERTABLE_CLUSTER_SORT: 
                        case ALTERTABLE_COMPACT: 
                        case ALTERTABLE_DROPPARTS: 
                        case ALTERTABLE_DROPCONSTRAINT: 
                        case ALTERTABLE_ADDCONSTRAINT: 
                        case ALTERTABLE_FILEFORMAT: 
                        case ALTERTABLE_LOCATION: 
                        case ALTERTABLE_MERGEFILES: 
                        case ALTERTABLE_PARTCOLTYPE: 
                        case ALTERTABLE_PROPERTIES: 
                        case ALTERTABLE_PROTECTMODE: 
                        case ALTERTABLE_RENAME: 
                        case ALTERTABLE_RENAMECOL: 
                        case ALTERTABLE_RENAMEPART: 
                        case ALTERTABLE_REPLACECOLS: 
                        case ALTERTABLE_SERDEPROPERTIES: 
                        case ALTERTABLE_SERIALIZER: 
                        case ALTERTABLE_SKEWED: 
                        case ALTERTABLE_TOUCH: 
                        case ALTERTABLE_UNARCHIVE: 
                        case ALTERTABLE_UPDATEPARTSTATS: 
                        case ALTERTABLE_UPDATETABLESTATS: 
                        case ALTERTBLPART_SKEWED_LOCATION: 
                        case ALTERVIEW_AS: 
                        case ALTERVIEW_PROPERTIES: 
                        case ALTERVIEW_RENAME: 
                        case DROPVIEW_PROPERTIES: 
                        case MSCK: {
                            accessType = HiveAccessType.ALTER;
                            break block0;
                        }
                        case DROPFUNCTION: 
                        case DROPINDEX: 
                        case DROPTABLE: 
                        case DROPVIEW: 
                        case DROPDATABASE: {
                            accessType = HiveAccessType.DROP;
                            break block0;
                        }
                        case CREATEINDEX: {
                            accessType = HiveAccessType.INDEX;
                            break block0;
                        }
                        case IMPORT: {
                            accessType = isInput ? HiveAccessType.SELECT : HiveAccessType.CREATE;
                            break block0;
                        }
                        case EXPORT: 
                        case LOAD: {
                            accessType = isInput ? HiveAccessType.SELECT : HiveAccessType.UPDATE;
                            break block0;
                        }
                        case LOCKDB: 
                        case LOCKTABLE: 
                        case UNLOCKDB: 
                        case UNLOCKTABLE: {
                            accessType = HiveAccessType.LOCK;
                            break block0;
                        }
                        case QUERY: 
                        case SHOW_TABLESTATUS: 
                        case SHOW_CREATETABLE: 
                        case SHOWINDEXES: 
                        case SHOWPARTITIONS: 
                        case SHOW_TBLPROPERTIES: 
                        case ANALYZE_TABLE: {
                            accessType = HiveAccessType.SELECT;
                            break block0;
                        }
                        case SHOWCOLUMNS: 
                        case DESCTABLE: {
                            switch (StringUtil.toLower((String)RangerHivePlugin.DescribeShowTableAuth)) {
                                case "show-allowed": 
                                case "none": 
                                case "": {
                                    accessType = HiveAccessType.SELECT;
                                    break block0;
                                }
                                case "show-all": {
                                    accessType = HiveAccessType.USE;
                                }
                            }
                            break block0;
                        }
                        case SHOWDATABASES: 
                        case SWITCHDATABASE: 
                        case DESCDATABASE: 
                        case SHOWTABLES: {
                            accessType = HiveAccessType.USE;
                            break block0;
                        }
                        case TRUNCATETABLE: {
                            accessType = HiveAccessType.UPDATE;
                            break block0;
                        }
                        case GRANT_PRIVILEGE: 
                        case REVOKE_PRIVILEGE: {
                            accessType = HiveAccessType.NONE;
                            break block0;
                        }
                    }
                }
            }
        }
        return accessType;
    }

    private FsAction getURIAccessType(HiveOperationType hiveOpType) {
        FsAction ret = FsAction.NONE;
        switch (hiveOpType) {
            case IMPORT: 
            case LOAD: {
                ret = FsAction.READ;
                break;
            }
            case EXPORT: {
                ret = FsAction.WRITE;
                break;
            }
            case CREATEDATABASE: 
            case CREATETABLE: 
            case CREATETABLE_AS_SELECT: 
            case ALTERDATABASE: 
            case ALTERDATABASE_OWNER: 
            case ALTERINDEX_PROPS: 
            case ALTERPARTITION_BUCKETNUM: 
            case ALTERPARTITION_FILEFORMAT: 
            case ALTERPARTITION_LOCATION: 
            case ALTERPARTITION_MERGEFILES: 
            case ALTERPARTITION_PROTECTMODE: 
            case ALTERPARTITION_SERDEPROPERTIES: 
            case ALTERPARTITION_SERIALIZER: 
            case ALTERTABLE_ADDCOLS: 
            case ALTERTABLE_ADDPARTS: 
            case ALTERTABLE_ARCHIVE: 
            case ALTERTABLE_BUCKETNUM: 
            case ALTERTABLE_CLUSTER_SORT: 
            case ALTERTABLE_COMPACT: 
            case ALTERTABLE_DROPPARTS: 
            case ALTERTABLE_DROPCONSTRAINT: 
            case ALTERTABLE_ADDCONSTRAINT: 
            case ALTERTABLE_FILEFORMAT: 
            case ALTERTABLE_LOCATION: 
            case ALTERTABLE_MERGEFILES: 
            case ALTERTABLE_PARTCOLTYPE: 
            case ALTERTABLE_PROPERTIES: 
            case ALTERTABLE_PROTECTMODE: 
            case ALTERTABLE_RENAME: 
            case ALTERTABLE_RENAMECOL: 
            case ALTERTABLE_RENAMEPART: 
            case ALTERTABLE_REPLACECOLS: 
            case ALTERTABLE_SERDEPROPERTIES: 
            case ALTERTABLE_SERIALIZER: 
            case ALTERTABLE_SKEWED: 
            case ALTERTABLE_TOUCH: 
            case ALTERTABLE_UNARCHIVE: 
            case ALTERTABLE_UPDATEPARTSTATS: 
            case ALTERTABLE_UPDATETABLESTATS: 
            case ALTERTBLPART_SKEWED_LOCATION: 
            case QUERY: 
            case ALTERTABLE_EXCHANGEPARTITION: {
                ret = FsAction.ALL;
                break;
            }
        }
        return ret;
    }

    private String buildPathForException(String path, HiveOperationType hiveOpType) {
        String ret = path;
        int endIndex = 0;
        switch (hiveOpType) {
            case DESCTABLE: {
                ret = path + "/*";
                break;
            }
            case QUERY: {
                try {
                    endIndex = StringUtils.ordinalIndexOf((String)path, (String)"/", (int)2);
                    ret = path.substring(0, endIndex) + "/*";
                    break;
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)"RangerHiveAuthorizer.buildPathForException(): Error while creating exception message ", (Throwable)e);
                }
            }
        }
        return ret;
    }

    private boolean isURIAccessAllowed(String userName, FsAction action, String uri, HiveConf conf) {
        boolean ret = false;
        if (action == FsAction.NONE) {
            ret = true;
        } else {
            try {
                Path filePath = new Path(uri);
                FileSystem fs = FileSystem.get((URI)filePath.toUri(), (Configuration)conf);
                FileStatus[] filestat = fs.globStatus(filePath);
                if (filestat != null && filestat.length > 0) {
                    boolean isDenied = false;
                    for (FileStatus file : filestat) {
                        if (FileUtils.isOwnerOfFileHierarchy((FileSystem)fs, (FileStatus)file, (String)userName) || FileUtils.isActionPermittedForFileHierarchy((FileSystem)fs, (FileStatus)file, (String)userName, (FsAction)action)) continue;
                        isDenied = true;
                        break;
                    }
                    ret = !isDenied;
                } else {
                    FileStatus file = FileUtils.getPathOrParentThatExists((FileSystem)fs, (Path)filePath);
                    FileUtils.checkFileAccessWithImpersonation((FileSystem)fs, (FileStatus)file, (FsAction)action, (String)userName);
                    ret = true;
                }
            }
            catch (Exception excp) {
                ret = false;
                LOG.error((Object)("Error getting permissions for " + uri), (Throwable)excp);
            }
        }
        return ret;
    }

    private boolean isPathInFSScheme(String uri) {
        boolean ret = false;
        String[] fsScheme = hivePlugin.getFSScheme();
        if (fsScheme != null) {
            for (String scheme : fsScheme) {
                if (uri.isEmpty() || !uri.startsWith(scheme)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private void handleDfsCommand(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, String user, RangerHiveAuditHandler auditHandler) throws HiveAuthzPluginException, HiveAccessControlException {
        String dfsCommandParams = null;
        if (inputHObjs != null) {
            for (HivePrivilegeObject hiveObj : inputHObjs) {
                if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.COMMAND_PARAMS && !StringUtil.isEmpty((String)(dfsCommandParams = StringUtil.toString((List)hiveObj.getCommandParams())))) break;
            }
        }
        int serviceType = -1;
        String serviceName = null;
        if (hivePlugin != null) {
            serviceType = hivePlugin.getServiceDefId();
            serviceName = hivePlugin.getServiceName();
        }
        auditHandler.logAuditEventForDfs(user, dfsCommandParams, false, serviceType, serviceName);
        throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have privilege for [%s] command", user, hiveOpType.name()));
    }

    private boolean existsByResourceAndAccessType(Collection<RangerHiveAccessRequest> requests, RangerHiveResource resource, HiveAccessType accessType) {
        boolean ret = false;
        if (requests != null && resource != null) {
            for (RangerHiveAccessRequest request : requests) {
                if (request.getHiveAccessType() != accessType || !request.getResource().equals((Object)resource)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private String getGrantorUsername(HivePrincipal grantorPrincipal) {
        String grantor;
        String string = grantor = grantorPrincipal != null ? grantorPrincipal.getName() : null;
        if (StringUtil.isEmpty((String)grantor)) {
            UserGroupInformation ugi = this.getCurrentUserGroupInfo();
            grantor = ugi != null ? ugi.getShortUserName() : null;
        }
        return grantor;
    }

    private Set<String> getGrantorGroupNames(HivePrincipal grantorPrincipal) {
        String[] groups;
        HashSet<String> ret = null;
        String grantor = grantorPrincipal != null ? grantorPrincipal.getName() : null;
        UserGroupInformation ugi = StringUtil.isEmpty((String)grantor) ? this.getCurrentUserGroupInfo() : UserGroupInformation.createRemoteUser((String)grantor);
        String[] stringArray = groups = ugi != null ? ugi.getGroupNames() : null;
        if (groups != null && groups.length > 0) {
            ret = new HashSet<String>(Arrays.asList(groups));
        }
        return ret;
    }

    private GrantRevokeRequest createGrantRevokeData(RangerHiveResource resource, List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAccessControlException {
        HiveAuthzSessionContext sessionContext;
        if (resource == null || resource.getObjectType() != HiveObjectType.DATABASE && resource.getObjectType() != HiveObjectType.TABLE && resource.getObjectType() != HiveObjectType.VIEW && resource.getObjectType() != HiveObjectType.COLUMN) {
            throw new HiveAccessControlException("grant/revoke: unexpected object type '" + (resource == null ? null : resource.getObjectType().name()));
        }
        GrantRevokeRequest ret = new GrantRevokeRequest();
        ret.setGrantor(this.getGrantorUsername(grantorPrincipal));
        ret.setGrantorGroups(this.getGrantorGroupNames(grantorPrincipal));
        ret.setDelegateAdmin(grantOption ? Boolean.TRUE : Boolean.FALSE);
        ret.setEnableAudit(Boolean.TRUE);
        ret.setReplaceExistingPermissions(Boolean.FALSE);
        String database = StringUtils.isEmpty((String)resource.getDatabase()) ? "*" : resource.getDatabase();
        String table = StringUtils.isEmpty((String)resource.getTable()) ? "*" : resource.getTable();
        String column = StringUtils.isEmpty((String)resource.getColumn()) ? "*" : resource.getColumn();
        HashMap<String, String> mapResource = new HashMap<String, String>();
        mapResource.put("database", database);
        mapResource.put("table", table);
        mapResource.put("column", column);
        ret.setResource(mapResource);
        SessionState ss = SessionState.get();
        if (ss != null) {
            ret.setClientIPAddress(ss.getUserIpAddress());
            ret.setSessionId(ss.getSessionId());
            HiveConf hiveConf = ss.getConf();
            if (hiveConf != null) {
                ret.setRequestData(hiveConf.get(HIVE_CONF_VAR_QUERY_STRING));
            }
        }
        if ((sessionContext = this.getHiveAuthzSessionContext()) != null) {
            ret.setClientType(sessionContext.getClientType() == null ? null : sessionContext.getClientType().toString());
        }
        for (HivePrincipal principal : hivePrincipals) {
            switch (principal.getType()) {
                case USER: {
                    ret.getUsers().add(principal.getName());
                    break;
                }
                case GROUP: 
                case ROLE: {
                    ret.getGroups().add(principal.getName());
                    break;
                }
            }
        }
        for (HivePrivilege privilege : hivePrivileges) {
            String privName = privilege.getName();
            if (StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.ALL.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.ALTER.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.CREATE.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.DROP.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.INDEX.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.LOCK.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.SELECT.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.UPDATE.name())) {
                ret.getAccessTypes().add(privName.toLowerCase());
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)privName, (String)"Insert") || StringUtils.equalsIgnoreCase((String)privName, (String)"Delete")) {
                ret.getAccessTypes().add(HiveAccessType.UPDATE.name().toLowerCase());
                continue;
            }
            LOG.warn((Object)("grant/revoke: unexpected privilege type '" + privName + "'. Ignored"));
        }
        return ret;
    }

    @Override
    public List<HivePrivilegeInfo> showPrivileges(HivePrincipal principal, HivePrivilegeObject privObj) throws HiveAuthzPluginException {
        try {
            List msObjPrivs;
            LOG.debug((Object)"RangerHiveAuthorizer.showPrivileges()");
            IMetaStoreClient mClient = this.getMetastoreClientFactory().getHiveMetastoreClient();
            ArrayList<HivePrivilegeInfo> resPrivInfos = new ArrayList<HivePrivilegeInfo>();
            String principalName = null;
            PrincipalType principalType = null;
            if (principal != null) {
                principalName = principal.getName();
                principalType = AuthorizationUtils.getThriftPrincipalType((HivePrincipal.HivePrincipalType)principal.getType());
            }
            if ((msObjPrivs = mClient.list_privileges(principalName, principalType, RangerHiveAuthorizer.getThriftHiveObjectRef(privObj))) != null) {
                for (HiveObjectPrivilege msObjPriv : msObjPrivs) {
                    HiveObjectRef msObjRef = msObjPriv.getHiveObject();
                    org.apache.hadoop.hive.metastore.api.HiveObjectType objectType = msObjRef.getObjectType();
                    if (!this.isSupportedObjectType(objectType)) continue;
                    HivePrincipal resPrincipal = new HivePrincipal(msObjPriv.getPrincipalName(), AuthorizationUtils.getHivePrincipalType((PrincipalType)msObjPriv.getPrincipalType()));
                    PrivilegeGrantInfo msGrantInfo = msObjPriv.getGrantInfo();
                    HivePrivilege resPrivilege = new HivePrivilege(msGrantInfo.getPrivilege(), null);
                    HivePrivilegeObject resPrivObj = new HivePrivilegeObject(this.getPluginPrivilegeObjType(objectType), msObjRef.getDbName(), msObjRef.getObjectName(), msObjRef.getPartValues(), msObjRef.getColumnName());
                    HivePrincipal grantorPrincipal = new HivePrincipal(msGrantInfo.getGrantor(), AuthorizationUtils.getHivePrincipalType((PrincipalType)msGrantInfo.getGrantorType()));
                    HivePrivilegeInfo resPrivInfo = new HivePrivilegeInfo(resPrincipal, resPrivilege, resPrivObj, grantorPrincipal, msGrantInfo.isGrantOption(), msGrantInfo.getCreateTime());
                    resPrivInfos.add(resPrivInfo);
                }
            } else {
                throw new HiveAccessControlException("RangerHiveAuthorizer.showPrivileges():User has to specify a user name or role in the show grant. ");
            }
            return resPrivInfos;
        }
        catch (Exception e) {
            LOG.error((Object)"RangerHiveAuthorizer.showPrivileges: showPrivileges returned by showPrivileges is null");
            throw new HiveAuthzPluginException("hive showPrivileges: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean isSupportedObjectType(org.apache.hadoop.hive.metastore.api.HiveObjectType objectType) {
        switch (objectType) {
            case DATABASE: 
            case TABLE: {
                return true;
            }
        }
        return false;
    }

    private HivePrivilegeObject.HivePrivilegeObjectType getPluginPrivilegeObjType(org.apache.hadoop.hive.metastore.api.HiveObjectType objectType) {
        switch (objectType) {
            case DATABASE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.DATABASE;
            }
            case TABLE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
            }
        }
        throw new AssertionError((Object)("Unexpected object type " + objectType));
    }

    static HiveObjectRef getThriftHiveObjectRef(HivePrivilegeObject privObj) throws HiveAuthzPluginException {
        try {
            return AuthorizationUtils.getThriftHiveObjectRef((HivePrivilegeObject)privObj);
        }
        catch (HiveException e) {
            throw new HiveAuthzPluginException((Throwable)e);
        }
    }

    private RangerRequestedResources buildRequestContextWithAllAccessedResources(List<RangerHiveAccessRequest> requests) {
        RangerRequestedResources requestedResources = new RangerRequestedResources();
        for (RangerHiveAccessRequest request : requests) {
            RangerAccessRequestUtil.setRequestedResourcesInContext((Map)request.getContext(), (RangerRequestedResources)requestedResources);
            RangerHiveResource resource = (RangerHiveResource)request.getResource();
            if (resource.getObjectType() == HiveObjectType.COLUMN && StringUtils.contains((String)resource.getColumn(), (char)',')) {
                String[] columns = StringUtils.split((String)resource.getColumn(), (char)',');
                resource.setServiceDef(hivePlugin.getServiceDef());
                for (String column : columns) {
                    if (column != null) {
                        column = column.trim();
                    }
                    if (StringUtils.isBlank((String)column)) continue;
                    RangerHiveResource colResource = new RangerHiveResource(HiveObjectType.COLUMN, resource.getDatabase(), resource.getTable(), column);
                    colResource.setServiceDef(hivePlugin.getServiceDef());
                    requestedResources.addRequestedResource((RangerAccessResource)colResource);
                }
                continue;
            }
            resource.setServiceDef(hivePlugin.getServiceDef());
            requestedResources.addRequestedResource((RangerAccessResource)resource);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerHiveAuthorizer.buildRequestContextWithAllAccessedResources() - " + requestedResources));
        }
        return requestedResources;
    }

    private boolean isBlockAccessIfRowfilterColumnMaskSpecified(HiveOperationType hiveOpType, RangerHiveAccessRequest request) {
        boolean ret = false;
        RangerHiveResource resource = (RangerHiveResource)request.getResource();
        HiveObjectType objType = resource.getObjectType();
        if (objType == HiveObjectType.TABLE || objType == HiveObjectType.VIEW || objType == HiveObjectType.COLUMN) {
            boolean bl = ret = hiveOpType == HiveOperationType.EXPORT;
            if (!ret && request.getHiveAccessType() == HiveAccessType.UPDATE) {
                if (RangerHivePlugin.BlockUpdateIfRowfilterColumnMaskSpecified) {
                    ret = true;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isBlockAccessIfRowfilterColumnMaskSpecified(" + hiveOpType + ", " + (Object)((Object)request) + "): " + ret));
        }
        return ret;
    }

    private String toString(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, HiveAuthzContext context, HiveAuthzSessionContext sessionContext) {
        StringBuilder sb = new StringBuilder();
        sb.append("'checkPrivileges':{");
        sb.append("'hiveOpType':").append(hiveOpType);
        sb.append(", 'inputHObjs':[");
        this.toString(inputHObjs, sb);
        sb.append("]");
        sb.append(", 'outputHObjs':[");
        this.toString(outputHObjs, sb);
        sb.append("]");
        sb.append(", 'context':{");
        sb.append("'clientType':").append(sessionContext == null ? null : sessionContext.getClientType());
        sb.append(", 'commandString':").append(context == null ? "null" : context.getCommandString());
        sb.append(", 'ipAddress':").append(context == null ? "null" : context.getIpAddress());
        sb.append(", 'forwardedAddresses':").append(context == null ? "null" : StringUtils.join((Collection)context.getForwardedAddresses(), (String)", "));
        sb.append(", 'sessionString':").append(sessionContext == null ? "null" : sessionContext.getSessionString());
        sb.append("}");
        sb.append(", 'user':").append(this.getCurrentUserGroupInfo().getUserName());
        sb.append(", 'groups':[").append(StringUtil.toString((String[])this.getCurrentUserGroupInfo().getGroupNames())).append("]");
        sb.append("}");
        return sb.toString();
    }

    private StringBuilder toString(List<HivePrivilegeObject> privObjs, StringBuilder sb) {
        if (privObjs != null && privObjs.size() > 0) {
            this.toString(privObjs.get(0), sb);
            for (int i = 1; i < privObjs.size(); ++i) {
                sb.append(",");
                this.toString(privObjs.get(i), sb);
            }
        }
        return sb;
    }

    private StringBuilder toString(HivePrivilegeObject privObj, StringBuilder sb) {
        sb.append("'HivePrivilegeObject':{");
        sb.append("'type':").append(privObj.getType().toString());
        sb.append(", 'dbName':").append(privObj.getDbname());
        sb.append(", 'objectType':").append(privObj.getType());
        sb.append(", 'objectName':").append(privObj.getObjectName());
        sb.append(", 'columns':[").append(StringUtil.toString((List)privObj.getColumns())).append("]");
        sb.append(", 'partKeys':[").append(StringUtil.toString((List)privObj.getPartKeys())).append("]");
        sb.append(", 'commandParams':[").append(StringUtil.toString((List)privObj.getCommandParams())).append("]");
        sb.append(", 'actionType':").append(privObj.getActionType().toString());
        sb.append("}");
        return sb;
    }
}

