/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerHiveAuthorizerFactory
implements HiveAuthorizerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RangerHiveAuthorizerFactory.class);
    private static final String RANGER_PLUGIN_TYPE = "hive";
    private static final String RANGER_HIVE_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.hive.authorizer.RangerHiveAuthorizerFactory";
    private HiveAuthorizerFactory rangerHiveAuthorizerFactoryImpl;
    private RangerPluginClassLoader rangerPluginClassLoader;

    public RangerHiveAuthorizerFactory() {
        LOG.debug("==> RangerHiveAuthorizerFactory.RangerHiveAuthorizerFactory()");
        this.init();
        LOG.debug("<== RangerHiveAuthorizerFactory.RangerHiveAuthorizerFactory()");
    }

    public void init() {
        LOG.debug("==> RangerHiveAuthorizerFactory.init()");
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_HIVE_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.rangerHiveAuthorizerFactoryImpl = (HiveAuthorizerFactory)cls.newInstance();
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerHivePlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        LOG.debug("<== RangerHiveAuthorizerFactory.init()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveAuthorizer createHiveAuthorizer(HiveMetastoreClientFactory metastoreClientFactory, HiveConf conf, HiveAuthenticationProvider hiveAuthenticator, HiveAuthzSessionContext sessionContext) throws HiveAuthzPluginException {
        LOG.debug("==> RangerHiveAuthorizerFactory.createHiveAuthorizer()");
        try {
            this.activatePluginClassLoader();
            HiveAuthorizer hiveAuthorizer = this.rangerHiveAuthorizerFactoryImpl.createHiveAuthorizer(metastoreClientFactory, conf, hiveAuthenticator, sessionContext);
            return hiveAuthorizer;
        }
        finally {
            this.deactivatePluginClassLoader();
            LOG.debug("<== RangerHiveAuthorizerFactory.createHiveAuthorizer()");
        }
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }
}

