/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hdfs.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.hdfs.client.HdfsClient;
import org.apache.ranger.services.hdfs.client.HdfsConnectionMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsResourceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsResourceMgr.class);
    public static final String PATH = "path";

    private HdfsResourceMgr() {
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        Map<String, Object> ret;
        LOG.debug("<== HdfsResourceMgr.connectionTest ServiceName: {}Configs{}", (Object)serviceName, configs);
        try {
            ret = HdfsClient.connectionTest(serviceName, configs);
        }
        catch (HadoopException e) {
            LOG.error("<== HdfsResourceMgr.testConnection Error: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        LOG.debug("<== HdfsResourceMgr.connectionTest Result : {}", ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getHdfsResources(String serviceName, String serviceType, Map<String, String> configs, ResourceLookupContext context) throws Exception {
        List resultList;
        block13: {
            resultList = null;
            String userInput = context.getUserInput();
            String resource = context.getResourceName();
            Map resourceMap = context.getResources();
            ArrayList pathList = new ArrayList();
            if (resource != null && resourceMap != null && resourceMap.get(PATH) != null) {
                pathList.addAll((Collection)resourceMap.get(PATH));
            }
            if (serviceName != null && userInput != null) {
                try {
                    String wildCardToMatch;
                    LOG.debug("<== HdfsResourceMgr.getHdfsResources() UserInput: {}configs: {}context: {}", new Object[]{userInput, configs, context});
                    HdfsClient hdfsClient = new HdfsConnectionMgr().getHadoopConnection(serviceName, serviceType, configs);
                    if (hdfsClient == null) break block13;
                    int lastIndex = userInput.lastIndexOf("/");
                    if (lastIndex < 0) {
                        wildCardToMatch = userInput + "*";
                        userInput = "/";
                    } else if (lastIndex == 0 && userInput.length() == 1) {
                        wildCardToMatch = null;
                        userInput = "/";
                    } else if (lastIndex + 1 == userInput.length()) {
                        wildCardToMatch = null;
                        userInput = userInput.substring(0, lastIndex + 1);
                    } else {
                        wildCardToMatch = userInput.substring(lastIndex + 1) + "*";
                        userInput = userInput.substring(0, lastIndex + 1);
                    }
                    String finalBaseDir = userInput;
                    String finalWildCardToMatch = wildCardToMatch;
                    Callable<List> callableObj = () -> hdfsClient.listFiles(finalBaseDir, finalWildCardToMatch, pathList);
                    HdfsClient hdfsClient2 = hdfsClient;
                    synchronized (hdfsClient2) {
                        resultList = (List)TimedEventUtil.timedTask(callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                    }
                    LOG.debug("Resource dir : {} wild card to match : {}\n Matching resources : {}", new Object[]{userInput, wildCardToMatch, resultList});
                }
                catch (HadoopException e) {
                    LOG.error("Unable to get hdfs resources.", (Throwable)e);
                    throw e;
                }
            }
        }
        LOG.debug("<== HdfsResourceMgr.getHdfsResources() Result : {}", resultList);
        return resultList;
    }
}

