/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hdfs.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.hdfs.client.HdfsClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsConnectionMgr {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsConnectionMgr.class);
    private final ConcurrentMap<String, HdfsClient> hdfsConnectionCache = new ConcurrentHashMap<String, HdfsClient>();
    private final ConcurrentMap<String, Boolean> repoConnectStatusMap = new ConcurrentHashMap<String, Boolean>();

    public HdfsClient getHadoopConnection(String serviceName, String serviceType, Map<String, String> configs) throws Exception {
        HdfsClient hdfsClient = null;
        if (serviceType != null) {
            hdfsClient = (HdfsClient)((Object)this.hdfsConnectionCache.get(serviceName));
            if (hdfsClient == null) {
                Callable<HdfsClient> connectHDFS;
                if (configs == null) {
                    connectHDFS = () -> new HdfsClient(serviceName, configs);
                    try {
                        hdfsClient = (HdfsClient)((Object)TimedEventUtil.timedTask(connectHDFS, (long)10L, (TimeUnit)TimeUnit.SECONDS));
                    }
                    catch (Exception e) {
                        LOG.error("Error establishing connection for HDFS repository : {}", (Object)serviceName, (Object)e);
                        throw e;
                    }
                }
                connectHDFS = () -> new HdfsClient(serviceName, configs);
                try {
                    hdfsClient = (HdfsClient)((Object)TimedEventUtil.timedTask(connectHDFS, (long)5L, (TimeUnit)TimeUnit.SECONDS));
                }
                catch (Exception e) {
                    LOG.error("Error establishing connection for HDFS repository : {} using configuration : {}", new Object[]{serviceName, configs, e});
                    throw e;
                }
                HdfsClient oldClient = this.hdfsConnectionCache.putIfAbsent(serviceName, hdfsClient);
                if (oldClient != null) {
                    hdfsClient = oldClient;
                }
                this.repoConnectStatusMap.put(serviceName, true);
            } else {
                List<String> testConnect;
                try {
                    testConnect = hdfsClient.listFiles("/", "*", null);
                }
                catch (Exception e) {
                    LOG.error("Error establishing connection for HDFS repository : {} using configuration : {}", new Object[]{serviceName, configs, e});
                    throw e;
                }
                if (testConnect == null) {
                    this.hdfsConnectionCache.put(serviceName, hdfsClient);
                    hdfsClient = this.getHadoopConnection(serviceName, serviceType, configs);
                }
            }
        } else {
            LOG.error("Service not found with name {}", (Object)serviceName, (Object)new Throwable());
        }
        return hdfsClient;
    }
}

