/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.ranger.authorization.hadoop.RangerAccessControlEnforcer;
import org.apache.ranger.authorization.hadoop.RangerHdfsPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerHdfsAuthorizer
extends INodeAttributeProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RangerHdfsAuthorizer.class);
    public static final String KEY_FILENAME = "FILENAME";
    public static final String KEY_BASE_FILENAME = "BASE_FILENAME";
    public static final String DEFAULT_FILENAME_EXTENSION_SEPARATOR = ".";
    public static final String KEY_RESOURCE_PATH = "path";
    public static final String RANGER_FILENAME_EXTENSION_SEPARATOR_PROP = "ranger.plugin.hdfs.filename.extension.separator";
    private final Path addlConfigFile;
    private RangerHdfsPlugin rangerPlugin;

    public RangerHdfsAuthorizer() {
        this(null);
    }

    public RangerHdfsAuthorizer(Path addlConfigFile) {
        LOG.debug("==> RangerHdfsAuthorizer.RangerHdfsAuthorizer()");
        this.addlConfigFile = addlConfigFile;
        LOG.debug("<== RangerHdfsAuthorizer.RangerHdfsAuthorizer()");
    }

    public void start() {
        LOG.debug("==> RangerHdfsAuthorizer.start()");
        RangerHdfsPlugin plugin = new RangerHdfsPlugin(this.addlConfigFile);
        plugin.init();
        if (plugin.isOptimizeSubAccessAuthEnabled()) {
            LOG.info("{} is enabled", (Object)"ranger.optimize-subaccess-authorization");
        }
        LOG.info("Legacy way of authorizing sub-access requests will {}be used", (Object)(plugin.isUseLegacySubAccessAuthorization() ? "" : "not "));
        this.rangerPlugin = plugin;
        LOG.debug("<== RangerHdfsAuthorizer.start()");
    }

    public void stop() {
        LOG.debug("==> RangerHdfsAuthorizer.stop()");
        RangerHdfsPlugin plugin = this.rangerPlugin;
        this.rangerPlugin = null;
        if (plugin != null) {
            plugin.cleanup();
        }
        LOG.debug("<== RangerHdfsAuthorizer.stop()");
    }

    public INodeAttributes getAttributes(String fullPath, INodeAttributes inode) {
        return inode;
    }

    public INodeAttributes getAttributes(String[] pathElements, INodeAttributes inode) {
        return inode;
    }

    public INodeAttributeProvider.AccessControlEnforcer getExternalAccessControlEnforcer(INodeAttributeProvider.AccessControlEnforcer defaultEnforcer) {
        LOG.debug("==> RangerHdfsAuthorizer.getExternalAccessControlEnforcer()");
        RangerAccessControlEnforcer rangerAce = new RangerAccessControlEnforcer(this.rangerPlugin, defaultEnforcer);
        LOG.debug("<== RangerHdfsAuthorizer.getExternalAccessControlEnforcer()");
        return rangerAce;
    }

    public Configuration getConfig() {
        return this.rangerPlugin.getConfig();
    }
}

