/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.ranger.authorization.hadoop.OperationOptimizer;
import org.apache.ranger.authorization.hadoop.RangerHdfsAccessRequest;
import org.apache.ranger.authorization.hadoop.RangerHdfsAuditHandler;
import org.apache.ranger.authorization.hadoop.RangerHdfsPlugin;
import org.apache.ranger.authorization.hadoop.exceptions.RangerAccessControlException;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAccessControlEnforcer
implements INodeAttributeProvider.AccessControlEnforcer {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAccessControlEnforcer.class);
    private static final Logger PERF_HDFSAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"hdfsauth.request");
    private static final Map<FsAction, Set<String>> ACCESS_TO_ACTIONS;
    private final RangerHdfsPlugin plugin;
    private final INodeAttributeProvider.AccessControlEnforcer defaultEnforcer;
    private Map<String, OptimizedAuthzContext> pathToContextCache;

    public RangerAccessControlEnforcer(RangerHdfsPlugin plugin, INodeAttributeProvider.AccessControlEnforcer defaultEnforcer) {
        LOG.debug("==> RangerAccessControlEnforcer.RangerAccessControlEnforcer()");
        this.plugin = plugin;
        this.defaultEnforcer = defaultEnforcer;
        LOG.debug("<== RangerAccessControlEnforcer.RangerAccessControlEnforcer()");
    }

    public Map<String, OptimizedAuthzContext> getOrCreateCache() {
        Map<String, OptimizedAuthzContext> ret = this.pathToContextCache;
        if (ret == null) {
            this.pathToContextCache = ret = new HashMap<String, OptimizedAuthzContext>();
        }
        return ret;
    }

    public void checkPermission(String fsOwner, String superGroup, UserGroupInformation ugi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] pathByNameArr, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException {
        this.checkRangerPermission(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir, null, null);
    }

    public void checkPermissionWithContext(INodeAttributeProvider.AuthorizationContext authzContext) throws AccessControlException {
        this.checkRangerPermission(authzContext.getFsOwner(), authzContext.getSupergroup(), authzContext.getCallerUgi(), authzContext.getInodeAttrs(), authzContext.getInodes(), authzContext.getPathByNameArr(), authzContext.getSnapshotId(), authzContext.getPath(), authzContext.getAncestorIndex(), authzContext.isDoCheckOwner(), authzContext.getAncestorAccess(), authzContext.getParentAccess(), authzContext.getAccess(), authzContext.getSubAccess(), authzContext.isIgnoreEmptyDir(), authzContext.getOperationName(), authzContext.getCallerContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkRangerPermission(String fsOwner, String superGroup, UserGroupInformation ugi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] pathByNameArr, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir, String operationName, CallerContext callerContext) throws AccessControlException {
        INode inode;
        INode parent;
        INode ancestor;
        RangerPerfTracer perf;
        OptimizedAuthzContext optAuthzContext;
        AuthzContext context;
        String resourcePath;
        AuthzStatus authzStatus;
        block59: {
            INodeAttributes inodeAttribs;
            String parentPath;
            INodeAttributes parentAttribs;
            String ancestorPath;
            INodeAttributes ancestorAttribs;
            byte[][] components;
            boolean doNotGenerateAuditRecord;
            boolean useDefaultAuthorizerOnly;
            String providedPath;
            block62: {
                FsAction action;
                block63: {
                    block61: {
                        authzStatus = AuthzStatus.NOT_DETERMINED;
                        resourcePath = path;
                        context = new AuthzContext(ugi, operationName, access == null && parentAccess == null && ancestorAccess == null && subAccess == null);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("==> RangerAccessControlEnforcer.checkRangerPermission(fsOwner={}; superGroup={}, inodesCount={}, snapshotId={}, user={}, provided-path={}, ancestorIndex={}, doCheckOwner={}, ancestorAccess={}, parentAccess={}, access={}, subAccess={}, ignoreEmptyDir={}, operationName={}, callerContext={})", new Object[]{fsOwner, superGroup, inodes != null ? inodes.length : 0, snapshotId, context.user, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir, operationName, callerContext});
                            LOG.info("operationName={}, path={}, user={}, ancestorIndex={}, ancestorAccess={}, parentAccess={}, access={}, subAccess={}", new Object[]{context.operationName, path, context.user, ancestorIndex, ancestorAccess, parentAccess, access, subAccess});
                        }
                        optAuthzContext = null;
                        perf = null;
                        if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_HDFSAUTH_REQUEST_LOG)) {
                            perf = RangerPerfTracer.getPerfTracer((Logger)PERF_HDFSAUTH_REQUEST_LOG, (String)("RangerHdfsAuthorizer.checkRangerPermission(provided-path=" + path + ")"));
                        }
                        try {
                            int i;
                            ancestor = null;
                            parent = null;
                            inode = null;
                            providedPath = path;
                            useDefaultAuthorizerOnly = false;
                            doNotGenerateAuditRecord = false;
                            if (this.plugin == null || ArrayUtils.isEmpty((Object[])inodes)) break block59;
                            int sz = inodeAttrs.length;
                            LOG.trace("Size of INodeAttrs array:[{}]", (Object)sz);
                            LOG.trace("Size of INodes array:[{}]", (Object)inodes.length);
                            components = new byte[sz][];
                            for (i = 0; i < sz && inodeAttrs[i] != null; ++i) {
                                components[i] = inodeAttrs[i].getLocalNameBytes();
                            }
                            if (i != sz) {
                                LOG.trace("Input INodeAttributes array contains null at position {}", (Object)i);
                                LOG.trace("Will use only first [{}] components", (Object)i);
                            }
                            if (sz == 1 && inodes.length == 1 && inodes[0].getParent() != null) {
                                LOG.trace("Using the only inode in the array to figure out path to resource. No audit record will be generated for this authorization request");
                                doNotGenerateAuditRecord = true;
                                resourcePath = inodes[0].getFullPathName();
                                if (snapshotId != 0x7FFFFFFE) {
                                    useDefaultAuthorizerOnly = true;
                                    LOG.trace("path:[{}] is for a snapshot, id=[{}], default Authorizer will be used to authorize this request", (Object)resourcePath, (Object)snapshotId);
                                } else {
                                    LOG.trace("path:[{}] is not for a snapshot, id=[{}]. It will be used to authorize this request", (Object)resourcePath, (Object)snapshotId);
                                }
                            } else if (snapshotId != 0x7FFFFFFE) {
                                resourcePath = DFSUtil.byteArray2PathString((byte[][])pathByNameArr);
                                LOG.trace("pathByNameArr array is used to figure out path to resource, resourcePath:[{}]", (Object)resourcePath);
                            } else {
                                resourcePath = DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)i);
                                LOG.trace("INodeAttributes array is used to figure out path to resource, resourcePath:[{}]", (Object)resourcePath);
                            }
                            if (ancestorIndex >= inodes.length) {
                                ancestorIndex = inodes.length - 1;
                            }
                            while (ancestorIndex >= 0 && inodes[ancestorIndex] == null) {
                                --ancestorIndex;
                            }
                            ancestor = inodes.length > ancestorIndex && ancestorIndex >= 0 ? inodes[ancestorIndex] : null;
                            parent = inodes.length > 1 ? inodes[inodes.length - 2] : null;
                            inode = inodes[inodes.length - 1];
                            if (this.plugin.isAuthzOptimizationEnabled() && OperationOptimizer.isOptimizableOperation(operationName)) {
                                optAuthzContext = new OperationOptimizer(this, operationName, resourcePath, ancestorAccess, parentAccess, access, subAccess, components, inodeAttrs, ancestorIndex, ancestor, parent, inode).optimize();
                            }
                            if (optAuthzContext != OperationOptimizer.OPT_BYPASS_AUTHZ) break block61;
                            authzStatus = AuthzStatus.ALLOW;
                        }
                        catch (Throwable throwable) {
                            if (context.auditHandler != null) {
                                context.auditHandler.flushAudit();
                            }
                            if (optAuthzContext != null && optAuthzContext != OperationOptimizer.OPT_BYPASS_AUTHZ) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Updating OptimizedAuthzContext:[{}] with authzStatus={}]", optAuthzContext, (Object)authzStatus.name());
                                }
                                optAuthzContext.authzStatus = authzStatus;
                            }
                            RangerPerfTracer.log(perf);
                            LOG.debug("<== RangerAccessControlEnforcer.checkRangerPermission({}, {}, user={}) : {}", new Object[]{resourcePath, access, context.user, authzStatus});
                            throw throwable;
                        }
                        if (context.auditHandler != null) {
                            context.auditHandler.flushAudit();
                        }
                        if (optAuthzContext != null && optAuthzContext != OperationOptimizer.OPT_BYPASS_AUTHZ) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Updating OptimizedAuthzContext:[{}] with authzStatus={}]", (Object)optAuthzContext, (Object)authzStatus.name());
                            }
                            optAuthzContext.authzStatus = authzStatus;
                        }
                        RangerPerfTracer.log((RangerPerfTracer)perf);
                        LOG.debug("<== RangerAccessControlEnforcer.checkRangerPermission({}, {}, user={}) : {}", new Object[]{resourcePath, access, context.user, authzStatus});
                        return;
                    }
                    if (optAuthzContext == null || optAuthzContext.authzStatus == null) break block62;
                    authzStatus = optAuthzContext.authzStatus;
                    LOG.debug("OperationOptimizer.optimize() returned {}, operationName={} has been pre-computed. Returning without any access evaluation!", (Object)authzStatus, (Object)operationName);
                    if (authzStatus != AuthzStatus.ALLOW) break block63;
                    if (context.auditHandler != null) {
                        context.auditHandler.flushAudit();
                    }
                    if (optAuthzContext != null && optAuthzContext != OperationOptimizer.OPT_BYPASS_AUTHZ) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Updating OptimizedAuthzContext:[{}] with authzStatus={}]", (Object)optAuthzContext, (Object)authzStatus.name());
                        }
                        optAuthzContext.authzStatus = authzStatus;
                    }
                    RangerPerfTracer.log((RangerPerfTracer)perf);
                    LOG.debug("<== RangerAccessControlEnforcer.checkRangerPermission({}, {}, user={}) : {}", new Object[]{resourcePath, access, context.user, authzStatus});
                    return;
                }
                if (access != null) {
                    action = access;
                    throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
                }
                if (parentAccess != null) {
                    action = parentAccess;
                    throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
                }
                if (ancestorAccess != null) {
                    action = ancestorAccess;
                    throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
                }
                action = FsAction.EXECUTE;
                throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
            }
            AuthzStatus authzStatus2 = authzStatus = useDefaultAuthorizerOnly ? AuthzStatus.NOT_DETERMINED : AuthzStatus.ALLOW;
            if (optAuthzContext != null) {
                access = optAuthzContext.access;
                parentAccess = optAuthzContext.parentAccess;
                ancestorAccess = optAuthzContext.ancestorAccess;
            } else {
                LOG.debug("OperationOptimizer.optimize() returned null, operationName={} needs to be evaluated!", (Object)operationName);
            }
            context.isTraverseOnlyCheck = parentAccess == null && ancestorAccess == null && access == null && subAccess == null;
            context.auditHandler = doNotGenerateAuditRecord ? null : new RangerHdfsAuditHandler(providedPath, context.isTraverseOnlyCheck, this.plugin.getHadoopModuleName(), this.plugin.getExcludedUsers(), callerContext != null ? callerContext.toString() : null);
            if (authzStatus == AuthzStatus.ALLOW && context.isTraverseOnlyCheck) {
                authzStatus = this.traverseOnlyCheck(inode, inodeAttrs, resourcePath, components, parent, ancestor, ancestorIndex, context);
            }
            if (authzStatus == AuthzStatus.ALLOW && parentAccess != null && parentAccess.implies(FsAction.WRITE) && parent != null && inode != null && parent.getFsPermission() != null && parent.getFsPermission().getStickyBit()) {
                AuthzStatus authzStatus3 = authzStatus = StringUtils.equals((String)parent.getUserName(), (String)context.user) || StringUtils.equals((String)inode.getUserName(), (String)context.user) ? AuthzStatus.ALLOW : AuthzStatus.NOT_DETERMINED;
            }
            if (authzStatus == AuthzStatus.ALLOW && ancestorAccess != null && ancestor != null && (authzStatus = this.isAccessAllowed(ancestor, ancestorAttribs = inodeAttrs.length > ancestorIndex ? inodeAttrs[ancestorIndex] : null, ancestorPath = ancestorAttribs != null ? DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)(ancestorIndex + 1)) : null, ancestorAccess, context)) == AuthzStatus.NOT_DETERMINED) {
                authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, null, null, null, ignoreEmptyDir, ancestor, parent, inode, context);
            }
            if (authzStatus == AuthzStatus.ALLOW && parentAccess != null && parent != null && (authzStatus = this.isAccessAllowed(parent, parentAttribs = inodeAttrs.length > 1 ? inodeAttrs[inodeAttrs.length - 2] : null, parentPath = parentAttribs != null ? DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)(inodeAttrs.length - 1)) : null, parentAccess, context)) == AuthzStatus.NOT_DETERMINED) {
                authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, null, parentAccess, null, null, ignoreEmptyDir, ancestor, parent, inode, context);
            }
            if (authzStatus == AuthzStatus.ALLOW && access != null && inode != null && (authzStatus = this.isAccessAllowed(inode, inodeAttribs = inodeAttrs.length > 0 ? inodeAttrs[inodeAttrs.length - 1] : null, resourcePath, access, context)) == AuthzStatus.NOT_DETERMINED) {
                authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, null, null, access, null, ignoreEmptyDir, ancestor, parent, inode, context);
            }
            if (authzStatus == AuthzStatus.ALLOW && subAccess != null && inode != null && inode.isDirectory()) {
                Stack<SubAccessData> directories = new Stack<SubAccessData>();
                directories.push(new SubAccessData(inode.asDirectory(), resourcePath, inodes, inodeAttrs));
                while (!directories.isEmpty()) {
                    byte[][] dirComponents;
                    INode dirParent;
                    INode dirAncestor;
                    int dirAncestorIndex;
                    INode[] dirINodes;
                    INodeAttributes[] dirINodeAttrs;
                    INodeDirectory dirINode;
                    SubAccessData data = (SubAccessData)directories.pop();
                    ReadOnlyList cList = data.dir.getChildrenList(snapshotId);
                    if (cList.isEmpty() && ignoreEmptyDir) continue;
                    INodeDirectoryAttributes dirAttribs = data.dir.getSnapshotINode(snapshotId);
                    authzStatus = this.isAccessAllowed((INode)data.dir, (INodeAttributes)dirAttribs, data.resourcePath, subAccess, context);
                    if (data.dir.equals((Object)inode)) {
                        dirINode = inode.asDirectory();
                        dirINodeAttrs = inodeAttrs;
                        dirINodes = inodes;
                        dirAncestorIndex = ancestorIndex;
                        dirAncestor = ancestor;
                        dirParent = parent;
                        dirComponents = pathByNameArr;
                    } else {
                        int idx;
                        dirINode = data.dir;
                        INodeAttributes[] curINodeAttributes = data.iNodeAttributes;
                        INode[] curINodes = data.inodes;
                        dirINodes = new INode[curINodes.length + 1];
                        for (idx = 0; idx < curINodes.length; ++idx) {
                            dirINodes[idx] = curINodes[idx];
                        }
                        dirINodes[idx] = dirINode;
                        dirINodeAttrs = new INodeAttributes[curINodeAttributes.length + 1];
                        for (idx = 0; idx < curINodeAttributes.length; ++idx) {
                            dirINodeAttrs[idx] = curINodeAttributes[idx];
                        }
                        dirINodeAttrs[idx] = dirAttribs;
                        for (dirAncestorIndex = dirINodes.length - 1; dirAncestorIndex >= 0 && dirINodes[dirAncestorIndex] == null; --dirAncestorIndex) {
                        }
                        dirAncestor = dirINodes.length > dirAncestorIndex && dirAncestorIndex >= 0 ? dirINodes[dirAncestorIndex] : null;
                        dirParent = dirINodes.length > 1 ? dirINodes[dirINodes.length - 2] : null;
                        dirComponents = dirINode.getPathComponents();
                    }
                    if (authzStatus == AuthzStatus.NOT_DETERMINED && !this.plugin.isUseLegacySubAccessAuthorization()) {
                        if (LOG.isDebugEnabled()) {
                            if (data.dir.equals((Object)inode)) {
                                LOG.debug("Top level directory being processed for default authorizer call, [{}]", (Object)data.resourcePath);
                            } else {
                                LOG.debug("Sub directory being processed for default authorizer call, [{}]", (Object)data.resourcePath);
                            }
                            LOG.debug("Calling default authorizer for hierarchy/subaccess with the following parameters");
                            LOG.debug("fsOwner={}; superGroup={}, inodesCount={}, snapshotId={}, user={}, provided-path={}, ancestorIndex={}, doCheckOwner={}, ancestorAccess=null, parentAccess=null, access=null, subAccess=null, ignoreEmptyDir={}, operationName={}, callerContext=null", new Object[]{fsOwner, superGroup, dirINodes != null ? dirINodes.length : 0, snapshotId, ugi != null ? ugi.getShortUserName() : null, data.resourcePath, dirAncestorIndex, doCheckOwner, ignoreEmptyDir, operationName});
                        }
                        authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, dirINodeAttrs, dirINodes, dirComponents, snapshotId, data.resourcePath, dirAncestorIndex, doCheckOwner, null, null, null, null, ignoreEmptyDir, dirAncestor, dirParent, (INode)dirINode, context);
                        LOG.debug("Default authorizer call returned : [{}]", (Object)authzStatus);
                    }
                    if (authzStatus != AuthzStatus.ALLOW) break;
                    AuthzStatus subDirAuthStatus = AuthzStatus.NOT_DETERMINED;
                    boolean optimizeSubAccessAuthEnabled = this.plugin.isOptimizeSubAccessAuthEnabled();
                    if (optimizeSubAccessAuthEnabled) {
                        subDirAuthStatus = this.isAccessAllowedForHierarchy((INode)data.dir, (INodeAttributes)dirAttribs, data.resourcePath, subAccess, context);
                    }
                    if (subDirAuthStatus == AuthzStatus.ALLOW) continue;
                    for (INode child : cList) {
                        if (!child.isDirectory()) continue;
                        if (data.resourcePath.endsWith("/")) {
                            directories.push(new SubAccessData(child.asDirectory(), data.resourcePath + child.getLocalName(), dirINodes, dirINodeAttrs));
                            continue;
                        }
                        directories.push(new SubAccessData(child.asDirectory(), data.resourcePath + '/' + child.getLocalName(), dirINodes, dirINodeAttrs));
                    }
                }
                if (authzStatus == AuthzStatus.NOT_DETERMINED) {
                    authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, null, null, null, subAccess, ignoreEmptyDir, ancestor, parent, inode, context);
                }
            }
            if (authzStatus == AuthzStatus.ALLOW && doCheckOwner) {
                inodeAttribs = inodeAttrs.length > 0 ? inodeAttrs[inodeAttrs.length - 1] : null;
                String owner = inodeAttribs != null ? inodeAttribs.getUserName() : null;
                AuthzStatus authzStatus4 = authzStatus = StringUtils.equals((String)context.user, (String)owner) ? AuthzStatus.ALLOW : AuthzStatus.NOT_DETERMINED;
            }
        }
        if (authzStatus == AuthzStatus.NOT_DETERMINED) {
            authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir, ancestor, parent, inode, context);
        }
        if (authzStatus != AuthzStatus.ALLOW) {
            FsAction action = access;
            if (action != null) throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
            if (parentAccess != null) {
                action = parentAccess;
                throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
            }
            if (ancestorAccess != null) {
                action = ancestorAccess;
                throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
            }
            action = FsAction.EXECUTE;
            throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
        }
        if (context.auditHandler != null) {
            context.auditHandler.flushAudit();
        }
        if (optAuthzContext != null && optAuthzContext != OperationOptimizer.OPT_BYPASS_AUTHZ) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating OptimizedAuthzContext:[{}] with authzStatus={}]", optAuthzContext, (Object)authzStatus.name());
            }
            optAuthzContext.authzStatus = authzStatus;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        LOG.debug("<== RangerAccessControlEnforcer.checkRangerPermission({}, {}, user={}) : {}", new Object[]{resourcePath, access, context.user, authzStatus});
    }

    private AuthzStatus traverseOnlyCheck(INode inode, INodeAttributes[] inodeAttrs, String path, byte[][] components, INode parent, INode ancestor, int ancestorIndex, AuthzContext context) {
        AuthzStatus ret;
        LOG.debug("==> RangerAccessControlEnforcer.traverseOnlyCheck(path={}, user={}, groups={}, operationName={})", new Object[]{path, context.user, context.userGroups, context.operationName});
        INode nodeToCheck = inode;
        INodeAttributes nodeAttribs = inodeAttrs.length > 0 ? inodeAttrs[inodeAttrs.length - 1] : null;
        boolean skipAuditOnAllow = false;
        String resourcePath = path;
        if (nodeToCheck == null || nodeToCheck.isFile()) {
            skipAuditOnAllow = true;
            if (parent != null) {
                nodeToCheck = parent;
                nodeAttribs = inodeAttrs.length > 1 ? inodeAttrs[inodeAttrs.length - 2] : null;
                resourcePath = inodeAttrs.length > 0 ? DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)(inodeAttrs.length - 1)) : "/";
            } else if (ancestor != null) {
                nodeToCheck = ancestor;
                nodeAttribs = inodeAttrs.length > ancestorIndex ? inodeAttrs[ancestorIndex] : null;
                String string = resourcePath = nodeAttribs != null ? DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)(ancestorIndex + 1)) : "/";
            }
        }
        if (nodeToCheck != null) {
            if (resourcePath.length() > 1 && resourcePath.endsWith("/")) {
                resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
            }
            ret = this.isAccessAllowedForTraversal(nodeToCheck, nodeAttribs, resourcePath, skipAuditOnAllow, context, context.operationName);
        } else {
            ret = AuthzStatus.ALLOW;
        }
        LOG.debug("<== RangerAccessControlEnforcer.traverseOnlyCheck(path={}, resourcePath={}, user={}, groups={}, operationName={}) : {}", new Object[]{path, resourcePath, context.user, context.userGroups, context.operationName, ret});
        return ret;
    }

    private AuthzStatus isAccessAllowedForTraversal(INode inode, INodeAttributes inodeAttribs, String path, boolean skipAuditOnAllow, AuthzContext context, String operation) {
        String pathOwner = inodeAttribs != null ? inodeAttribs.getUserName() : null;
        FsAction access = FsAction.EXECUTE;
        if (pathOwner == null) {
            pathOwner = inode.getUserName();
        }
        if ("".equals(path)) {
            path = "/";
        }
        LOG.debug("==> RangerAccessControlEnforcer.isAccessAllowedForTraversal({}, {}, {}, {}, {})", new Object[]{path, access, context.user, skipAuditOnAllow, context.operationName});
        RangerHdfsAccessRequest request = new RangerHdfsAccessRequest(inode, path, pathOwner, access, "execute", operation, context.user, context.userGroups);
        RangerAccessResult result = this.plugin.isAccessAllowed((RangerAccessRequest)request, null);
        context.saveResult(result);
        AuthzStatus ret = result != null && result.getIsAccessDetermined() && !result.getIsAllowed() ? AuthzStatus.DENY : AuthzStatus.ALLOW;
        if (ret == AuthzStatus.ALLOW) {
            LOG.debug("This request is for the first time allowed by Ranger policies. request:[{}]", (Object)request);
        }
        if ((ret == AuthzStatus.DENY || !skipAuditOnAllow && result != null && result.getIsAccessDetermined()) && context.auditHandler != null) {
            context.auditHandler.processResult(result);
        }
        LOG.debug("<== RangerAccessControlEnforcer.isAccessAllowedForTraversal({}, {}, {}, {}, {}): {}", new Object[]{path, access, context.user, skipAuditOnAllow, context.operationName, ret});
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthzStatus checkDefaultEnforcer(String fsOwner, String superGroup, UserGroupInformation ugi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] pathByNameArr, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir, INode ancestor, INode parent, INode inode, AuthzContext context) throws AccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAccessControlEnforcer.checkDefaultEnforcer(fsOwner={}; superGroup={}, inodesCount={}, snapshotId={}, path={}, ancestorIndex={}, doCheckOwner={}, ancestorAccess={}, parentAccess={}, access={}, subAccess={}, ignoreEmptyDir={}, isTraverseOnlyCheck={},ancestor={}, parent={}, inode={})", new Object[]{fsOwner, superGroup, inodes != null ? inodes.length : 0, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir, context.isTraverseOnlyCheck, ancestor == null ? null : ancestor.getFullPathName(), parent == null ? null : parent.getFullPathName(), inode == null ? null : inode.getFullPathName()});
        }
        AuthzStatus authzStatus = AuthzStatus.NOT_DETERMINED;
        if (this.plugin.isHadoopAuthEnabled() && this.defaultEnforcer != null) {
            RangerPerfTracer hadoopAuthPerf = null;
            if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_HDFSAUTH_REQUEST_LOG)) {
                hadoopAuthPerf = RangerPerfTracer.getPerfTracer((Logger)PERF_HDFSAUTH_REQUEST_LOG, (String)("RangerAccessControlEnforcer.checkDefaultEnforcer(path=" + path + ")"));
            }
            try {
                this.defaultEnforcer.checkPermission(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir);
                authzStatus = AuthzStatus.ALLOW;
            }
            catch (Throwable throwable) {
                if (context.auditHandler != null) {
                    INode nodeChecked = inode;
                    FsAction action = access;
                    if (context.isTraverseOnlyCheck) {
                        if (nodeChecked == null || nodeChecked.isFile()) {
                            if (parent != null) {
                                nodeChecked = parent;
                            } else if (ancestor != null) {
                                nodeChecked = ancestor;
                            }
                        }
                        action = FsAction.EXECUTE;
                    } else if (action == null || action == FsAction.NONE) {
                        if (parentAccess != null && parentAccess != FsAction.NONE) {
                            nodeChecked = parent;
                            action = parentAccess;
                        } else if (ancestorAccess != null && ancestorAccess != FsAction.NONE) {
                            nodeChecked = ancestor;
                            action = ancestorAccess;
                        } else if (subAccess != null && subAccess != FsAction.NONE) {
                            action = subAccess;
                        }
                    }
                    String pathChecked = nodeChecked != null ? nodeChecked.getFullPathName() : path;
                    boolean isAllowed = authzStatus == AuthzStatus.ALLOW;
                    RangerAccessResult lastResult = context.getLastResult();
                    if (lastResult != null) {
                        lastResult.setIsAllowed(isAllowed);
                        lastResult.setIsAccessDetermined(true);
                        this.plugin.evalAuditPolicies(lastResult);
                        context.auditHandler.processResult(lastResult);
                    }
                    context.auditHandler.logHadoopEvent(pathChecked, action, isAllowed);
                }
                RangerPerfTracer.log(hadoopAuthPerf);
                throw throwable;
            }
            if (context.auditHandler != null) {
                INode nodeChecked = inode;
                FsAction action = access;
                if (context.isTraverseOnlyCheck) {
                    if (nodeChecked == null || nodeChecked.isFile()) {
                        if (parent != null) {
                            nodeChecked = parent;
                        } else if (ancestor != null) {
                            nodeChecked = ancestor;
                        }
                    }
                    action = FsAction.EXECUTE;
                } else if (action == null || action == FsAction.NONE) {
                    if (parentAccess != null && parentAccess != FsAction.NONE) {
                        nodeChecked = parent;
                        action = parentAccess;
                    } else if (ancestorAccess != null && ancestorAccess != FsAction.NONE) {
                        nodeChecked = ancestor;
                        action = ancestorAccess;
                    } else if (subAccess != null && subAccess != FsAction.NONE) {
                        action = subAccess;
                    }
                }
                String pathChecked = nodeChecked != null ? nodeChecked.getFullPathName() : path;
                boolean isAllowed = authzStatus == AuthzStatus.ALLOW;
                RangerAccessResult lastResult = context.getLastResult();
                if (lastResult != null) {
                    lastResult.setIsAllowed(isAllowed);
                    lastResult.setIsAccessDetermined(true);
                    this.plugin.evalAuditPolicies(lastResult);
                    context.auditHandler.processResult(lastResult);
                }
                context.auditHandler.logHadoopEvent(pathChecked, action, isAllowed);
            }
            RangerPerfTracer.log((RangerPerfTracer)hadoopAuthPerf);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAccessControlEnforcer.checkDefaultEnforcer(fsOwner={}; superGroup={}, inodesCount={}, snapshotId={}, path={}, ancestorIndex={}, doCheckOwner={}, ancestorAccess={}, parentAccess={}, access={}, subAccess={}, ignoreEmptyDir={}, isTraverseOnlyCheck={},ancestor={}, parent={}, inode={}) : {}", new Object[]{fsOwner, superGroup, inodes != null ? inodes.length : 0, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir, context.isTraverseOnlyCheck, ancestor == null ? null : ancestor.getFullPathName(), parent == null ? null : parent.getFullPathName(), inode == null ? null : inode.getFullPathName(), authzStatus});
        }
        return authzStatus;
    }

    private AuthzStatus isAccessAllowed(INode inode, INodeAttributes inodeAttribs, String path, FsAction access, AuthzContext context) {
        String pathOwner;
        AuthzStatus ret = null;
        String string = pathOwner = inodeAttribs != null ? inodeAttribs.getUserName() : null;
        if (pathOwner == null && inode != null) {
            pathOwner = inode.getUserName();
        }
        if ("".equals(path)) {
            path = "/";
        }
        LOG.debug("==> RangerAccessControlEnforcer.isAccessAllowed({}, {}, {})", new Object[]{path, access, context.user});
        Set<String> accessTypes = ACCESS_TO_ACTIONS.get(access);
        if (accessTypes == null) {
            LOG.warn("RangerAccessControlEnforcer.isAccessAllowed({}, {}, {}): no Ranger accessType found for {}", new Object[]{path, access, context.user, access});
            accessTypes = ACCESS_TO_ACTIONS.get(FsAction.NONE);
        }
        if (!accessTypes.isEmpty()) {
            RangerHdfsAccessRequest request = new RangerHdfsAccessRequest(inode, path, pathOwner, access, accessTypes.iterator().next(), context.operationName, context.user, context.userGroups);
            if (accessTypes.size() > 1) {
                Set allAccessTypeGroups = accessTypes.stream().map(Collections::singleton).collect(Collectors.toSet());
                RangerAccessRequestUtil.setAllRequestedAccessTypeGroups((RangerAccessRequest)request, allAccessTypeGroups);
                RangerAccessRequestUtil.setAllRequestedAccessTypes((Map)request.getContext(), accessTypes);
                if (accessTypes.contains("execute")) {
                    RangerAccessRequestUtil.setIgnoreIfNotDeniedAccessTypes((Map)request.getContext(), ACCESS_TO_ACTIONS.get(FsAction.EXECUTE));
                }
            }
            RangerAccessResult result = this.plugin.isAccessAllowed((RangerAccessRequest)request, (RangerAccessResultProcessor)context.auditHandler);
            context.saveResult(result);
            ret = result == null || !result.getIsAccessDetermined() ? AuthzStatus.NOT_DETERMINED : (!result.getIsAllowed() ? AuthzStatus.DENY : AuthzStatus.ALLOW);
            if (ret == AuthzStatus.ALLOW) {
                LOG.debug("This request is for the first time allowed by Ranger policies. request:[{}]", (Object)request);
            }
        }
        if (ret == null) {
            ret = AuthzStatus.NOT_DETERMINED;
        }
        LOG.debug("<== RangerAccessControlEnforcer.isAccessAllowed({}, {}, {}): {}", new Object[]{path, access, context.user, ret});
        return ret;
    }

    private AuthzStatus isAccessAllowedForHierarchy(INode inode, INodeAttributes inodeAttribs, String path, FsAction access, AuthzContext context) {
        String pathOwner;
        AuthzStatus ret = null;
        String string = pathOwner = inodeAttribs != null ? inodeAttribs.getUserName() : null;
        if (pathOwner == null && inode != null) {
            pathOwner = inode.getUserName();
        }
        if ("".equals(path)) {
            path = "/";
        }
        LOG.debug("==> RangerAccessControlEnforcer.isAccessAllowedForHierarchy({}, {}, {})", new Object[]{path, access, context.user});
        if (path != null) {
            String subDirPath;
            Set<String> accessTypes = ACCESS_TO_ACTIONS.get(access);
            if (accessTypes == null) {
                LOG.warn("RangerAccessControlEnforcer.isAccessAllowedForHierarchy({}, {}, {}): no Ranger accessType found for {}", new Object[]{path, access, context.user, access});
                accessTypes = ACCESS_TO_ACTIONS.get(FsAction.NONE);
            }
            if ((subDirPath = path).charAt(subDirPath.length() - 1) != '/') {
                subDirPath = subDirPath + '/';
            }
            subDirPath = subDirPath + this.plugin.getRandomizedWildcardPathName();
            if (!accessTypes.isEmpty()) {
                RangerHdfsAccessRequest request = new RangerHdfsAccessRequest(null, subDirPath, pathOwner, access, accessTypes.iterator().next(), context.operationName, context.user, context.userGroups);
                if (accessTypes.size() > 1) {
                    Set allAccessTypeGroups = accessTypes.stream().map(Collections::singleton).collect(Collectors.toSet());
                    RangerAccessRequestUtil.setAllRequestedAccessTypeGroups((RangerAccessRequest)request, allAccessTypeGroups);
                    RangerAccessRequestUtil.setAllRequestedAccessTypes((Map)request.getContext(), accessTypes);
                    if (accessTypes.contains("execute")) {
                        RangerAccessRequestUtil.setIgnoreIfNotDeniedAccessTypes((Map)request.getContext(), ACCESS_TO_ACTIONS.get(FsAction.EXECUTE));
                    }
                }
                RangerAccessResult result = this.plugin.isAccessAllowed((RangerAccessRequest)request, null);
                context.saveResult(result);
                ret = result == null || !result.getIsAccessDetermined() ? AuthzStatus.NOT_DETERMINED : (!result.getIsAllowed() ? AuthzStatus.DENY : AuthzStatus.ALLOW);
            }
        }
        if (ret == null) {
            ret = AuthzStatus.NOT_DETERMINED;
        }
        LOG.debug("<== RangerAccessControlEnforcer.isAccessAllowedForHierarchy({}, {}, {}): {}", new Object[]{path, access, context.user, ret});
        return ret;
    }

    static {
        HashMap<FsAction, Set> accessToActions = new HashMap<FsAction, Set>();
        accessToActions.put(FsAction.NONE, new TreeSet());
        accessToActions.put(FsAction.ALL, Stream.of("read", "write", "execute").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        accessToActions.put(FsAction.READ, Stream.of("read").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        accessToActions.put(FsAction.READ_WRITE, Stream.of("read", "write").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        accessToActions.put(FsAction.READ_EXECUTE, Stream.of("read", "execute").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        accessToActions.put(FsAction.WRITE, Stream.of("write").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        accessToActions.put(FsAction.WRITE_EXECUTE, Stream.of("write", "execute").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        accessToActions.put(FsAction.EXECUTE, Stream.of("execute").collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER))));
        ACCESS_TO_ACTIONS = Collections.unmodifiableMap(accessToActions);
    }

    private static class SubAccessData {
        final INodeDirectory dir;
        final String resourcePath;
        final INode[] inodes;
        final INodeAttributes[] iNodeAttributes;

        SubAccessData(INodeDirectory dir, String resourcePath, INode[] inodes, INodeAttributes[] iNodeAttributes) {
            this.dir = dir;
            this.resourcePath = resourcePath;
            this.iNodeAttributes = iNodeAttributes;
            this.inodes = inodes;
        }
    }

    public static class AuthzContext {
        public final String user;
        public final Set<String> userGroups;
        public final String operationName;
        private boolean isTraverseOnlyCheck;
        private RangerHdfsAuditHandler auditHandler;
        private RangerAccessResult lastResult;

        public AuthzContext(UserGroupInformation ugi, String operationName, boolean isTraverseOnlyCheck) {
            this.user = ugi != null ? ugi.getShortUserName() : null;
            this.userGroups = ugi != null ? Sets.newHashSet((Object[])ugi.getGroupNames()) : null;
            this.operationName = operationName;
            this.isTraverseOnlyCheck = isTraverseOnlyCheck;
        }

        public void saveResult(RangerAccessResult result) {
            if (result != null) {
                this.lastResult = result;
            }
        }

        public RangerAccessResult getLastResult() {
            return this.lastResult;
        }
    }

    public static class OptimizedAuthzContext {
        private final String path;
        private final FsAction ancestorAccess;
        private final FsAction parentAccess;
        private final FsAction access;
        private AuthzStatus authzStatus;

        OptimizedAuthzContext(String path, FsAction ancestorAccess, FsAction parentAccess, FsAction access, AuthzStatus authzStatus) {
            this.path = path;
            this.ancestorAccess = ancestorAccess;
            this.parentAccess = parentAccess;
            this.access = access;
            this.authzStatus = authzStatus;
        }

        public String toString() {
            return "path=" + this.path + ", authzStatus=" + (Object)((Object)this.authzStatus);
        }
    }

    public static enum AuthzStatus {
        ALLOW,
        DENY,
        NOT_DETERMINED;

    }
}

