/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.ranger.authorization.hadoop.RangerAccessControlEnforcer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OperationOptimizer {
    private static final Logger LOG = LoggerFactory.getLogger(OperationOptimizer.class);
    public static final String OPERATION_NAME_CREATE = "create";
    public static final String OPERATION_NAME_DELETE = "delete";
    public static final String OPERATION_NAME_RENAME = "rename";
    public static final String OPERATION_NAME_LISTSTATUS = "listStatus";
    public static final String OPERATION_NAME_MKDIRS = "mkdirs";
    public static final String OPERATION_NAME_GETEZFORPATH = "getEZForPath";
    public static final RangerAccessControlEnforcer.OptimizedAuthzContext OPT_BYPASS_AUTHZ = new RangerAccessControlEnforcer.OptimizedAuthzContext("", FsAction.NONE, FsAction.NONE, FsAction.NONE, RangerAccessControlEnforcer.AuthzStatus.ALLOW);
    private static final Set<String> OPTIMIZED_OPERATIONS;
    private final RangerAccessControlEnforcer enforcer;
    private final String operationName;
    private final byte[][] components;
    private final INodeAttributes[] inodeAttrs;
    private final int ancestorIndex;
    private final INode ancestor;
    private final INode parent;
    private final INode inode;
    private final FsAction subAccess;
    private String resourcePath;
    private FsAction ancestorAccess;
    private FsAction parentAccess;
    private FsAction access;

    OperationOptimizer(RangerAccessControlEnforcer enforcer, String operationName, String resourcePath, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, byte[][] components, INodeAttributes[] inodeAttrs, int ancestorIndex, INode ancestor, INode parent, INode inode) {
        this.enforcer = enforcer;
        this.operationName = operationName;
        this.resourcePath = resourcePath;
        this.ancestorAccess = ancestorAccess;
        this.parentAccess = parentAccess;
        this.access = access;
        this.subAccess = subAccess;
        this.components = components;
        this.inodeAttrs = inodeAttrs;
        this.ancestorIndex = ancestorIndex;
        this.ancestor = ancestor;
        this.parent = parent;
        this.inode = inode;
    }

    public static boolean isOptimizableOperation(String operationName) {
        return OPTIMIZED_OPERATIONS.contains(operationName);
    }

    RangerAccessControlEnforcer.OptimizedAuthzContext optimize() {
        switch (this.operationName) {
            case "create": {
                return this.optimizeCreateOp();
            }
            case "delete": {
                return this.optimizeDeleteOp();
            }
            case "rename": {
                return this.optimizeRenameOp();
            }
            case "mkdirs": {
                return this.optimizeMkdirsOp();
            }
            case "listStatus": {
                return this.optimizeListStatusOp();
            }
            case "getEZForPath": {
                return this.optimizeGetEZForPathOp();
            }
        }
        return null;
    }

    private RangerAccessControlEnforcer.OptimizedAuthzContext optimizeCreateOp() {
        INode nodeToAuthorize = this.getINodeToAuthorize();
        if (nodeToAuthorize == null) {
            return OPT_BYPASS_AUTHZ;
        }
        if (!nodeToAuthorize.isDirectory() && this.access == null) {
            LOG.debug("nodeToCheck is not a directory and access is null for a create operation! Optimization skipped");
            return null;
        }
        return this.getOrCreateOptimizedAuthzContext();
    }

    private RangerAccessControlEnforcer.OptimizedAuthzContext optimizeDeleteOp() {
        int numOfRequestedAccesses = 0;
        if (this.ancestorAccess != null) {
            ++numOfRequestedAccesses;
        }
        if (this.parentAccess != null) {
            ++numOfRequestedAccesses;
        }
        if (this.access != null) {
            ++numOfRequestedAccesses;
        }
        if (this.subAccess != null) {
            ++numOfRequestedAccesses;
        }
        if (numOfRequestedAccesses == 0) {
            return OPT_BYPASS_AUTHZ;
        }
        this.parentAccess = FsAction.WRITE_EXECUTE;
        return this.getOrCreateOptimizedAuthzContext();
    }

    private RangerAccessControlEnforcer.OptimizedAuthzContext optimizeRenameOp() {
        INode nodeToAuthorize = this.getINodeToAuthorize();
        if (nodeToAuthorize == null) {
            return OPT_BYPASS_AUTHZ;
        }
        if (!nodeToAuthorize.isDirectory()) {
            LOG.debug("nodeToCheck is not a directory for a rename operation! Optimization skipped");
            return null;
        }
        return this.getOrCreateOptimizedAuthzContext();
    }

    private RangerAccessControlEnforcer.OptimizedAuthzContext optimizeMkdirsOp() {
        INode nodeToAuthorize = this.getINodeToAuthorize();
        if (nodeToAuthorize == null) {
            return OPT_BYPASS_AUTHZ;
        }
        if (!nodeToAuthorize.isDirectory()) {
            LOG.debug("nodeToCheck is not a directory for a mkdirs operation! Optimization skipped");
            return null;
        }
        return this.getOrCreateOptimizedAuthzContext();
    }

    private RangerAccessControlEnforcer.OptimizedAuthzContext optimizeListStatusOp() {
        if (this.inode == null || this.inode.isFile()) {
            LOG.debug("inode is null or is a file for a listStatus/getEZForPath operation! Optimization skipped");
            return null;
        }
        if (this.resourcePath.length() > 1 && this.resourcePath.endsWith("/")) {
            this.resourcePath = this.resourcePath.substring(0, this.resourcePath.length() - 1);
        }
        this.access = FsAction.READ_EXECUTE;
        return this.getOrCreateOptimizedAuthzContext();
    }

    private RangerAccessControlEnforcer.OptimizedAuthzContext optimizeGetEZForPathOp() {
        if (this.inode == null || this.inode.isFile()) {
            LOG.debug("inode is null or is a file for a listStatus/getEZForPath operation! Optimization skipped");
            return null;
        }
        this.access = FsAction.READ_EXECUTE;
        return this.getOrCreateOptimizedAuthzContext();
    }

    private INode getINodeToAuthorize() {
        INode ret = null;
        INode nodeToAuthorize = this.inode;
        if (nodeToAuthorize == null || nodeToAuthorize.isFile()) {
            if (StringUtils.equals((String)this.operationName, (String)OPERATION_NAME_CREATE) && this.inode != null && this.access != null) {
                LOG.debug("Create operation with non-null access is being authorized. authorize for write access for the file!!");
            } else {
                if (this.parent != null) {
                    nodeToAuthorize = this.parent;
                    this.resourcePath = this.inodeAttrs.length > 0 ? DFSUtil.byteArray2PathString((byte[][])this.components, (int)0, (int)(this.inodeAttrs.length - 1)) : "/";
                    this.parentAccess = FsAction.WRITE_EXECUTE;
                } else if (this.ancestor != null) {
                    INodeAttributes nodeAttribs = this.inodeAttrs.length > this.ancestorIndex ? this.inodeAttrs[this.ancestorIndex] : null;
                    nodeToAuthorize = this.ancestor;
                    this.resourcePath = nodeAttribs != null ? DFSUtil.byteArray2PathString((byte[][])this.components, (int)0, (int)(this.ancestorIndex + 1)) : "/";
                    this.ancestorAccess = FsAction.WRITE_EXECUTE;
                }
                if (this.resourcePath.length() > 1 && this.resourcePath.endsWith("/")) {
                    this.resourcePath = this.resourcePath.substring(0, this.resourcePath.length() - 1);
                }
            }
            ret = nodeToAuthorize;
        } else {
            LOG.debug("inode is not null and it is not a file for a create/rename/mkdirs operation! Optimization skipped");
        }
        return ret;
    }

    private RangerAccessControlEnforcer.OptimizedAuthzContext getOrCreateOptimizedAuthzContext() {
        Map<String, RangerAccessControlEnforcer.OptimizedAuthzContext> pathToContextCache = this.enforcer.getOrCreateCache();
        RangerAccessControlEnforcer.OptimizedAuthzContext opContext = pathToContextCache.get(this.resourcePath);
        if (opContext == null) {
            opContext = new RangerAccessControlEnforcer.OptimizedAuthzContext(this.resourcePath, this.ancestorAccess, this.parentAccess, this.access, null);
            pathToContextCache.put(this.resourcePath, opContext);
            LOG.debug("Added OptimizedAuthzContext:[{}] to cache", (Object)opContext);
        }
        return opContext;
    }

    static {
        HashSet<String> optimizedOperations = new HashSet<String>();
        optimizedOperations.add(OPERATION_NAME_CREATE);
        optimizedOperations.add(OPERATION_NAME_DELETE);
        optimizedOperations.add(OPERATION_NAME_RENAME);
        optimizedOperations.add(OPERATION_NAME_LISTSTATUS);
        optimizedOperations.add(OPERATION_NAME_MKDIRS);
        optimizedOperations.add(OPERATION_NAME_GETEZFORPATH);
        OPTIMIZED_OPERATIONS = Collections.unmodifiableSet(optimizedOperations);
    }
}

