/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hbase.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.hbase.client.HBaseClient;
import org.apache.ranger.services.hbase.client.HBaseConnectionMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseResourceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseResourceMgr.class);
    private static final String TABLE = "table";
    private static final String COLUMNFAMILY = "column-family";

    private HBaseResourceMgr() {
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        LOG.debug("==> HBaseResourceMgr.connectionTest() ServiceName: {} Configs{}", (Object)serviceName, configs);
        Map<String, Object> ret = null;
        try {
            ret = HBaseClient.connectionTest(serviceName, configs);
        }
        catch (HadoopException e) {
            LOG.error("<== HBaseResourceMgr.connectionTest() Error: " + (Object)((Object)e));
            throw e;
        }
        LOG.debug("<== HBaseResourceMgr.connectionTest() Result: {}", ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getHBaseResource(String serviceName, String serviceType, Map<String, String> configs, ResourceLookupContext context) throws Exception {
        List resultList;
        block21: {
            String userInput = context.getUserInput();
            String resource = context.getResourceName();
            Map resourceMap = context.getResources();
            resultList = null;
            String tableName = null;
            String columnFamilies = null;
            List tableList = null;
            List columnFamilyList = null;
            LOG.debug("==> HBaseResourceMgr.getHBaseResource UserInput: \"{}\" resource : {} resourceMap: {}", new Object[]{userInput, resource, resourceMap});
            if (userInput != null && resource != null) {
                if (resourceMap != null && !resourceMap.isEmpty()) {
                    tableList = (List)resourceMap.get(TABLE);
                    columnFamilyList = (List)resourceMap.get(COLUMNFAMILY);
                }
                switch (resource.trim().toLowerCase()) {
                    case "table": {
                        tableName = userInput;
                        break;
                    }
                    case "column-family": {
                        columnFamilies = userInput;
                        break;
                    }
                }
            }
            if (serviceName != null && userInput != null) {
                final List finaltableList = tableList;
                final List finalcolumnFamilyList = columnFamilyList;
                try {
                    final HBaseClient hBaseClient = new HBaseConnectionMgr().getHBaseConnection(serviceName, serviceType, configs);
                    Callable<List<String>> callableObj = null;
                    if (hBaseClient == null) break block21;
                    if (tableName != null && !tableName.isEmpty()) {
                        if (!tableName.endsWith("*")) {
                            tableName = tableName + "*";
                        }
                        final String finalTableName = tableName = tableName.replaceAll("\\*", ".\\*");
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() {
                                return hBaseClient.getTableList(finalTableName, finaltableList);
                            }
                        };
                    } else if (columnFamilies != null && !columnFamilies.isEmpty()) {
                        if (!columnFamilies.endsWith("*")) {
                            columnFamilies = columnFamilies + "*";
                        }
                        final String finalColFamilies = columnFamilies = columnFamilies.replaceAll("\\*", ".\\*");
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() {
                                return hBaseClient.getColumnFamilyList(finalColFamilies, finaltableList, finalcolumnFamilyList);
                            }
                        };
                    }
                    if (callableObj == null) break block21;
                    HBaseClient hBaseClient2 = hBaseClient;
                    synchronized (hBaseClient2) {
                        resultList = (List)TimedEventUtil.timedTask(callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                    }
                }
                catch (Exception e) {
                    LOG.error("Unable to get hbase resources.", (Throwable)e);
                    throw e;
                }
            }
        }
        LOG.debug("<== HBaseResourceMgr.getHBaseResource() Result :{}", resultList);
        return resultList;
    }
}

