/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hbase.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.hbase.client.HBaseClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseConnectionMgr {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseConnectionMgr.class);
    protected ConcurrentMap<String, HBaseClient> hbaseConnectionCache = new ConcurrentHashMap<String, HBaseClient>();
    protected ConcurrentMap<String, Boolean> repoConnectStatusMap = new ConcurrentHashMap<String, Boolean>();

    public HBaseClient getHBaseConnection(final String serviceName, String serviceType, final Map<String, String> configs) {
        HBaseClient client = null;
        if (serviceType != null) {
            client = (HBaseClient)((Object)this.hbaseConnectionCache.get(serviceName));
            if (client == null) {
                HBaseClient oldClient;
                Callable<HBaseClient> connectHBase;
                if (configs == null) {
                    connectHBase = new Callable<HBaseClient>(){

                        @Override
                        public HBaseClient call() throws Exception {
                            HBaseClient hBaseClient = null;
                            if (serviceName != null) {
                                try {
                                    hBaseClient = new HBaseClient(serviceName, configs);
                                }
                                catch (Exception ex) {
                                    LOG.error("Error connecting HBase repository : ", (Throwable)ex);
                                }
                            }
                            return hBaseClient;
                        }
                    };
                    try {
                        if (connectHBase != null) {
                            client = (HBaseClient)((Object)TimedEventUtil.timedTask((Callable)connectHBase, (long)5L, (TimeUnit)TimeUnit.SECONDS));
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Error connecting HBase repository : {}", (Object)serviceName);
                    }
                } else {
                    connectHBase = new Callable<HBaseClient>(){

                        @Override
                        public HBaseClient call() throws Exception {
                            HBaseClient hBaseClient = null;
                            if (serviceName != null && configs != null) {
                                try {
                                    hBaseClient = new HBaseClient(serviceName, configs);
                                }
                                catch (Exception ex) {
                                    LOG.error("Error connecting HBase repository : ", (Throwable)ex);
                                }
                            }
                            return hBaseClient;
                        }
                    };
                    try {
                        if (connectHBase != null) {
                            client = (HBaseClient)((Object)TimedEventUtil.timedTask((Callable)connectHBase, (long)5L, (TimeUnit)TimeUnit.SECONDS));
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Error connecting HBase repository : {} using config : {}", (Object)serviceName, configs);
                    }
                }
                if (client != null && (oldClient = this.hbaseConnectionCache.putIfAbsent(serviceName, client)) != null) {
                    client = oldClient;
                }
            } else {
                List<String> testConnect = client.getTableList(".\\*", null);
                if (testConnect == null) {
                    this.hbaseConnectionCache.remove(serviceName);
                    client = this.getHBaseConnection(serviceName, serviceType, configs);
                }
            }
            this.repoConnectStatusMap.put(serviceName, true);
        } else {
            LOG.error("Service Name not found with name {}", (Object)serviceName, (Object)new Throwable());
        }
        LOG.debug("<== HBaseConnectionMgr.getHBaseConnection() HbaseClient : {}", (Object)client);
        return client;
    }
}

