/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.thirdparty.com.google.common.base.MoreObjects;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.authorization.hbase.AuthorizationSession;
import org.apache.ranger.authorization.hbase.HbaseAuditHandler;
import org.apache.ranger.authorization.hbase.HbaseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthorizationFilter
extends FilterBase {
    private static final Logger LOG = LoggerFactory.getLogger((String)RangerAuthorizationFilter.class.getName());
    final Set<String> familiesAccessAllowed;
    final Set<String> familiesAccessDenied;
    final Set<String> familiesAccessIndeterminate;
    final Map<String, Set<String>> columnsAccessAllowed;
    final Set<String> familiesFullyAuthorized;
    final AuthorizationSession session;
    final HbaseAuditHandler auditHandler = HbaseFactory.getInstance().getAuditHandler();

    public RangerAuthorizationFilter(AuthorizationSession session, Set<String> familiesAccessAllowed, Set<String> familiesAccessDenied, Set<String> familiesAccessIndeterminate, Map<String, Set<String>> columnsAccessAllowed, Set<String> familiesFullyAuthorized) {
        this.familiesAccessAllowed = familiesAccessAllowed;
        this.familiesAccessDenied = familiesAccessDenied;
        this.familiesAccessIndeterminate = familiesAccessIndeterminate;
        this.columnsAccessAllowed = columnsAccessAllowed;
        this.familiesFullyAuthorized = familiesFullyAuthorized;
        this.session = session;
        this.session.auditHandler(this.auditHandler);
    }

    public Filter.ReturnCode filterKeyValue(Cell kv) {
        LOG.debug("==> filterKeyValue");
        String family = null;
        byte[] familyBytes = CellUtil.cloneFamily((Cell)kv);
        if (familyBytes.length > 0) {
            family = Bytes.toString((byte[])familyBytes);
            LOG.debug("filterKeyValue: evaluating family[{}].", (Object)family);
        }
        String column = null;
        byte[] qualifier = CellUtil.cloneQualifier((Cell)kv);
        if (qualifier.length > 0) {
            column = Bytes.toString((byte[])qualifier);
            LOG.debug("filterKeyValue: evaluating column[{}].", (Object)column);
        } else {
            LOG.warn("filterKeyValue: empty/null column set! Unexpected!");
        }
        Filter.ReturnCode result = Filter.ReturnCode.NEXT_COL;
        boolean authCheckNeeded = false;
        if (family == null) {
            LOG.warn("filterKeyValue: Unexpected - null/empty family! Access denied!");
        } else if (this.familiesAccessDenied.contains(family)) {
            LOG.debug("filterKeyValue: family found in access denied families cache.  Access denied.");
        } else if (this.session.getPropertyIsColumnAuthOptimizationEnabled() && this.familiesFullyAuthorized.contains(family)) {
            LOG.debug("filterKeyValue: ColumnAuthOptimizationEnabled and family found in fully authorized families cache.  Column authorization is not required");
            result = Filter.ReturnCode.INCLUDE;
        } else if (this.columnsAccessAllowed.containsKey(family)) {
            LOG.debug("filterKeyValue: family found in column level access results cache.");
            if (this.columnsAccessAllowed.get(family).contains(column)) {
                LOG.debug("filterKeyValue: family/column found in column level access results cache. Access allowed.");
                result = Filter.ReturnCode.INCLUDE;
            } else {
                LOG.debug("filterKeyValue: family/column not in column level access results cache. Access denied.");
            }
        } else if (this.familiesAccessAllowed.contains(family)) {
            LOG.debug("filterKeyValue: family found in access allowed families cache.  Must re-authorize for correct audit generation.");
            authCheckNeeded = true;
        } else if (this.familiesAccessIndeterminate.contains(family)) {
            LOG.debug("filterKeyValue: family found in indeterminate families cache.  Evaluating access...");
            authCheckNeeded = true;
        } else {
            LOG.warn("filterKeyValue: Unexpected - alien family encountered that wasn't seen by pre-hook!  Access Denied.!");
        }
        if (authCheckNeeded) {
            LOG.debug("filterKeyValue: Checking authorization...");
            this.session.columnFamily(family).column(column).buildRequest().authorize();
            AuthzAuditEvent auditEvent = this.auditHandler.getAndDiscardMostRecentEvent();
            if (this.session.isAuthorized()) {
                LOG.debug("filterKeyValue: Access granted.");
                result = Filter.ReturnCode.INCLUDE;
                if (auditEvent != null) {
                    LOG.debug("filterKeyValue: access is audited.");
                    this.auditHandler.logAuthzAudits(Collections.singletonList(auditEvent));
                } else {
                    LOG.debug("filterKeyValue: no audit event returned.  Access not audited.");
                }
            } else {
                LOG.debug("filterKeyValue: Access denied.  Denial not audited.");
            }
        }
        LOG.debug("filterKeyValue: {}", (Object)result);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("familiesAccessAllowed", this.familiesAccessAllowed).add("familiesAccessDenied", this.familiesAccessDenied).add("familiesAccessUnknown", this.familiesAccessIndeterminate).add("columnsAccessAllowed", this.columnsAccessAllowed).toString();
    }
}

