/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.BulkLoadObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.EndpointObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.TableProtos;
import org.apache.hadoop.hbase.quotas.GlobalQuotaSettings;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessControlUtil;
import org.apache.hadoop.hbase.security.access.NamespacePermission;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.com.google.common.collect.MapMaker;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.AuditProviderFactory;
import org.apache.ranger.authorization.hbase.AuthorizationSession;
import org.apache.ranger.authorization.hbase.ColumnIterator;
import org.apache.ranger.authorization.hbase.HbaseAuditHandler;
import org.apache.ranger.authorization.hbase.HbaseAuthUtils;
import org.apache.ranger.authorization.hbase.HbaseFactory;
import org.apache.ranger.authorization.hbase.HbaseUserUtils;
import org.apache.ranger.authorization.hbase.RangerAuthorizationFilter;
import org.apache.ranger.authorization.hbase.RangerHBasePlugin;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthorizationCoprocessor
implements AccessControlProtos.AccessControlService.Interface,
RegionCoprocessor,
MasterCoprocessor,
RegionServerCoprocessor,
MasterObserver,
RegionObserver,
RegionServerObserver,
EndpointObserver,
BulkLoadObserver,
Coprocessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)RangerAuthorizationCoprocessor.class.getName());
    private static final Logger PERF_HBASEAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"hbaseauth.request");
    private static final String GROUP_PREFIX = "@";
    private static final String MASTER_COPROCESSOR_TYPE = "master";
    private static final String REGIONAL_COPROCESSOR_TYPE = "regional";
    private static final String REGIONAL_SERVER_COPROCESSOR_TYPE = "regionalServer";
    private static final String[] SPECIAL_TABLES = new String[]{"hbase:meta", "-ROOT-", ".META.", "hbase:acl", "hbase:namespace"};
    private static boolean updateRangerPoliciesOnGrantRevoke = true;
    private static volatile RangerHBasePlugin hbasePlugin;
    final HbaseFactory factory = HbaseFactory.getInstance();
    final HbaseUserUtils userUtils = this.factory.getUserUtils();
    final HbaseAuthUtils authUtils = this.factory.getAuthUtils();
    private UserProvider userProvider;
    private RegionCoprocessorEnvironment regionEnv;
    private final Map<InternalScanner, String> scannerOwners = new MapMaker().weakKeys().makeMap();
    private boolean shouldCheckExecPermission;
    private String coprocessorType = "unknown";

    public void setColumnAuthOptimizationEnabled(boolean enable) throws Exception {
        RangerHBasePlugin plugin = hbasePlugin;
        if (plugin == null) {
            throw new Exception("Error while enabling column auth optimization");
        }
        plugin.setColumnAuthOptimizationEnabled(enable);
    }

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public Optional<EndpointObserver> getEndpointObserver() {
        return Optional.of(this);
    }

    public Optional<BulkLoadObserver> getBulkLoadObserver() {
        return Optional.of(this);
    }

    public Optional<MasterObserver> getMasterObserver() {
        return Optional.of(this);
    }

    public Optional<RegionServerObserver> getRegionServerObserver() {
        return Optional.of(this);
    }

    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        this.requirePermission(c, "createTable", desc.getTableName().getName(), Permission.Action.CREATE);
    }

    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission(c, "deleteTable", tableName.getName(), null, null, Permission.Action.CREATE);
    }

    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, TableDescriptor htd) throws IOException {
        this.requirePermission(c, "modifyTable", tableName.getName(), null, null, Permission.Action.CREATE);
    }

    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission(c, "enableTable", tableName.getName(), null, null, Permission.Action.CREATE);
    }

    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission(c, "disableTable", tableName.getName(), null, null, Permission.Action.CREATE);
    }

    public void preAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> observerContext, long procId) throws IOException {
        this.requirePermission(observerContext, "abortProcedure", Permission.Action.ADMIN);
    }

    public void postGetProcedures(ObserverContext<MasterCoprocessorEnvironment> observerContext) throws IOException {
        this.requirePermission(observerContext, "getProcedures", Permission.Action.ADMIN);
    }

    public void preMove(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        this.requirePermission(c, "move", region.getTable().getName(), null, null, Permission.Action.ADMIN);
    }

    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo) throws IOException {
        this.requirePermission(c, "assign", regionInfo.getTable().getName(), null, null, Permission.Action.ADMIN);
    }

    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo, boolean force) throws IOException {
        this.requirePermission(c, "unassign", regionInfo.getTable().getName(), null, null, Permission.Action.ADMIN);
    }

    public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo) throws IOException {
        this.requirePermission(c, "regionOffline", regionInfo.getTable().getName(), null, null, Permission.Action.ADMIN);
    }

    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> c, BalanceRequest request) throws IOException {
        this.requirePermission(c, "balance", Permission.Action.ADMIN);
    }

    public void preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean newValue) throws IOException {
        this.requirePermission(c, "balanceSwitch", Permission.Action.ADMIN);
    }

    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission(c, "shutdown", Permission.Action.ADMIN);
        this.cleanUpHBaseRangerPlugin();
    }

    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission(c, "stopMaster", Permission.Action.ADMIN);
        this.cleanUpHBaseRangerPlugin();
    }

    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        if (updateRangerPoliciesOnGrantRevoke) {
            LOG.debug("Calling create ACL table ...");
            try (Admin admin = ((MasterCoprocessorEnvironment)ctx.getEnvironment()).getConnection().getAdmin();){
                if (!admin.tableExists(PermissionStorage.ACL_TABLE_NAME)) {
                    RangerAuthorizationCoprocessor.createACLTable(admin);
                }
            }
        }
    }

    public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission(ctx, "snapshot", hTableDescriptor.getTableName().getName(), Permission.Action.ADMIN);
    }

    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission(ctx, "cloneSnapshot", hTableDescriptor.getTableName().getName(), Permission.Action.ADMIN);
    }

    public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission(ctx, "restoreSnapshot", hTableDescriptor.getTableName().getName(), Permission.Action.ADMIN);
    }

    public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
        this.requirePermission(ctx, "deleteSnapshot", snapshot.getTableName().getName(), Permission.Action.ADMIN);
    }

    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<TableDescriptor> descriptors, String regex) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> postGetTableDescriptors(count(tableNamesList)={}, count(descriptors)={}, regex={})", new Object[]{tableNamesList == null ? 0 : tableNamesList.size(), descriptors == null ? 0 : descriptors.size(), regex});
        }
        this.checkGetTableInfoAccess(ctx, "getTableDescriptors", descriptors, regex, this.authUtils.getAccess(Permission.Action.CREATE));
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== postGetTableDescriptors(count(tableNamesList)={}, count(descriptors)={}, regex={})", new Object[]{tableNamesList == null ? 0 : tableNamesList.size(), descriptors == null ? 0 : descriptors.size(), regex});
        }
    }

    public void postGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableDescriptor> descriptors, String regex) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> postGetTableNames(count(descriptors)={}, regex={})", (Object)(descriptors == null ? 0 : descriptors.size()), (Object)regex);
        }
        this.checkGetTableInfoAccess(ctx, "getTableNames", descriptors, regex, "_any");
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== postGetTableNames(count(descriptors)={}, regex={})", (Object)(descriptors == null ? 0 : descriptors.size()), (Object)regex);
        }
    }

    public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.requireGlobalPermission(ctx, "createNamespace", ns.getName(), Permission.Action.ADMIN);
    }

    public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        this.requireGlobalPermission(ctx, "deleteNamespace", namespace, Permission.Action.ADMIN);
    }

    public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.requireGlobalPermission(ctx, "modifyNamespace", ns.getName(), Permission.Action.ADMIN);
    }

    public void postListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<NamespaceDescriptor> descriptors) {
        LOG.debug("==> RangerAuthorizationCoprocessor.postListNamespaceDescriptors()");
        this.checkAccessForNamespaceDescriptor(ctx, "getNameSpaceDescriptors", descriptors);
        LOG.debug("<== RangerAuthorizationCoprocessor.postListNamespaceDescriptors()");
    }

    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, GlobalQuotaSettings quotas) throws IOException {
        this.requireGlobalPermission(ctx, "setUserQuota", null, Permission.Action.ADMIN);
    }

    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        this.requirePermission(ctx, "setUserTableQuota", tableName.getName(), null, null, Permission.Action.ADMIN);
    }

    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, GlobalQuotaSettings quotas) throws IOException {
        this.requireGlobalPermission(ctx, "setUserNamespaceQuota", namespace, Permission.Action.ADMIN);
    }

    public void preSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        this.requirePermission(ctx, "setTableQuota", tableName.getName(), null, null, Permission.Action.ADMIN);
    }

    public void preSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, GlobalQuotaSettings quotas) throws IOException {
        this.requireGlobalPermission(ctx, "setNamespaceQuota", namespace, Permission.Action.ADMIN);
    }

    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> observerContext) throws IOException {
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)observerContext.getEnvironment();
        Region region = env.getRegion();
        if (region == null) {
            LOG.error("NULL region from RegionCoprocessorEnvironment in preOpen()");
        } else {
            RegionInfo regionInfo = region.getRegionInfo();
            if (this.isSpecialTable(regionInfo)) {
                this.requireSystemOrSuperUser(observerContext);
            } else {
                this.requirePermission(observerContext, "open", this.getTableName((RegionCoprocessorEnvironment)observerContext.getEnvironment()), Permission.Action.ADMIN);
            }
        }
    }

    public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e, FlushLifeCycleTracker tracker) throws IOException {
        this.requirePermission(e, "flush", this.getTableName((RegionCoprocessorEnvironment)e.getEnvironment()), null, null, Permission.Action.CREATE);
    }

    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> e, Store store, List<? extends StoreFile> candidates, CompactionLifeCycleTracker tracker) throws IOException {
        this.requirePermission(e, "compactSelection", this.getTableName((RegionCoprocessorEnvironment)e.getEnvironment()), null, null, Permission.Action.CREATE);
    }

    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        this.requirePermission(e, "compact", this.getTableName((RegionCoprocessorEnvironment)e.getEnvironment()), null, null, Permission.Action.CREATE);
        return scanner;
    }

    public void preClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) throws IOException {
        this.requirePermission(e, "close", this.getTableName((RegionCoprocessorEnvironment)e.getEnvironment()), Permission.Action.ADMIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> rEnv, Get get, List<Cell> result) throws IOException {
        String commandStr;
        block3: {
            LOG.debug("==> preGetOp");
            commandStr = null;
            try {
                RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)rEnv.getEnvironment();
                Map familyMap = get.getFamilyMap();
                String operation = "get";
                byte[] tableName = this.getTableName(e);
                String tableNameStr = tableName != null ? new String(tableName) : " ";
                commandStr = this.getCommandString("get", tableNameStr, get.toMap());
                Filter filter = this.authorizeAccess(rEnv, operation, Permission.Action.READ, e, familyMap, commandStr);
                if (filter == null) {
                    LOG.debug("preGetOp: all access allowed, no filter returned");
                    break block3;
                }
                Filter existingFilter = get.getFilter();
                Filter combinedFilter = this.combineFilters(filter, existingFilter);
                get.setFilter(combinedFilter);
                LOG.debug("preGetOp: partial access, new filter added");
            }
            catch (Throwable throwable) {
                LOG.debug("<== preGetOp: commandStr: {}", commandStr);
                throw throwable;
            }
        }
        LOG.debug("<== preGetOp: commandStr: {}", (Object)commandStr);
    }

    public boolean preExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        this.requirePermission(c, "exists", Permission.Action.READ, (RegionCoprocessorEnvironment)c.getEnvironment(), get.familySet());
        return exists;
    }

    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        this.requirePermission(c, "put", Permission.Action.WRITE, (RegionCoprocessorEnvironment)c.getEnvironment(), put.getFamilyCellMap());
    }

    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        this.requirePermission(c, "delete", Permission.Action.WRITE, (RegionCoprocessorEnvironment)c.getEnvironment(), delete.getFamilyCellMap());
    }

    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        List<byte[]> familyMap = Arrays.asList(new byte[][]{family});
        this.requirePermission(c, "checkAndPut", Permission.Action.READ, (RegionCoprocessorEnvironment)c.getEnvironment(), familyMap);
        this.requirePermission(c, "checkAndPut", Permission.Action.WRITE, (RegionCoprocessorEnvironment)c.getEnvironment(), familyMap);
        return result;
    }

    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        List<byte[]> familyMap = Arrays.asList(new byte[][]{family});
        this.requirePermission(c, "checkAndDelete", Permission.Action.READ, (RegionCoprocessorEnvironment)c.getEnvironment(), familyMap);
        this.requirePermission(c, "checkAndDelete", Permission.Action.WRITE, (RegionCoprocessorEnvironment)c.getEnvironment(), familyMap);
        return result;
    }

    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        this.requirePermission(c, "append", Permission.Action.WRITE, (RegionCoprocessorEnvironment)c.getEnvironment(), append.getFamilyCellMap());
        return null;
    }

    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        this.requirePermission(c, "increment", Permission.Action.WRITE, (RegionCoprocessorEnvironment)c.getEnvironment(), increment.getFamilyCellMap().keySet());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) throws IOException {
        String commandStr;
        block3: {
            LOG.debug("==> preScannerOpen");
            commandStr = null;
            try {
                RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
                Map familyMap = scan.getFamilyMap();
                String operation = "scannerOpen";
                byte[] tableName = this.getTableName(e);
                String tableNameStr = tableName != null ? new String(tableName) : " ";
                commandStr = this.getCommandString("scan", tableNameStr, scan.toMap());
                Filter filter = this.authorizeAccess(c, operation, Permission.Action.READ, e, familyMap, commandStr);
                if (filter == null) {
                    LOG.debug("preScannerOpen: Access allowed for all families/column.  No filter added");
                    break block3;
                }
                LOG.debug("preScannerOpen: Access allowed for some of the families/column. New filter added.");
                Filter existingFilter = scan.getFilter();
                Filter combinedFilter = this.combineFilters(filter, existingFilter);
                scan.setFilter(combinedFilter);
            }
            catch (Throwable throwable) {
                LOG.debug("<== preScannerOpen: commandStr: {}", commandStr);
                throw throwable;
            }
        }
        LOG.debug("<== preScannerOpen: commandStr: {}", (Object)commandStr);
    }

    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) {
        User user = this.getActiveUser(c);
        if (user != null && user.getShortName() != null) {
            this.scannerOwners.put((InternalScanner)s, user.getShortName());
        }
        return s;
    }

    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        this.requireScannerOwner(c, s);
        return hasNext;
    }

    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.requireScannerOwner(c, s);
    }

    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) {
        this.scannerOwners.remove(s);
    }

    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        LinkedList<byte[]> cfs = new LinkedList<byte[]>();
        for (Pair<byte[], String> el : familyPaths) {
            cfs.add((byte[])el.getFirst());
        }
        this.requirePermission(ctx, "bulkLoadHFile", Permission.Action.WRITE, (RegionCoprocessorEnvironment)ctx.getEnvironment(), cfs);
    }

    public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> env) throws IOException {
        this.requirePermission(env, "stop", Permission.Action.ADMIN);
        this.cleanUpHBaseRangerPlugin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void start(CoprocessorEnvironment env) {
        String appType = "unknown";
        this.shouldCheckExecPermission = env.getConfiguration().getBoolean("hbase.security.exec.permission.checks", false);
        if (env instanceof MasterCoprocessorEnvironment) {
            this.coprocessorType = MASTER_COPROCESSOR_TYPE;
            appType = "hbaseMaster";
        } else if (env instanceof RegionServerCoprocessorEnvironment) {
            this.coprocessorType = REGIONAL_SERVER_COPROCESSOR_TYPE;
            appType = "hbaseRegional";
        } else if (env instanceof RegionCoprocessorEnvironment) {
            this.regionEnv = (RegionCoprocessorEnvironment)env;
            this.coprocessorType = REGIONAL_COPROCESSOR_TYPE;
            appType = "hbaseRegional";
        }
        this.userProvider = UserProvider.instantiate((Configuration)env.getConfiguration());
        Configuration conf = env.getConfiguration();
        HbaseFactory.initialize(conf);
        RangerHBasePlugin plugin = hbasePlugin;
        if (plugin == null) {
            Class<RangerAuthorizationCoprocessor> clazz = RangerAuthorizationCoprocessor.class;
            // MONITORENTER : org.apache.ranger.authorization.hbase.RangerAuthorizationCoprocessor.class
            plugin = hbasePlugin;
            if (plugin == null) {
                plugin = new RangerHBasePlugin(appType);
                plugin.init();
                updateRangerPoliciesOnGrantRevoke = plugin.getConfig().getBoolean("xasecure.hbase.update.xapolicies.on.grant.revoke", true);
                hbasePlugin = plugin;
            }
            // MONITOREXIT : clazz
        }
        LOG.debug("Start of Coprocessor: [{}]", (Object)this.coprocessorType);
    }

    public Iterable<Service> getServices() {
        return Collections.singleton(AccessControlProtos.AccessControlService.newReflectiveService((AccessControlProtos.AccessControlService.Interface)this));
    }

    public void prePrepareBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx, ClientProtos.PrepareBulkLoadRequest request) throws IOException {
        Collection<byte[]> cfs = null;
        this.requirePermission(ctx, "prePrepareBulkLoad", Permission.Action.WRITE, (RegionCoprocessorEnvironment)ctx.getEnvironment(), cfs);
    }

    public void preCleanupBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx, ClientProtos.CleanupBulkLoadRequest request) throws IOException {
        Collection<byte[]> cfs = null;
        this.requirePermission(ctx, "preCleanupBulkLoad", Permission.Action.WRITE, (RegionCoprocessorEnvironment)ctx.getEnvironment(), cfs);
    }

    public Message preEndpointInvocation(ObserverContext<RegionCoprocessorEnvironment> ctx, Service service, String methodName, Message request) throws IOException {
        if (this.shouldCheckExecPermission && !(service instanceof AccessControlProtos.AccessControlService)) {
            this.requirePermission(ctx, "invoke(" + service.getDescriptorForType().getName() + "." + methodName + ")", this.getTableName((RegionCoprocessorEnvironment)ctx.getEnvironment()), null, null, Permission.Action.EXEC);
        }
        return request;
    }

    public void grant(RpcController controller, AccessControlProtos.GrantRequest request, RpcCallback<AccessControlProtos.GrantResponse> done) {
        boolean isSuccess = false;
        if (updateRangerPoliciesOnGrantRevoke) {
            try {
                GrantRevokeRequest grData = this.createGrantData(request);
                RangerHBasePlugin plugin = hbasePlugin;
                if (plugin != null) {
                    RangerDefaultAuditHandler auditHandler = new RangerDefaultAuditHandler((Configuration)hbasePlugin.getConfig());
                    plugin.grantAccess(grData, (RangerAccessResultProcessor)auditHandler);
                    isSuccess = true;
                }
            }
            catch (AccessControlException excp) {
                LOG.warn("grant() failed", (Throwable)excp);
                ResponseConverter.setControllerException((RpcController)controller, (IOException)new AccessDeniedException((Throwable)excp));
            }
            catch (IOException excp) {
                LOG.warn("grant() failed", (Throwable)excp);
                ResponseConverter.setControllerException((RpcController)controller, (IOException)excp);
            }
            catch (Exception excp) {
                LOG.warn("grant() failed", (Throwable)excp);
                ResponseConverter.setControllerException((RpcController)controller, (IOException)new CoprocessorException(excp.getMessage()));
            }
        }
        AccessControlProtos.GrantResponse response = isSuccess ? AccessControlProtos.GrantResponse.getDefaultInstance() : null;
        done.run((Object)response);
    }

    public void revoke(RpcController controller, AccessControlProtos.RevokeRequest request, RpcCallback<AccessControlProtos.RevokeResponse> done) {
        boolean isSuccess = false;
        if (updateRangerPoliciesOnGrantRevoke) {
            try {
                GrantRevokeRequest grData = this.createRevokeData(request);
                RangerHBasePlugin plugin = hbasePlugin;
                if (plugin != null) {
                    RangerDefaultAuditHandler auditHandler = new RangerDefaultAuditHandler((Configuration)hbasePlugin.getConfig());
                    plugin.revokeAccess(grData, (RangerAccessResultProcessor)auditHandler);
                    isSuccess = true;
                }
            }
            catch (AccessControlException excp) {
                LOG.warn("revoke() failed", (Throwable)excp);
                ResponseConverter.setControllerException((RpcController)controller, (IOException)new AccessDeniedException((Throwable)excp));
            }
            catch (IOException excp) {
                LOG.warn("revoke() failed", (Throwable)excp);
                ResponseConverter.setControllerException((RpcController)controller, (IOException)excp);
            }
            catch (Exception excp) {
                LOG.warn("revoke() failed", (Throwable)excp);
                ResponseConverter.setControllerException((RpcController)controller, (IOException)new CoprocessorException(excp.getMessage()));
            }
        }
        AccessControlProtos.RevokeResponse response = isSuccess ? AccessControlProtos.RevokeResponse.getDefaultInstance() : null;
        done.run((Object)response);
    }

    public void getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request, RpcCallback<AccessControlProtos.GetUserPermissionsResponse> done) {
        AccessControlProtos.GetUserPermissionsResponse response = null;
        try {
            List perms;
            Object[] groupArray;
            String operation = "userPermissions";
            RangerAccessResourceImpl resource = new RangerAccessResourceImpl();
            User user = this.getActiveUser(null);
            HashSet groups = this.userUtils.getUserGroups(user);
            if (groups.isEmpty() && user.getUGI() != null && (groupArray = user.getUGI().getGroupNames()) != null) {
                groups = Sets.newHashSet((Object[])groupArray);
            }
            RangerAccessRequestImpl rangerAccessrequest = new RangerAccessRequestImpl((RangerAccessResource)resource, null, this.userUtils.getUserAsString(user), groups, null);
            rangerAccessrequest.setAction(operation);
            rangerAccessrequest.setClientIPAddress(this.getRemoteAddress());
            rangerAccessrequest.setResourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF);
            if (request.getType() == AccessControlProtos.Permission.Type.Table) {
                TableName table = request.hasTableName() ? ProtobufUtil.toTableName((TableProtos.TableName)request.getTableName()) : null;
                this.requirePermission(null, operation, table.getName(), Permission.Action.ADMIN);
                resource.setValue("table", (Object)table.getNameAsString());
                perms = (List)User.runAsLoginUser(() -> this.getUserPermissions(hbasePlugin.getResourceACLs((RangerAccessRequest)rangerAccessrequest), table.getNameAsString(), false));
            } else if (request.getType() == AccessControlProtos.Permission.Type.Namespace) {
                String namespace = request.getNamespaceName().toStringUtf8();
                this.requireGlobalPermission(null, "getUserPermissionForNamespace", namespace, Permission.Action.ADMIN);
                resource.setValue("table", (Object)(namespace + ":"));
                rangerAccessrequest.setRequestData(namespace);
                perms = (List)User.runAsLoginUser(() -> this.getUserPermissions(hbasePlugin.getResourceACLs((RangerAccessRequest)rangerAccessrequest), namespace, true));
            } else {
                this.requirePermission(null, "userPermissions", Permission.Action.ADMIN);
                perms = (List)User.runAsLoginUser(() -> this.getUserPermissions(hbasePlugin.getResourceACLs((RangerAccessRequest)rangerAccessrequest), null, false));
                if (this.userUtils.isSuperUser(user)) {
                    perms.add(new UserPermission(this.userUtils.getUserAsString(user), Permission.newBuilder((TableName)PermissionStorage.ACL_TABLE_NAME).withActions(Permission.Action.values()).build()));
                }
            }
            response = AccessControlUtil.buildGetUserPermissionsResponse((List)perms);
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)ioe);
        }
        done.run(response);
    }

    public void checkPermissions(RpcController controller, AccessControlProtos.CheckPermissionsRequest request, RpcCallback<AccessControlProtos.CheckPermissionsResponse> done) {
        LOG.debug("checkPermissions(): ");
    }

    public void hasPermission(RpcController controller, AccessControlProtos.HasPermissionRequest request, RpcCallback<AccessControlProtos.HasPermissionResponse> done) {
        LOG.debug("hasPermission(): ");
    }

    protected byte[] getTableName(RegionCoprocessorEnvironment e) {
        RegionInfo regionInfo;
        Region region = e.getRegion();
        byte[] tableName = null;
        if (region != null && (regionInfo = region.getRegionInfo()) != null) {
            tableName = regionInfo.getTable().getName();
        }
        return tableName;
    }

    protected void requireSystemOrSuperUser(ObserverContext<?> ctx) throws IOException {
        User activeUser;
        User user = User.getCurrent();
        if (user == null) {
            throw new IOException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        String systemUser = user.getShortName();
        if (!Objects.equals(systemUser, (activeUser = this.getActiveUser(ctx)).getShortName()) && !this.userUtils.isSuperUser(activeUser)) {
            throw new AccessDeniedException("User '" + user.getShortName() + "is not system or super user.");
        }
    }

    protected boolean isSpecialTable(RegionInfo regionInfo) {
        return this.isSpecialTable(regionInfo.getTable().getName());
    }

    protected boolean isSpecialTable(byte[] tableName) {
        return this.isSpecialTable(Bytes.toString((byte[])tableName));
    }

    protected boolean isSpecialTable(String input) {
        for (String specialTable : SPECIAL_TABLES) {
            if (!specialTable.equals(input)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAccessForMetaTables(RegionCoprocessorEnvironment env) {
        RegionInfo hri = env.getRegion().getRegionInfo();
        return hri.isMetaRegion();
    }

    protected void requireGlobalPermission(ObserverContext<?> ctx, String request, String objName, Permission.Action action) throws AccessDeniedException {
        this.authorizeAccess(ctx, request, objName, action, null, null, null);
    }

    protected void requirePermission(ObserverContext<?> ctx, String request, Permission.Action action) throws AccessDeniedException {
        this.requirePermission(ctx, request, null, action);
    }

    protected void requirePermission(ObserverContext<?> ctx, String request, byte[] tableName, Permission.Action action) throws AccessDeniedException {
        String table = Bytes.toString((byte[])tableName);
        this.authorizeAccess(ctx, request, null, action, table, null, null);
    }

    protected void requirePermission(ObserverContext<?> ctx, String request, byte[] aTableName, byte[] aColumnFamily, byte[] aQualifier, Permission.Action action) throws AccessDeniedException {
        String table = Bytes.toString((byte[])aTableName);
        String columnFamily = Bytes.toString((byte[])aColumnFamily);
        String column = Bytes.toString((byte[])aQualifier);
        this.authorizeAccess(ctx, request, null, action, table, columnFamily, column);
    }

    protected void requirePermission(ObserverContext<?> ctx, String request, Permission.Action perm, RegionCoprocessorEnvironment env, Collection<byte[]> families) throws IOException {
        HashMap<byte[], Object> familyMap = new HashMap<byte[], Object>();
        if (families != null) {
            for (byte[] family : families) {
                familyMap.put(family, null);
            }
        }
        this.requirePermission(ctx, request, perm, env, familyMap);
    }

    Map<String, Set<String>> getColumnFamilies(Map<byte[], ? extends Collection<?>> families) {
        if (families == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry<byte[], Collection<?>> anEntry : families.entrySet()) {
            byte[] familyBytes = anEntry.getKey();
            String family = Bytes.toString((byte[])familyBytes);
            if (family == null || family.isEmpty()) {
                LOG.error("Unexpected Input: got null or empty column family (key) in families map! Ignoring...");
                continue;
            }
            Collection<?> columnCollection = anEntry.getValue();
            if (CollectionUtils.isEmpty(columnCollection)) {
                LOG.debug("RangerAuthorizationCoprocessor getColumnFamilies: columns are empty. Setting columns to emptySet in familyMap");
                result.put(family, Collections.emptySet());
                continue;
            }
            LOG.debug("RangerAuthorizationCoprocessor getColumnFamilies: columns exist");
            ColumnIterator columnIterator = new ColumnIterator(columnCollection);
            HashSet<String> columns = new HashSet<String>();
            try {
                while (columnIterator.hasNext()) {
                    String column = (String)columnIterator.next();
                    columns.add(column);
                }
            }
            catch (Throwable t) {
                LOG.error("Exception encountered when converting family-map to set of columns. Ignoring and returning empty set of columns for family[{}]", (Object)family, (Object)t);
                LOG.error("Ignoring exception and returning empty set of columns for family[{}]", (Object)family);
                columns.clear();
            }
            result.put(family, columns);
        }
        return result;
    }

    ColumnFamilyAccessResult evaluateAccess(ObserverContext<?> ctx, String operation, Permission.Action action, RegionCoprocessorEnvironment env, Map<byte[], ? extends Collection<?>> familyMap, String commandStr) throws AccessDeniedException {
        Map<Object, Object> colFamiliesForDebugLoggingOnly;
        if (LOG.isDebugEnabled()) {
            LOG.debug("evaluateAccess: isColumnAuthOptimizationEnabled={}", (Object)hbasePlugin.getPropertyIsColumnAuthOptimizationEnabled());
        }
        String access = this.authUtils.getAccess(action);
        User user = this.getActiveUser(ctx);
        String userName = this.userUtils.getUserAsString(user);
        if (LOG.isDebugEnabled()) {
            colFamiliesForDebugLoggingOnly = this.getColumnFamilies(familyMap);
            LOG.debug("evaluateAccess: entered: user[{}], Operation[{}], access[{}], families[{}]", new Object[]{userName, operation, access, colFamiliesForDebugLoggingOnly});
        } else {
            colFamiliesForDebugLoggingOnly = Collections.emptyMap();
        }
        byte[] tableBytes = this.getTableName(env);
        if (tableBytes == null || tableBytes.length == 0) {
            LOG.debug("evaluateAccess: Unexpected: Couldn't get table from RegionCoprocessorEnvironment. Access denied, not audited");
            throw new AccessDeniedException("Insufficient permissions for operation '" + operation + "',action: " + action);
        }
        String table = Bytes.toString((byte[])tableBytes);
        if (this.canSkipAccessCheck(user, operation, access, table) || this.canSkipAccessCheck(user, operation, access, env)) {
            LOG.debug("evaluateAccess: exiting: isKnownAccessPattern returned true: access allowed, not audited");
            ColumnFamilyAccessResult result = new ColumnFamilyAccessResult(true, true, null, null, null, null, null);
            LOG.debug("evaluateAccess: exiting: user[{}], Operation[{}], access[{}], families[{}], verdict[{}]", new Object[]{userName, operation, access, colFamiliesForDebugLoggingOnly, result});
            return result;
        }
        HbaseAuditHandler auditHandler = this.factory.getAuditHandler();
        AuthorizationSession session = new AuthorizationSession(hbasePlugin).operation(operation).otherInformation(commandStr).remoteAddress(this.getRemoteAddress()).auditHandler(auditHandler).user(user).access(access).table(table);
        LOG.debug("evaluateAccess: families to process: {}", colFamiliesForDebugLoggingOnly);
        if (familyMap == null || familyMap.isEmpty()) {
            LOG.debug("evaluateAccess: Null or empty families collection, ok.  Table level access is desired");
            session.buildRequest().authorize();
            boolean authorized = session.isAuthorized();
            String reason = "";
            if (authorized) {
                LOG.debug("evaluateAccess: table level access granted [{}]", (Object)table);
            } else {
                reason = String.format("Insufficient permissions for user \u2018%s',action: %s, tableName:%s, no column families found.", user.getName(), operation, table);
            }
            AuthzAuditEvent event = auditHandler.getAndDiscardMostRecentEvent();
            ColumnFamilyAccessResult result = new ColumnFamilyAccessResult(authorized, authorized, authorized ? Collections.singletonList(event) : null, null, authorized ? null : event, reason, null);
            LOG.debug("evaluateAccess: exiting: user[{}], Operation[{}], access[{}], families[{}], verdict[{}]", new Object[]{userName, operation, access, colFamiliesForDebugLoggingOnly, result});
            return result;
        }
        LOG.debug("evaluateAccess: Families collection not null.  Skipping table-level check, will do finer level check");
        boolean everythingIsAccessible = true;
        boolean somethingIsAccessible = false;
        ArrayList<AuthzAuditEvent> authorizedEvents = new ArrayList<AuthzAuditEvent>();
        ArrayList<AuthzAuditEvent> familyLevelAccessEvents = new ArrayList<AuthzAuditEvent>();
        AuthzAuditEvent deniedEvent = null;
        String denialReason = null;
        HashMap<String, Set<String>> columnsAccessAllowed = new HashMap<String, Set<String>>();
        HashSet<String> familesAccessAllowed = new HashSet<String>();
        HashSet<String> familesAccessDenied = new HashSet<String>();
        HashSet<String> familesAccessIndeterminate = new HashSet<String>();
        HashSet<String> familiesFullyAuthorized = new HashSet<String>();
        for (Map.Entry<byte[], Collection<?>> anEntry : familyMap.entrySet()) {
            String family = Bytes.toString((byte[])anEntry.getKey());
            session.columnFamily(family);
            LOG.debug("evaluateAccess: Processing family: {}", (Object)family);
            Collection<?> columns = anEntry.getValue();
            if (columns == null || columns.isEmpty()) {
                LOG.debug("evaluateAccess: columns collection null or empty, ok.  Family level access is desired.");
                session.column(null).buildRequest().authorize();
                AuthzAuditEvent auditEvent = auditHandler.getAndDiscardMostRecentEvent();
                boolean isColumnFamilyAuthorized = session.isAuthorized();
                if (auditEvent != null) {
                    if (isColumnFamilyAuthorized) {
                        familyLevelAccessEvents.add(auditEvent);
                    } else if (deniedEvent == null) {
                        LOG.debug("evaluateAccess: Setting denied access audit event with last auth failure audit event.");
                        deniedEvent = auditEvent;
                    }
                }
                LOG.debug("evaluateAccess: family level access for [{}] is evaluated to {}. Checking if [{}] descendants have access.", new Object[]{family, isColumnFamilyAuthorized, family});
                session.resourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS).ignoreDescendantDeny(false).buildRequest().authorize();
                auditEvent = auditHandler.getAndDiscardMostRecentEvent();
                if (session.isAuthorized()) {
                    LOG.debug("evaluateAccess: [{}] descendants have access", (Object)family);
                    somethingIsAccessible = true;
                    if (isColumnFamilyAuthorized) {
                        familesAccessAllowed.add(family);
                        if (auditEvent != null) {
                            LOG.debug("evaluateAccess: adding to family-level-access-granted-event-set");
                            familyLevelAccessEvents.add(auditEvent);
                        }
                    } else {
                        familesAccessIndeterminate.add(family);
                        LOG.debug("evaluateAccess: has partial access (of some type) in family [{}]", (Object)family);
                        everythingIsAccessible = false;
                        if (auditEvent != null && deniedEvent == null) {
                            LOG.debug("evaluateAccess: Setting denied access audit event with last auth failure audit event.");
                            deniedEvent = auditEvent;
                        }
                    }
                } else {
                    everythingIsAccessible = false;
                    if (isColumnFamilyAuthorized) {
                        somethingIsAccessible = true;
                        familesAccessIndeterminate.add(family);
                        LOG.debug("evaluateAccess: has partial access (of some type) in family [{}]", (Object)family);
                        if (auditEvent != null && deniedEvent == null) {
                            LOG.debug("evaluateAccess: Setting denied access audit event with last auth failure audit event.");
                            deniedEvent = auditEvent;
                        }
                    } else {
                        LOG.debug("evaluateAccess: has no access of [{}] type in family [{}]", (Object)access, (Object)family);
                        familesAccessDenied.add(family);
                        denialReason = String.format("Insufficient permissions for user \u2018%s',action: %s, tableName:%s, family:%s.", user.getName(), operation, table, family);
                    }
                }
                session.resourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF);
                session.ignoreDescendantDeny(true);
                continue;
            }
            boolean isColumnAuthOptimizationEnabled = hbasePlugin.getPropertyIsColumnAuthOptimizationEnabled();
            LOG.debug("evaluateAccess: columns collection not empty. Skipping Family level check, will do finer level access check for columns.");
            if (isColumnAuthOptimizationEnabled) {
                session.column(null).buildRequest().authorize();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("evaluateAccess: isColumnAuthOptimizationEnabled={}, isColumnFamilyAuthorized={}", (Object)isColumnAuthOptimizationEnabled, (Object)session.isAuthorized());
                }
                if (session.isAuthorized()) {
                    session.column(null).resourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS).ignoreDescendantDeny(false).buildRequest().authorize();
                    boolean isColumnFamilyAndDescendantsAuthorized = session.isAuthorized();
                    AuthzAuditEvent auditEvent = auditHandler.getAndDiscardMostRecentEvent();
                    session.resourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF).ignoreDescendantDeny(true);
                    LOG.debug("evaluateAccess: isColumnAuthOptimizationEnabled={}, isColumnFamilyAndDescendantsAuthorized={}", (Object)isColumnAuthOptimizationEnabled, (Object)isColumnFamilyAndDescendantsAuthorized);
                    if (isColumnFamilyAndDescendantsAuthorized) {
                        familiesFullyAuthorized.add(family);
                        if (auditEvent == null) continue;
                        LOG.debug("evaluateAccess: isColumnAuthOptimizationEnabled ={}, adding family {} to familiesFullyAuthorized", (Object)isColumnAuthOptimizationEnabled, (Object)family);
                        familyLevelAccessEvents.add(auditEvent);
                        continue;
                    }
                }
            }
            HashSet<String> accessibleColumns = new HashSet<String>();
            ColumnIterator columnIterator = new ColumnIterator(columns);
            while (columnIterator.hasNext()) {
                String column = (String)columnIterator.next();
                LOG.debug("evaluateAccess: Processing column: {}", (Object)column);
                session.column(column).buildRequest().authorize();
                AuthzAuditEvent auditEvent = auditHandler.getAndDiscardMostRecentEvent();
                if (session.isAuthorized()) {
                    LOG.debug("evaluateAccess: has column level access [{}, {}]", (Object)family, (Object)column);
                    somethingIsAccessible = true;
                    accessibleColumns.add(column);
                    if (auditEvent != null) {
                        LOG.debug("evaluateAccess: adding to access-granted-audit-event-set");
                        authorizedEvents.add(auditEvent);
                    }
                } else {
                    LOG.debug("evaluateAccess: no column level access [{}, {}]", (Object)family, (Object)column);
                    somethingIsAccessible = false;
                    everythingIsAccessible = false;
                    denialReason = String.format("Insufficient permissions for user \u2018%s',action: %s, tableName:%s, family:%s, column: %s", user.getName(), operation, table, family, column);
                    if (auditEvent != null && deniedEvent == null) {
                        LOG.debug("evaluateAccess: Setting denied access audit event with last auth failure audit event.");
                        deniedEvent = auditEvent;
                    }
                }
                if (accessibleColumns.isEmpty()) continue;
                columnsAccessAllowed.put(family, accessibleColumns);
            }
        }
        RangerAuthorizationFilter filter = new RangerAuthorizationFilter(session, familesAccessAllowed, familesAccessDenied, familesAccessIndeterminate, columnsAccessAllowed, familiesFullyAuthorized);
        ColumnFamilyAccessResult result = new ColumnFamilyAccessResult(everythingIsAccessible, somethingIsAccessible, authorizedEvents, familyLevelAccessEvents, deniedEvent, denialReason, filter);
        LOG.debug("evaluateAccess: exiting: user[{}], Operation[{}], access[{}], families[{}], verdict[{}]", new Object[]{userName, operation, access, colFamiliesForDebugLoggingOnly, result});
        return result;
    }

    Filter authorizeAccess(ObserverContext<?> ctx, String operation, Permission.Action action, RegionCoprocessorEnvironment env, Map<byte[], NavigableSet<byte[]>> familyMap, String commandStr) throws AccessDeniedException {
        RangerDefaultAuditHandler auditHandler;
        ColumnFamilyAccessResult accessResult;
        block5: {
            RangerPerfTracer perf;
            block4: {
                Filter filter;
                LOG.debug("==> authorizeAccess");
                perf = null;
                try {
                    perf = RangerPerfTracer.getPerfTracer((Logger)PERF_HBASEAUTH_REQUEST_LOG, (String)("RangerAuthorizationCoprocessor.authorizeAccess(request=Operation[" + operation + "]"));
                    accessResult = this.evaluateAccess(ctx, operation, action, env, familyMap, commandStr);
                    auditHandler = new RangerDefaultAuditHandler((Configuration)hbasePlugin.getConfig());
                    if (!accessResult.everythingIsAccessible) break block4;
                    auditHandler.logAuthzAudits(accessResult.accessAllowedEvents);
                    auditHandler.logAuthzAudits(accessResult.familyLevelAccessEvents);
                    LOG.debug("authorizeAccess: exiting: No filter returned since all access was allowed");
                    filter = null;
                }
                catch (Throwable throwable) {
                    RangerPerfTracer.log(perf);
                    LOG.debug("<== authorizeAccess");
                    throw throwable;
                }
                RangerPerfTracer.log((RangerPerfTracer)perf);
                LOG.debug("<== authorizeAccess");
                return filter;
            }
            if (!accessResult.somethingIsAccessible) break block5;
            auditHandler.logAuthzAudits(accessResult.accessAllowedEvents);
            LOG.debug("authorizeAccess: exiting: Filter returned since some access was allowed");
            RangerAuthorizationFilter rangerAuthorizationFilter = accessResult.filter;
            RangerPerfTracer.log((RangerPerfTracer)perf);
            LOG.debug("<== authorizeAccess");
            return rangerAuthorizationFilter;
        }
        auditHandler.logAuthzAudit(accessResult.accessDeniedEvent);
        LOG.debug("authorizeAccess: exiting: Throwing exception since nothing was accessible");
        throw new AccessDeniedException(accessResult.denialReason);
    }

    Filter combineFilters(Filter filter, Filter existingFilter) {
        Filter combinedFilter = filter;
        if (existingFilter != null) {
            combinedFilter = new FilterList(FilterList.Operator.MUST_PASS_ALL, (List)Lists.newArrayList((Object[])new Filter[]{filter, existingFilter}));
        }
        return combinedFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requirePermission(ObserverContext<?> ctx, String operation, Permission.Action action, RegionCoprocessorEnvironment regionServerEnv, Map<byte[], ? extends Collection<?>> familyMap) throws AccessDeniedException {
        RangerPerfTracer perf = null;
        try {
            if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_HBASEAUTH_REQUEST_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Logger)PERF_HBASEAUTH_REQUEST_LOG, (String)("RangerAuthorizationCoprocessor.requirePermission(request=Operation[" + operation + "]"));
            }
            ColumnFamilyAccessResult accessResult = this.evaluateAccess(ctx, operation, action, regionServerEnv, familyMap, null);
            RangerDefaultAuditHandler auditHandler = new RangerDefaultAuditHandler((Configuration)hbasePlugin.getConfig());
            if (!accessResult.everythingIsAccessible) {
                auditHandler.logAuthzAudit(accessResult.accessDeniedEvent);
                LOG.debug("requirePermission: exiting: throwing exception as everything wasn't accessible");
                throw new AccessDeniedException(accessResult.denialReason);
            }
            auditHandler.logAuthzAudits(accessResult.accessAllowedEvents);
            auditHandler.logAuthzAudits(accessResult.familyLevelAccessEvents);
            LOG.debug("requirePermission: exiting: all access was allowed");
        }
        catch (Throwable throwable) {
            RangerPerfTracer.log(perf);
            throw throwable;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
    }

    void authorizeAccess(ObserverContext<?> ctx, String operation, String otherInformation, Permission.Action action, String table, String columnFamily, String column) throws AccessDeniedException {
        User user = this.getActiveUser(ctx);
        String access = this.authUtils.getAccess(action);
        LOG.debug("authorizeAccess: Entering : Operation[{}], Info[{}], access[{}], table[{}], columnFamily[{}], column[{}]", new Object[]{operation, otherInformation, access, table, columnFamily, column});
        if (this.canSkipAccessCheck(user, operation, access, table)) {
            LOG.debug("authorizeAccess: {}: Operation[{}], Info[{}], access[{}], table[{}], columnFamily[{}], column[{}], allowed[{}], reason[{}]", new Object[]{"Exiting", operation, otherInformation, access, table, columnFamily, column, true, "can skip auth check"});
            return;
        }
        HbaseAuditHandler auditHandler = this.factory.getAuditHandler();
        AuthorizationSession session = new AuthorizationSession(hbasePlugin).operation(operation).otherInformation(otherInformation).remoteAddress(this.getRemoteAddress()).auditHandler(auditHandler).user(user).access(access).table(table).columnFamily(columnFamily).column(column).buildRequest().authorize();
        if (LOG.isDebugEnabled()) {
            LOG.debug("authorizeAccess: {}: Operation[{}], Info[{}], access[{}], table[{}], columnFamily[{}], column[{}], allowed[{}], reason[{}]", new Object[]{"Exiting", operation, otherInformation, access, table, columnFamily, column, session.isAuthorized(), session.getDenialReason()});
        }
        session.publishResults();
    }

    boolean canSkipAccessCheck(User user, String operation, String access, String table) throws AccessDeniedException {
        boolean result = false;
        if (user == null) {
            LOG.warn("canSkipAccessCheck: exiting{}", (Object)"Unexpeceted: User is null: access denied, not audited!");
            throw new AccessDeniedException("No user associated with request (" + operation + ") for action: " + access + "on table:" + table);
        }
        if (this.isAccessForMetadataRead(access, table)) {
            LOG.debug("canSkipAccessCheck: true: metadata read access always allowed, not audited");
            result = true;
        } else {
            LOG.debug("Can't skip access checks");
        }
        return result;
    }

    boolean canSkipAccessCheck(User user, String operation, String access, RegionCoprocessorEnvironment regionServerEnv) throws AccessDeniedException {
        if (this.isAccessForMetaTables(regionServerEnv) && this.authUtils.isReadAccess(access)) {
            LOG.debug("isKnownAccessPattern: exiting: Read access for metadata tables allowed, not audited!");
            return true;
        }
        if (this.authUtils.isWriteAccess(access) && this.isAccessForMetaTables(regionServerEnv)) {
            String createAccess = this.authUtils.getAccess(Permission.Action.CREATE);
            AuthorizationSession session = new AuthorizationSession(hbasePlugin).operation(operation).remoteAddress(this.getRemoteAddress()).user(user).access(createAccess).buildRequest().authorize();
            if (session.isAuthorized()) {
                LOG.debug("isKnownAccessPattern: exiting: User has global create access, allowed!");
                return true;
            }
        }
        return false;
    }

    boolean isAccessForMetadataRead(String access, String table) {
        if (this.authUtils.isReadAccess(access) && this.isSpecialTable(table)) {
            LOG.debug("isAccessForMetadataRead: Metadata tables read: access allowed!");
            return true;
        }
        return false;
    }

    private User getActiveUser(ObserverContext<?> ctx) {
        User user = null;
        if (ctx != null) {
            try {
                Optional optionalUser = ctx.getCaller();
                user = optionalUser.isPresent() ? (User)optionalUser.get() : this.userProvider.getCurrent();
            }
            catch (Exception e) {
                LOG.info("Unable to get request user using context{}", ctx);
            }
        }
        if (user == null) {
            try {
                user = (User)RpcServer.getRequestUser().get();
            }
            catch (NoSuchElementException e) {
                LOG.info("Unable to get request user via RPCServer");
            }
        }
        if (user == null) {
            try {
                user = User.getCurrent();
            }
            catch (IOException e) {
                LOG.error("Unable to find the current user");
                user = null;
            }
        }
        return user;
    }

    private String getRemoteAddress() {
        InetAddress remoteAddr = null;
        try {
            remoteAddr = (InetAddress)RpcServer.getRemoteAddress().get();
        }
        catch (NoSuchElementException e) {
            LOG.trace("Unable to get remote Address");
        }
        if (remoteAddr == null) {
            remoteAddr = RpcServer.getRemoteIp();
        }
        return remoteAddr != null ? remoteAddr.getHostAddress() : null;
    }

    private void requireScannerOwner(ObserverContext<?> ctx, InternalScanner s) throws AccessDeniedException {
        if (!RpcServer.isInRpcCallContext()) {
            return;
        }
        User user = this.getActiveUser(ctx);
        String requestUserName = user.getShortName();
        String owner = this.scannerOwners.get(s);
        if (owner != null && !owner.equals(requestUserName)) {
            throw new AccessDeniedException("User '" + requestUserName + "' is not the scanner owner!");
        }
    }

    private static void createACLTable(Admin admin) throws IOException {
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])PermissionStorage.ACL_LIST_FAMILY).setMaxVersions(1).setInMemory(true).setBlockCacheEnabled(true).setBlocksize(8192).setBloomFilterType(BloomType.NONE).setScope(0).build();
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)PermissionStorage.ACL_TABLE_NAME).addColumnFamily(cfd).build();
        admin.createTable(td);
    }

    private List<UserPermission> getUserPermissions(RangerResourceACLs rangerResourceACLs, String resource, boolean isNamespace) {
        ArrayList<UserPermission> userPermissions = new ArrayList<UserPermission>();
        Permission.Action[] hbaseActions = Permission.Action.values();
        ArrayList<String> hbaseActionsList = new ArrayList<String>();
        for (Permission.Action action : hbaseActions) {
            hbaseActionsList.add(action.name());
        }
        this.addPermission(rangerResourceACLs.getUserACLs(), isNamespace, hbaseActionsList, userPermissions, resource, false);
        this.addPermission(rangerResourceACLs.getGroupACLs(), isNamespace, hbaseActionsList, userPermissions, resource, true);
        return userPermissions;
    }

    private void addPermission(Map<String, Map<String, RangerResourceACLs.AccessResult>> acls, boolean isNamespace, List<String> hbaseActionsList, List<UserPermission> userPermissions, String resource, boolean isGroup) {
        for (Map.Entry<String, Map<String, RangerResourceACLs.AccessResult>> userAcls : acls.entrySet()) {
            String user = !isGroup ? userAcls.getKey() : AuthUtil.toGroupEntry((String)userAcls.getKey());
            ArrayList<Permission.Action> allowedPermissions = new ArrayList<Permission.Action>();
            for (Map.Entry<String, RangerResourceACLs.AccessResult> permissionAccess : userAcls.getValue().entrySet()) {
                String permission = this.authUtils.getActionName(permissionAccess.getKey());
                if (!hbaseActionsList.contains(permission) || permissionAccess.getValue().getResult() != RangerPolicyEvaluator.ACCESS_ALLOWED.intValue()) continue;
                allowedPermissions.add(Permission.Action.valueOf((String)permission));
            }
            if (allowedPermissions.isEmpty()) continue;
            UserPermission up = isNamespace ? new UserPermission(user, Permission.newBuilder((String)resource).withActions(allowedPermissions.toArray(new Permission.Action[allowedPermissions.size()])).build()) : new UserPermission(user, Permission.newBuilder((TableName)TableName.valueOf((String)resource)).withActions(allowedPermissions.toArray(new Permission.Action[allowedPermissions.size()])).build());
            userPermissions.add(up);
        }
    }

    private GrantRevokeRequest createGrantData(AccessControlProtos.GrantRequest request) throws Exception {
        User activeUser;
        AccessControlProtos.UserPermission up = request.getUserPermission();
        AccessControlProtos.Permission perm = up == null ? null : up.getPermission();
        UserPermission userPerm = up == null ? null : AccessControlUtil.toUserPermission((AccessControlProtos.UserPermission)up);
        Permission.Action[] actions = userPerm == null ? null : userPerm.getPermission().getActions();
        String userName = userPerm == null ? null : userPerm.getUser();
        String nameSpace = null;
        String tableName = null;
        String colFamily = null;
        String qualifier = null;
        if (perm == null) {
            throw new Exception("grant(): invalid data - permission is null");
        }
        if (StringUtil.isEmpty((String)userName)) {
            throw new Exception("grant(): invalid data - username empty");
        }
        if (actions == null || actions.length == 0) {
            throw new Exception("grant(): invalid data - no action specified");
        }
        switch (perm.getType()) {
            case Global: {
                qualifier = "*";
                colFamily = "*";
                tableName = "*";
                break;
            }
            case Table: {
                TablePermission tablePerm = (TablePermission)userPerm.getPermission();
                tableName = Bytes.toString((byte[])tablePerm.getTableName().getName());
                colFamily = Bytes.toString((byte[])tablePerm.getFamily());
                qualifier = Bytes.toString((byte[])tablePerm.getQualifier());
                break;
            }
            case Namespace: {
                NamespacePermission namepsacePermission = (NamespacePermission)userPerm.getPermission();
                nameSpace = namepsacePermission.getNamespace();
            }
        }
        if (StringUtil.isEmpty(nameSpace) && StringUtil.isEmpty(tableName) && StringUtil.isEmpty((String)colFamily) && StringUtil.isEmpty((String)qualifier)) {
            throw new Exception("grant(): namespace/table/columnFamily/columnQualifier not specified");
        }
        tableName = StringUtil.isEmpty(tableName) ? "*" : tableName;
        colFamily = StringUtil.isEmpty((String)colFamily) ? "*" : colFamily;
        String string = qualifier = StringUtil.isEmpty((String)qualifier) ? "*" : qualifier;
        if (!StringUtil.isEmpty((String)nameSpace)) {
            tableName = nameSpace + ":" + tableName;
        }
        String grantor = (activeUser = this.getActiveUser(null)) != null ? activeUser.getShortName() : null;
        String[] groups = activeUser != null ? activeUser.getGroupNames() : null;
        HashSet<String> grantorGroups = null;
        if (groups != null && groups.length > 0) {
            grantorGroups = new HashSet<String>(Arrays.asList(groups));
        }
        HashMap<String, String> mapResource = new HashMap<String, String>();
        mapResource.put("table", tableName);
        mapResource.put("column-family", colFamily);
        mapResource.put("column", qualifier);
        GrantRevokeRequest ret = new GrantRevokeRequest();
        ret.setGrantor(grantor);
        ret.setGrantorGroups(grantorGroups);
        ret.setDelegateAdmin(Boolean.FALSE);
        ret.setEnableAudit(Boolean.TRUE);
        ret.setReplaceExistingPermissions(Boolean.TRUE);
        ret.setResource(mapResource);
        ret.setClientIPAddress(this.getRemoteAddress());
        ret.setForwardedAddresses(null);
        ret.setRemoteIPAddress(this.getRemoteAddress());
        ret.setRequestData(up.toString());
        if (userName.startsWith(GROUP_PREFIX)) {
            ret.getGroups().add(userName.substring(GROUP_PREFIX.length()));
        } else {
            ret.getUsers().add(userName);
        }
        block12: for (Permission.Action action : actions) {
            switch (action.code()) {
                case 82: {
                    ret.getAccessTypes().add("read");
                    continue block12;
                }
                case 87: {
                    ret.getAccessTypes().add("write");
                    continue block12;
                }
                case 67: {
                    ret.getAccessTypes().add("create");
                    continue block12;
                }
                case 65: {
                    ret.getAccessTypes().add("admin");
                    ret.setDelegateAdmin(Boolean.TRUE);
                    continue block12;
                }
                case 88: {
                    ret.getAccessTypes().add("execute");
                    continue block12;
                }
                default: {
                    LOG.warn("grant(): ignoring action '{}' for user '{}'", (Object)action.name(), (Object)userName);
                }
            }
        }
        return ret;
    }

    private GrantRevokeRequest createRevokeData(AccessControlProtos.RevokeRequest request) throws Exception {
        User activeUser;
        AccessControlProtos.UserPermission up = request.getUserPermission();
        AccessControlProtos.Permission perm = up == null ? null : up.getPermission();
        UserPermission userPerm = up == null ? null : AccessControlUtil.toUserPermission((AccessControlProtos.UserPermission)up);
        String userName = userPerm == null ? null : userPerm.getUser();
        String nameSpace = null;
        String tableName = null;
        String colFamily = null;
        String qualifier = null;
        if (perm == null) {
            throw new Exception("revoke(): invalid data - permission is null");
        }
        if (StringUtil.isEmpty((String)userName)) {
            throw new Exception("revoke(): invalid data - username empty");
        }
        switch (perm.getType()) {
            case Global: {
                qualifier = "*";
                colFamily = "*";
                tableName = "*";
                break;
            }
            case Table: {
                TablePermission tablePerm = (TablePermission)userPerm.getPermission();
                tableName = Bytes.toString((byte[])tablePerm.getTableName().getName());
                colFamily = Bytes.toString((byte[])tablePerm.getFamily());
                qualifier = Bytes.toString((byte[])tablePerm.getQualifier());
                break;
            }
            case Namespace: {
                NamespacePermission namespacePermission = (NamespacePermission)userPerm.getPermission();
                nameSpace = namespacePermission.getNamespace();
            }
        }
        if (StringUtil.isEmpty(nameSpace) && StringUtil.isEmpty(tableName) && StringUtil.isEmpty((String)colFamily) && StringUtil.isEmpty((String)qualifier)) {
            throw new Exception("revoke(): table/columnFamily/columnQualifier not specified");
        }
        tableName = StringUtil.isEmpty(tableName) ? "*" : tableName;
        colFamily = StringUtil.isEmpty((String)colFamily) ? "*" : colFamily;
        String string = qualifier = StringUtil.isEmpty((String)qualifier) ? "*" : qualifier;
        if (!StringUtil.isEmpty((String)nameSpace)) {
            tableName = nameSpace + ":" + tableName;
        }
        String grantor = (activeUser = this.getActiveUser(null)) != null ? activeUser.getShortName() : null;
        String[] groups = activeUser != null ? activeUser.getGroupNames() : null;
        HashSet<String> grantorGroups = null;
        if (groups != null && groups.length > 0) {
            grantorGroups = new HashSet<String>(Arrays.asList(groups));
        }
        HashMap<String, String> mapResource = new HashMap<String, String>();
        mapResource.put("table", tableName);
        mapResource.put("column-family", colFamily);
        mapResource.put("column", qualifier);
        GrantRevokeRequest ret = new GrantRevokeRequest();
        ret.setGrantor(grantor);
        ret.setGrantorGroups(grantorGroups);
        ret.setDelegateAdmin(Boolean.TRUE);
        ret.setEnableAudit(Boolean.TRUE);
        ret.setReplaceExistingPermissions(Boolean.TRUE);
        ret.setResource(mapResource);
        ret.setClientIPAddress(this.getRemoteAddress());
        ret.setForwardedAddresses(null);
        ret.setRemoteIPAddress(this.getRemoteAddress());
        ret.setRequestData(up.toString());
        if (userName.startsWith(GROUP_PREFIX)) {
            ret.getGroups().add(userName.substring(GROUP_PREFIX.length()));
        } else {
            ret.getUsers().add(userName);
        }
        ret.getAccessTypes().add("read");
        ret.getAccessTypes().add("write");
        ret.getAccessTypes().add("create");
        ret.getAccessTypes().add("admin");
        ret.getAccessTypes().add("execute");
        return ret;
    }

    private void cleanUpHBaseRangerPlugin() {
        LOG.debug("==> RangerAuthorizationCoprocessor.cleanUp_HBaseRangerPlugin()");
        if (hbasePlugin != null) {
            hbasePlugin.setHBaseShuttingDown(true);
            hbasePlugin.cleanup();
            AuditProviderFactory auditProviderFactory = hbasePlugin.getAuditProviderFactory();
            if (auditProviderFactory != null) {
                auditProviderFactory.shutdown();
            }
        }
        LOG.debug("<== RangerAuthorizationCoprocessor.cleanUp_HBaseRangerPlugin() completed!");
    }

    private String getCommandString(String operationName, String tableNameStr, Map<String, Object> opMetaData) {
        StringBuilder ret = new StringBuilder();
        if (!"hbase:meta".equals(tableNameStr)) {
            ret.append(operationName);
            ret.append(" ");
            ret.append(tableNameStr).append(",").append(" ");
            ret.append(this.getPredicates(operationName, opMetaData));
        }
        return ret.toString();
    }

    private String getPredicates(String operationName, Map<String, Object> opMetaData) {
        StringBuilder ret = new StringBuilder();
        if (MapUtils.isNotEmpty(opMetaData)) {
            HashMap families = (HashMap)opMetaData.get("families");
            String startRowVal = (String)opMetaData.get("startRow");
            String stopRowVal = (String)opMetaData.get("stopRow");
            String filterVal = (String)opMetaData.get("filter");
            String rowVal = (String)opMetaData.get("row");
            if (!this.isQueryforInfo(families)) {
                ret.append("{");
                if ("scan".equals(operationName)) {
                    if (StringUtils.isNotEmpty((String)startRowVal)) {
                        ret.append(this.formatPredicate(ret, PredicateType.STARTROW, startRowVal));
                    }
                    if (StringUtils.isNotEmpty((String)stopRowVal)) {
                        ret.append(this.formatPredicate(ret, PredicateType.STOPROW, stopRowVal));
                    }
                } else if (StringUtils.isNotEmpty((String)rowVal)) {
                    ret.append(this.formatPredicate(ret, PredicateType.ROW, rowVal));
                }
                if (StringUtils.isNotEmpty((String)filterVal)) {
                    ret.append(this.formatPredicate(ret, PredicateType.FILTER, filterVal));
                }
                if (MapUtils.isNotEmpty((Map)families)) {
                    String colfamily = families.toString();
                    ret.append(this.formatPredicate(ret, PredicateType.COLUMNS, colfamily));
                }
                ret.append(" ").append("}");
            }
        }
        return ret.toString();
    }

    private boolean isQueryforInfo(HashMap<String, ArrayList<?>> families) {
        boolean ret = false;
        for (Map.Entry<String, ArrayList<?>> family : families.entrySet()) {
            String familyKey = family.getKey();
            if (!"info".equals(familyKey)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private String formatPredicate(StringBuilder commandStr, PredicateType predicateType, String val) {
        StringBuilder ret = new StringBuilder();
        if ("{".contentEquals(commandStr)) {
            ret.append(" ");
        } else {
            ret.append(",").append(" ");
        }
        ret.append(this.buildPredicate(predicateType, val));
        return ret.toString();
    }

    private String buildPredicate(PredicateType predicateType, String val) {
        StringBuilder ret = new StringBuilder();
        switch (predicateType) {
            case STARTROW: {
                ret.append(PredicateType.STARTROW.name().toUpperCase());
                ret.append("=>");
                ret.append("'").append(val).append("'");
                break;
            }
            case STOPROW: {
                ret.append(PredicateType.STOPROW.name().toUpperCase());
                ret.append("=>");
                ret.append("'").append(val).append("'");
                break;
            }
            case FILTER: {
                ret.append(PredicateType.FILTER.name().toUpperCase());
                ret.append("=>");
                ret.append("'").append(val).append("'");
                break;
            }
            case COLUMNS: {
                ret.append(PredicateType.COLUMNS.name().toUpperCase());
                ret.append("=>");
                ret.append("'").append(val).append("'");
                break;
            }
            case ROW: {
                ret.append(val);
            }
        }
        return ret.toString();
    }

    private void checkGetTableInfoAccess(ObserverContext<MasterCoprocessorEnvironment> ctx, String operation, List<TableDescriptor> descriptors, String regex, String accessPermission) {
        if (CollectionUtils.isNotEmpty(descriptors)) {
            User user = this.getActiveUser(ctx);
            String access = accessPermission;
            HbaseAuditHandler auditHandler = this.factory.getAuditHandler();
            AuthorizationSession session = new AuthorizationSession(hbasePlugin).operation(operation).otherInformation("regex=" + regex).remoteAddress(this.getRemoteAddress()).auditHandler(auditHandler).user(user).access(access);
            Iterator<TableDescriptor> itr = descriptors.iterator();
            while (itr.hasNext()) {
                TableDescriptor htd = itr.next();
                String tableName = htd.getTableName().getNameAsString();
                session.table(tableName).buildRequest().authorize();
                if (session.isAuthorized()) continue;
                ArrayList events = null;
                itr.remove();
                AuthzAuditEvent event = auditHandler.getAndDiscardMostRecentEvent();
                if (event != null) {
                    events = Lists.newArrayList((Object[])new AuthzAuditEvent[]{event});
                }
                auditHandler.logAuthzAudits(events);
            }
            if (!descriptors.isEmpty()) {
                session.logCapturedEvents();
            }
        }
    }

    private void checkAccessForNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, String operation, List<NamespaceDescriptor> descriptors) {
        if (CollectionUtils.isNotEmpty(descriptors)) {
            User user = this.getActiveUser(ctx);
            String access = this.authUtils.getAccess(Permission.Action.ADMIN);
            HbaseAuditHandler auditHandler = this.factory.getAuditHandler();
            AuthorizationSession session = new AuthorizationSession(hbasePlugin).operation(operation).remoteAddress(this.getRemoteAddress()).auditHandler(auditHandler).user(user).access(access);
            Iterator<NamespaceDescriptor> itr = descriptors.iterator();
            while (itr.hasNext()) {
                NamespaceDescriptor namespaceDescriptor = itr.next();
                String namespace = namespaceDescriptor.getName();
                session.table(namespace).buildRequest().authorize();
                if (session.isAuthorized()) continue;
                ArrayList events = null;
                itr.remove();
                AuthzAuditEvent event = auditHandler.getAndDiscardMostRecentEvent();
                if (event != null) {
                    events = Lists.newArrayList((Object[])new AuthzAuditEvent[]{event});
                }
                auditHandler.logAuthzAudits(events);
            }
            if (!descriptors.isEmpty()) {
                session.logCapturedEvents();
            }
        }
    }

    static class ColumnFamilyAccessResult {
        final boolean everythingIsAccessible;
        final boolean somethingIsAccessible;
        final List<AuthzAuditEvent> accessAllowedEvents;
        final List<AuthzAuditEvent> familyLevelAccessEvents;
        final AuthzAuditEvent accessDeniedEvent;
        final String denialReason;
        final RangerAuthorizationFilter filter;

        ColumnFamilyAccessResult(boolean everythingIsAccessible, boolean somethingIsAccessible, List<AuthzAuditEvent> accessAllowedEvents, List<AuthzAuditEvent> familyLevelAccessEvents, AuthzAuditEvent accessDeniedEvent, String denialReason, RangerAuthorizationFilter filter) {
            this.everythingIsAccessible = everythingIsAccessible;
            this.somethingIsAccessible = somethingIsAccessible;
            this.accessAllowedEvents = accessAllowedEvents;
            this.familyLevelAccessEvents = familyLevelAccessEvents;
            this.accessDeniedEvent = accessDeniedEvent;
            this.denialReason = denialReason;
            this.filter = filter;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("everythingIsAccessible", this.everythingIsAccessible).add("somethingIsAccessible", this.somethingIsAccessible).add("accessAllowedEvents", this.accessAllowedEvents).add("familyLevelAccessEvents", this.familyLevelAccessEvents).add("accessDeniedEvent", (Object)this.accessDeniedEvent).add("denialReason", (Object)this.denialReason).add("filter", (Object)this.filter).toString();
        }
    }

    static enum PredicateType {
        STARTROW,
        STOPROW,
        FILTER,
        COLUMNS,
        ROW;

    }
}

