/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.ranger.authorization.hbase.HbaseUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaseUserUtilsImpl
implements HbaseUserUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)HbaseUserUtilsImpl.class.getName());
    static final AtomicBoolean isInitialized = new AtomicBoolean(false);
    static final AtomicReference<Set<String>> superUsers = new AtomicReference(new HashSet());
    private static final String SUPERUSER_CONFIG_PROP = "hbase.superuser";

    public static void initialize(Configuration conf) {
        if (isInitialized.get()) {
            LOG.warn("HbaseUserUtilsImpl.initialize: Unexpected: initialization called more than once!");
        } else {
            if (conf == null) {
                LOG.error("HbaseUserUtilsImpl.initialize: Internal error: called with null conf value!");
            } else {
                String[] users = conf.getStrings(SUPERUSER_CONFIG_PROP);
                if (users != null && users.length > 0) {
                    HashSet<String> superUsers = new HashSet<String>(users.length);
                    for (String user : users) {
                        user = user.trim();
                        LOG.info("HbaseUserUtilsImpl.initialize: Adding Super User({})", (Object)user);
                        superUsers.add(user);
                    }
                    HbaseUserUtilsImpl.superUsers.set(superUsers);
                }
            }
            isInitialized.set(true);
        }
    }

    @Override
    public String getUserAsString(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User is null!");
        }
        return user.getShortName();
    }

    @Override
    public Set<String> getUserGroups(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User is null!");
        }
        String[] groupsArray = user.getGroupNames();
        return new HashSet<String>(Arrays.asList(groupsArray));
    }

    @Override
    public User getUser() {
        User user = null;
        try {
            user = (User)RpcServer.getRequestUser().get();
        }
        catch (NoSuchElementException e) {
            LOG.info("Unable to get request user");
        }
        if (user == null) {
            try {
                user = User.getCurrent();
            }
            catch (IOException e) {
                LOG.error("Unable to get current user: User.getCurrent() threw IOException");
            }
        }
        return user;
    }

    @Override
    public String getUserAsString() {
        User user = this.getUser();
        if (user == null) {
            return "";
        }
        return this.getUserAsString(user);
    }

    @Override
    public boolean isSuperUser(User user) {
        if (!isInitialized.get()) {
            LOG.error("HbaseUserUtilsImpl.isSuperUser: Internal error: called before initialization was complete!");
        }
        Set<String> superUsers = HbaseUserUtilsImpl.superUsers.get();
        boolean isSuper = superUsers.contains(user.getShortName());
        LOG.debug("IsSuperCheck on [{}] returns [{}]", (Object)user.getShortName(), (Object)isSuper);
        return isSuper;
    }
}

