/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import java.util.ArrayList;
import java.util.List;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.authorization.hbase.HbaseAuditHandler;
import org.apache.ranger.authorization.hbase.RangerHBaseResource;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaseAuditHandlerImpl
extends RangerDefaultAuditHandler
implements HbaseAuditHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HbaseAuditHandlerImpl.class);
    final List<AuthzAuditEvent> allEventsList = new ArrayList<AuthzAuditEvent>();
    AuthzAuditEvent mostRecentEvent;
    boolean superUserOverride;

    public AuthzAuditEvent getAuthzEvents(RangerAccessResult result) {
        LOG.debug("==> HbaseAuditHandlerImpl.getAuthzEvents({})", (Object)result);
        this.resetResourceForAudit(result.getAccessRequest());
        AuthzAuditEvent event = super.getAuthzEvents(result);
        if (this.mostRecentEvent != null) {
            LOG.debug("getAuthzEvents: got one event from default audit handler");
            this.allEventsList.add(this.mostRecentEvent);
        } else {
            LOG.debug("getAuthzEvents: no event produced by default audit handler");
        }
        this.mostRecentEvent = event;
        LOG.debug("==> getAuthzEvents: mostRecentEvent:{}", (Object)this.mostRecentEvent);
        LOG.debug("<== HbaseAuditHandlerImpl.getAuthzEvents({}): null", (Object)result);
        return null;
    }

    @Override
    public List<AuthzAuditEvent> getCapturedEvents() {
        LOG.debug("==> HbaseAuditHandlerImpl.getCapturedEvents()");
        ArrayList<AuthzAuditEvent> result = new ArrayList<AuthzAuditEvent>(this.allEventsList);
        if (this.mostRecentEvent != null) {
            result.add(this.mostRecentEvent);
        }
        this.applySuperUserOverride(result);
        LOG.debug("<== HbaseAuditHandlerImpl.getAuthzEvents(): count[{}] :result : {}", (Object)result.size(), result);
        return result;
    }

    @Override
    public AuthzAuditEvent getAndDiscardMostRecentEvent() {
        LOG.debug("==> HbaseAuditHandlerImpl.getAndDiscardMostRecentEvent():");
        AuthzAuditEvent result = this.mostRecentEvent;
        this.applySuperUserOverride(result);
        this.mostRecentEvent = null;
        LOG.debug("<== HbaseAuditHandlerImpl.getAndDiscardMostRecentEvent(): {}", (Object)result);
        return result;
    }

    @Override
    public void setMostRecentEvent(AuthzAuditEvent event) {
        LOG.debug("==> HbaseAuditHandlerImpl.setMostRecentEvent({})", (Object)event);
        this.mostRecentEvent = event;
        LOG.debug("<== HbaseAuditHandlerImpl.setMostRecentEvent(...)");
    }

    @Override
    public void setSuperUserOverride(boolean override) {
        LOG.debug("==> HbaseAuditHandlerImpl.setSuperUserOverride({})", (Object)override);
        this.superUserOverride = override;
        LOG.debug("<== HbaseAuditHandlerImpl.setSuperUserOverride(...)");
    }

    void applySuperUserOverride(List<AuthzAuditEvent> events) {
        LOG.debug("==> HbaseAuditHandlerImpl.applySuperUserOverride({})", events);
        for (AuthzAuditEvent event : events) {
            this.applySuperUserOverride(event);
        }
        LOG.debug("<== HbaseAuditHandlerImpl.applySuperUserOverride(...)");
    }

    void applySuperUserOverride(AuthzAuditEvent event) {
        LOG.debug("==> HbaseAuditHandlerImpl.applySuperUserOverride({})", (Object)event);
        if (event != null && this.superUserOverride) {
            event.setAccessResult((short)1);
            event.setPolicyId(-1L);
        }
        LOG.debug("<== HbaseAuditHandlerImpl.applySuperUserOverride(...)");
    }

    private void resetResourceForAudit(RangerAccessRequest request) {
        LOG.debug("==> HbaseAuditHandlerImpl.resetResourceForAudit({})", (Object)request);
        if (request != null && request.getResource() instanceof RangerHBaseResource) {
            RangerHBaseResource hbaseResource = (RangerHBaseResource)request.getResource();
            hbaseResource.resetValue("table");
        }
        LOG.debug("<== HbaseAuditHandlerImpl.resetResourceForAudit({})", (Object)request);
    }
}

