/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnIterator
implements Iterator<String> {
    private static final Logger LOG = LoggerFactory.getLogger((String)ColumnIterator.class.getName());
    Iterator<byte[]> setIterator;
    Iterator<Cell> listIterator;

    public ColumnIterator(Collection<?> columnCollection) {
        if (columnCollection != null) {
            if (columnCollection instanceof Set) {
                this.setIterator = ((Set)columnCollection).iterator();
            } else if (columnCollection instanceof List) {
                this.listIterator = ((List)columnCollection).iterator();
            } else {
                LOG.error("Unexpected type {} passed as value in column family collection", (Object)columnCollection.getClass().getName());
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.setIterator != null) {
            return this.setIterator.hasNext();
        }
        if (this.listIterator != null) {
            return this.listIterator.hasNext();
        }
        return false;
    }

    @Override
    public String next() {
        String value;
        if (this.setIterator != null) {
            byte[] valueBytes = this.setIterator.next();
            value = valueBytes != null ? Bytes.toString((byte[])valueBytes) : "";
        } else if (this.listIterator != null) {
            Cell cell = this.listIterator.next();
            byte[] v = CellUtil.cloneQualifier((Cell)cell);
            value = Bytes.toString((byte[])v);
        } else {
            throw new NoSuchElementException("Empty values passed in!");
        }
        return value;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported from iterator!");
    }
}

