/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.authorization.hbase.HbaseAuditHandler;
import org.apache.ranger.authorization.hbase.HbaseAuthUtils;
import org.apache.ranger.authorization.hbase.HbaseFactory;
import org.apache.ranger.authorization.hbase.HbaseUserUtils;
import org.apache.ranger.authorization.hbase.RangerHBasePlugin;
import org.apache.ranger.authorization.hbase.RangerHBaseResource;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationSession {
    private static final Logger LOG = LoggerFactory.getLogger((String)AuthorizationSession.class.getName());
    final HbaseFactory factory = HbaseFactory.getInstance();
    final HbaseUserUtils userUtils = this.factory.getUserUtils();
    final HbaseAuthUtils authUtils = this.factory.getAuthUtils();
    final RangerHBasePlugin authorizer;
    String operation;
    String otherInformation;
    String access;
    String table;
    String column;
    String columnFamily;
    String remoteAddress;
    User user;
    Set<String> groups;
    HbaseAuditHandler auditHandler;
    boolean superUser;
    RangerAccessRequest request;
    RangerAccessResult result;
    private RangerAccessRequest.ResourceMatchingScope resourceMatchingScope = RangerAccessRequest.ResourceMatchingScope.SELF;
    private boolean ignoreDescendantDeny = true;

    public AuthorizationSession(RangerHBasePlugin authorizer) {
        this.authorizer = authorizer;
    }

    public boolean getPropertyIsColumnAuthOptimizationEnabled() {
        return this.authorizer.getPropertyIsColumnAuthOptimizationEnabled();
    }

    AuthorizationSession operation(String anOperation) {
        this.operation = anOperation;
        return this;
    }

    AuthorizationSession otherInformation(String information) {
        this.otherInformation = information;
        return this;
    }

    AuthorizationSession remoteAddress(String ipAddress) {
        this.remoteAddress = ipAddress;
        return this;
    }

    AuthorizationSession access(String anAccess) {
        this.access = anAccess;
        return this;
    }

    AuthorizationSession user(User aUser) {
        this.user = aUser;
        if (this.user == null) {
            LOG.warn("AuthorizationSession.user: user is null!");
            this.groups = null;
        } else {
            Object[] groups;
            this.groups = this.userUtils.getUserGroups(this.user);
            if (this.groups.isEmpty() && this.user.getUGI() != null && (groups = this.user.getUGI().getGroupNames()) != null) {
                this.groups = Sets.newHashSet((Object[])groups);
            }
            this.superUser = this.userUtils.isSuperUser(this.user);
        }
        return this;
    }

    AuthorizationSession table(String aTable) {
        this.table = aTable;
        return this;
    }

    AuthorizationSession columnFamily(String aColumnFamily) {
        this.columnFamily = aColumnFamily;
        return this;
    }

    AuthorizationSession column(String aColumn) {
        this.column = aColumn;
        return this;
    }

    void verifyBuildable() {
        String template = "Internal error: Incomplete/inconsisten state: [%s]. Can't build auth request!";
        if (this.factory == null) {
            String message = String.format(template, "factory is null");
            LOG.error(message);
            throw new IllegalStateException(message);
        }
        if (this.access == null || this.access.isEmpty()) {
            String message = String.format(template, "access is null");
            LOG.error(message);
            throw new IllegalStateException(message);
        }
        if (this.user == null) {
            String message = String.format(template, "user is null");
            LOG.error(message);
            throw new IllegalStateException(message);
        }
        if (this.isProvided(this.columnFamily) && !this.isProvided(this.table)) {
            String message = String.format(template, "Table must be provided if column-family is provided");
            LOG.error(message);
            throw new IllegalStateException(message);
        }
        if (this.isProvided(this.column) && !this.isProvided(this.columnFamily)) {
            String message = String.format(template, "Column family must be provided if column is provided");
            LOG.error(message);
            throw new IllegalStateException(message);
        }
    }

    void zapAuthorizationState() {
        this.request = null;
        this.result = null;
    }

    boolean isProvided(String aString) {
        return aString != null && !aString.isEmpty();
    }

    boolean isNameSpaceOperation() {
        return StringUtils.equals((String)this.operation, (String)"createNamespace") || StringUtils.equals((String)this.operation, (String)"deleteNamespace") || StringUtils.equals((String)this.operation, (String)"modifyNamespace") || StringUtils.equals((String)this.operation, (String)"setUserNamespaceQuota") || StringUtils.equals((String)this.operation, (String)"setNamespaceQuota") || StringUtils.equals((String)this.operation, (String)"getUserPermissionForNamespace");
    }

    AuthorizationSession buildRequest() {
        this.verifyBuildable();
        this.zapAuthorizationState();
        this.request = this.createRangerRequest();
        LOG.debug("Built request: {}", (Object)this.request);
        return this;
    }

    AuthorizationSession authorize() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AuthorizationSession.authorize: {}", (Object)this.getRequestMessage());
        }
        if (this.request == null) {
            String message = "Invalid state transition: buildRequest() must be called before authorize().  This request would ultimately get denied.!";
            throw new IllegalStateException(message);
        }
        if (this.auditHandler != null && this.superUser) {
            LOG.debug("Setting super-user override on audit handler");
            this.auditHandler.setSuperUserOverride(this.superUser);
        }
        this.result = this.authorizer.isAccessAllowed(this.request, this.auditHandler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AuthorizationSession.authorize: {}", (Object)this.getLogMessage(this.isAuthorized(), this.getDenialReason()));
        }
        return this;
    }

    void logCapturedEvents() {
        if (this.auditHandler != null) {
            List<AuthzAuditEvent> events = this.auditHandler.getCapturedEvents();
            this.auditHandler.logAuthzAudits(events);
        }
    }

    void publishResults() throws AccessDeniedException {
        LOG.debug("==> AuthorizationSession.publishResults()");
        boolean authorized = this.isAuthorized();
        if (this.auditHandler != null && this.isAudited()) {
            ArrayList events = null;
            if (authorized) {
                ArrayList theseEvents = this.auditHandler.getCapturedEvents();
                if (theseEvents != null && !theseEvents.isEmpty()) {
                    events = theseEvents;
                }
            } else {
                AuthzAuditEvent event = this.auditHandler.getAndDiscardMostRecentEvent();
                if (event != null) {
                    events = Lists.newArrayList((Object[])new AuthzAuditEvent[]{event});
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Writing {} messages to audit: [{}]", (Object)(events == null ? 0 : events.size()), (Object)(events == null ? "" : ((Object)events).toString()));
            }
            this.auditHandler.logAuthzAudits(events);
        }
        if (!authorized) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AuthorizationSession.publishResults: throwing exception: {}", (Object)this.getLogMessage(false, this.getDenialReason()));
            }
            throw new AccessDeniedException("Insufficient permissions for user '" + this.user.getName() + "' (action=" + this.access + ")");
        }
        LOG.debug("<== AuthorizationSession.publishResults()");
    }

    boolean isAudited() {
        boolean audited = false;
        if (this.result == null) {
            LOG.error("Internal error: _result was null!  Assuming no audit. Request[{}]", (Object)this.request);
        } else {
            audited = this.result.getIsAudited();
        }
        return audited;
    }

    boolean isAuthorized() {
        boolean allowed = false;
        if (this.result == null) {
            LOG.error("Internal error: _result was null! Returning false.");
        } else {
            allowed = this.result.getIsAllowed();
        }
        if (!allowed && this.superUser) {
            LOG.debug("User [{}] is a superUser!  Overriding policy engine's decision.  Request is deemed authorized!", (Object)this.user);
            allowed = true;
        }
        return allowed;
    }

    String getDenialReason() {
        String reason = "";
        if (this.result == null) {
            LOG.error("Internal error: _result was null!  Returning empty reason.");
        } else {
            boolean allowed = this.result.getIsAllowed();
            if (!allowed) {
                reason = this.result.getReason();
            }
        }
        return reason;
    }

    String requestToString() {
        return this.toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.request.getClass()).add("operation", (Object)this.operation).add("otherInformation", (Object)this.otherInformation).add("access", (Object)this.access).add("user", this.user != null ? this.user.getName() : null).add("groups", this.groups).add("auditHandler", this.auditHandler != null ? this.auditHandler.getClass().getSimpleName() : null).add("table", (Object)this.table).add("column", (Object)this.column).add("column-family", (Object)this.columnFamily).add("resource-matching-scope", (Object)this.resourceMatchingScope).add("ignoreDescendantDeny", this.ignoreDescendantDeny).toString();
    }

    String getPrintableValue(String value) {
        if (this.isProvided(value)) {
            return value;
        }
        return "";
    }

    String getRequestMessage() {
        String format = "Access[%s] by user[%s] belonging to groups[%s] to table[%s] for column-family[%s], column[%s] triggered by operation[%s], otherInformation[%s]";
        String user = this.userUtils.getUserAsString();
        return String.format(format, this.getPrintableValue(this.access), this.getPrintableValue(user), this.groups, this.getPrintableValue(this.table), this.getPrintableValue(this.columnFamily), this.getPrintableValue(this.column), this.getPrintableValue(this.operation), this.getPrintableValue(this.otherInformation));
    }

    String getLogMessage(boolean allowed, String reason) {
        String format = " %s: status[%s], reason[%s]";
        return String.format(format, this.getRequestMessage(), allowed ? "allowed" : "denied", reason);
    }

    AuthorizationSession auditHandler(HbaseAuditHandler anAuditHandler) {
        this.auditHandler = anAuditHandler;
        return this;
    }

    AuthorizationSession resourceMatchingScope(RangerAccessRequest.ResourceMatchingScope scope) {
        this.resourceMatchingScope = scope;
        return this;
    }

    AuthorizationSession ignoreDescendantDeny(boolean ignoreDescendantDeny) {
        this.ignoreDescendantDeny = ignoreDescendantDeny;
        return this;
    }

    private RangerAccessResource createHBaseResource() {
        RangerHBaseResource resource = new RangerHBaseResource();
        if (this.isNameSpaceOperation() && StringUtils.isNotBlank((String)this.otherInformation)) {
            resource.setValue("table", this.otherInformation + ":");
        } else {
            resource.setValue("table", this.table);
        }
        resource.setValue("column-family", this.columnFamily);
        resource.setValue("column", this.column);
        return resource;
    }

    private RangerAccessRequest createRangerRequest() {
        RangerAccessResource resource = this.createHBaseResource();
        String user = this.userUtils.getUserAsString(this.user);
        RangerAccessRequestImpl request = new RangerAccessRequestImpl(resource, this.access, user, this.groups, null);
        request.setAction(this.operation);
        request.setRequestData(this.otherInformation);
        request.setClientIPAddress(this.remoteAddress);
        request.setResourceMatchingScope(this.resourceMatchingScope);
        request.setAccessTime(new Date());
        request.setIgnoreDescendantDeny(Boolean.valueOf(this.ignoreDescendantDeny));
        return request;
    }
}

