/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.BulkLoadObserver;
import org.apache.hadoop.hbase.coprocessor.EndpointObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.quotas.GlobalQuotaSettings;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.ranger.plugin.classloader.PluginClassLoaderActivator;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthorizationCoprocessor
implements RegionCoprocessor,
MasterCoprocessor,
RegionServerCoprocessor,
MasterObserver,
RegionObserver,
RegionServerObserver,
EndpointObserver,
BulkLoadObserver,
AccessControlProtos.AccessControlService.Interface {
    public static final Logger LOG = LoggerFactory.getLogger(RangerAuthorizationCoprocessor.class);
    private static final String RANGER_PLUGIN_TYPE = "hbase";
    private static final String RANGER_HBASE_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.hbase.RangerAuthorizationCoprocessor";
    private RangerPluginClassLoader pluginClassLoader;
    private MasterObserver implMasterObserver;
    private RegionObserver implRegionObserver;
    private RegionServerObserver implRegionServerObserver;
    private BulkLoadObserver implBulkLoadObserver;
    private AccessControlProtos.AccessControlService.Interface implAccessControlService;
    private MasterCoprocessor implMasterCoprocessor;
    private RegionCoprocessor implRegionCoprocessor;
    private RegionServerCoprocessor implRegionServerCoporcessor;

    public RangerAuthorizationCoprocessor() {
        LOG.debug("==> RangerAuthorizationCoprocessor.RangerAuthorizationCoprocessor()");
        this.init();
        LOG.debug("<== RangerAuthorizationCoprocessor.RangerAuthorizationCoprocessor()");
    }

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public Optional<EndpointObserver> getEndpointObserver() {
        return Optional.of(this);
    }

    public Optional<BulkLoadObserver> getBulkLoadObserver() {
        return Optional.of(this);
    }

    public Optional<MasterObserver> getMasterObserver() {
        return Optional.of(this);
    }

    public Optional<RegionServerObserver> getRegionServerObserver() {
        return Optional.of(this);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "start");){
            if (env instanceof MasterCoprocessorEnvironment) {
                this.implMasterCoprocessor.start(env);
            } else if (env instanceof RegionServerCoprocessorEnvironment) {
                this.implRegionServerCoporcessor.start(env);
            } else if (env instanceof RegionCoprocessorEnvironment) {
                this.implRegionCoprocessor.start(env);
            }
        }
    }

    public Iterable<Service> getServices() {
        return Collections.singleton(AccessControlProtos.AccessControlService.newReflectiveService((AccessControlProtos.AccessControlService.Interface)this));
    }

    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preCreateTable");){
            this.implMasterObserver.preCreateTable(c, desc, regions);
        }
    }

    public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCreateTable");){
            this.implMasterObserver.postCreateTable(ctx, desc, regions);
        }
    }

    public void preCreateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preCreateTableAction");){
            this.implMasterObserver.preCreateTableAction(ctx, desc, regions);
        }
    }

    public void postCompletedCreateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCompletedCreateTableAction");){
            this.implMasterObserver.postCompletedCreateTableAction(ctx, desc, regions);
        }
    }

    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preDeleteTable");){
            this.implMasterObserver.preDeleteTable(c, tableName);
        }
    }

    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postDeleteTable");){
            this.implMasterObserver.postDeleteTable(ctx, tableName);
        }
    }

    public void preDeleteTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preDeleteTableAction");){
            this.implMasterObserver.preDeleteTableAction(ctx, tableName);
        }
    }

    public void postCompletedDeleteTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCompletedDeleteTableAction");){
            this.implMasterObserver.postCompletedDeleteTableAction(ctx, tableName);
        }
    }

    public void preTruncateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preTruncateTable");){
            this.implMasterObserver.preTruncateTable(ctx, tableName);
        }
    }

    public void postTruncateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postTruncateTable");){
            this.implMasterObserver.postTruncateTable(ctx, tableName);
        }
    }

    public void preTruncateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preTruncateTableAction");){
            this.implMasterObserver.preTruncateTableAction(ctx, tableName);
        }
    }

    public void postCompletedTruncateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCompletedTruncateTableAction");){
            this.implMasterObserver.postCompletedTruncateTableAction(ctx, tableName);
        }
    }

    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, TableDescriptor htd) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preModifyTable");){
            this.implMasterObserver.preModifyTable(c, tableName, htd);
        }
    }

    public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, TableDescriptor htd) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postModifyTable");){
            this.implMasterObserver.postModifyTable(ctx, tableName, htd);
        }
    }

    public void preModifyTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, TableDescriptor htd) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preModifyTableAction");){
            this.implMasterObserver.preModifyTableAction(ctx, tableName, htd);
        }
    }

    public void postCompletedModifyTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, TableDescriptor htd) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCompletedModifyTableAction");){
            this.implMasterObserver.postCompletedModifyTableAction(ctx, tableName, htd);
        }
    }

    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preEnableTable");){
            this.implMasterObserver.preEnableTable(c, tableName);
        }
    }

    public void postEnableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postEnableTable");){
            this.implMasterObserver.postEnableTable(ctx, tableName);
        }
    }

    public void preEnableTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preEnableTableAction");){
            this.implMasterObserver.preEnableTableAction(ctx, tableName);
        }
    }

    public void postCompletedEnableTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCompletedEnableTableAction");){
            this.implMasterObserver.postCompletedEnableTableAction(ctx, tableName);
        }
    }

    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preDisableTable");){
            this.implMasterObserver.preDisableTable(c, tableName);
        }
    }

    public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postDisableTable");){
            this.implMasterObserver.postDisableTable(ctx, tableName);
        }
    }

    public void preDisableTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preDisableTableAction");){
            this.implMasterObserver.preDisableTableAction(ctx, tableName);
        }
    }

    public void postCompletedDisableTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCompletedDisableTableAction");){
            this.implMasterObserver.postCompletedDisableTableAction(ctx, tableName);
        }
    }

    public void preAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> observerContext, long procId) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preAbortProcedure");){
            this.implMasterObserver.preAbortProcedure(observerContext, procId);
        }
    }

    public void postAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> observerContext) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postAbortProcedure");){
            this.implMasterObserver.postAbortProcedure(observerContext);
        }
    }

    public void preGetProcedures(ObserverContext<MasterCoprocessorEnvironment> observerContext) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preGetProcedures");){
            this.implMasterObserver.preGetProcedures(observerContext);
        }
    }

    public void postGetProcedures(ObserverContext<MasterCoprocessorEnvironment> observerContext) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postGetProcedures");){
            this.implMasterObserver.postGetProcedures(observerContext);
        }
    }

    public void preMove(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preMove");){
            this.implMasterObserver.preMove(c, region, srcServer, destServer);
        }
    }

    public void postMove(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postMove");){
            this.implMasterObserver.postMove(ctx, region, srcServer, destServer);
        }
    }

    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preAssign");){
            this.implMasterObserver.preAssign(c, regionInfo);
        }
    }

    public void postAssign(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo regionInfo) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postAssign");){
            this.implMasterObserver.postAssign(ctx, regionInfo);
        }
    }

    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo, boolean force) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preUnassign");){
            this.implMasterObserver.preUnassign(c, regionInfo, force);
        }
    }

    public void postUnassign(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo regionInfo, boolean force) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postUnassign");){
            this.implMasterObserver.postUnassign(ctx, regionInfo, force);
        }
    }

    public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preRegionOffline");){
            this.implMasterObserver.preRegionOffline(c, regionInfo);
        }
    }

    public void postRegionOffline(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo regionInfo) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postRegionOffline");){
            this.implMasterObserver.postRegionOffline(ctx, regionInfo);
        }
    }

    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> c, BalanceRequest request) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preBalance");){
            this.implMasterObserver.preBalance(c, request);
        }
    }

    public void postBalance(ObserverContext<MasterCoprocessorEnvironment> ctx, BalanceRequest request, List<RegionPlan> plans) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postBalance");){
            this.implMasterObserver.postBalance(ctx, request, plans);
        }
    }

    public void preSetSplitOrMergeEnabled(ObserverContext<MasterCoprocessorEnvironment> arg0, boolean arg1, MasterSwitchType arg2) throws IOException {
    }

    public void postSetSplitOrMergeEnabled(ObserverContext<MasterCoprocessorEnvironment> arg0, boolean arg1, MasterSwitchType arg2) throws IOException {
    }

    public void preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean newValue) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preBalanceSwitch");){
            this.implMasterObserver.preBalanceSwitch(c, newValue);
        }
    }

    public void postBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean oldValue, boolean newValue) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postBalanceSwitch");){
            this.implMasterObserver.postBalanceSwitch(ctx, oldValue, newValue);
        }
    }

    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preShutdown");){
            this.implMasterObserver.preShutdown(c);
        }
    }

    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preStopMaster");){
            this.implMasterObserver.preStopMaster(c);
        }
    }

    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postStartMaster");){
            this.implMasterObserver.postStartMaster(ctx);
        }
    }

    public void preMasterInitialization(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preMasterInitialization");){
            this.implMasterObserver.preMasterInitialization(ctx);
        }
    }

    public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preSnapshot");){
            this.implMasterObserver.preSnapshot(ctx, snapshot, hTableDescriptor);
        }
    }

    public void postSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postSnapshot");){
            this.implMasterObserver.postSnapshot(ctx, snapshot, hTableDescriptor);
        }
    }

    public void preListSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preListSnapshot");){
            this.implMasterObserver.preListSnapshot(ctx, snapshot);
        }
    }

    public void postListSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postListSnapshot");){
            this.implMasterObserver.postListSnapshot(ctx, snapshot);
        }
    }

    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preCloneSnapshot");){
            this.implMasterObserver.preCloneSnapshot(ctx, snapshot, hTableDescriptor);
        }
    }

    public void postCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCloneSnapshot");){
            this.implMasterObserver.postCloneSnapshot(ctx, snapshot, hTableDescriptor);
        }
    }

    public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preRestoreSnapshot");){
            this.implMasterObserver.preRestoreSnapshot(ctx, snapshot, hTableDescriptor);
        }
    }

    public void postRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postRestoreSnapshot");){
            this.implMasterObserver.postRestoreSnapshot(ctx, snapshot, hTableDescriptor);
        }
    }

    public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preDeleteSnapshot");){
            this.implMasterObserver.preDeleteSnapshot(ctx, snapshot);
        }
    }

    public void postDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postDeleteSnapshot");){
            this.implMasterObserver.postDeleteSnapshot(ctx, snapshot);
        }
    }

    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<TableDescriptor> descriptors, String regex) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preGetTableDescriptors");){
            this.implMasterObserver.preGetTableDescriptors(ctx, tableNamesList, descriptors, regex);
        }
    }

    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<TableDescriptor> descriptors, String regex) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postGetTableDescriptors");){
            this.implMasterObserver.postGetTableDescriptors(ctx, tableNamesList, descriptors, regex);
        }
    }

    public void preGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableDescriptor> descriptors, String regex) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preGetTableNames");){
            this.implMasterObserver.preGetTableNames(ctx, descriptors, regex);
        }
    }

    public void postGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableDescriptor> descriptors, String regex) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postGetTableNames");){
            this.implMasterObserver.postGetTableNames(ctx, descriptors, regex);
        }
    }

    public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preCreateNamespace");){
            this.implMasterObserver.preCreateNamespace(ctx, ns);
        }
    }

    public void postCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCreateNamespace");){
            this.implMasterObserver.postCreateNamespace(ctx, ns);
        }
    }

    public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preDeleteNamespace");){
            this.implMasterObserver.preDeleteNamespace(ctx, namespace);
        }
    }

    public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postDeleteNamespace");){
            this.implMasterObserver.postDeleteNamespace(ctx, namespace);
        }
    }

    public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preModifyNamespace");){
            this.implMasterObserver.preModifyNamespace(ctx, ns);
        }
    }

    public void postModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postModifyNamespace");){
            this.implMasterObserver.postModifyNamespace(ctx, ns);
        }
    }

    public void preGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preGetNamespaceDescriptor");){
            this.implMasterObserver.preGetNamespaceDescriptor(ctx, namespace);
        }
    }

    public void postGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postGetNamespaceDescriptor");){
            this.implMasterObserver.postGetNamespaceDescriptor(ctx, ns);
        }
    }

    public void preListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<NamespaceDescriptor> descriptors) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preListNamespaceDescriptors");){
            this.implMasterObserver.preListNamespaceDescriptors(ctx, descriptors);
        }
    }

    public void postListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<NamespaceDescriptor> descriptors) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postListNamespaceDescriptors");){
            this.implMasterObserver.postListNamespaceDescriptors(ctx, descriptors);
        }
    }

    public void preTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preTableFlush");){
            this.implMasterObserver.preTableFlush(ctx, tableName);
        }
    }

    public void postTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postTableFlush");){
            this.implMasterObserver.postTableFlush(ctx, tableName);
        }
    }

    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, GlobalQuotaSettings quotas) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preSetUserQuota");){
            this.implMasterObserver.preSetUserQuota(ctx, userName, quotas);
        }
    }

    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, GlobalQuotaSettings quotas) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postSetUserQuota");){
            this.implMasterObserver.postSetUserQuota(ctx, userName, quotas);
        }
    }

    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preSetUserQuota");){
            this.implMasterObserver.preSetUserQuota(ctx, userName, tableName, quotas);
        }
    }

    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postSetUserQuota");){
            this.implMasterObserver.postSetUserQuota(ctx, userName, tableName, quotas);
        }
    }

    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, GlobalQuotaSettings quotas) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preSetUserQuota");){
            this.implMasterObserver.preSetUserQuota(ctx, userName, namespace, quotas);
        }
    }

    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, GlobalQuotaSettings quotas) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postSetUserQuota");){
            this.implMasterObserver.postSetUserQuota(ctx, userName, quotas);
        }
    }

    public void preSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preSetTableQuota");){
            this.implMasterObserver.preSetTableQuota(ctx, tableName, quotas);
        }
    }

    public void postSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postSetTableQuota");){
            this.implMasterObserver.postSetTableQuota(ctx, tableName, quotas);
        }
    }

    public void preSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, GlobalQuotaSettings quotas) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preSetNamespaceQuota");){
            this.implMasterObserver.preSetNamespaceQuota(ctx, namespace, quotas);
        }
    }

    public void postSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, GlobalQuotaSettings quotas) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postSetNamespaceQuota");){
            this.implMasterObserver.postSetNamespaceQuota(ctx, namespace, quotas);
        }
    }

    public void preMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
    }

    public void postMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
    }

    public void preMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
    }

    public void postMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
    }

    public void preAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void postAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void preRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void postRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preOpen");){
            this.implRegionObserver.preOpen(e);
        }
    }

    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postOpen");){
            this.implRegionObserver.postOpen(c);
        }
    }

    public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e, FlushLifeCycleTracker tracker) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preFlush");){
            this.implRegionObserver.preFlush(e, tracker);
        }
    }

    public InternalScanner preFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, FlushLifeCycleTracker tracker) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preFlush");){
            InternalScanner internalScanner = this.implRegionObserver.preFlush(c, store, scanner, tracker);
            return internalScanner;
        }
    }

    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c, FlushLifeCycleTracker tracker) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postFlush");){
            this.implRegionObserver.postFlush(c, tracker);
        }
    }

    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile, FlushLifeCycleTracker tracker) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postFlush");){
            this.implRegionObserver.postFlush(c, store, resultFile, tracker);
        }
    }

    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends StoreFile> candidates, CompactionLifeCycleTracker request) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preCompactSelection");){
            this.implRegionObserver.preCompactSelection(c, store, candidates, request);
        }
    }

    public void postCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends StoreFile> selected, CompactionLifeCycleTracker tracker, CompactionRequest request) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCompactSelection");){
            this.implRegionObserver.postCompactSelection(c, store, selected, tracker, request);
        }
    }

    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preCompact");){
            InternalScanner internalScanner = this.implRegionObserver.preCompact(c, store, scanner, scanType, tracker, request);
            return internalScanner;
        }
    }

    public void postCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCompact");){
            this.implRegionObserver.postCompact(c, store, resultFile, tracker, request);
        }
    }

    public void preClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preClose");){
            this.implRegionObserver.preClose(e, abortRequested);
        }
    }

    public void postClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postClose");){
            this.implRegionObserver.postClose(c, abortRequested);
        }
    }

    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> rEnv, Get get, List<Cell> result) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preGetOp");){
            this.implRegionObserver.preGetOp(rEnv, get, result);
        }
    }

    public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postGetOp");){
            this.implRegionObserver.postGetOp(c, get, result);
        }
    }

    public boolean preExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preExists");){
            boolean bl = this.implRegionObserver.preExists(c, get, exists);
            return bl;
        }
    }

    public boolean postExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postExists");){
            boolean bl = this.implRegionObserver.postExists(c, get, exists);
            return bl;
        }
    }

    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "prePut");){
            this.implRegionObserver.prePut(c, put, edit, durability);
        }
    }

    public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postPut");){
            this.implRegionObserver.postPut(c, put, edit, durability);
        }
    }

    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preDelete");){
            this.implRegionObserver.preDelete(c, delete, edit, durability);
        }
    }

    public void prePrepareTimeStampForDeleteVersion(ObserverContext<RegionCoprocessorEnvironment> c, Mutation mutation, Cell cell, byte[] byteNow, Get get) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "prePrepareTimeStampForDeleteVersion");){
            this.implRegionObserver.prePrepareTimeStampForDeleteVersion(c, mutation, cell, byteNow, get);
        }
    }

    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postDelete");){
            this.implRegionObserver.postDelete(c, delete, edit, durability);
        }
    }

    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preBatchMutate");){
            this.implRegionObserver.preBatchMutate(c, miniBatchOp);
        }
    }

    public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postBatchMutate");){
            this.implRegionObserver.postBatchMutate(c, miniBatchOp);
        }
    }

    public void postStartRegionOperation(ObserverContext<RegionCoprocessorEnvironment> ctx, Region.Operation operation) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postStartRegionOperation");){
            this.implRegionObserver.postStartRegionOperation(ctx, operation);
        }
    }

    public void postCloseRegionOperation(ObserverContext<RegionCoprocessorEnvironment> ctx, Region.Operation operation) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCloseRegionOperation");){
            this.implRegionObserver.postCloseRegionOperation(ctx, operation);
        }
    }

    public void postBatchMutateIndispensably(ObserverContext<RegionCoprocessorEnvironment> ctx, MiniBatchOperationInProgress<Mutation> miniBatchOp, boolean success) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postBatchMutateIndispensably");){
            this.implRegionObserver.postBatchMutateIndispensably(ctx, miniBatchOp, success);
        }
    }

    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preCheckAndPut");){
            boolean bl = this.implRegionObserver.preCheckAndPut(c, row, family, qualifier, compareOp, comparator, put, result);
            return bl;
        }
    }

    public boolean preCheckAndPutAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preCheckAndPutAfterRowLock");){
            boolean bl = this.implRegionObserver.preCheckAndPutAfterRowLock(c, row, family, qualifier, compareOp, comparator, put, result);
            return bl;
        }
    }

    public boolean postCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCheckAndPut");){
            boolean bl = this.implRegionObserver.postCheckAndPut(c, row, family, qualifier, compareOp, comparator, put, result);
            return bl;
        }
    }

    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preCheckAndDelete");){
            boolean bl = this.implRegionObserver.preCheckAndDelete(c, row, family, qualifier, compareOp, comparator, delete, result);
            return bl;
        }
    }

    public boolean preCheckAndDeleteAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preCheckAndDeleteAfterRowLock");){
            boolean bl = this.implRegionObserver.preCheckAndDeleteAfterRowLock(c, row, family, qualifier, compareOp, comparator, delete, result);
            return bl;
        }
    }

    public boolean postCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCheckAndDelete");){
            boolean bl = this.implRegionObserver.postCheckAndDelete(c, row, family, qualifier, compareOp, comparator, delete, result);
            return bl;
        }
    }

    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preAppend");){
            Result result = this.implRegionObserver.preAppend(c, append);
            return result;
        }
    }

    public Result preAppendAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preAppendAfterRowLock");){
            Result result = this.implRegionObserver.preAppendAfterRowLock(c, append);
            return result;
        }
    }

    public Result postAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append, Result result) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postAppend");){
            Result result2 = this.implRegionObserver.postAppend(c, append, result);
            return result2;
        }
    }

    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preIncrement");){
            Result result = this.implRegionObserver.preIncrement(c, increment);
            return result;
        }
    }

    public Result preIncrementAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preIncrementAfterRowLock");){
            Result result = this.implRegionObserver.preIncrementAfterRowLock(c, increment);
            return result;
        }
    }

    public Result postIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment, Result result) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postIncrement");){
            Result result2 = this.implRegionObserver.postIncrement(c, increment, result);
            return result2;
        }
    }

    public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preScannerOpen");){
            this.implRegionObserver.preScannerOpen(c, scan);
        }
    }

    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postScannerOpen");){
            RegionScanner regionScanner = this.implRegionObserver.postScannerOpen(c, scan, s);
            return regionScanner;
        }
    }

    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preScannerNext");){
            boolean bl = this.implRegionObserver.preScannerNext(c, s, result, limit, hasNext);
            return bl;
        }
    }

    public boolean postScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postScannerNext");){
            boolean bl = this.implRegionObserver.postScannerNext(c, s, result, limit, hasNext);
            return bl;
        }
    }

    public boolean postScannerFilterRow(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, Cell currentCell, boolean hasMore) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postScannerFilterRow");){
            boolean bl = this.implRegionObserver.postScannerFilterRow(c, s, currentCell, hasMore);
            return bl;
        }
    }

    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preScannerClose");){
            this.implRegionObserver.preScannerClose(c, s);
        }
    }

    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postScannerClose");){
            this.implRegionObserver.postScannerClose(c, s);
        }
    }

    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preBulkLoadHFile");){
            this.implRegionObserver.preBulkLoadHFile(ctx, familyPaths);
        }
    }

    public void postBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths, Map<byte[], List<Path>> finalPaths) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postBulkLoadHFile");){
            this.implRegionObserver.postBulkLoadHFile(ctx, familyPaths, finalPaths);
        }
    }

    public StoreFileReader preStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFileReader reader) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preStoreFileReaderOpen");){
            StoreFileReader storeFileReader = this.implRegionObserver.preStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, reader);
            return storeFileReader;
        }
    }

    public StoreFileReader postStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFileReader reader) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postStoreFileReaderOpen");){
            StoreFileReader storeFileReader = this.implRegionObserver.postStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, reader);
            return storeFileReader;
        }
    }

    public Cell postMutationBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, RegionObserver.MutationType opType, Mutation mutation, Cell oldCell, Cell newCell) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postMutationBeforeWAL");){
            Cell cell = this.implRegionObserver.postMutationBeforeWAL(ctx, opType, mutation, oldCell, newCell);
            return cell;
        }
    }

    public DeleteTracker postInstantiateDeleteTracker(ObserverContext<RegionCoprocessorEnvironment> ctx, DeleteTracker delTracker) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postInstantiateDeleteTracker");){
            DeleteTracker deleteTracker = this.implRegionObserver.postInstantiateDeleteTracker(ctx, delTracker);
            return deleteTracker;
        }
    }

    public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> env) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preStopRegionServer");){
            this.implRegionServerObserver.preStopRegionServer(env);
        }
    }

    public void preRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preRollWALWriterRequest");){
            this.implRegionServerObserver.preRollWALWriterRequest(ctx);
        }
    }

    public void postRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postRollWALWriterRequest");){
            this.implRegionServerObserver.postRollWALWriterRequest(ctx);
        }
    }

    public ReplicationEndpoint postCreateReplicationEndPoint(ObserverContext<RegionServerCoprocessorEnvironment> ctx, ReplicationEndpoint endpoint) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "postCreateReplicationEndPoint");){
            ReplicationEndpoint replicationEndpoint = this.implRegionServerObserver.postCreateReplicationEndPoint(ctx, endpoint);
            return replicationEndpoint;
        }
    }

    public void prePrepareBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "prePrepareBulkLoad");){
            this.implBulkLoadObserver.prePrepareBulkLoad(ctx);
        }
    }

    public void preCleanupBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "preCleanupBulkLoad");){
            this.implBulkLoadObserver.preCleanupBulkLoad(ctx);
        }
    }

    public void grant(RpcController controller, AccessControlProtos.GrantRequest request, RpcCallback<AccessControlProtos.GrantResponse> done) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "grant");){
            this.implAccessControlService.grant(controller, request, done);
        }
    }

    public void revoke(RpcController controller, AccessControlProtos.RevokeRequest request, RpcCallback<AccessControlProtos.RevokeResponse> done) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "revoke");){
            this.implAccessControlService.revoke(controller, request, done);
        }
    }

    public void getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request, RpcCallback<AccessControlProtos.GetUserPermissionsResponse> done) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "getUserPermissions");){
            this.implAccessControlService.getUserPermissions(controller, request, done);
        }
    }

    public void checkPermissions(RpcController controller, AccessControlProtos.CheckPermissionsRequest request, RpcCallback<AccessControlProtos.CheckPermissionsResponse> done) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "checkPermissions");){
            this.implAccessControlService.checkPermissions(controller, request, done);
        }
    }

    public void hasPermission(RpcController controller, AccessControlProtos.HasPermissionRequest request, RpcCallback<AccessControlProtos.HasPermissionResponse> done) {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "hasPermission");){
            this.implAccessControlService.hasPermission(controller, request, done);
        }
    }

    public void preBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName) throws IOException {
    }

    public void postBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName, boolean balancerRan) throws IOException {
    }

    public void postDispatchMerge(ObserverContext<MasterCoprocessorEnvironment> arg0, HRegionInfo arg1, HRegionInfo arg2) throws IOException {
    }

    public void preDispatchMerge(ObserverContext<MasterCoprocessorEnvironment> arg0, HRegionInfo arg1, HRegionInfo arg2) throws IOException {
    }

    private void init() {
        LOG.debug("==> RangerAuthorizationCoprocessor.init()");
        try {
            this.pluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_HBASE_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.pluginClassLoader);
            try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "init");){
                Object impl = cls.newInstance();
                this.implAccessControlService = (AccessControlProtos.AccessControlService.Interface)impl;
                this.implMasterCoprocessor = (MasterCoprocessor)impl;
                this.implRegionCoprocessor = (RegionCoprocessor)impl;
                this.implRegionServerCoporcessor = (RegionServerCoprocessor)impl;
                this.implMasterObserver = (MasterObserver)impl;
                this.implRegionObserver = (RegionObserver)impl;
                this.implRegionServerObserver = (RegionServerObserver)impl;
                this.implBulkLoadObserver = (BulkLoadObserver)impl;
            }
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerHbasePlugin", (Throwable)e);
        }
        LOG.debug("<== RangerAuthorizationCoprocessor.init()");
    }
}

