/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.elasticsearch.client;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.elasticsearch.client.ElasticsearchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchResourceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchResourceMgr.class);
    public static final String INDEX = "index";

    private ElasticsearchResourceMgr() {
    }

    public static Map<String, Object> validateConfig(String serviceName, Map<String, String> configs) {
        Map<String, Object> ret;
        LOG.debug("==> ElasticsearchResourceMgr.validateConfig() serviceName: {}, configs: {}", (Object)serviceName, configs);
        try {
            ret = ElasticsearchClient.connectionTest(serviceName, configs);
        }
        catch (Exception e) {
            LOG.error("<== ElasticsearchResourceMgr.validateConfig() error: {}", (Object)String.valueOf(e));
            throw e;
        }
        LOG.debug("<== ElasticsearchResourceMgr.validateConfig() result: {}", ret);
        return ret;
    }

    public static List<String> getElasticsearchResources(String serviceName, Map<String, String> configs, ResourceLookupContext context) {
        String userInput = context.getUserInput();
        String resource = context.getResourceName();
        Map resourceMap = context.getResources();
        LOG.debug("==> ElasticsearchResourceMgr.getElasticsearchResources()  userInput: {}, resource: {}, resourceMap: {}", new Object[]{userInput, resource, resourceMap});
        if (MapUtils.isEmpty(configs)) {
            LOG.error("Connection config is empty!");
            return null;
        }
        if (StringUtils.isEmpty((String)userInput)) {
            LOG.warn("User input is empty, set default value : *");
            userInput = "*";
        }
        List<String> resultList = null;
        if (StringUtils.isNotEmpty((String)resource) && resource.equals(INDEX)) {
            List existingConnectors = (List)resourceMap.get(INDEX);
            resultList = ElasticsearchClient.getElasticsearchClient(serviceName, configs).getIndexList(userInput, existingConnectors);
        }
        LOG.debug("<== ElasticsearchResourceMgr.getElasticsearchResources() result: {}", resultList);
        return resultList;
    }
}

