/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.elasticsearch.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchClient
extends BaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchClient.class);
    private static final String ELASTICSEARCH_INDEX_API_ENDPOINT = "/_all";
    private final String elasticsearchUrl;
    private final String userName;

    public ElasticsearchClient(String serviceName, Map<String, String> configs) {
        super(serviceName, configs, "elasticsearch-client");
        this.elasticsearchUrl = configs.get("elasticsearch.url");
        this.userName = configs.get("username");
        if (StringUtils.isEmpty((String)this.elasticsearchUrl)) {
            LOG.error("No value found for configuration 'elasticsearch.url'. Elasticsearch resource lookup will fail.");
        }
        if (StringUtils.isEmpty((String)this.userName)) {
            LOG.error("No value found for configuration 'username'. Elasticsearch resource lookup will fail.");
        }
        LOG.debug("Elasticsearch client is build with url: [{}], user: [{}].", (Object)this.elasticsearchUrl, (Object)this.userName);
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) {
        ElasticsearchClient elasticsearchClient = ElasticsearchClient.getElasticsearchClient(serviceName, configs);
        List<String> indexList = elasticsearchClient.getIndexList(null, null);
        boolean connectivityStatus = false;
        if (CollectionUtils.isNotEmpty(indexList)) {
            LOG.debug("ConnectionTest list size {} elasticsearch indices.", (Object)indexList.size());
            connectivityStatus = true;
        }
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        if (connectivityStatus) {
            String successMsg = "ConnectionTest Successful.";
            BaseClient.generateResponseDataMap((boolean)true, (String)successMsg, (String)successMsg, null, null, responseData);
        } else {
            String failureMsg = "Unable to retrieve any elasticsearch indices using given parameters.";
            BaseClient.generateResponseDataMap((boolean)false, (String)failureMsg, (String)(failureMsg + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info."), null, null, responseData);
        }
        return responseData;
    }

    public static ElasticsearchClient getElasticsearchClient(String serviceName, Map<String, String> configs) {
        LOG.debug("Getting elasticsearchClient for datasource: {}", (Object)serviceName);
        if (MapUtils.isEmpty(configs)) {
            String msgDesc = "Could not connect elasticsearch as connection configMap is empty.";
            LOG.error(msgDesc);
            HadoopException hdpException = new HadoopException(msgDesc);
            hdpException.generateResponseDataMap(false, msgDesc, msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
            throw hdpException;
        }
        ElasticsearchClient elasticsearchClient = new ElasticsearchClient(serviceName, configs);
        return elasticsearchClient;
    }

    public List<String> getIndexList(String indexMatching, List<String> existingIndices) {
        LOG.debug("Get elasticsearch index list for indexMatching: {}, existingIndices: {}", (Object)indexMatching, existingIndices);
        Subject subj = this.getLoginSubject();
        if (subj == null) {
            return Collections.emptyList();
        }
        List ret = Subject.doAs(subj, () -> {
            ClientResponse response;
            Map index2detailMap;
            String indexApi;
            if (StringUtils.isNotEmpty((String)indexMatching)) {
                indexApi = '/' + indexMatching;
                if (!indexApi.endsWith("*")) {
                    indexApi = indexApi + "*";
                }
            } else {
                indexApi = ELASTICSEARCH_INDEX_API_ENDPOINT;
            }
            if (MapUtils.isEmpty((Map)(index2detailMap = (Map)this.getElasticsearchResourceResponse(response = ElasticsearchClient.getClientResponse(this.elasticsearchUrl, indexApi, this.userName), new TypeToken<HashMap<String, Object>>(){}.getType())))) {
                return Collections.emptyList();
            }
            Set indexResponses = index2detailMap.keySet();
            if (CollectionUtils.isEmpty(indexResponses)) {
                return Collections.emptyList();
            }
            return ElasticsearchClient.filterResourceFromResponse(indexMatching, existingIndices, new ArrayList<String>(indexResponses));
        });
        LOG.debug("Get elasticsearch index list result: {}", (Object)ret);
        return ret;
    }

    private static ClientResponse getClientResponse(String elasticsearchUrl, String elasticsearchApi, String userName) {
        Object[] elasticsearchUrls = elasticsearchUrl.trim().split("[,;]");
        if (ArrayUtils.isEmpty((Object[])elasticsearchUrls)) {
            return null;
        }
        ClientResponse response = null;
        Client client = Client.create();
        for (Object currentUrl : elasticsearchUrls) {
            if (StringUtils.isBlank((String)currentUrl)) continue;
            String url = ((String)currentUrl).trim() + elasticsearchApi;
            try {
                response = ElasticsearchClient.getClientResponse(url, client, userName);
                if (response == null) continue;
                if (response.getStatus() == 200) break;
                response.close();
            }
            catch (Throwable t) {
                String msgDesc = "Exception while getting elasticsearch response, elasticsearchUrl: " + url;
                LOG.error(msgDesc, t);
            }
        }
        client.destroy();
        return response;
    }

    private static ClientResponse getClientResponse(String url, Client client, String userName) {
        LOG.debug("getClientResponse():calling {}", (Object)url);
        ClientResponse response = (ClientResponse)((WebResource.Builder)client.resource(url).accept(new String[]{"application/json"}).header("userName", (Object)userName)).get(ClientResponse.class);
        if (response != null) {
            LOG.debug("getClientResponse():response.getStatus()= {}", (Object)response.getStatus());
            if (response.getStatus() != 200) {
                LOG.warn("getClientResponse():response.getStatus()= {} for URL {}, failed to get elasticsearch resource list, response= {}", new Object[]{response.getStatus(), url, response.getEntity(String.class)});
            }
        }
        return response;
    }

    private <T> T getElasticsearchResourceResponse(ClientResponse response, Type type) {
        Object resource;
        block8: {
            try {
                if (response != null && response.getStatus() == 200) {
                    String jsonString = (String)response.getEntity(String.class);
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    resource = gson.fromJson(jsonString, type);
                    break block8;
                }
                String msgDesc = "Unable to get a valid response for expected mime type : [application/json], elasticsearchUrl: " + this.elasticsearchUrl + " - got null response.";
                LOG.error(msgDesc);
                HadoopException hdpException = new HadoopException(msgDesc);
                hdpException.generateResponseDataMap(false, msgDesc, msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                throw hdpException;
            }
            catch (HadoopException he) {
                throw he;
            }
            catch (Throwable t) {
                String msgDesc = "Exception while getting elasticsearch resource response, elasticsearchUrl: " + this.elasticsearchUrl;
                HadoopException hdpException = new HadoopException(msgDesc, t);
                LOG.error(msgDesc, t);
                hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)t), msgDesc + " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.", null, null);
                throw hdpException;
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        return (T)resource;
    }

    private static List<String> filterResourceFromResponse(String resourceMatching, List<String> existingResources, List<String> resourceResponses) {
        ArrayList<String> resources = new ArrayList<String>();
        for (String resourceResponse : resourceResponses) {
            if (CollectionUtils.isNotEmpty(existingResources) && existingResources.contains(resourceResponse) || !StringUtils.isEmpty((String)resourceMatching) && !resourceMatching.startsWith("*") && !resourceResponse.toLowerCase().startsWith(resourceMatching.toLowerCase())) continue;
            LOG.debug("filterResourceFromResponse(): Adding elasticsearch resource {}", (Object)resourceResponse);
            resources.add(resourceResponse);
        }
        return resources;
    }
}

