/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.elasticsearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.elasticsearch.client.ElasticsearchResourceMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceElasticsearch
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceElasticsearch.class);
    public static final String ACCESS_TYPE_READ = "read";

    private RangerServiceElasticsearch() {
    }

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public Map<String, Object> validateConfig() {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        LOG.debug("==> RangerServiceElasticsearch.validateConfig() service: {}", (Object)serviceName);
        if (this.configs != null) {
            try {
                ret = ElasticsearchResourceMgr.validateConfig(serviceName, this.configs);
            }
            catch (Exception e) {
                LOG.error("<== RangerServiceElasticsearch.validateConfig() error: {}", (Object)String.valueOf(e));
                throw e;
            }
        }
        LOG.debug("<== RangerServiceElasticsearch.validateConfig() result: {}", ret);
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        Map configs = this.getConfigs();
        LOG.debug("==> RangerServiceElasticsearch.lookupResource() context: {}", (Object)context);
        if (context != null) {
            try {
                ret = ElasticsearchResourceMgr.getElasticsearchResources(serviceName, configs, context);
            }
            catch (Exception e) {
                LOG.error("<==RangerServiceElasticsearch.lookupResource() error: {}", (Object)String.valueOf(e));
                throw e;
            }
        }
        LOG.debug("<== RangerServiceElasticsearch.lookupResource() result: {}", ret);
        return ret;
    }

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        LOG.debug("==> RangerServiceElasticsearch.getDefaultRangerPolicies()");
        List ret = super.getDefaultRangerPolicies();
        for (RangerPolicy defaultPolicy : ret) {
            if (!defaultPolicy.getName().contains("all") || !StringUtils.isNotBlank((String)this.lookUpUser)) continue;
            ArrayList<RangerPolicy.RangerPolicyItemAccess> accessListForLookupUser = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_READ));
            RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
            policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
            policyItemForLookupUser.setAccesses(accessListForLookupUser);
            policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
            defaultPolicy.addPolicyItem(policyItemForLookupUser);
        }
        LOG.debug("<== RangerServiceElasticsearch.getDefaultRangerPolicies()");
        return ret;
    }
}

