/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.elasticsearch.authorizer;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.elasticsearch.authorizer.RangerElasticsearchAccessControl;
import org.apache.ranger.authorization.elasticsearch.authorizer.RangerElasticsearchAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.services.elasticsearch.privilege.IndexPrivilegeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerElasticsearchAuthorizer
implements RangerElasticsearchAccessControl {
    private static final Logger LOG = LoggerFactory.getLogger(RangerElasticsearchAuthorizer.class);
    private static volatile RangerElasticsearchInnerPlugin elasticsearchPlugin;

    public RangerElasticsearchAuthorizer() {
        LOG.debug("==> RangerElasticsearchAuthorizer.RangerElasticsearchAuthorizer()");
        this.init();
        LOG.debug("<== RangerElasticsearchAuthorizer.RangerElasticsearchAuthorizer()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init() {
        LOG.debug("==> RangerElasticsearchAuthorizer.init()");
        RangerElasticsearchInnerPlugin plugin = elasticsearchPlugin;
        if (plugin == null) {
            Class<RangerElasticsearchAuthorizer> clazz = RangerElasticsearchAuthorizer.class;
            // MONITORENTER : org.apache.ranger.authorization.elasticsearch.authorizer.RangerElasticsearchAuthorizer.class
            plugin = elasticsearchPlugin;
            if (plugin == null) {
                plugin = new RangerElasticsearchInnerPlugin();
                plugin.init();
                elasticsearchPlugin = plugin;
            }
            // MONITOREXIT : clazz
        }
        LOG.debug("<== RangerElasticsearchAuthorizer.init()");
    }

    public boolean checkPermission(String user, List<String> groups, String index, String action, String clientIPAddress) {
        LOG.debug("==> RangerElasticsearchAuthorizer.checkPermission( user={}, groups={}, index={}, action={}, clientIPAddress={})", new Object[]{user, groups, index, action, clientIPAddress});
        boolean ret = false;
        if (elasticsearchPlugin != null) {
            String privilege;
            RangerElasticsearchAccessRequest request;
            RangerAccessResult result;
            if (null == groups) {
                groups = new ArrayList<String>(MiscUtil.getGroupsForRequestUser((String)user));
            }
            if ((result = elasticsearchPlugin.isAccessAllowed((RangerAccessRequest)(request = new RangerElasticsearchAccessRequest(user, groups, index, privilege = IndexPrivilegeUtils.getPrivilegeFromAction(action), clientIPAddress)))) != null && result.getIsAllowed()) {
                ret = true;
            }
        }
        LOG.debug("<== RangerElasticsearchAuthorizer.checkPermission(): result={}", (Object)ret);
        return ret;
    }

    static class RangerElasticsearchAccessRequest
    extends RangerAccessRequestImpl {
        public RangerElasticsearchAccessRequest(String user, List<String> groups, String index, String privilege, String clientIPAddress) {
            super.setUser(user);
            if (CollectionUtils.isNotEmpty(groups)) {
                super.setUserGroups((Set)Sets.newHashSet(groups));
            }
            super.setResource((RangerAccessResource)new RangerElasticsearchResource(index));
            super.setAccessType(privilege);
            super.setAction(privilege);
            super.setClientIPAddress(clientIPAddress);
            super.setAccessTime(new Date());
        }
    }

    static class RangerElasticsearchResource
    extends RangerAccessResourceImpl {
        public RangerElasticsearchResource(String index) {
            if (StringUtils.isEmpty((String)index)) {
                index = "*";
            }
            this.setValue("index", index);
        }
    }

    static class RangerElasticsearchInnerPlugin
    extends RangerBasePlugin {
        public RangerElasticsearchInnerPlugin() {
            super("elasticsearch", "elasticsearch");
        }

        public void init() {
            super.init();
            RangerElasticsearchAuditHandler auditHandler = new RangerElasticsearchAuditHandler((Configuration)this.getConfig());
            super.setResultProcessor((RangerAccessResultProcessor)auditHandler);
        }
    }
}

