/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.elasticsearch.plugin.rest.filter;

import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.elasticsearch.plugin.authc.user.UsernamePasswordToken;
import org.apache.ranger.authorization.elasticsearch.plugin.utils.RequestUtils;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSecurityRestFilter
extends AbstractLifecycleComponent
implements RestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RangerSecurityRestFilter.class);
    private final RestHandler restHandler;
    private final ThreadContext threadContext;

    public RangerSecurityRestFilter(ThreadContext threadContext, RestHandler restHandler) {
        this.restHandler = restHandler;
        this.threadContext = threadContext;
    }

    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        UsernamePasswordToken user = UsernamePasswordToken.parseToken(request);
        if (user == null) {
            throw new ElasticsearchStatusException("Error: User is null, the request requires user authentication.", RestStatus.UNAUTHORIZED, new Object[0]);
        }
        LOG.debug("Success to parse user[{}] from request[{}].", (Object)user, (Object)request);
        this.threadContext.putTransient("username", (Object)user.getUsername());
        String clientIPAddress = RequestUtils.getClientIPAddress(request);
        if (StringUtils.isNotEmpty((String)clientIPAddress)) {
            this.threadContext.putTransient("ClientIPAddress", (Object)clientIPAddress);
        }
        this.restHandler.handleRequest(request, channel, client);
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
    }
}

