/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.elasticsearch.plugin.authc.user;

import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class UsernamePasswordToken {
    public static final String USERNAME = "username";
    public static final String BASIC_AUTH_PREFIX = "Basic ";
    public static final String BASIC_AUTH_HEADER = "Authorization";
    private String username;
    private String password;

    public UsernamePasswordToken(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public static UsernamePasswordToken parseToken(RestRequest request) {
        String userPass;
        Map headers = request.getHeaders();
        if (MapUtils.isEmpty((Map)headers)) {
            return null;
        }
        List authStrs = (List)headers.get(BASIC_AUTH_HEADER);
        if (CollectionUtils.isEmpty((Collection)authStrs)) {
            return null;
        }
        String authStr = (String)authStrs.get(0);
        if (StringUtils.isEmpty((String)authStr)) {
            return null;
        }
        try {
            userPass = new String(Base64.getUrlDecoder().decode(authStr.substring(BASIC_AUTH_PREFIX.length())));
        }
        catch (IllegalArgumentException e) {
            throw new ElasticsearchStatusException("Error: Failed to parse user authentication.", RestStatus.UNAUTHORIZED, (Throwable)e, new Object[0]);
        }
        int i = StringUtils.indexOf((String)userPass, (char)':');
        if (i <= 0) {
            throw new ElasticsearchStatusException("Error: Parse user authentication to get the wrong userPass[{}].", RestStatus.UNAUTHORIZED, new Object[]{userPass});
        }
        return new UsernamePasswordToken(StringUtils.substring((String)userPass, (int)0, (int)i), StringUtils.substring((String)userPass, (int)(i + 1), (int)userPass.length()));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        return "UsernamePasswordToken [username=" + this.username + ", password=******]";
    }
}

