/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger;

import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.ha.ActiveInstanceState;
import org.apache.ranger.ha.CuratorFactory;
import org.apache.ranger.ha.ServiceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangerHAInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(RangerHAInitializer.class);
    protected ServiceState serviceState;
    protected CuratorFactory curatorFactory;
    protected ActiveInstanceState activeInstanceState;

    public RangerHAInitializer() {
    }

    public RangerHAInitializer(Configuration configuration) {
        try {
            this.init(configuration);
        }
        catch (Exception e) {
            LOG.error("RangerHAInitializer initialization failed {}", (Object)e.getMessage());
        }
    }

    public void init(Configuration configuration) throws Exception {
        LOG.debug("==> RangerHAInitializer.init() initialization started ");
        this.serviceState = ServiceState.getInstance(configuration);
        this.curatorFactory = CuratorFactory.getInstance(configuration);
        this.activeInstanceState = new ActiveInstanceState(configuration, this.curatorFactory);
        LOG.debug("<== RangerHAInitializer.init() initialization completed ");
    }

    public abstract void stop();
}

