/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ha;

import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.AuthInfo;
import org.apache.hadoop.thirdparty.com.google.common.base.Charsets;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.ranger.ha.ServiceState;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperSecurityProperties {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceState.class);

    private ZookeeperSecurityProperties() {
    }

    public static ACL parseAcl(String aclString, ACL defaultAcl) {
        if (StringUtils.isEmpty((String)aclString)) {
            return defaultAcl;
        }
        return ZookeeperSecurityProperties.parseAcl(aclString);
    }

    public static ACL parseAcl(String aclString) {
        LOG.info(" inside parseAcl ");
        String[] aclComponents = ZookeeperSecurityProperties.getComponents(aclString, "acl", "scheme:id");
        return new ACL(31, new Id(aclComponents[0], aclComponents[1]));
    }

    public static AuthInfo parseAuth(String authString) {
        LOG.info(" inside parseAuth ");
        String[] authComponents = ZookeeperSecurityProperties.getComponents(authString, "authString", "scheme:authString");
        return new AuthInfo(authComponents[0], authComponents[1].getBytes(Charsets.UTF_8));
    }

    private static String[] getComponents(String securityString, String variableName, String formatExample) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)securityString) ? 1 : 0) != 0, (Object)String.format("%s cannot be null or empty. Needs to be of form %s", variableName, formatExample));
        String[] aclComponents = securityString.split(":", 2);
        if (aclComponents.length != 2) {
            throw new IllegalArgumentException(String.format("Invalid %s string. Needs to be of form %s", variableName, formatExample));
        }
        return aclComponents;
    }
}

