/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ha;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.ranger.ha.HAConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceServerIdSelector {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceServerIdSelector.class);

    private RangerServiceServerIdSelector() {
    }

    public static String selectServerId(Configuration configuration) throws Exception {
        int appPort;
        Object[] ids = HAConfiguration.getStringsConfig(configuration, ".server.ha.ids", null);
        String matchingServerId = null;
        boolean isSecure = HAConfiguration.getBooleanConfig(configuration, ".server.ha.ssl.enabled", false);
        int n = appPort = isSecure ? HAConfiguration.getIntConfig(configuration, ".service.https.port", -1) : HAConfiguration.getIntConfig(configuration, ".service.http.port", -1);
        if (appPort < 1) {
            LOG.warn("Service HTTP/HTTPS port is not configured correctly. Please configure properties {}{} and {}{}", new Object[]{HAConfiguration.getPrefix(configuration), ".service.https.port", HAConfiguration.getPrefix(configuration), ".service.http.port"});
        }
        for (String string : ids) {
            String hostPort = HAConfiguration.getStringConfig(configuration, ".server.ha.address." + string, null);
            LOG.info("==> RangerServiceServerIdSelector.selectServerId() id:{} hostPort:{}", (Object)string, (Object)hostPort);
            if (!StringUtils.isEmpty((String)hostPort)) {
                InetSocketAddress socketAddress;
                try {
                    socketAddress = NetUtils.createSocketAddr((String)hostPort, (int)appPort);
                    LOG.info("==> RangerServiceServerIdSelector.selectServerId() socketAddress[{}]", (Object)socketAddress);
                }
                catch (Exception e) {
                    LOG.error("Exception while trying to get socket address for {}", (Object)hostPort, (Object)e);
                    continue;
                }
                if (socketAddress.isUnresolved() || !NetUtils.isLocalAddress((InetAddress)socketAddress.getAddress()) || appPort != socketAddress.getPort()) continue;
                LOG.info("Found matched server id {} with host port: {}", (Object)string, (Object)hostPort);
                matchingServerId = string;
                break;
            }
            LOG.info("Could not find matching address entry for id: {}", (Object)string);
        }
        if (matchingServerId == null) {
            String msg = String.format("Could not find server id for this instance. Unable to find IDs matching any local host and port binding among %s", StringUtils.join((Object[])ids, (String)","));
            throw new Exception(msg);
        }
        return matchingServerId;
    }
}

