/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ha;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.ha.ActiveInstanceState;
import org.apache.ranger.ha.ActiveStateChangeHandler;
import org.apache.ranger.ha.CuratorFactory;
import org.apache.ranger.ha.HAConfiguration;
import org.apache.ranger.ha.RangerServiceServerIdSelector;
import org.apache.ranger.ha.ServiceState;
import org.apache.ranger.ha.service.HARangerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveInstanceElectorService
implements HARangerService,
LeaderLatchListener {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveInstanceElectorService.class);
    private final Configuration configuration;
    private final ServiceState serviceState;
    private final ActiveInstanceState activeInstanceState;
    private final Set<ActiveStateChangeHandler> activeStateChangeHandlerProviders;
    private final List<ActiveStateChangeHandler> activeStateChangeHandlers;
    private final CuratorFactory curatorFactory;
    private LeaderLatch leaderLatch;
    private String serverId;
    private static Long transitionCount = 0L;
    private static Long lastTranstionTime = 0L;

    public ActiveInstanceElectorService(Set<ActiveStateChangeHandler> activeStateChangeHandlerProviders, CuratorFactory curatorFactory, ActiveInstanceState activeInstanceState, ServiceState serviceState, Configuration configuration) throws Exception {
        this.configuration = configuration;
        this.activeStateChangeHandlerProviders = activeStateChangeHandlerProviders;
        this.activeStateChangeHandlers = new ArrayList<ActiveStateChangeHandler>();
        this.curatorFactory = curatorFactory;
        this.activeInstanceState = activeInstanceState;
        this.serviceState = serviceState;
    }

    @Override
    public void start() throws Exception {
        if (!HAConfiguration.isHAEnabled(this.configuration)) {
            LOG.info("HA is not enabled, no need to start leader election service");
            return;
        }
        this.cacheActiveStateChangeHandlers();
        this.serverId = RangerServiceServerIdSelector.selectServerId(this.configuration);
        this.joinElection();
    }

    @Override
    public void stop() throws Exception {
        if (!HAConfiguration.isHAEnabled(this.configuration)) {
            LOG.info("HA is not enabled, no need to stop leader election service");
            return;
        }
        try {
            this.leaderLatch.close();
            this.curatorFactory.close();
        }
        catch (IOException e) {
            LOG.error("Error closing leader latch", (Throwable)e);
        }
    }

    public void isLeader() {
        LOG.warn("Server instance with server id {} is elected as leader ", (Object)this.serverId);
        this.serviceState.becomingActive();
        try {
            for (ActiveStateChangeHandler handler : this.activeStateChangeHandlers) {
                handler.instanceIsActive();
            }
            this.activeInstanceState.update(this.serverId);
            this.serviceState.setActive();
            Long l = transitionCount;
            Long l2 = transitionCount = Long.valueOf(transitionCount + 1L);
            ActiveInstanceElectorService.setLastTranstionTime(Instant.now().toEpochMilli());
        }
        catch (Exception e) {
            LOG.error("Got exception while activating", (Throwable)e);
            this.serviceState.setPassive();
            this.rejoinElection();
        }
    }

    public void notLeader() {
        LOG.warn("Server instance with server id {} is removed as leader", (Object)this.serverId);
        this.serviceState.becomingPassive();
        for (int idx = this.activeStateChangeHandlers.size() - 1; idx >= 0; --idx) {
            try {
                this.activeStateChangeHandlers.get(idx).instanceIsPassive();
                continue;
            }
            catch (Exception e) {
                LOG.error("Error while reacting to passive state.", (Throwable)e);
            }
        }
        this.serviceState.setPassive();
        Long l = transitionCount;
        Long l2 = transitionCount = Long.valueOf(transitionCount + 1L);
        ActiveInstanceElectorService.setLastTranstionTime(Instant.now().toEpochMilli());
    }

    public static Long getTransitionCount() {
        return transitionCount;
    }

    public static Long getLastTranstionTime() {
        return lastTranstionTime;
    }

    public static void setLastTranstionTime(Long lastTranstionTime) {
        ActiveInstanceElectorService.lastTranstionTime = lastTranstionTime;
    }

    private void joinElection() {
        LOG.info("Starting leader election for {}", (Object)this.serverId);
        String zkRoot = HAConfiguration.getZookeeperProperties(this.configuration).getZkRoot();
        this.leaderLatch = this.curatorFactory.leaderLatchInstance(this.serverId, zkRoot);
        this.leaderLatch.addListener((LeaderLatchListener)this);
        try {
            this.leaderLatch.start();
            LOG.info("Leader latch started for {}.", (Object)this.serverId);
        }
        catch (Exception e) {
            LOG.info("Exception while starting leader latch for {}. ", (Object)this.serverId, (Object)e);
        }
    }

    private void cacheActiveStateChangeHandlers() {
        if (this.activeStateChangeHandlers.isEmpty()) {
            this.activeStateChangeHandlers.addAll(this.activeStateChangeHandlerProviders);
            LOG.info("activeStateChangeHandlers(): before reorder: {}", this.activeStateChangeHandlers);
        }
    }

    private void rejoinElection() {
        LOG.info(" inside rejoinElection ActiveInstanceElectorService");
        try {
            this.leaderLatch.close();
            this.joinElection();
        }
        catch (IOException e) {
            LOG.error("Error rejoining election", (Throwable)e);
        }
    }
}

