/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.orc.Writer;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.utils.AbstractRangerAuditWriter;
import org.apache.ranger.audit.utils.ORCFileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerORCAuditWriter
extends AbstractRangerAuditWriter {
    private static final Logger logger = LoggerFactory.getLogger(RangerORCAuditWriter.class);
    protected static final String ORC_FILE_EXTENSION = ".orc";
    protected volatile ORCFileUtil orcFileUtil;
    protected Writer orcLogWriter;
    protected String fileType = "orc";
    protected String compression;
    protected int orcBufferSize;
    protected int defaultbufferSize = 100000;
    protected long orcStripeSize;
    protected long defaultStripeSize = 100000L;

    public void init(Properties props, String propPrefix, String auditProviderName, Map<String, String> auditConfigs) {
        logger.debug("==> RangerORCAuditWriter.init()");
        this.init(props, propPrefix, auditProviderName);
        super.init(props, propPrefix, auditProviderName, auditConfigs);
        logger.debug("<== RangerORCAuditWriter.init()");
    }

    public void flush() {
    }

    public synchronized boolean logAuditAsORC(Collection<AuthzAuditEvent> events) throws Exception {
        boolean ret = false;
        Writer out = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("UGI={}. Will write to HDFS file={}", (Object)MiscUtil.getUGILoginUser(), (Object)this.currentFileName);
            }
            out = (Writer)MiscUtil.executePrivilegedAction(() -> {
                Writer out1 = this.getORCFileWrite();
                this.orcFileUtil.log(out1, events);
                return out1;
            });
        }
        catch (Exception e) {
            this.orcLogWriter = null;
            logger.error("Error while writing into ORC FileWriter", (Throwable)e);
            throw e;
        }
        finally {
            logger.debug("Flushing HDFS audit in ORC Format. Event Size:{}", (Object)events.size());
            if (out != null) {
                try {
                    this.orcFileUtil.close(out);
                    ret = true;
                }
                catch (Exception e) {
                    logger.error("Error while closing the ORC FileWriter", (Throwable)e);
                    throw e;
                }
                this.orcLogWriter = null;
            }
        }
        return ret;
    }

    public boolean log(Collection<String> events) throws Exception {
        return this.logAsORC(events);
    }

    public boolean logFile(File file) throws Exception {
        return false;
    }

    public void start() {
    }

    public synchronized void stop() {
        if (this.orcLogWriter != null) {
            try {
                this.orcFileUtil.close(this.orcLogWriter);
            }
            catch (Throwable t) {
                logger.error("Error on closing log ORC Writer. Exception will be ignored. name={}, fileName={}", (Object)this.auditProviderName, (Object)this.currentFileName);
            }
            this.orcLogWriter = null;
        }
    }

    public boolean logAsORC(Collection<String> events) throws Exception {
        Collection<AuthzAuditEvent> authzAuditEvents = this.getAuthzAuditEvents(events);
        return this.logAuditAsORC(authzAuditEvents);
    }

    public Collection<AuthzAuditEvent> getAuthzAuditEvents(Collection<String> events) {
        ArrayList<AuthzAuditEvent> ret = new ArrayList<AuthzAuditEvent>();
        for (String event : events) {
            try {
                AuthzAuditEvent authzAuditEvent = (AuthzAuditEvent)MiscUtil.fromJson((String)event, AuthzAuditEvent.class);
                ret.add(authzAuditEvent);
            }
            catch (Exception e) {
                logger.error("Error converting to From JSON to AuthzAuditEvent={}", (Object)event);
                throw e;
            }
        }
        return ret;
    }

    public void init(Properties props, String propPrefix, String auditProviderName) {
        this.compression = MiscUtil.getStringProperty((Properties)props, (String)(propPrefix + "." + this.fileType + ".compression"));
        this.orcBufferSize = MiscUtil.getIntProperty((Properties)props, (String)(propPrefix + "." + this.fileType + ".buffersize"), (int)this.defaultbufferSize);
        this.orcStripeSize = MiscUtil.getLongProperty((Properties)props, (String)(propPrefix + "." + this.fileType + ".stripesize"), (long)this.defaultStripeSize);
        this.setFileExtension(ORC_FILE_EXTENSION);
        try {
            this.orcFileUtil = ORCFileUtil.getInstance();
            this.orcFileUtil.init(this.orcBufferSize, this.orcStripeSize, this.compression);
        }
        catch (Exception e) {
            logger.error("Error while doing ORCWriter.init() ", (Throwable)e);
        }
    }

    protected synchronized Writer getORCFileWrite() throws Exception {
        logger.debug("==> RangerORCAuditWriter.getORCFileWrite()");
        if (this.orcLogWriter == null) {
            this.createFileSystemFolders();
            logger.info("Creating new log file. hdfPath={}", (Object)this.fullPath);
            this.orcLogWriter = this.orcFileUtil.createWriter(this.conf, this.fileSystem, this.fullPath);
            this.currentFileName = this.fullPath;
        }
        logger.debug("<== RangerORCAuditWriter.getORCFileWrite()");
        return this.orcLogWriter;
    }
}

